package org.jboss.cache.commands.write;

import org.jboss.cache.Fqn;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.commands.Visitor;
import org.jboss.cache.transaction.GlobalTransaction;

/**
 * Represents the {@link org.jboss.cache.Cache#putForExternalRead(org.jboss.cache.Fqn, Object, Object)} method call.
 *
 * @author Manik Surtani (<a href="mailto:manik@jboss.org">manik@jboss.org</a>)
 * @since 2.2.0
 */
public class PutForExternalReadCommand extends PutKeyValueCommand
{
   public static final int METHOD_ID = 45;
   public static final int VERSIONED_METHOD_ID = 46;

   public PutForExternalReadCommand(GlobalTransaction gtx, Fqn fqn, Object key, Object value)
   {
      super(gtx, fqn, key, value);
   }

   public PutForExternalReadCommand()
   {
      super();
   }

   @Override
   public int getCommandId()
   {
      if (isVersioned())
      {
         return VERSIONED_METHOD_ID;
      }
      else
      {
         return METHOD_ID;
      }
   }

   @Override
   protected boolean isVersionedId(int commandId)
   {
      return commandId == VERSIONED_METHOD_ID;
   }

   @Override
   public Object acceptVisitor(InvocationContext ctx, Visitor visitor) throws Throwable
   {
      return visitor.visitPutForExternalReadCommand(ctx, this);
   }
}
