/*
 * Decompiled with CFR 0.152.
 */
package gnu.jpdf;

import gnu.jpdf.PDFObject;
import gnu.jpdf.PDFPage;
import gnu.jpdf.PDFStringHelper;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;

public class PDFOutline
extends PDFObject
implements Serializable {
    private final Vector<PDFOutline> outlines = new Vector();
    protected PDFOutline parent;
    private String title = null;
    PDFPage dest = null;
    int l;
    int b;
    int r;
    int t;
    boolean destMode = false;
    static final boolean FITPAGE = false;
    static final boolean FITRECT = true;

    protected PDFOutline() {
        super("/Outlines");
    }

    public PDFOutline(String string, PDFPage pDFPage) {
        this();
        this.title = string;
        this.dest = pDFPage;
    }

    public PDFOutline(String string, PDFPage pDFPage, int n, int n2, int n3, int n4) {
        this(string, pDFPage);
        this.destMode = true;
        this.l = n;
        this.b = n2;
        this.r = n3;
        this.t = n4;
    }

    public PDFOutline add(String string, PDFPage pDFPage) {
        PDFOutline pDFOutline = new PDFOutline(string, pDFPage);
        this.pdfDocument.add(pDFOutline);
        this.add(pDFOutline);
        return pDFOutline;
    }

    public PDFOutline add(String string, PDFPage pDFPage, int n, int n2, int n3, int n4) {
        int[] nArray = pDFPage.cxy(n, n2 + n4);
        int[] nArray2 = pDFPage.cxy(n + n3, n2);
        PDFOutline pDFOutline = new PDFOutline(string, pDFPage, nArray[0], nArray[1], nArray2[0], nArray2[1]);
        this.pdfDocument.add(pDFOutline);
        this.add(pDFOutline);
        return pDFOutline;
    }

    public void add(PDFOutline pDFOutline) {
        this.outlines.addElement(pDFOutline);
        pDFOutline.parent = this;
    }

    @Override
    public void write(OutputStream outputStream) throws IOException {
        int n;
        this.writeStart(outputStream);
        if (this.parent != null) {
            outputStream.write("/Title ".getBytes());
            outputStream.write(PDFStringHelper.makePDFString(this.title).getBytes());
            outputStream.write("\n/Dest [".getBytes());
            outputStream.write(this.dest.toString().getBytes());
            if (!this.destMode) {
                outputStream.write(" /Fit]\n/Parent ".getBytes());
            } else {
                outputStream.write(" /FitR ".getBytes());
                outputStream.write(Integer.toString(this.l).getBytes());
                outputStream.write(" ".getBytes());
                outputStream.write(Integer.toString(this.b).getBytes());
                outputStream.write(" ".getBytes());
                outputStream.write(Integer.toString(this.r).getBytes());
                outputStream.write(" ".getBytes());
                outputStream.write(Integer.toString(this.t).getBytes());
                outputStream.write("]\n/Parent ".getBytes());
            }
            outputStream.write(this.parent.toString().getBytes());
            outputStream.write("\n".getBytes());
        }
        if (this.parent == null) {
            outputStream.write("/Count ".getBytes());
            outputStream.write(Integer.toString(this.outlines.size()).getBytes());
            outputStream.write("\n".getBytes());
        } else {
            n = this.descendants();
            if (n > 0) {
                outputStream.write("/Count ".getBytes());
                outputStream.write(Integer.toString(-n).getBytes());
                outputStream.write("\n".getBytes());
            }
        }
        if (this.outlines.size() > 0) {
            outputStream.write("/First ".getBytes());
            outputStream.write(this.outlines.elementAt(0).toString().getBytes());
            outputStream.write("\n".getBytes());
            outputStream.write("/Last ".getBytes());
            outputStream.write(this.outlines.elementAt(this.outlines.size() - 1).toString().getBytes());
            outputStream.write("\n".getBytes());
        }
        if (this.parent != null) {
            n = this.parent.getIndex(this);
            if (n > 0) {
                outputStream.write("/Prev ".getBytes());
                outputStream.write(this.parent.getNode(n - 1).toString().getBytes());
                outputStream.write("\n".getBytes());
            }
            if (n < this.parent.getLast()) {
                outputStream.write("/Next ".getBytes());
                outputStream.write(this.parent.getNode(n + 1).toString().getBytes());
                outputStream.write("\n".getBytes());
            }
        }
        this.writeEnd(outputStream);
    }

    protected int getIndex(PDFOutline pDFOutline) {
        return this.outlines.indexOf(pDFOutline);
    }

    protected int getLast() {
        return this.outlines.size() - 1;
    }

    protected PDFOutline getNode(int n) {
        return this.outlines.elementAt(n);
    }

    public Enumeration<PDFOutline> elements() {
        return this.outlines.elements();
    }

    protected int descendants() {
        int n = this.outlines.size();
        for (PDFOutline pDFOutline : this.outlines) {
            n += pDFOutline.descendants();
        }
        return n;
    }
}

