/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGeneratorSpi;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.spec.AlgorithmParameterSpec;

public abstract class KeyPairGenerator
extends KeyPairGeneratorSpi {
    private String algorithm;
    private Provider provider;

    protected KeyPairGenerator(String string) {
        this.algorithm = string;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public static KeyPairGenerator getInstance(String string) throws NoSuchAlgorithmException {
        try {
            Object[] objectArray = Security.getImpl(string, "KeyPairGenerator", (String)null);
            if (objectArray[0] instanceof KeyPairGenerator) {
                KeyPairGenerator keyPairGenerator = (KeyPairGenerator)objectArray[0];
                keyPairGenerator.provider = (Provider)objectArray[1];
                return keyPairGenerator;
            }
            Delegate delegate = new Delegate((KeyPairGeneratorSpi)objectArray[0], string);
            delegate.provider = (Provider)objectArray[1];
            return delegate;
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new NoSuchAlgorithmException(string + " not found");
        }
    }

    public static KeyPairGenerator getInstance(String string, String string2) throws NoSuchAlgorithmException, NoSuchProviderException {
        if (string2 == null || string2.length() == 0) {
            throw new IllegalArgumentException("missing provider");
        }
        Object[] objectArray = Security.getImpl(string, "KeyPairGenerator", string2);
        if (objectArray[0] instanceof KeyPairGenerator) {
            KeyPairGenerator keyPairGenerator = (KeyPairGenerator)objectArray[0];
            keyPairGenerator.provider = (Provider)objectArray[1];
            return keyPairGenerator;
        }
        Delegate delegate = new Delegate((KeyPairGeneratorSpi)objectArray[0], string);
        delegate.provider = (Provider)objectArray[1];
        return delegate;
    }

    public static KeyPairGenerator getInstance(String string, Provider provider) throws NoSuchAlgorithmException {
        if (provider == null) {
            throw new IllegalArgumentException("missing provider");
        }
        Object[] objectArray = Security.getImpl(string, "KeyPairGenerator", provider);
        if (objectArray[0] instanceof KeyPairGenerator) {
            KeyPairGenerator keyPairGenerator = (KeyPairGenerator)objectArray[0];
            keyPairGenerator.provider = (Provider)objectArray[1];
            return keyPairGenerator;
        }
        Delegate delegate = new Delegate((KeyPairGeneratorSpi)objectArray[0], string);
        delegate.provider = (Provider)objectArray[1];
        return delegate;
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public void initialize(int n) {
        this.initialize(n, new SecureRandom());
    }

    public void initialize(int n, SecureRandom secureRandom) {
    }

    public void initialize(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
        this.initialize(algorithmParameterSpec, new SecureRandom());
    }

    public void initialize(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
    }

    public final KeyPair genKeyPair() {
        return this.generateKeyPair();
    }

    public KeyPair generateKeyPair() {
        return null;
    }

    static class Delegate
    extends KeyPairGenerator {
        private KeyPairGeneratorSpi kpairGenSpi;

        public Delegate(KeyPairGeneratorSpi keyPairGeneratorSpi, String string) {
            super(string);
            this.kpairGenSpi = keyPairGeneratorSpi;
        }

        public void initialize(int n, SecureRandom secureRandom) {
            this.kpairGenSpi.initialize(n, secureRandom);
        }

        public void initialize(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
            this.kpairGenSpi.initialize(algorithmParameterSpec, secureRandom);
        }

        public KeyPair generateKeyPair() {
            return this.kpairGenSpi.generateKeyPair();
        }
    }
}

