/*
 * Decompiled with CFR 0.152.
 */
package sun.misc;

import java.util.StringTokenizer;
import java.util.jar.Attributes;

public class ExtensionInfo {
    public static final int COMPATIBLE = 0;
    public static final int REQUIRE_SPECIFICATION_UPGRADE = 1;
    public static final int REQUIRE_IMPLEMENTATION_UPGRADE = 2;
    public static final int REQUIRE_VENDOR_SWITCH = 3;
    public static final int INCOMPATIBLE = 4;
    public String title;
    public String name;
    public String specVersion;
    public String specVendor;
    public String implementationVersion;
    public String vendor;
    public String vendorId;
    public String url;

    public ExtensionInfo() {
    }

    public ExtensionInfo(String string, Attributes attributes) throws NullPointerException {
        String string2 = string != null ? string + "-" : "";
        String string3 = string2 + Attributes.Name.EXTENSION_NAME.toString();
        this.name = attributes.getValue(string3);
        string3 = string2 + Attributes.Name.SPECIFICATION_TITLE.toString();
        this.title = attributes.getValue(string3);
        string3 = string2 + Attributes.Name.SPECIFICATION_VERSION.toString();
        this.specVersion = attributes.getValue(string3);
        string3 = string2 + Attributes.Name.SPECIFICATION_VERSION.toString();
        this.specVersion = attributes.getValue(string3);
        string3 = string2 + Attributes.Name.IMPLEMENTATION_VERSION.toString();
        this.implementationVersion = attributes.getValue(string3);
        string3 = string2 + Attributes.Name.IMPLEMENTATION_VENDOR.toString();
        this.vendor = attributes.getValue(string3);
        string3 = string2 + Attributes.Name.IMPLEMENTATION_VENDOR_ID.toString();
        this.vendorId = attributes.getValue(string3);
        string3 = string2 + Attributes.Name.IMPLEMENTATION_URL.toString();
        this.url = attributes.getValue(string3);
    }

    public int isCompatibleWith(ExtensionInfo extensionInfo) {
        if (this.name == null || extensionInfo.name == null) {
            return 4;
        }
        if (this.name.compareTo(extensionInfo.name) == 0) {
            System.out.println("Potential match");
            if (this.specVersion == null || extensionInfo.specVersion == null) {
                return 0;
            }
            int n = this.compareExtensionVersion(this.specVersion, extensionInfo.specVersion);
            if (n < 0) {
                if (this.vendorId != null && extensionInfo.vendorId != null && this.vendorId.compareTo(extensionInfo.vendorId) != 0) {
                    return 3;
                }
                return 1;
            }
            if (this.vendorId != null && extensionInfo.vendorId != null) {
                if (this.vendorId.compareTo(extensionInfo.vendorId) != 0) {
                    return 3;
                }
                if (this.implementationVersion != null && extensionInfo.implementationVersion != null && (n = this.compareExtensionVersion(this.implementationVersion, extensionInfo.implementationVersion)) < 0) {
                    return 2;
                }
            }
            return 0;
        }
        return 4;
    }

    public String toString() {
        return "Extension : " + this.title + "(" + this.name + "), spec version(" + this.specVersion + "), impl version(" + this.implementationVersion + ") from " + this.vendor + "(" + this.vendorId + ")";
    }

    private int compareExtensionVersion(String string, String string2) throws NumberFormatException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".,");
        StringTokenizer stringTokenizer2 = new StringTokenizer(string2, ".,");
        while (stringTokenizer.hasMoreTokens() || stringTokenizer2.hasMoreTokens()) {
            int n;
            int n2 = stringTokenizer.hasMoreTokens() ? Integer.parseInt(stringTokenizer.nextToken()) : 0;
            if (n2 < (n = stringTokenizer2.hasMoreTokens() ? Integer.parseInt(stringTokenizer2.nextToken()) : 0)) {
                return -1;
            }
            if (n2 <= n) continue;
            return 1;
        }
        return 0;
    }
}

