package Locales::DB::Language::hi;

use strict;
use warnings;

# Auto generated from CLDR

$Locales::DB::Language::hi::VERSION = '0.09';

$Locales::DB::Language::hi::cldr_version = '2.0';

%Locales::DB::Language::hi::misc_info = (
    'characters'   => { 'more_information' => "\?" },
    'cldr_formats' => {
        '_decimal_format_decimal' => "\.",
        '_decimal_format_group'   => "\,",
        '_percent_format_percent' => "\%",
        'decimal'                 => "\#\,\#\#\,\#\#0\.\#\#\#",
        'ellipsis'                => {
            'final'   => "\{0\}…",
            'initial' => "…\{0\}",
            'medial'  => "\{0\}…\{1\}"
        },
        'language' => "Language\:\ \{0\}",
        'list'     => {
            2        => "\{0\}\ और\ \{1\}",
            'end'    => "\{0\}\,\ और\ \{1\}",
            'middle' => "\{0\}\,\ \{1\}",
            'start'  => "\{0\}\,\ \{1\}"
        },
        'locale'    => "\{0\}\ \(\{1\}\)",
        'percent'   => "\#\,\#\#\,\#\#0\%",
        'territory' => "Region\:\ \{0\}"
    },
    'delimiters' => {
        'alternate_quotation_end'   => "\"",
        'alternate_quotation_start' => "\"",
        'quotation_end'             => "\'",
        'quotation_start'           => "\'"
    },
    'fallback'    => [],
    'orientation' => {
        'characters' => "left\-to\-right",
        'lines'      => "top\-to\-bottom"
    },
    'plural_forms' => {
        'category_list' => [
            'one',
            'other'
        ],
        'category_rules'          => { 'one' => "n\ in\ 0\.\.1" },
        'category_rules_compiled' => {
            'one' => sub {
                if ( ( ( int( $_[0] ) == $_[0] && $_[0] >= 0 && $_[0] <= 1 ) ) ) { return 'one'; }
                return;
              }
        }
    },
    'posix' => {
        'nostr'  => 'नहीं',
        'yesstr' => 'हाँ'
    },
);

%Locales::DB::Language::hi::code_to_name = (
    'aa'     => 'अफ़ार',
    'ab'     => 'अब्खाज़ियन्',
    'ace'    => 'अचाइनीस',
    'ach'    => 'अकोली',
    'ada'    => 'अदान्गमे',
    'ady'    => 'अदिघे',
    'ae'     => 'अवेस्तन',
    'af'     => 'अफ्रीकी',
    'afa'    => "अफ्रो\-एशियाई\ भाषाएँ",
    'afh'    => 'अफ्रिहिली',
    'agq'    => 'Aghem',
    'ain'    => 'ऐनू',
    'ak'     => 'अकन',
    'akk'    => 'अक्केदिअन',
    'ale'    => 'अलेउत',
    'alg'    => "एल्गोनक्युइअन\ भाषा",
    'alt'    => "दक्षिणी\ अल्ताई",
    'am'     => 'अम्हारिक्',
    'an'     => 'अर्गोनी',
    'ang'    => "पुरानी\ अंग्रेज़ी",
    'anp'    => 'अंगिका',
    'apa'    => "अपाचे\ भाषा",
    'ar'     => 'अरबी',
    'arc'    => 'ऐरेमेक',
    'arn'    => 'एरोकैनियन',
    'arp'    => 'अराफाओ',
    'art'    => "कृत्रिम\ भाषा",
    'arw'    => 'अरावक',
    'as'     => 'असामी',
    'asa'    => 'Asu',
    'ast'    => 'अस्तुरियन',
    'ath'    => "अथापास्कान\ भाषा",
    'aus'    => "आस्ट्रेलियाई\ भाषा",
    'av'     => 'अवेरिक',
    'awa'    => 'अवधी',
    'ay'     => 'आयमारा',
    'az'     => 'अज़ेरी',
    'ba'     => 'बशख़िर',
    'bad'    => 'बांदा',
    'bai'    => "बमिलेके\ भाषा",
    'bal'    => 'बलूची',
    'ban'    => 'बालिनीस',
    'bas'    => 'बसा',
    'bat'    => "बाल्टिक\ भाषा",
    'be'     => 'बैलोरूशियन्',
    'bej'    => 'बेजा',
    'bem'    => 'बेम्बा',
    'ber'    => 'बरबर',
    'bez'    => 'Bena',
    'bg'     => 'बल्गेरियाई',
    'bh'     => 'बिहारी',
    'bho'    => 'भोजपुरी',
    'bi'     => 'बिस्लामा',
    'bik'    => 'बिकोल',
    'bin'    => 'बिनी',
    'bla'    => 'सिक्सिका',
    'bm'     => 'बाम्बारा',
    'bn'     => 'बँगाली',
    'bnt'    => 'बन्तु',
    'bo'     => 'तिब्बती',
    'br'     => 'ब्रेटन',
    'bra'    => 'ब्रज',
    'brx'    => 'Bodo',
    'bs'     => 'बोस्नियाई',
    'btk'    => 'बताक',
    'bua'    => 'बुरियात',
    'bug'    => 'बगिनीस',
    'byn'    => 'ब्लिन',
    'ca'     => 'कातालान',
    'cad'    => 'कैड्डो',
    'cai'    => "मध्य\ अमेरिकी\ इंडियन\ भाषा",
    'car'    => 'कैरिब',
    'cau'    => "कॉकेशियन\ भाषा",
    'cay'    => 'Cayuga',
    'cch'    => 'अत्सम',
    'ce'     => 'चेचन',
    'ceb'    => 'सिबुआनो',
    'cel'    => "केल्टिक\ भाषा",
    'cgg'    => 'Chiga',
    'ch'     => 'कमोरो',
    'chb'    => 'चिब्चा',
    'chg'    => 'छगाताई',
    'chk'    => 'चूकीस',
    'chm'    => 'मारी',
    'chn'    => "चिनूक\ जारगॉन",
    'cho'    => 'चोक्तौ',
    'chp'    => 'शिपेव्यान',
    'chr'    => 'शेरूकी',
    'chy'    => 'शेयेन्न',
    'cmc'    => "शैमिक\ भाषा",
    'co'     => 'कोर्सीकन',
    'cop'    => 'कॉप्टिक',
    'cpe'    => "अंग्रेजी\ आधारित\ क्रेओल\ या\ पिजिन",
    'cpf'    => "फ्रेंच\ आधारित\ क्रेओल\ या\ पिजिन",
    'cpp'    => "पुर्तगाली\ आधारित\ क्रेओल\ या\ पिजिन",
    'cr'     => 'क्री',
    'crh'    => "क्रीमीन\ तुर्की",
    'crp'    => "क्रेओल\ या\ पिजिन",
    'cs'     => 'चेक',
    'csb'    => 'काशुबियन',
    'cu'     => "चर्च\ साल्विक",
    'cus'    => "कुशितिक\ भाषा",
    'cv'     => 'चूवाश',
    'cy'     => 'वेल्श',
    'da'     => 'डैनीश',
    'dak'    => 'दाकोता',
    'dar'    => 'दार्गवा',
    'dav'    => 'Taita',
    'day'    => 'दायक',
    'de'     => 'ज़र्मन',
    'de_at'  => "जर्मन\ \(ऑस्ट्रिया\)",
    'de_ch'  => "स्विस\ हाई\ जर्मन",
    'del'    => 'डिलैवेयर',
    'den'    => 'स्लेव',
    'dgr'    => 'डोग्रिब',
    'din'    => 'दिन्का',
    'dje'    => 'Zarma',
    'doi'    => 'डोग्री',
    'dra'    => "द्रविण\ भाषा",
    'dsb'    => "निचला\ सॉर्बियन",
    'dua'    => 'दुआला',
    'dum'    => "मध्य\ पुर्तगाली",
    'dv'     => 'दिवेही',
    'dyo'    => "Jola\-Fonyi",
    'dyu'    => 'ड्युला',
    'dz'     => 'ज़ोन्गखा',
    'ebu'    => 'Embu',
    'ee'     => 'ईवे',
    'efi'    => 'एफिक',
    'egy'    => "प्राचीन\ मिस्री",
    'eka'    => 'एकाजुक',
    'el'     => 'ग्रीक',
    'elx'    => 'एलामाइट',
    'en'     => 'अंग्रेजी',
    'en_au'  => "अंग्रेज़ी\ \(ऑस्ट्रेलिया\)",
    'en_ca'  => "अंग्रेज़ी\(कनाडाई\)",
    'en_gb'  => "अंग्रेजी\(ब्रिटिश\)",
    'en_us'  => "अंग्रेज़ी\ अमेरीकी",
    'enm'    => "मिडिल\ अंग्रजी",
    'eo'     => 'एस्पेरान्तो',
    'es'     => 'स्पेनिश',
    'es_419' => "लेटिन\ अमेरिकी\ स्पेनिश",
    'es_es'  => "ईवेरियाई\ स्पेनिश",
    'et'     => 'ऐस्तोनियन्',
    'eu'     => 'बास्क्',
    'ewo'    => 'इवोन्डो',
    'fa'     => 'पर्शियन्',
    'fan'    => 'फैन्ग',
    'fat'    => 'फन्टी',
    'ff'     => 'फुलाह',
    'fi'     => 'फिनिश',
    'fil'    => 'फिलिपिनो',
    'fiu'    => "फिन्नो\-उग्रीयन\ भाषा",
    'fj'     => 'फ़ीजी',
    'fo'     => 'फिरोज़ी',
    'fon'    => 'फॉन',
    'fr'     => 'फ्रेंच',
    'fr_ca'  => "फ़्रेंच\(कनाडाई\)",
    'fr_ch'  => "स्विस\ फ़्रेंच",
    'frm'    => "मिडिल\ फ्रेंच",
    'fro'    => "पुरानी\ फ्रांसीसी",
    'frr'    => "उत्तरी\ फ्रीसीयन",
    'frs'    => "पूर्वी\ फ्रीसीयन",
    'fur'    => 'फ्रीयुलीयान',
    'fy'     => "पश्चिमी\ फ़्रिसियाई",
    'ga'     => 'आयरिश',
    'gaa'    => 'गा',
    'gay'    => 'गायो',
    'gba'    => 'ग्बाया',
    'gd'     => "स्काट्स्\ गायेलिक्",
    'gem'    => "जर्मनिक\ भाषा",
    'gez'    => 'गीज़',
    'gil'    => 'गिल्बरतीस',
    'gl'     => 'गैलिशियन्',
    'gmh'    => "मध्यकालीन\ हाइ\ जर्मन",
    'gn'     => 'गुआरानी',
    'goh'    => "पुरातन\ हाइ\ जर्मन",
    'gon'    => 'गाँडी',
    'gor'    => 'गोरोन्तालो',
    'got'    => 'गॉथिक',
    'grb'    => 'ग्रेबो',
    'grc'    => "प्राचीन\ यूनानी",
    'gsw'    => "स्विस\ जर्मन",
    'gu'     => 'गुज़राती',
    'guz'    => 'Gusii',
    'gv'     => 'मैंक्स',
    'gwi'    => "ग्विच\'इन",
    'ha'     => 'होउसा',
    'hai'    => 'हैडा',
    'haw'    => 'हावाइयन',
    'he'     => 'हीब्रू',
    'hi'     => 'हिन्दी',
    'hil'    => 'हिलिगेनन',
    'him'    => 'हिमाचली',
    'hit'    => 'हिताइत',
    'hmn'    => 'ह्मॉंग',
    'ho'     => "हिरी\ मोटू",
    'hr'     => 'क्रोएशन्',
    'hsb'    => "ऊपरी\ सॉर्बियन",
    'ht'     => 'हैतीयन',
    'hu'     => 'हंगेरी',
    'hup'    => 'हूपा',
    'hy'     => 'अरमेनियन्',
    'hz'     => 'हरैरो',
    'ia'     => 'ईन्टरलिंगुआ',
    'iba'    => 'इबान',
    'id'     => 'इन्डोनेशियाई',
    'ie'     => 'ईन्टरलिंगुइ',
    'ig'     => 'ईग्बो',
    'ii'     => "सिचुआन\ यी",
    'ijo'    => 'इजो',
    'ik'     => 'इनुपियाक्',
    'ilo'    => 'इलोको',
    'inc'    => "भारतीय\ भाषा",
    'ine'    => "इंडो\-युरोपीय\ भाषा",
    'inh'    => 'इंगुश',
    'io'     => 'इडौ',
    'ira'    => "ईरानी\ भाषा",
    'iro'    => "इरोक्युओइयन\ भाषा",
    'is'     => 'आईस्लैंडिक्',
    'it'     => 'इतालवी',
    'iu'     => 'इनूकीटूत्',
    'ja'     => 'जापानी',
    'jbo'    => 'लोज्बान',
    'jmc'    => 'Machame',
    'jpr'    => "जुदेओ\-पर्शियन",
    'jrb'    => "जुदेओ\-अरेबिक",
    'jv'     => 'जावानीस',
    'ka'     => 'जॉर्जीयन्',
    'kaa'    => "कारा\-कल्पक",
    'kab'    => 'कबाइल',
    'kac'    => 'काचिन',
    'kaj'    => 'ज्जु',
    'kam'    => 'कम्बा',
    'kar'    => 'कारेन',
    'kaw'    => 'कावी',
    'kbd'    => 'कबार्डियन',
    'kcg'    => 'त्याप',
    'kde'    => 'Makonde',
    'kea'    => 'Kabuverdianu',
    'kfo'    => 'कोरो',
    'kg'     => 'कोंगो',
    'kha'    => 'खासी',
    'khi'    => "खोइसन\ भाषा",
    'kho'    => 'खोतानीस',
    'khq'    => "Koyra\ Chiini",
    'ki'     => 'किकुयू',
    'kj'     => 'क्वान्यामा',
    'kk'     => 'कज़ाख',
    'kl'     => 'ग्रीनलैंडिक',
    'kln'    => 'Kalenjin',
    'km'     => 'कैम्बोडियन्',
    'kmb'    => 'किम्बन्दु',
    'kn'     => 'कन्नड़',
    'ko'     => 'कोरीयन्',
    'kok'    => 'कोंकणी',
    'kos'    => 'कोसरैन',
    'kpe'    => 'क्पेल्लै',
    'kr'     => 'कनुरी',
    'krc'    => "कराचय\-बल्कार",
    'krl'    => 'करेलियन',
    'kro'    => 'क्रु',
    'kru'    => 'कुरूख',
    'ks'     => 'कश्मीरी',
    'ksb'    => 'Shambala',
    'ksf'    => 'Bafia',
    'ksh'    => 'Colognian',
    'ku'     => 'कुरदीश',
    'kum'    => 'कुमीक',
    'kut'    => 'कुतेनाई',
    'kv'     => 'कोमी',
    'kw'     => 'कोर्निश',
    'ky'     => 'किरघिज़',
    'la'     => 'लैटीन',
    'lad'    => 'लादीनो',
    'lag'    => 'Langi',
    'lah'    => 'लाह्न्डा',
    'lam'    => 'लाम्बा',
    'lb'     => 'लक्ष्ज़ेमबर्गिश',
    'lez'    => 'लेज़्घीयन',
    'lg'     => 'गांडा',
    'li'     => 'लिंबर्गिश',
    'ln'     => 'लिंगाला',
    'lo'     => 'लाओथीयन्',
    'lol'    => 'मोंगो',
    'loz'    => 'लोज़ी',
    'lt'     => 'लिथुनियन्',
    'lu'     => "ल्यूबा\-कटांगा",
    'lua'    => "ल्यूबा\-लुलुआ",
    'lui'    => 'लुइसेनो',
    'lun'    => 'लुन्डा',
    'luo'    => 'ल्युओ',
    'lus'    => 'लुशाई',
    'luy'    => 'Luyia',
    'lv'     => 'लातवी',
    'mad'    => 'मादुरीस',
    'mag'    => 'मगाही',
    'mai'    => 'मैथिली',
    'mak'    => 'मकासर',
    'man'    => 'मन्डिन्गो',
    'map'    => 'ऑस्ट्रोनेशियन',
    'mas'    => 'मसाई',
    'mdf'    => 'मोक्ष',
    'mdr'    => 'मंधार',
    'men'    => 'मेन्डे',
    'mer'    => 'Meru',
    'mfe'    => 'Morisyen',
    'mg'     => 'मालागासी',
    'mga'    => "मिडिल\ आइरिश",
    'mgh'    => "Makhuwa\-Meetto",
    'mh'     => 'मार्शलीज़',
    'mi'     => 'मेओरी',
    'mic'    => 'मिकमैक',
    'min'    => 'मिनांग्काबाउ',
    'mis'    => "विविध\ भाषा",
    'mk'     => 'मैसेडोनियन्',
    'mkh'    => "मॉन\-ख्मेर\ भाषा",
    'ml'     => 'मलयालम',
    'mn'     => 'मंगोलीयाई',
    'mnc'    => 'मन्चु',
    'mni'    => 'मणिपूरी',
    'mno'    => "मनोबो\ भाषा",
    'mo'     => 'मोलडावियन्',
    'moh'    => 'मोहौक',
    'mos'    => 'मोस्सी',
    'mr'     => 'मराठी',
    'ms'     => 'मलय',
    'mt'     => 'मालटिस्',
    'mua'    => 'Mundang',
    'mul'    => "विविध\ भाषाएँ",
    'mun'    => "मुन्डा\ भाषा",
    'mus'    => 'क्रीक',
    'mwl'    => 'मिरांडी',
    'mwr'    => 'मारवाड़ी',
    'my'     => 'बर्लिस',
    'myn'    => "माया\ भाषा",
    'myv'    => 'एर्ज़या',
    'na'     => 'नाउरू',
    'nah'    => 'नहुआत्ल',
    'nai'    => "उत्तरी\ अमेरीकी\ इंडियन\ भाषा",
    'nap'    => 'नीपोलिटन',
    'naq'    => 'Nama',
    'nb'     => "नॉर्वेजियन\ बोकमाल",
    'nd'     => "उत्तरी\ देबेल",
    'nds'    => "निचला\ जर्मन",
    'ne'     => 'नेपाली',
    'new'    => 'नेवाड़ी',
    'ng'     => 'डोन्गा',
    'nia'    => 'नियास',
    'nic'    => "नाइगर\-कोर्डोफैनियन\ भाषा",
    'niu'    => 'नियुआन',
    'nl'     => 'डच्',
    'nl_be'  => 'फ़्लेमिश',
    'nmg'    => 'Kwasio',
    'nn'     => "नॉर्वेजियन\ नाइनोर्स्क",
    'no'     => 'नार्वेजियन',
    'nog'    => 'नोगाई',
    'non'    => "पुराना\ नॉर्स",
    'nqo'    => 'एन्को',
    'nr'     => "दक्षिण\ देबेल",
    'nso'    => "उत्तरी\ सोथो",
    'nub'    => "न्युबियान\ भाषा",
    'nus'    => 'Nuer',
    'nv'     => 'नावाजो',
    'nwc'    => "पारम्परिक\ नेवारी",
    'ny'     => 'न्यानजा',
    'nym'    => 'न्यामवेज़ी',
    'nyn'    => 'न्यानकोल',
    'nyo'    => 'न्योरो',
    'nzi'    => 'न्ज़ीमा',
    'oc'     => 'ओसीटान',
    'oj'     => 'ओजिब्वा',
    'om'     => 'ओरोमो',
    'or'     => 'उड़िया',
    'os'     => 'ओस्सेटिक',
    'osa'    => 'ओसेज',
    'ota'    => "ओटोमान\ तुर्किश",
    'oto'    => "ओटोमियन\ भाषा",
    'pa'     => 'पंजाबी',
    'paa'    => "पापुआन\ भाषा",
    'pag'    => 'पंगासीनान',
    'pal'    => 'पाह्लावी',
    'pam'    => 'पाम्पान्गा',
    'pap'    => 'पापियामेन्टो',
    'pau'    => 'पलोउआन',
    'peo'    => "पुरानी\ फारसी",
    'phi'    => "फिलिपीन\ भाषा",
    'phn'    => 'फोएनिशियन',
    'pi'     => 'पाली',
    'pl'     => 'पॉलिश',
    'pon'    => 'पोह्नपिएन',
    'pra'    => 'प्राकृत',
    'pro'    => "पुरानी\ प्रोवेन्सल",
    'ps'     => 'पुश्तो',
    'pt'     => 'पुर्तगाली',
    'pt_br'  => "पुर्तगाली\ \(ब्राज़ील\)",
    'pt_pt'  => "ईवेरियाई\ पुर्तगाली",
    'qu'     => 'क्वेशुआ',
    'raj'    => 'राजस्थानी',
    'rap'    => 'रापानुई',
    'rar'    => 'रारोतोंगन',
    'rm'     => "रहेय्टो\-रोमान्स",
    'rn'     => 'रुन्दी',
    'ro'     => 'रोमानियाई',
    'roa'    => "रोमांस\ भाषा",
    'rof'    => 'Rombo',
    'rom'    => 'रोमानी',
    'ru'     => 'रूसी',
    'rup'    => 'अरोमानियन',
    'rw'     => 'किन्यारवाण्डा',
    'rwk'    => 'Rwa',
    'sa'     => 'संस्कृत',
    'sad'    => 'सन्डावे',
    'sah'    => 'याकूत',
    'sai'    => "दक्षिण\ अमेरीकी\ इंडियन\ भाषा",
    'sal'    => "सलीशन\ भाषा",
    'sam'    => "सामैरिटन\ अरैमिक",
    'saq'    => 'Samburu',
    'sas'    => 'सासाक',
    'sat'    => 'संताली',
    'sbp'    => 'Sangu',
    'sc'     => 'सार्दिनियन',
    'scn'    => 'सिसिलियन',
    'sco'    => 'स्कॉट्स',
    'sd'     => 'सिन्धी',
    'se'     => "नॉर्दन\ सामी",
    'see'    => 'Seneca',
    'seh'    => 'Sena',
    'sel'    => 'सेल्कप',
    'sem'    => "सेमिटिक\ भाषा",
    'ses'    => "Koyraboro\ Senni",
    'sg'     => 'सांगो',
    'sga'    => "पुरानी\ आइरिश",
    'sgn'    => "सांकेतिक\ भाषा",
    'sh'     => "सेर्बो\-क्रोएशन्",
    'shi'    => 'Tachelhit',
    'shn'    => 'शैन',
    'si'     => 'शिंघालीस्',
    'sid'    => 'सिदामो',
    'sio'    => "सिउआन\ भाषा",
    'sit'    => "चीनी\-तिब्ब्ती\ भाषा",
    'sk'     => 'स्लोवाक्',
    'sl'     => 'स्लोवेनियन्',
    'sla'    => "स्लोवियाई\ भाषा",
    'sm'     => 'सामोन',
    'sma'    => "दक्षिण\ सामी",
    'smi'    => "सामी\ भाषा",
    'smj'    => "ल्युल\ सामी",
    'smn'    => "इनारी\ सामी",
    'sms'    => "स्कोल्ट\ सामी",
    'sn'     => 'सोणा',
    'snk'    => 'सोनिन्के',
    'so'     => 'सोमाली',
    'sog'    => 'सोग्डिएन',
    'son'    => 'सोन्घाई',
    'sq'     => 'अल्बेनियन्',
    'sr'     => 'सर्बियन्',
    'srn'    => "स्रानान\ टॉन्गो",
    'srr'    => 'सेरेर',
    'ss'     => 'स्वाती',
    'ssa'    => "नील\ सहारी\ भाषा",
    'ssy'    => 'Saho',
    'st'     => 'सेसोथो',
    'su'     => 'सुंडानी',
    'suk'    => 'सुकुमा',
    'sus'    => 'सुसु',
    'sux'    => 'सुमेरियन',
    'sv'     => 'स्विडिश',
    'sw'     => 'स्वाहिली',
    'swb'    => 'कोमोरियन',
    'swc'    => "Congo\ Swahili",
    'syc'    => "क्लासिकल\ सिरिएक",
    'syr'    => 'सिरिएक',
    'ta'     => 'तमिल',
    'tai'    => "ताई\ भाषा",
    'te'     => 'तेलेगु',
    'tem'    => 'टिम्ने',
    'teo'    => 'Teso',
    'ter'    => 'तेरेनो',
    'tet'    => 'तेतुम',
    'tg'     => 'ताजिक्',
    'th'     => 'थाई',
    'ti'     => 'तिग्रीन्या',
    'tig'    => 'टाइग्रे',
    'tiv'    => 'तिव',
    'tk'     => 'तुक्रमेन',
    'tkl'    => 'तोकेलाऊ',
    'tl'     => 'तागालोग',
    'tlh'    => 'क्लिंगन',
    'tli'    => 'त्लिंगित',
    'tmh'    => 'तामाशेक',
    'tn'     => 'सेत्स्वाना',
    'to'     => 'टोंगा',
    'tog'    => "न्यासा\ टोन्गा",
    'tpi'    => "टोक\ पिसिन",
    'tr'     => 'तुर्की',
    'trv'    => 'Taroko',
    'ts'     => 'सोंगा',
    'tsi'    => 'त्सिमीशियन',
    'tt'     => 'टाटर',
    'tum'    => 'तम्बूका',
    'tup'    => "ट्यूपी\ भाषा",
    'tut'    => "अल्तैक\ भाषा",
    'tvl'    => 'तुवालु',
    'tw'     => 'ट्वी',
    'twq'    => 'Tasawaq',
    'ty'     => 'ताहितियन',
    'tyv'    => 'तुवीनियन',
    'tzm'    => "Central\ Morocco\ Tamazight",
    'udm'    => 'उदमुर्त',
    'ug'     => 'विग्वर',
    'uga'    => 'युगैरिटिक',
    'uk'     => 'यूक्रेनी',
    'umb'    => 'उम्बुन्डु',
    'und'    => "अज्ञात\ या\ अवैध\ भाषा",
    'ur'     => 'उर्दू',
    'uz'     => 'उज़्बेक',
    'vai'    => 'वाई',
    've'     => 'वेन्दा',
    'vi'     => 'वियेतनामी',
    'vo'     => 'वोलापुक',
    'vot'    => 'वॉटिक',
    'vun'    => 'Vunjo',
    'wa'     => 'वाल्लून',
    'wae'    => 'Walser',
    'wak'    => "वाकाशन\ भाषा",
    'wal'    => 'वलामो',
    'war'    => 'वारै',
    'was'    => 'वाशो',
    'wen'    => "सॉर्बियन\ भाषा",
    'wo'     => 'वोलोफ',
    'xal'    => 'काल्मिक',
    'xh'     => 'षोसा',
    'xog'    => 'Soga',
    'yao'    => 'याओ',
    'yap'    => 'यापीस',
    'yav'    => 'Yangben',
    'yi'     => 'येहुदी',
    'yo'     => 'योरूबा',
    'ypk'    => "यूपिक\ भाषा",
    'yue'    => 'कैंटोनीस',
    'za'     => 'ज़ुआंग',
    'zap'    => 'ज़ेपोटेक',
    'zbl'    => 'ब्लिसिम्बॉल्स',
    'zen'    => 'ज़ेनान्गा',
    'zh'     => 'चीनी',
    'znd'    => 'ज़न्डे',
    'zu'     => 'ज़ुलू',
    'zun'    => 'ज़ूनी',
    'zxx'    => "कोई\ लिंग्विस्ट\ सामग्री\ नहीं",
    'zza'    => 'ज़ाज़ा',
);

%Locales::DB::Language::hi::name_to_code = (
    'aghem'                                                                                => 'agq',
    'asu'                                                                                  => 'asa',
    'bafia'                                                                                => 'ksf',
    'bena'                                                                                 => 'bez',
    'bodo'                                                                                 => 'brx',
    'cayuga'                                                                               => 'cay',
    'centralmoroccotamazight'                                                              => 'tzm',
    'chiga'                                                                                => 'cgg',
    'colognian'                                                                            => 'ksh',
    'congoswahili'                                                                         => 'swc',
    'embu'                                                                                 => 'ebu',
    'gusii'                                                                                => 'guz',
    'jolafonyi'                                                                            => 'dyo',
    'kabuverdianu'                                                                         => 'kea',
    'kalenjin'                                                                             => 'kln',
    'koyraborosenni'                                                                       => 'ses',
    'koyrachiini'                                                                          => 'khq',
    'kwasio'                                                                               => 'nmg',
    'langi'                                                                                => 'lag',
    'luyia'                                                                                => 'luy',
    'machame'                                                                              => 'jmc',
    'makhuwameetto'                                                                        => 'mgh',
    'makonde'                                                                              => 'kde',
    'meru'                                                                                 => 'mer',
    'morisyen'                                                                             => 'mfe',
    'mundang'                                                                              => 'mua',
    'nama'                                                                                 => 'naq',
    'nuer'                                                                                 => 'nus',
    'rombo'                                                                                => 'rof',
    'rwa'                                                                                  => 'rwk',
    'saho'                                                                                 => 'ssy',
    'samburu'                                                                              => 'saq',
    'sangu'                                                                                => 'sbp',
    'sena'                                                                                 => 'seh',
    'seneca'                                                                               => 'see',
    'shambala'                                                                             => 'ksb',
    'soga'                                                                                 => 'xog',
    'tachelhit'                                                                            => 'shi',
    'taita'                                                                                => 'dav',
    'taroko'                                                                               => 'trv',
    'tasawaq'                                                                              => 'twq',
    'teso'                                                                                 => 'teo',
    'vunjo'                                                                                => 'vun',
    'walser'                                                                               => 'wae',
    'yangben'                                                                              => 'yav',
    'zarma'                                                                                => 'dje',
    'अंगिका'                                                                   => 'anp',
    'अंग्रेज़ीअमेरीकी'                                     => 'en_us',
    'अंग्रेज़ीऑस्ट्रेलिया'                         => 'en_au',
    'अंग्रेज़ीकनाडाई'                                        => 'en_ca',
    'अंग्रेजी'                                                             => 'en',
    'अंग्रेजीआधारितक्रेओलयापिजिन'    => 'cpe',
    'अंग्रेजीब्रिटिश'                                        => 'en_gb',
    'अकन'                                                                            => 'ak',
    'अकोली'                                                                      => 'ach',
    'अक्केदिअन'                                                          => 'akk',
    'अचाइनीस'                                                                => 'ace',
    'अज़ेरी'                                                                   => 'az',
    'अज्ञातयाअवैधभाषा'                                     => 'und',
    'अत्सम'                                                                      => 'cch',
    'अथापास्कानभाषा'                                           => 'ath',
    'अदान्गमे'                                                             => 'ada',
    'अदिघे'                                                                      => 'ady',
    'अपाचेभाषा'                                                          => 'apa',
    'अफ़ार'                                                                      => 'aa',
    'अफ्रिहिली'                                                          => 'afh',
    'अफ्रीकी'                                                                => 'af',
    'अफ्रोएशियाईभाषाएँ'                                  => 'afa',
    'अब्खाज़ियन्'                                                    => 'ab',
    'अम्हारिक्'                                                          => 'am',
    'अरबी'                                                                         => 'ar',
    'अरमेनियन्'                                                          => 'hy',
    'अराफाओ'                                                                   => 'arp',
    'अरावक'                                                                      => 'arw',
    'अरोमानियन'                                                          => 'rup',
    'अर्गोनी'                                                                => 'an',
    'अलेउत'                                                                      => 'ale',
    'अल्तैकभाषा'                                                       => 'tut',
    'अल्बेनियन्'                                                       => 'sq',
    'अवधी'                                                                         => 'awa',
    'अवेरिक'                                                                   => 'av',
    'अवेस्तन'                                                                => 'ae',
    'असामी'                                                                      => 'as',
    'अस्तुरियन'                                                          => 'ast',
    'आईस्लैंडिक्'                                                    => 'is',
    'आयमारा'                                                                   => 'ay',
    'आयरिश'                                                                      => 'ga',
    'आस्ट्रेलियाईभाषा'                                     => 'aus',
    'इंगुश'                                                                      => 'inh',
    'इंडोयुरोपीयभाषा'                                        => 'ine',
    'इजो'                                                                            => 'ijo',
    'इडौ'                                                                            => 'io',
    'इतालवी'                                                                   => 'it',
    'इनारीसामी'                                                          => 'smn',
    'इनुपियाक्'                                                          => 'ik',
    'इनूकीटूत्'                                                          => 'iu',
    'इन्डोनेशियाई'                                                 => 'id',
    'इबान'                                                                         => 'iba',
    'इरोक्युओइयनभाषा'                                        => 'iro',
    'इलोको'                                                                      => 'ilo',
    'इवोन्डो'                                                                => 'ewo',
    'ईग्बो'                                                                      => 'ig',
    'ईन्टरलिंगुआ'                                                    => 'ia',
    'ईन्टरलिंगुइ'                                                    => 'ie',
    'ईरानीभाषा'                                                          => 'ira',
    'ईवे'                                                                            => 'ee',
    'ईवेरियाईपुर्तगाली'                                  => 'pt_pt',
    'ईवेरियाईस्पेनिश'                                        => 'es_es',
    'उज़्बेक'                                                                => 'uz',
    'उड़िया'                                                                   => 'or',
    'उत्तरीअमेरीकीइंडियनभाषा'                => 'nai',
    'उत्तरीदेबेल'                                                    => 'nd',
    'उत्तरीफ्रीसीयन'                                           => 'frr',
    'उत्तरीसोथो'                                                       => 'nso',
    'उदमुर्त'                                                                => 'udm',
    'उम्बुन्डु'                                                          => 'umb',
    'उर्दू'                                                                      => 'ur',
    'ऊपरीसॉर्बियन'                                                 => 'hsb',
    'एकाजुक'                                                                   => 'eka',
    'एन्को'                                                                      => 'nqo',
    'एफिक'                                                                         => 'efi',
    'एरोकैनियन'                                                          => 'arn',
    'एर्ज़या'                                                                => 'myv',
    'एलामाइट'                                                                => 'elx',
    'एल्गोनक्युइअनभाषा'                                  => 'alg',
    'एस्पेरान्तो'                                                    => 'eo',
    'ऐनू'                                                                            => 'ain',
    'ऐरेमेक'                                                                   => 'arc',
    'ऐस्तोनियन्'                                                       => 'et',
    'ऑस्ट्रोनेशियन'                                              => 'map',
    'ओजिब्वा'                                                                => 'oj',
    'ओटोमानतुर्किश'                                              => 'ota',
    'ओटोमियनभाषा'                                                    => 'oto',
    'ओरोमो'                                                                      => 'om',
    'ओसीटान'                                                                   => 'oc',
    'ओसेज'                                                                         => 'osa',
    'ओस्सेटिक'                                                             => 'os',
    'कज़ाख'                                                                      => 'kk',
    'कनुरी'                                                                      => 'kr',
    'कन्नड़'                                                                   => 'kn',
    'कबाइल'                                                                      => 'kab',
    'कबार्डियन'                                                          => 'kbd',
    'कमोरो'                                                                      => 'ch',
    'कम्बा'                                                                      => 'kam',
    'कराचयबल्कार'                                                    => 'krc',
    'करेलियन'                                                                => 'krl',
    'कश्मीरी'                                                                => 'ks',
    'काचिन'                                                                      => 'kac',
    'कातालान'                                                                => 'ca',
    'काराकल्पक'                                                          => 'kaa',
    'कारेन'                                                                      => 'kar',
    'काल्मिक'                                                                => 'xal',
    'कावी'                                                                         => 'kaw',
    'काशुबियन'                                                             => 'csb',
    'किकुयू'                                                                   => 'ki',
    'किन्यारवाण्डा'                                              => 'rw',
    'किम्बन्दु'                                                          => 'kmb',
    'किरघिज़'                                                                => 'ky',
    'कुतेनाई'                                                                => 'kut',
    'कुमीक'                                                                      => 'kum',
    'कुरदीश'                                                                   => 'ku',
    'कुरूख'                                                                      => 'kru',
    'कुशितिकभाषा'                                                    => 'cus',
    'कृत्रिमभाषा'                                                    => 'art',
    'केल्टिकभाषा'                                                    => 'cel',
    'कैंटोनीस'                                                             => 'yue',
    'कैड्डो'                                                                   => 'cad',
    'कैम्बोडियन्'                                                    => 'km',
    'कैरिब'                                                                      => 'car',
    'कॉकेशियनभाषा'                                                 => 'cau',
    'कॉप्टिक'                                                                => 'cop',
    'कोंकणी'                                                                   => 'kok',
    'कोंगो'                                                                      => 'kg',
    'कोईलिंग्विस्टसामग्रीनहीं'             => 'zxx',
    'कोमी'                                                                         => 'kv',
    'कोमोरियन'                                                             => 'swb',
    'कोरीयन्'                                                                => 'ko',
    'कोरो'                                                                         => 'kfo',
    'कोर्निश'                                                                => 'kw',
    'कोर्सीकन'                                                             => 'co',
    'कोसरैन'                                                                   => 'kos',
    'क्पेल्लै'                                                             => 'kpe',
    'क्री'                                                                         => 'cr',
    'क्रीक'                                                                      => 'mus',
    'क्रीमीनतुर्की'                                              => 'crh',
    'क्रु'                                                                         => 'kro',
    'क्रेओलयापिजिन'                                              => 'crp',
    'क्रोएशन्'                                                             => 'hr',
    'क्लासिकलसिरिएक'                                           => 'syc',
    'क्लिंगन'                                                                => 'tlh',
    'क्वान्यामा'                                                       => 'kj',
    'क्वेशुआ'                                                                => 'qu',
    'खासी'                                                                         => 'kha',
    'खोइसनभाषा'                                                          => 'khi',
    'खोतानीस'                                                                => 'kho',
    'गा'                                                                               => 'gaa',
    'गाँडी'                                                                      => 'gon',
    'गांडा'                                                                      => 'lg',
    'गायो'                                                                         => 'gay',
    'गिल्बरतीस'                                                          => 'gil',
    'गीज़'                                                                         => 'gez',
    'गुआरानी'                                                                => 'gn',
    'गुज़राती'                                                             => 'gu',
    'गैलिशियन्'                                                          => 'gl',
    'गॉथिक'                                                                      => 'got',
    'गोरोन्तालो'                                                       => 'gor',
    'ग्बाया'                                                                   => 'gba',
    'ग्रीक'                                                                      => 'el',
    'ग्रीनलैंडिक'                                                    => 'kl',
    'ग्रेबो'                                                                   => 'grb',
    'ग्विचइन'                                                                => 'gwi',
    'चर्चसाल्विक'                                                    => 'cu',
    'चिनूकजारगॉन'                                                    => 'chn',
    'चिब्चा'                                                                   => 'chb',
    'चीनी'                                                                         => 'zh',
    'चीनीतिब्ब्तीभाषा'                                     => 'sit',
    'चूकीस'                                                                      => 'chk',
    'चूवाश'                                                                      => 'cv',
    'चेक'                                                                            => 'cs',
    'चेचन'                                                                         => 'ce',
    'चोक्तौ'                                                                   => 'cho',
    'छगाताई'                                                                   => 'chg',
    'जर्मनऑस्ट्रिया'                                           => 'de_at',
    'जर्मनिकभाषा'                                                    => 'gem',
    'ज़न्डे'                                                                   => 'znd',
    'ज़र्मन'                                                                   => 'de',
    'ज़ाज़ा'                                                                   => 'zza',
    'ज़ुआंग'                                                                   => 'za',
    'ज़ुलू'                                                                      => 'zu',
    'ज़ूनी'                                                                      => 'zun',
    'ज़ेनान्गा'                                                          => 'zen',
    'ज़ेपोटेक'                                                             => 'zap',
    'ज़ोन्गखा'                                                             => 'dz',
    'जापानी'                                                                   => 'ja',
    'जावानीस'                                                                => 'jv',
    'जुदेओअरेबिक'                                                    => 'jrb',
    'जुदेओपर्शियन'                                                 => 'jpr',
    'जॉर्जीयन्'                                                          => 'ka',
    'ज्जु'                                                                         => 'kaj',
    'टाइग्रे'                                                                => 'tig',
    'टाटर'                                                                         => 'tt',
    'टिम्ने'                                                                   => 'tem',
    'टोंगा'                                                                      => 'to',
    'टोकपिसिन'                                                             => 'tpi',
    'ट्यूपीभाषा'                                                       => 'tup',
    'ट्वी'                                                                         => 'tw',
    'डच्'                                                                            => 'nl',
    'डिलैवेयर'                                                             => 'del',
    'डैनीश'                                                                      => 'da',
    'डोग्रिब'                                                                => 'dgr',
    'डोग्री'                                                                   => 'doi',
    'डोन्गा'                                                                   => 'ng',
    'ड्युला'                                                                   => 'dyu',
    'तमिल'                                                                         => 'ta',
    'तम्बूका'                                                                => 'tum',
    'ताईभाषा'                                                                => 'tai',
    'तागालोग'                                                                => 'tl',
    'ताजिक्'                                                                   => 'tg',
    'तामाशेक'                                                                => 'tmh',
    'ताहितियन'                                                             => 'ty',
    'तिग्रीन्या'                                                       => 'ti',
    'तिब्बती'                                                                => 'bo',
    'तिव'                                                                            => 'tiv',
    'तुक्रमेन'                                                             => 'tk',
    'तुर्की'                                                                   => 'tr',
    'तुवालु'                                                                   => 'tvl',
    'तुवीनियन'                                                             => 'tyv',
    'तेतुम'                                                                      => 'tet',
    'तेरेनो'                                                                   => 'ter',
    'तेलेगु'                                                                   => 'te',
    'तोकेलाऊ'                                                                => 'tkl',
    'त्याप'                                                                      => 'kcg',
    'त्लिंगित'                                                             => 'tli',
    'त्सिमीशियन'                                                       => 'tsi',
    'थाई'                                                                            => 'th',
    'दक्षिणअमेरीकीइंडियनभाषा'                => 'sai',
    'दक्षिणदेबेल'                                                    => 'nr',
    'दक्षिणसामी'                                                       => 'sma',
    'दक्षिणीअल्ताई'                                              => 'alt',
    'दाकोता'                                                                   => 'dak',
    'दायक'                                                                         => 'day',
    'दार्गवा'                                                                => 'dar',
    'दिन्का'                                                                   => 'din',
    'दिवेही'                                                                   => 'dv',
    'दुआला'                                                                      => 'dua',
    'द्रविणभाषा'                                                       => 'dra',
    'नहुआत्ल'                                                                => 'nah',
    'नाइगरकोर्डोफैनियनभाषा'                      => 'nic',
    'नाउरू'                                                                      => 'na',
    'नार्वेजियन'                                                       => 'no',
    'नावाजो'                                                                   => 'nv',
    'निचलाजर्मन'                                                       => 'nds',
    'निचलासॉर्बियन'                                              => 'dsb',
    'नियास'                                                                      => 'nia',
    'नियुआन'                                                                   => 'niu',
    'नीपोलिटन'                                                             => 'nap',
    'नीलसहारीभाषा'                                                 => 'ssa',
    'नेपाली'                                                                   => 'ne',
    'नेवाड़ी'                                                                => 'new',
    'नॉर्दनसामी'                                                       => 'se',
    'नॉर्वेजियननाइनोर्स्क'                         => 'nn',
    'नॉर्वेजियनबोकमाल'                                     => 'nb',
    'नोगाई'                                                                      => 'nog',
    'न्ज़ीमा'                                                                => 'nzi',
    'न्यानकोल'                                                             => 'nyn',
    'न्यानजा'                                                                => 'ny',
    'न्यामवेज़ी'                                                       => 'nym',
    'न्यासाटोन्गा'                                                 => 'tog',
    'न्युबियानभाषा'                                              => 'nub',
    'न्योरो'                                                                   => 'nyo',
    'पंगासीनान'                                                          => 'pag',
    'पंजाबी'                                                                   => 'pa',
    'पर्शियन्'                                                             => 'fa',
    'पलोउआन'                                                                   => 'pau',
    'पश्चिमीफ़्रिसियाई'                                  => 'fy',
    'पापियामेन्टो'                                                 => 'pap',
    'पापुआनभाषा'                                                       => 'paa',
    'पाम्पान्गा'                                                       => 'pam',
    'पारम्परिकनेवारी'                                        => 'nwc',
    'पाली'                                                                         => 'pi',
    'पाह्लावी'                                                             => 'pal',
    'पुरातनहाइजर्मन'                                           => 'goh',
    'पुरानानॉर्स'                                                    => 'non',
    'पुरानीअंग्रेज़ी'                                        => 'ang',
    'पुरानीआइरिश'                                                    => 'sga',
    'पुरानीप्रोवेन्सल'                                     => 'pro',
    'पुरानीफारसी'                                                    => 'peo',
    'पुरानीफ्रांसीसी'                                        => 'fro',
    'पुर्तगाली'                                                          => 'pt',
    'पुर्तगालीआधारितक्रेओलयापिजिन' => 'cpp',
    'पुर्तगालीब्राज़ील'                                  => 'pt_br',
    'पुश्तो'                                                                   => 'ps',
    'पूर्वीफ्रीसीयन'                                           => 'frs',
    'पॉलिश'                                                                      => 'pl',
    'पोह्नपिएन'                                                          => 'pon',
    'प्राकृत'                                                                => 'pra',
    'प्राचीनमिस्री'                                              => 'egy',
    'प्राचीनयूनानी'                                              => 'grc',
    'फन्टी'                                                                      => 'fat',
    'फ़ीजी'                                                                      => 'fj',
    'फ़्रेंचकनाडाई'                                              => 'fr_ca',
    'फ़्लेमिश'                                                             => 'nl_be',
    'फिनिश'                                                                      => 'fi',
    'फिन्नोउग्रीयनभाषा'                                  => 'fiu',
    'फिरोज़ी'                                                                => 'fo',
    'फिलिपिनो'                                                             => 'fil',
    'फिलिपीनभाषा'                                                    => 'phi',
    'फुलाह'                                                                      => 'ff',
    'फैन्ग'                                                                      => 'fan',
    'फॉन'                                                                            => 'fon',
    'फोएनिशियन'                                                          => 'phn',
    'फ्रीयुलीयान'                                                    => 'fur',
    'फ्रेंच'                                                                   => 'fr',
    'फ्रेंचआधारितक्रेओलयापिजिन'          => 'cpf',
    'बँगाली'                                                                   => 'bn',
    'बगिनीस'                                                                   => 'bug',
    'बताक'                                                                         => 'btk',
    'बन्तु'                                                                      => 'bnt',
    'बमिलेकेभाषा'                                                    => 'bai',
    'बरबर'                                                                         => 'ber',
    'बर्लिस'                                                                   => 'my',
    'बलूची'                                                                      => 'bal',
    'बल्गेरियाई'                                                       => 'bg',
    'बशख़िर'                                                                   => 'ba',
    'बसा'                                                                            => 'bas',
    'बांदा'                                                                      => 'bad',
    'बाम्बारा'                                                             => 'bm',
    'बालिनीस'                                                                => 'ban',
    'बाल्टिकभाषा'                                                    => 'bat',
    'बास्क्'                                                                   => 'eu',
    'बिकोल'                                                                      => 'bik',
    'बिनी'                                                                         => 'bin',
    'बिस्लामा'                                                             => 'bi',
    'बिहारी'                                                                   => 'bh',
    'बुरियात'                                                                => 'bua',
    'बेजा'                                                                         => 'bej',
    'बेम्बा'                                                                   => 'bem',
    'बैलोरूशियन्'                                                    => 'be',
    'बोस्नियाई'                                                          => 'bs',
    'ब्रज'                                                                         => 'bra',
    'ब्रेटन'                                                                   => 'br',
    'ब्लिन'                                                                      => 'byn',
    'ब्लिसिम्बॉल्स'                                              => 'zbl',
    'भारतीयभाषा'                                                       => 'inc',
    'भोजपुरी'                                                                => 'bho',
    'मंगोलीयाई'                                                          => 'mn',
    'मंधार'                                                                      => 'mdr',
    'मकासर'                                                                      => 'mak',
    'मगाही'                                                                      => 'mag',
    'मणिपूरी'                                                                => 'mni',
    'मध्यअमेरिकीइंडियनभाषा'                      => 'cai',
    'मध्यकालीनहाइजर्मन'                                  => 'gmh',
    'मध्यपुर्तगाली'                                              => 'dum',
    'मनोबोभाषा'                                                          => 'mno',
    'मन्चु'                                                                      => 'mnc',
    'मन्डिन्गो'                                                          => 'man',
    'मराठी'                                                                      => 'mr',
    'मलय'                                                                            => 'ms',
    'मलयालम'                                                                   => 'ml',
    'मसाई'                                                                         => 'mas',
    'मादुरीस'                                                                => 'mad',
    'मायाभाषा'                                                             => 'myn',
    'मारवाड़ी'                                                             => 'mwr',
    'मारी'                                                                         => 'chm',
    'मार्शलीज़'                                                          => 'mh',
    'मालटिस्'                                                                => 'mt',
    'मालागासी'                                                             => 'mg',
    'मिकमैक'                                                                   => 'mic',
    'मिडिलअंग्रजी'                                                 => 'enm',
    'मिडिलआइरिश'                                                       => 'mga',
    'मिडिलफ्रेंच'                                                    => 'frm',
    'मिनांग्काबाउ'                                                 => 'min',
    'मिरांडी'                                                                => 'mwl',
    'मुन्डाभाषा'                                                       => 'mun',
    'मेओरी'                                                                      => 'mi',
    'मेन्डे'                                                                   => 'men',
    'मैंक्स'                                                                   => 'gv',
    'मैथिली'                                                                   => 'mai',
    'मैसेडोनियन्'                                                    => 'mk',
    'मॉनख्मेरभाषा'                                                 => 'mkh',
    'मोंगो'                                                                      => 'lol',
    'मोक्ष'                                                                      => 'mdf',
    'मोलडावियन्'                                                       => 'mo',
    'मोस्सी'                                                                   => 'mos',
    'मोहौक'                                                                      => 'moh',
    'याओ'                                                                            => 'yao',
    'याकूत'                                                                      => 'sah',
    'यापीस'                                                                      => 'yap',
    'युगैरिटिक'                                                          => 'uga',
    'यूक्रेनी'                                                             => 'uk',
    'यूपिकभाषा'                                                          => 'ypk',
    'येहुदी'                                                                   => 'yi',
    'योरूबा'                                                                   => 'yo',
    'रहेय्टोरोमान्स'                                           => 'rm',
    'राजस्थानी'                                                          => 'raj',
    'रापानुई'                                                                => 'rap',
    'रारोतोंगन'                                                          => 'rar',
    'रुन्दी'                                                                   => 'rn',
    'रूसी'                                                                         => 'ru',
    'रोमांसभाषा'                                                       => 'roa',
    'रोमानियाई'                                                          => 'ro',
    'रोमानी'                                                                   => 'rom',
    'लक्ष्ज़ेमबर्गिश'                                        => 'lb',
    'लाओथीयन्'                                                             => 'lo',
    'लातवी'                                                                      => 'lv',
    'लादीनो'                                                                   => 'lad',
    'लाम्बा'                                                                   => 'lam',
    'लाह्न्डा'                                                             => 'lah',
    'लिंगाला'                                                                => 'ln',
    'लिंबर्गिश'                                                          => 'li',
    'लिथुनियन्'                                                          => 'lt',
    'लुइसेनो'                                                                => 'lui',
    'लुन्डा'                                                                   => 'lun',
    'लुशाई'                                                                      => 'lus',
    'लेज़्घीयन'                                                          => 'lez',
    'लेटिनअमेरिकीस्पेनिश'                            => 'es_419',
    'लैटीन'                                                                      => 'la',
    'लोज़ी'                                                                      => 'loz',
    'लोज्बान'                                                                => 'jbo',
    'ल्युओ'                                                                      => 'luo',
    'ल्युलसामी'                                                          => 'smj',
    'ल्यूबाकटांगा'                                                 => 'lu',
    'ल्यूबालुलुआ'                                                    => 'lua',
    'वलामो'                                                                      => 'wal',
    'वाई'                                                                            => 'vai',
    'वाकाशनभाषा'                                                       => 'wak',
    'वारै'                                                                         => 'war',
    'वाल्लून'                                                                => 'wa',
    'वाशो'                                                                         => 'was',
    'विग्वर'                                                                   => 'ug',
    'वियेतनामी'                                                          => 'vi',
    'विविधभाषा'                                                          => 'mis',
    'विविधभाषाएँ'                                                    => 'mul',
    'वेन्दा'                                                                   => 've',
    'वेल्श'                                                                      => 'cy',
    'वॉटिक'                                                                      => 'vot',
    'वोलापुक'                                                                => 'vo',
    'वोलोफ'                                                                      => 'wo',
    'शिंघालीस्'                                                          => 'si',
    'शिपेव्यान'                                                          => 'chp',
    'शेयेन्न'                                                                => 'chy',
    'शेरूकी'                                                                   => 'chr',
    'शैन'                                                                            => 'shn',
    'शैमिकभाषा'                                                          => 'cmc',
    'षोसा'                                                                         => 'xh',
    'संताली'                                                                   => 'sat',
    'संस्कृत'                                                                => 'sa',
    'सन्डावे'                                                                => 'sad',
    'सर्बियन्'                                                             => 'sr',
    'सलीशनभाषा'                                                          => 'sal',
    'सांकेतिकभाषा'                                                 => 'sgn',
    'सांगो'                                                                      => 'sg',
    'सामीभाषा'                                                             => 'smi',
    'सामैरिटनअरैमिक'                                           => 'sam',
    'सामोन'                                                                      => 'sm',
    'सार्दिनियन'                                                       => 'sc',
    'सासाक'                                                                      => 'sas',
    'सिउआनभाषा'                                                          => 'sio',
    'सिक्सिका'                                                             => 'bla',
    'सिचुआनयी'                                                             => 'ii',
    'सिदामो'                                                                   => 'sid',
    'सिन्धी'                                                                   => 'sd',
    'सिबुआनो'                                                                => 'ceb',
    'सिरिएक'                                                                   => 'syr',
    'सिसिलियन'                                                             => 'scn',
    'सुंडानी'                                                                => 'su',
    'सुकुमा'                                                                   => 'suk',
    'सुमेरियन'                                                             => 'sux',
    'सुसु'                                                                         => 'sus',
    'सेत्स्वाना'                                                       => 'tn',
    'सेमिटिकभाषा'                                                    => 'sem',
    'सेरेर'                                                                      => 'srr',
    'सेर्बोक्रोएशन्'                                           => 'sh',
    'सेल्कप'                                                                   => 'sel',
    'सेसोथो'                                                                   => 'st',
    'सॉर्बियनभाषा'                                                 => 'wen',
    'सोंगा'                                                                      => 'ts',
    'सोग्डिएन'                                                             => 'sog',
    'सोणा'                                                                         => 'sn',
    'सोनिन्के'                                                             => 'snk',
    'सोन्घाई'                                                                => 'son',
    'सोमाली'                                                                   => 'so',
    'स्काट्स्गायेलिक्'                                     => 'gd',
    'स्कॉट्स'                                                                => 'sco',
    'स्कोल्टसामी'                                                    => 'sms',
    'स्पेनिश'                                                                => 'es',
    'स्रानानटॉन्गो'                                              => 'srn',
    'स्लेव'                                                                      => 'den',
    'स्लोवाक्'                                                             => 'sk',
    'स्लोवियाईभाषा'                                              => 'sla',
    'स्लोवेनियन्'                                                    => 'sl',
    'स्वाती'                                                                   => 'ss',
    'स्वाहिली'                                                             => 'sw',
    'स्विडिश'                                                                => 'sv',
    'स्विसजर्मन'                                                       => 'gsw',
    'स्विसफ़्रेंच'                                                 => 'fr_ch',
    'स्विसहाईजर्मन'                                              => 'de_ch',
    'हंगेरी'                                                                   => 'hu',
    'हरैरो'                                                                      => 'hz',
    'हावाइयन'                                                                => 'haw',
    'हिताइत'                                                                   => 'hit',
    'हिन्दी'                                                                   => 'hi',
    'हिमाचली'                                                                => 'him',
    'हिरीमोटू'                                                             => 'ho',
    'हिलिगेनन'                                                             => 'hil',
    'हीब्रू'                                                                   => 'he',
    'हूपा'                                                                         => 'hup',
    'हैडा'                                                                         => 'hai',
    'हैतीयन'                                                                   => 'ht',
    'होउसा'                                                                      => 'ha',
    'ह्मॉंग'                                                                   => 'hmn',
);

1;
