/*
 * stream-engine.c - proxy for telepathy-stream-engine's D-Bus API
 *
 * Copyright (C) 2007-2008 Collabora Ltd. <http://www.collabora.co.uk/>
 * Copyright (C) 2007-2008 Nokia Corporation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include "rtcom-telepathy-glib/stream-engine.h"

#include <telepathy-glib/proxy-subclass.h>

#include "rtcom-telepathy-glib/extensions.h"

#include "rtcom-telepathy-glib/_gen/cli-stream-engine-body.h"

G_DEFINE_TYPE (RTComTpStreamEngine,
    rtcom_tp_stream_engine,
    TP_TYPE_PROXY);

static void
rtcom_tp_stream_engine_init (RTComTpStreamEngine *self)
{
}

static void
rtcom_tp_stream_engine_class_init (RTComTpStreamEngineClass *klass)
{
  GType tp_type = RTCOM_TP_TYPE_STREAM_ENGINE;
  TpProxyClass *proxy_class = (TpProxyClass *) klass;

  proxy_class->must_have_unique_name = FALSE;
  proxy_class->interface = RTCOM_TP_IFACE_QUARK_STREAM_ENGINE;
  tp_proxy_or_subclass_hook_on_interface_add (tp_type,
      rtcom_tp_cli_stream_engine_add_signals);
  tp_proxy_subclass_add_error_mapping (tp_type,
      TP_ERROR_PREFIX, TP_ERRORS, TP_TYPE_ERROR);
}

RTComTpStreamEngine *
rtcom_tp_stream_engine_new (TpDBusDaemon *dbus)
{
  return RTCOM_TP_STREAM_ENGINE (g_object_new (RTCOM_TP_TYPE_STREAM_ENGINE,
        "dbus-daemon", dbus,
        "bus-name", RTCOM_TP_STREAM_ENGINE_BUS_NAME,
        "object-path", RTCOM_TP_STREAM_ENGINE_OBJECT_PATH,
        NULL));
}
