/* Copyright (C) 1999 Beau Kuiper

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */

/* Includes */

#include <stdio.h>
#include <unistd.h>
#include <sys/types.h>
#include <stdarg.h>

#ifndef INT_MAX
#define INT_MAX 0x7FFFFFFF
#endif

/* Inportant Constants */

/* yep, true and false */
#define		FALSE		0
#define		TRUE		!FALSE

/* constants declaring various log levels.  */
#define		MYLOG_DACCESS	1    /* denied access to server because of ip */
#define		MYLOG_FTRANS	2    /* file transfer */
#define		MYLOG_COMMAND	4    /* command from client */
#define		MYLOG_RESPONSE	8    /* respone to client commands */
#define		MYLOG_INFO	16   /* informational logs */
#define 	MYLOG_LOGIN	32   /* login information */
#define 	MYLOG_DEBUG	64   /* debug log */

/* set err to this to tell the server the result of getting an auth handle */
#define		AUTH_OK		0	/* got handle, everything good */
#define		AUTH_USERNKNOW	1	/* This module is not responsible for
					   current user, move to next module */
#define		AUTH_ERROR	2	/* A bad error occured, stop attempting
					   to authenticate user */

/* a couple of macros to help :-) */
#define MAXIMUM(x, y)		(x) > (y) ? (x) : (y)
#define MINIMUM(x, y)		(x) > (y) ? (y) : (x)

/* Typedefs */

/* NEWFILE is a structure used with muddleftpd special text file handling
   routines. Don't directly modify its structure */
typedef struct
{
	int fd;
	void *buffer;
	int eof;
} NEWFILE;

/* here as some prototypes for functions you can use */

/* MEMORY FUNCTIONS */

/* Just like malloc, but it checks for out of memory */
extern void *mallocwrapper(int size);

/* Almost same a realloc, execpt supply double pointer of memory area(inarea)
 * and the new size */
void reallocwrapper(int size, void **inarea);

/* Same as strdup, but checks for out of memory result */
char *strdupwrapper(char *s);

/* to free areas created by strdupwrapper and mallocwrapper, It also updates
 * counters used to determine memory leakage, so you should use this instead
 * of plain free() */
void freewrapper(void *tofree);

/* just memmove because muddleftpd will supply a replacement if the system
 * doesn't supply one */
#ifndef HAVE_MEMMOVE
char *memmove(void *dest, void *src, int n);
#endif

/* STRING FUNCTIONS */

/* This drops all characaters with a code < 32 in the string suppled. This is 
 * done in place */
void strtrimspace(char *string);

/* This counts to number of occurences of char tok in the supplied string */
int strchrcount(char *string, char tok);

/* this is vsprintf except the result is given as a string allocated using
 * mallocwrapper. Use freewrapper to reclaim the space it uses */
char *safe_vsnprintf(char *format, va_list ap);

/* this is the same as sprintf execpt the result is given as a string allocated
 * in dynamic memory using mallocwrapper. Use freewrapper to free it */
char *safe_snprintf(char *format, ...);

/* gets suplementary gids of user */
gid_t *getusergrouplist(char *username);

/* these are for really bad errors. Don't use either errormsg or errormsgfatal.
 * Use the ERRORMSG and ERRORMSGFATAL macros instead. BTW, ONLY USE THESE
 * FOR ERRORS THAT CANNOT BE SOLVED ANYWAY ELSE */
void errormsg( char *errmessage, char *file, int line );
void errormsgfatal( char *errmessage, char *file, int line );
#define ERRORMSGFATAL(x)	errormsgfatal(x, __FILE__, __LINE__)
#define ERRORMSG(x)		errormsg(x, __FILE__, __LINE__)

/* LOG OPERATIONS */

/* Adds a log entry to muddleftpd's logs. type is one of the constants
 * specified above. peer is the same peer pointer passed to the gethandle
 * function. desc is the string to add to the log */
extern void log_addentry(int type, void *peer, char *desc);

/* Exactly the same a log_addentry, but muddleftpd will use freewrapper
 * on desc so you can use safe_snprintf for desc */
extern void log_giveentry(int type, void *peer, char *desc);

/* the debug log */
extern void debuglog(char *format, ...);

/* CONFIF FILE OPERATIONS */

char *strsplit(char *, char *, char *);
void substitute(char **inputstr, char *strin, char *strout);
int loadconfigfile(char *filename, int (* confighandler)(char *, char *, int, void *), void *configdata,
	int besecure, int *hendlererror, int *linenum);
void *loadconfigcache(char *filename);
char *mktokconfstr(void *tset, int section, char *setting, char *defaul);
void loadintfromconfig(void *cache, int section, char *setting, int *to, int def);
void loadstrfromconfig(void *cache, int section, char *setting, char **to, char *def);
void freeconfigcache(void *cache);
char **makeconfiglist(void *cache, char *section, char *label);

extern NEWFILE *nfopen(char *filename);
extern NEWFILE *nfdopen(int fd);
extern char *nfgetcs(NEWFILE *file, char testchar);
extern void nfclose(NEWFILE *file);

extern int chkpassword(char *, char *);

