<!--startmeta
custom_edit_url: "https://github.com/netdata/netdata/edit/master/src/go/plugin/go.d/modules/unbound/README.md"
meta_yaml: "https://github.com/netdata/netdata/edit/master/src/go/plugin/go.d/modules/unbound/metadata.yaml"
sidebar_label: "Unbound"
learn_status: "Published"
learn_rel_path: "Collecting Metrics/DNS and DHCP Servers"
most_popular: False
message: "DO NOT EDIT THIS FILE DIRECTLY, IT IS GENERATED BY THE COLLECTOR'S metadata.yaml FILE"
endmeta-->

# Unbound


<img src="https://netdata.cloud/img/unbound.png" width="150"/>


Plugin: go.d.plugin
Module: unbound

<img src="https://img.shields.io/badge/maintained%20by-Netdata-%2300ab44" />

## Overview

This collector monitors Unbound servers.




This collector is supported on all platforms.

This collector supports collecting metrics from multiple instances of this integration, including remote instances.


### Default Behavior

#### Auto-Detection

This integration doesn't support auto-detection.

#### Limits

The default configuration for this integration does not impose any limits on data collection.

#### Performance Impact

The default configuration for this integration is not expected to impose a significant performance impact on the system.


## Metrics

Metrics grouped by *scope*.

The scope defines the instance that the metric belongs to. An instance is uniquely identified by a set of labels.



### Per Unbound instance

These metrics refer to the entire monitored application.

This scope has no labels.

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| unbound.queries | queries | queries |
| unbound.queries_ip_ratelimited | ratelimited | queries |
| unbound.dnscrypt_queries | crypted, cert, cleartext, malformed | queries |
| unbound.cache | hits, miss | events |
| unbound.cache_percentage | hits, miss | percentage |
| unbound.prefetch | prefetches | prefetches |
| unbound.expired | expired | replies |
| unbound.zero_ttl_replies | zero_ttl | replies |
| unbound.recursive_replies | recursive | replies |
| unbound.recursion_time | avg, median | milliseconds |
| unbound.request_list_usage | avg, max | queries |
| unbound.current_request_list_usage | all, users | queries |
| unbound.request_list_jostle_list | overwritten, dropped | queries |
| unbound.tcpusage | usage | buffers |
| unbound.uptime | time | seconds |
| unbound.cache_memory | message, rrset, dnscrypt_nonce, dnscrypt_shared_secret | KB |
| unbound.mod_memory | iterator, respip, validator, subnet, ipsec | KB |
| unbound.mem_streamwait | streamwait | KB |
| unbound.cache_count | infra, key, msg, rrset, dnscrypt_nonce, shared_secret | items |
| unbound.type_queries | a dimension per query type | queries |
| unbound.class_queries | a dimension per query class | queries |
| unbound.opcode_queries | a dimension per query opcode | queries |
| unbound.flag_queries | qr, aa, tc, rd, ra, z, ad, cd | queries |
| unbound.rcode_answers | a dimension per reply rcode | replies |

### Per thread

These metrics refer to threads.

This scope has no labels.

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| unbound.thread_queries | queries | queries |
| unbound.thread_queries_ip_ratelimited | ratelimited | queries |
| unbound.thread_dnscrypt_queries | crypted, cert, cleartext, malformed | queries |
| unbound.thread_cache | hits, miss | events |
| unbound.thread_cache_percentage | hits, miss | percentage |
| unbound.thread_prefetch | prefetches | prefetches |
| unbound.thread_expired | expired | replies |
| unbound.thread_zero_ttl_replies | zero_ttl | replies |
| unbound.thread_recursive_replies | recursive | replies |
| unbound.thread_recursion_time | avg, median | milliseconds |
| unbound.thread_request_list_usage | avg, max | queries |
| unbound.thread_current_request_list_usage | all, users | queries |
| unbound.thread_request_list_jostle_list | overwritten, dropped | queries |
| unbound.thread_tcpusage | usage | buffers |



## Alerts

There are no alerts configured by default for this integration.


## Setup

### Prerequisites

#### Enable remote control interface

Set `control-enable` to yes in [unbound.conf](https://nlnetlabs.nl/documentation/unbound/unbound.conf).


#### Check permissions and adjust if necessary

If using unix socket:

- socket should be readable and writeable by `netdata` user

If using ip socket and TLS is disabled:

- socket should be accessible via network

If TLS is enabled, in addition:

- `control-key-file` should be readable by `netdata` user
- `control-cert-file` should be readable by `netdata` user

For auto-detection parameters from `unbound.conf`:

- `unbound.conf` should be readable by `netdata` user
- if you have several configuration files (include feature) all of them should be readable by `netdata` user



### Configuration

#### File

The configuration file name for this integration is `go.d/unbound.conf`.


You can edit the configuration file using the `edit-config` script from the
Netdata [config directory](/docs/netdata-agent/configuration/README.md#the-netdata-config-directory).

```bash
cd /etc/netdata 2>/dev/null || cd /opt/netdata/etc/netdata
sudo ./edit-config go.d/unbound.conf
```
#### Options

The following options can be defined globally: update_every, autodetection_retry.


<details open><summary>Config options</summary>

| Name | Description | Default | Required |
|:----|:-----------|:-------|:--------:|
| update_every | Data collection frequency. | 5 | no |
| autodetection_retry | Recheck interval in seconds. Zero means no recheck will be scheduled. | 0 | no |
| address | Server address in IP:PORT format. | 127.0.0.1:8953 | yes |
| timeout | Connection/read/write/ssl handshake timeout. | 1 | no |
| conf_path | Absolute path to the unbound configuration file. | /etc/unbound/unbound.conf | no |
| cumulative_stats | Statistics collection mode. Should have the same value as the `statistics-cumulative` parameter in the unbound configuration file. | no | no |
| use_tls | Whether to use TLS or not. | yes | no |
| tls_skip_verify | Server certificate chain and hostname validation policy. Controls whether the client performs this check. | yes | no |
| tls_ca | Certificate authority that client use when verifying server certificates. |  | no |
| tls_cert | Client tls certificate. | /etc/unbound/unbound_control.pem | no |
| tls_key | Client tls key. | /etc/unbound/unbound_control.key | no |

</details>

#### Examples

##### Basic

An example configuration.

<details open><summary>Config</summary>

```yaml
jobs:
  - name: local
    address: 127.0.0.1:8953

```
</details>

##### Unix socket

Connecting through Unix socket.

<details open><summary>Config</summary>

```yaml
jobs:
  - name: socket
    address: /var/run/unbound.sock

```
</details>

##### Multi-instance

> **Note**: When you define multiple jobs, their names must be unique.

Local and remote instances.


<details open><summary>Config</summary>

```yaml
jobs:
  - name: local
    address: 127.0.0.1:8953

  - name: remote
    address: 203.0.113.11:8953

```
</details>



## Troubleshooting

### Debug Mode

**Important**: Debug mode is not supported for data collection jobs created via the UI using the Dyncfg feature.

To troubleshoot issues with the `unbound` collector, run the `go.d.plugin` with the debug option enabled. The output
should give you clues as to why the collector isn't working.

- Navigate to the `plugins.d` directory, usually at `/usr/libexec/netdata/plugins.d/`. If that's not the case on
  your system, open `netdata.conf` and look for the `plugins` setting under `[directories]`.

  ```bash
  cd /usr/libexec/netdata/plugins.d/
  ```

- Switch to the `netdata` user.

  ```bash
  sudo -u netdata -s
  ```

- Run the `go.d.plugin` to debug the collector:

  ```bash
  ./go.d.plugin -d -m unbound
  ```

### Getting Logs

If you're encountering problems with the `unbound` collector, follow these steps to retrieve logs and identify potential issues:

- **Run the command** specific to your system (systemd, non-systemd, or Docker container).
- **Examine the output** for any warnings or error messages that might indicate issues.  These messages should provide clues about the root cause of the problem.

#### System with systemd

Use the following command to view logs generated since the last Netdata service restart:

```bash
journalctl _SYSTEMD_INVOCATION_ID="$(systemctl show --value --property=InvocationID netdata)" --namespace=netdata --grep unbound
```

#### System without systemd

Locate the collector log file, typically at `/var/log/netdata/collector.log`, and use `grep` to filter for collector's name:

```bash
grep unbound /var/log/netdata/collector.log
```

**Note**: This method shows logs from all restarts. Focus on the **latest entries** for troubleshooting current issues.

#### Docker Container

If your Netdata runs in a Docker container named "netdata" (replace if different), use this command:

```bash
docker logs netdata 2>&1 | grep unbound
```


