/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.mimetype;

import java.io.File;
import java.util.Locale;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.services.mimetype.MimeTypeService;
import org.apache.turbine.services.mimetype.util.MimeType;

public abstract class TurbineMimeTypes {
    public static String getContentType(File file) {
        return TurbineMimeTypes.getService().getContentType(file);
    }

    public static String getContentType(String name) {
        return TurbineMimeTypes.getService().getContentType(name);
    }

    public static String getContentType(String ext, String def) {
        return TurbineMimeTypes.getService().getContentType(ext, def);
    }

    public static MimeType getMimeContentType(File file) {
        return TurbineMimeTypes.getService().getMimeContentType(file);
    }

    public static MimeType getMimeContentType(String name) {
        return TurbineMimeTypes.getService().getMimeContentType(name);
    }

    public static MimeType getMimeContentType(String ext, String def) {
        return TurbineMimeTypes.getService().getMimeContentType(ext, def);
    }

    public static String getDefaultExtension(MimeType mime) {
        return TurbineMimeTypes.getService().getDefaultExtension(mime);
    }

    public static String getCharSet(Locale locale) {
        return TurbineMimeTypes.getService().getCharSet(locale);
    }

    public static String getCharSet(Locale locale, String variant) {
        return TurbineMimeTypes.getService().getCharSet(locale, variant);
    }

    public static String getCharSet(String key) {
        return TurbineMimeTypes.getService().getCharSet(key);
    }

    public static String getCharSet(String key, String def) {
        return TurbineMimeTypes.getService().getCharSet(key, def);
    }

    protected static MimeTypeService getService() {
        return (MimeTypeService)TurbineServices.getInstance().getService("MimeTypeService");
    }
}

