/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services;

import java.util.Iterator;
import java.util.Properties;
import javax.servlet.ServletConfig;
import org.apache.turbine.services.BaseServiceBroker;
import org.apache.turbine.services.InitializationException;
import org.apache.turbine.services.InstantiationException;
import org.apache.turbine.services.ServiceBroker;
import org.apache.turbine.services.logging.LoggingService;
import org.apache.turbine.services.resources.ResourceService;
import org.apache.turbine.services.resources.TurbineResources;
import org.apache.velocity.runtime.configuration.Configuration;

public class TurbineServices
extends BaseServiceBroker {
    public static final String RESOURCES_CLASS_KEY = "resources";
    public static final String RESOURCES_CLASS_DEFAULT = "org.apache.turbine.services.resources.TurbineResourceService";
    public static final String LOGGING_CLASS_DEFAULT = "org.apache.turbine.services.logging.TurbineLoggingService";
    public static final String LOGGING_CLASS_KEY = "logging";
    public static final String PROPERTIES_PATH_KEY = "properties";
    public static final String PROPERTIES_PATH_DEFAULT = "/WEB-INF/conf/TurbineResources.properties";
    public static final String SERVICE_PREFIX = "services.";
    public static final String CLASSNAME_SUFFIX = ".classname";
    protected static ServiceBroker instance = new TurbineServices();
    private boolean enabledLogging = false;

    public static ServiceBroker getInstance() {
        return instance;
    }

    public void initPrimaryServices(ServletConfig config) throws InstantiationException, InitializationException {
        String resourcesClass = config.getInitParameter(RESOURCES_CLASS_KEY);
        if (resourcesClass == null) {
            resourcesClass = RESOURCES_CLASS_DEFAULT;
        }
        this.mapping.put("ResourceService", resourcesClass);
        this.initService("ResourceService", config);
        String loggingClass = config.getInitParameter(LOGGING_CLASS_KEY);
        if (loggingClass == null) {
            loggingClass = LOGGING_CLASS_DEFAULT;
        }
        this.mapping.put("LoggingService", loggingClass);
        this.initService("LoggingService", config);
        this.enableLogging();
        this.initMapping();
    }

    public void initMapping(Configuration mapping) {
        this.mapping = mapping;
    }

    protected void initMapping() {
        int pref = SERVICE_PREFIX.length();
        int suff = CLASSNAME_SUFFIX.length();
        Iterator keys = TurbineResources.getKeys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            if (!key.startsWith(SERVICE_PREFIX) || !key.endsWith(CLASSNAME_SUFFIX)) continue;
            String serviceKey = key.substring(pref, key.length() - suff);
            this.notice("Added Mapping for Service: " + serviceKey);
            if (this.mapping.containsKey(serviceKey)) continue;
            this.mapping.setProperty(serviceKey, TurbineResources.getString(key));
        }
    }

    public Properties getProperties(String name) {
        Properties properties = new Properties();
        String servicePrefix = SERVICE_PREFIX + name + ".";
        Iterator keys = TurbineResources.getKeys(servicePrefix);
        while (keys.hasNext()) {
            String value;
            String key = (String)keys.next();
            try {
                String string = TurbineResources.getString(key);
            }
            catch (ClassCastException propIsArray) {
                String[] values = TurbineResources.getStringArray(key);
                value = values[values.length - 1];
            }
            properties.setProperty(key.substring(servicePrefix.length()), value);
        }
        return properties;
    }

    public Configuration getConfiguration(String name) {
        return TurbineResources.getConfiguration(SERVICE_PREFIX + name);
    }

    public ResourceService getResources(String name) {
        return TurbineResources.getResources(SERVICE_PREFIX + name);
    }

    public void notice(String msg) {
        if (this.enabledLogging) {
            LoggingService logger = this.getLogger();
            if (logger == null) {
                System.out.println("(!) NOTICE: " + msg);
            } else {
                logger.info(msg);
            }
        } else {
            System.out.println("NOTICE: " + msg);
        }
    }

    public void error(Throwable t) {
        if (this.enabledLogging) {
            LoggingService logger = this.getLogger();
            if (logger == null) {
                System.out.println("(!) ERROR: " + t.getMessage());
            } else {
                logger.error("", t);
            }
        } else {
            System.out.println("ERROR: " + t.getMessage());
            t.printStackTrace();
        }
    }

    private void enableLogging() {
        LoggingService logger = this.getLogger();
        if (logger != null) {
            logger.info("ServiceBroker: LoggingService enabled.");
            this.enabledLogging = true;
        }
    }

    private final LoggingService getLogger() {
        return (LoggingService)this.getService("LoggingService");
    }

    protected TurbineServices() {
    }
}

