/*###############################################################################
# Linux Management Providers (LMP), SSH provider package
# Copyright (C) 2010 Feng Zhanlei, REDFLAG <fengzhanlei@redflag-linux.com>
# 
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
# 
# Modified by Guillaume BOTTEX <guillaumebottex@uxsystem.net>, UXSystem, 2010
###############################################################################*/

#include "OpenDRIM_SSHProtocolServiceAccess.h"

const string systemCreationClassName = "OpenDRIM_ComputerSystem";
const string creationClassName = "OpenDRIM_SSHProtocolService";
const string name = "/usr/sbin/sshd";
string systemName;

int SSH_OpenDRIM_SSHProtocolService_load(const CMPIBroker* broker, string& errorMessage) {
	_E_;
	CF_assert(CF_getSystemName(systemName, errorMessage));
	_L_;
	return OK;
}

int SSH_OpenDRIM_SSHProtocolService_unload(string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return OK;
}

int SSH_OpenDRIM_SSHProtocolService_retrieve(const CMPIBroker* broker, const CMPIContext* ctx, vector<OpenDRIM_SSHProtocolService>& result, const char** properties, string& errorMessage, const string& discriminant) {
	_E_;
	if (!CF_isExist(name))
		return OK;
	
	//Initialize an instance
	OpenDRIM_SSHProtocolService instance;
	instance.setSystemCreationClassName(systemCreationClassName);
	instance.setCreationClassName(creationClassName);
	instance.setSystemName(systemName);
	instance.setName(name);

	if (discriminant == "ei")
		CF_assert(SSH_OpenDRIM_SSHProtocolService_populate(instance, errorMessage));

	result.push_back(instance);
	_L_;
	return OK;
}

int SSH_OpenDRIM_SSHProtocolService_getInstance(const CMPIBroker* broker, const CMPIContext* ctx, OpenDRIM_SSHProtocolService& instance, const char** properties, string& errorMessage) {
	_E_;
	if (instance.SystemCreationClassName != systemCreationClassName ||
			instance.CreationClassName != creationClassName ||
			instance.SystemName != systemName ||
			instance.Name != name ||
			!CF_isExist(name))
	{
		errorMessage = "Invalid path";
		return NOT_FOUND;
	}
	
	CF_assert(SSH_OpenDRIM_SSHProtocolService_populate(instance, errorMessage));
	_L_;
	return OK;
}

int SSH_OpenDRIM_SSHProtocolService_setInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_SSHProtocolService& newInstance, const OpenDRIM_SSHProtocolService& oldInstance, const char** properties, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int SSH_OpenDRIM_SSHProtocolService_createInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_SSHProtocolService& instance, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int SSH_OpenDRIM_SSHProtocolService_deleteInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_SSHProtocolService& instance, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int SSH_OpenDRIM_SSHProtocolService_RequestStateChange(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_SSHProtocolService& instance, unsigned int& returnValue, const OpenDRIM_SSHProtocolService_RequestStateChange_In& in, OpenDRIM_SSHProtocolService_RequestStateChange_Out& out, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return OK;
}

int SSH_OpenDRIM_SSHProtocolService_StartService(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_SSHProtocolService& instance, unsigned int& returnValue, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return OK;
}

int SSH_OpenDRIM_SSHProtocolService_StopService(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_SSHProtocolService& instance, unsigned int& returnValue, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return OK;
}

int SSH_OpenDRIM_SSHProtocolService_ChangeAffectedElementsAssignedSequence(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_SSHProtocolService& instance, unsigned int& returnValue, const OpenDRIM_SSHProtocolService_ChangeAffectedElementsAssignedSequence_In& in, OpenDRIM_SSHProtocolService_ChangeAffectedElementsAssignedSequence_Out& out, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return OK;
}

int SSH_OpenDRIM_SSHProtocolService_ListenOnPort(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_SSHProtocolService& instance, unsigned int& returnValue, const OpenDRIM_SSHProtocolService_ListenOnPort_In& in, OpenDRIM_SSHProtocolService_ListenOnPort_Out& out, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return OK;
}

int SSH_OpenDRIM_SSHProtocolService_populate(OpenDRIM_SSHProtocolService& instance, string& errorMessage) {
	_E_;
	/*
	 * Properties to fill from profile
	 * + Mandatory:
	 * [X] SystemCreationClassName [KEY]
	 * [X] CreationClassName       [KEY]
	 * [X] SystemName              [KEY]
	 * [X] Name                    [KEY]
	 * [X] Protocol
	 * [X] MaxConnections
	 * [X] RequestedState
	 * [X] EnabledState
	 * [X] ElementName
	 * [X] OperationalStatus
	 * [X] HealthState
	 */
	
	string elementName;
	
	CF_assert(CF_getWhatisFL("sshd",elementName,errorMessage));

	instance.setProtocol(2); // SSH
	
	string out_str;
	unsigned short maxSessions;
	CF_assert(CF_getConfigItem("MaxSession", out_str, errorMessage));
	
	if (out_str.size() != 0)
	{
		maxSessions = atoi(out_str.c_str());
		instance.setMaxConnections(maxSessions);
	}
	else
		instance.setMaxConnections(10);
	
	instance.setRequestedState(12); // Not Applicable
	instance.setEnabledState(5); // Not Applicable
	instance.setElementName(elementName);
	instance.setHealthState(0); // Unknown

	vector<unsigned short> operationalStatus;
	string cmd = "ps aux | grep /usr/sbin/sshd | grep -v grep";
	string stdout_msg, stderr_msg;

	CF_assert(CF_runCommand(cmd, stdout_msg, stderr_msg, errorMessage));
	
	if (stdout_msg.size() > 0)
		operationalStatus.push_back(2); // OK
	else
		operationalStatus.push_back(10); // Stopped
	
	instance.setOperationalStatus(operationalStatus);
	_L_;
	return OK;
}

