/*
 *  Copyright (c) 2008 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef _GTLFRAGMENT_LIBRARY_COMPILATION_H_
#define _GTLFRAGMENT_LIBRARY_COMPILATION_H_

#include "Export.h"
#include <GTLFragment/WhichStdLibrary_p.h>

namespace llvm {
  class Module;
}

namespace GTLCore {
  class ModuleData;
  class OperatorOverloadCenter;
}

namespace GTLFragment {
  class Wrapper;
  /**
   * @internal
   * @ingroup GTLFragment
   * 
   * Interface class to define preCompilation step of a @ref Library
   */
  class GTLFRAGMENT_EXPORT LibraryCompilation {
    public:
      LibraryCompilation();
      virtual ~LibraryCompilation();
      virtual void preCompilation() = 0;
      virtual void cleanup() = 0;
      virtual void postCompilation() = 0;
      virtual void createWrapper(GTLCore::ModuleData* _moduleData, llvm::Module* module, int _channels, WhichStdLibrary _library) = 0;
      virtual void addOperatorOverloads(GTLCore::OperatorOverloadCenter*) = 0;
      virtual Wrapper* wrapper() = 0;
  };
  
};

#endif
