/*
 * Copyright (c) 2005, 2006, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */
/* this file is generated by RelaxNGCC */
package com.sun.xml.internal.xsom.impl.parser.state;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.Attributes;
import com.sun.xml.internal.xsom.impl.parser.NGCCRuntimeEx;

    import com.sun.xml.internal.xsom.*;
    import com.sun.xml.internal.xsom.parser.*;
    import com.sun.xml.internal.xsom.impl.*;
    import com.sun.xml.internal.xsom.impl.parser.*;
    import org.xml.sax.Locator;
    import org.xml.sax.ContentHandler;
    import org.xml.sax.helpers.*;
    import java.util.*;



class complexType extends NGCCHandler {
    private Integer finalValue;
    private String name;
    private String abstractValue;
    private Integer blockValue;
    private XSFacet facet;
    private ForeignAttributesImpl fa;
    private AnnotationImpl annotation;
    private ContentTypeImpl explicitContent;
    private UName baseTypeName;
    private String mixedValue;
    protected final NGCCRuntimeEx $runtime;
    private int $_ngcc_current_state;
    protected String $uri;
    protected String $localName;
    protected String $qname;

    public final NGCCRuntime getRuntime() {
        return($runtime);
    }

    public complexType(NGCCHandler parent, NGCCEventSource source, NGCCRuntimeEx runtime, int cookie) {
        super(source, parent, cookie);
        $runtime = runtime;
        $_ngcc_current_state = 88;
    }

    public complexType(NGCCRuntimeEx runtime) {
        this(null, runtime, runtime, -1);
    }

    private void action0()throws SAXException {

            result.setContentType(explicitContent);

}

    private void action1()throws SAXException {

            baseType = $runtime.parser.schemaSet.anyType;
            makeResult(XSType.RESTRICTION);

}

    private void action2()throws SAXException {

                result.setExplicitContent(explicitContent);
                result.setContentType(
                  buildComplexExtensionContentModel(explicitContent));

}

    private void action3()throws SAXException {

                  baseType = new DelayedRef.Type(
                    $runtime, locator2, $runtime.currentSchema, baseTypeName );
                  makeResult(XSType.EXTENSION);

}

    private void action4()throws SAXException {
        locator2 = $runtime.copyLocator();
}

    private void action5()throws SAXException {

                result.setContentType(explicitContent);

}

    private void action6()throws SAXException {

                  baseType = new DelayedRef.Type(
                    $runtime, locator2, $runtime.currentSchema, baseTypeName );
                  makeResult(XSType.RESTRICTION);

}

    private void action7()throws SAXException {
        locator2 = $runtime.copyLocator();
}

    private void action8()throws SAXException {

                contentType = new BaseContentRef($runtime,baseType);
                makeResult(XSType.EXTENSION);
                result.setContentType(contentType);

}

    private void action9()throws SAXException {

                  baseType = new DelayedRef.Type(
                    $runtime, locator2, $runtime.currentSchema, baseTypeName );

}

    private void action10()throws SAXException {
        locator2 = $runtime.copyLocator();
}

    private void action11()throws SAXException {

                makeResult(XSType.RESTRICTION);
                result.setContentType(contentType);

}

    private void action12()throws SAXException {
        contentSimpleType.addFacet(facet);
}

    private void action13()throws SAXException {

                if(baseContentType==null) {
                  // contentType of the base type, which must be a complex type
                  baseContentType = new BaseContentSimpleTypeRef(baseType);
                }

                contentSimpleType = new RestrictionSimpleTypeImpl(
                  $runtime.document, null/*?*/, locator2, null,
                  null, true, Collections.EMPTY_SET, baseContentType );
                contentType = contentSimpleType;

}

    private void action14()throws SAXException {

                  baseType = new DelayedRef.Type(
                    $runtime, locator2, $runtime.currentSchema, baseTypeName );

}

    private void action15()throws SAXException {
        locator2 = $runtime.copyLocator();
}

    private void action16()throws SAXException {
        locator = $runtime.copyLocator();
}

    public void enterElement(String $__uri, String $__local, String $__qname, Attributes $attrs) throws SAXException {
        int $ai;
        $uri = $__uri;
        $localName = $__local;
        $qname = $__qname;
        switch($_ngcc_current_state) {
        case 7:
            {
                if(($__uri.equals("http://www.w3.org/2001/XMLSchema") && $__local.equals("restriction"))) {
                    $runtime.onEnterElementConsumed($__uri, $__local, $__qname, $attrs);
                    action7();
                    $_ngcc_current_state = 24;
                }
                else {
                    if(($__uri.equals("http://www.w3.org/2001/XMLSchema") && $__local.equals("extension"))) {
                        $runtime.onEnterElementConsumed($__uri, $__local, $__qname, $attrs);
                        action4();
                        $_ngcc_current_state = 15;
                    }
                    else {
                        unexpectedEnterElement($__qname);
                    }
                }
            }
            break;
        case 38:
            {
                action8();
                $_ngcc_current_state = 37;
                $runtime.sendEnterElement(super._cookie, $__uri, $__local, $__qname, $attrs);
            }
            break;
        case 48:
            {
                if((((((((((((($__uri.equals("http://www.w3.org/2001/XMLSchema") && $__local.equals("minExclusive")) || ($__uri.equals("http://www.w3.org/2001/XMLSchema") && $__local.equals("maxExclusive"))) || ($__uri.equals("http://www.w3.org/2001/XMLSchema") && $__local.equals("minInclusive"))) || ($__uri.equals("http://www.w3.org/2001/XMLSchema") && $__local.equals("maxInclusive"))) || ($__uri.equals("http://www.w3.org/2001/XMLSchema") && $__local.equals("totalDigits"))) || ($__uri.equals("http://www.w3.org/2001/XMLSchema") && $__local.equals("fractionDigits"))) || ($__uri.equals("http://www.w3.org/2001/XMLSchema") && $__local.equals("length"))) || ($__uri.equals("http://www.w3.org/2001/XMLSchema") && $__local.equals("maxLength"))) || ($__uri.equals("http://www.w3.org/2001/XMLSchema") && $__local.equals("minLength"))) || ($__uri.equals("http://www.w3.org/2001/XMLSchema") && $__local.equals("enumeration"))) || ($__uri.equals("http://www.w3.org/2001/XMLSchema") && $__local.equals("whiteSpace"))) || ($__uri.equals("http://www.w3.org/2001/XMLSchema") && $__local.equals("pattern")))) {
                    NGCCHandler h = new facet(this, super._source, $runtime, 257);
                    spawnChildFromEnterElement(h, $__uri, $__local, $__qname, $attrs);
                }
                else {
                    action11();
                    $_ngcc_current_state = 47;
                    $runtime.sendEnterElement(super._cookie, $__uri, $__local, $__qname, $attrs);
                }
            }
            break;
        case 72:
            {
                if(($ai = $runtime.getAttributeIndex("","mixed"))>=0) {
                    $runtime.consumeAttribute($ai);
                    $runtime.sendEnterElement(super._cookie, $__uri, $__local, $__qname, $attrs);
                }
                else {
                    $_ngcc_current_state = 68;
                    $runtime.sendEnterElement(super._cookie, $__uri, $__local, $__qname, $attrs);
                }
            }
            break;
        case 44:
            {
                if(($ai = $runtime.getAttributeIndex("","base"))>=0) {
                    $runtime.consumeAttribute($ai);
                    $runtime.sendEnterElement(super._cookie, $__uri, $__local, $__qname, $attrs);
                }
                else {
                    unexpectedEnterElement($__qname);
                }
            }
            break;
        case 49:
            {
                if((((((((((((($__uri.equals("http://www.w3.org/2001/XMLSchema") && $__local.equals("minExclusive")) || ($__uri.equals("http://www.w3.org/2001/XMLSchema") && $__local.equals("maxExclusive"))) || ($__uri.equals("http://www.w3.org/2001/XMLSchema") && $__local.equals("minInclusive"))) || ($__uri.equals("http://www.w3.org/2001/XMLSchema") && $__local.equals("maxInclusive"))) || ($__uri.equals("http://www.w3.org/2001/XMLSchema") && $__local.equals("totalDigits"))) || ($__uri.equals("http://www.w3.org/2001/XMLSchema") && $__local.equals("fractionDigits"))) || ($__uri.equals("http://www.w3.org/2001/XMLSchema") && $__local.equals("length"))) || ($__uri.equals("http://www.w3.org/2001/XMLSchema") && $__local.equals("maxLength"))) || ($__uri.equals("http://www.w3.org/2001/XMLSchema") && $__local.equals("minLength"))) || ($__uri.equals("http://www.w3.org/2001/XMLSchema") && $__local.equals("enumeration"))) || ($__uri.equals("http://www.w3.org/2001/XMLSchema") && $__local.equals("whiteSpace"))) || ($__uri.equals("http://www.w3.org/2001/XMLSchema") && $__local.equals("pattern")))) {
                    NGCCHandler h = new facet(this, super._source, $runtime, 258);
                    spawnChildFromEnterElement(h, $__uri, $__local, $__qname, $attrs);
                }
                else {
                    $_ngcc_current_state = 48;
                    $runtime.sendEnterElement(super._cookie, $__uri, $__local, $__qname, $attrs);
                }
            }
            break;
        case 18:
            {
                if((((($__uri.equals("http://www.w3.org/2001/XMLSchema") && $__local.equals("all")) || ($__uri.equals("http://www.w3.org/2001/XMLSchema") && $__local.equals("choice"))) || ($__uri.equals("http://www.w3.org/2001/XMLSchema") && $__local.equals("sequence"))) || (($__uri.equals("http://www.w3.org/2001/XMLSchema") && $__local.equals("anyAttribute")) || (($__uri.equals("http://www.w3.org/2001/XMLSchema") && $__local.equals("attributeGroup")) || (($__uri.equals("http://www.w3.org/2001/XMLSchema") && $__local.equals("attribute")) || (($__uri.equals("http://www.w3.org/2001/XMLSchema") && $__local.equals("any")) || (($__uri.equals("http://www.w3.org/2001/XMLSchema") && $__local.equals("element")) || ($__uri.equals("http://www.w3.org/2001/XMLSchema") && $__local.equals("group"))))))))) {
                    NGCCHandler h = new complexType_complexContent_body(this, super._source, $runtime, 219, result);
                    spawnChildFromEnterElement(h, $__uri, $__local, $__qname, $attrs);
                }
                else {
                    unexpectedEnterElement($__qname);
                }
            }
            break;
        case 67:
            {
                if((($__uri.equals("http://www.w3.org/2001/XMLSchema") && $__local.equals("annotation")) || (((($__uri.equals("http://www.w3.org/2001/XMLSchema") && $__local.equals("all")) || ($__uri.equals("http://www.w3.org/2001/XMLSchema") && $__local.equals("choice"))) || ($__uri.equals("http://www.w3.org/2001/XMLSchema") && $__local.equals("sequence"))) || (($__uri.equals("http://www.w3.org/2001/XMLSchema") && $__local.equals("complexContent")) || (($__uri.equals("http://www.w3.org/2001/XMLSchema") && $__local.equals("anyAttribute")) || (($__uri.equals("http://www.w3.org/2001/XMLSchema") && $__local.equals("attributeGroup")) || (($__uri.equals("http://www.w3.org/2001/XMLSchema") && $__local.equals("attribute")) || (($__uri.equals("http://www.w3.org/2001/XMLSchema") && $__local.equals("any")) || (($__uri.equals("http://www.w3.org/2001/XMLSchema") && $__local.equals("element")) || (($__uri.equals("http://www.w3.org/2001/XMLSchema") && $__local.equals("group")) || ($__uri.equals("http://www.w3.org/2001/XMLSchema") && $__local.equals("simpleContent")))))))))))) {
                    NGCCHandler h = new foreignAttributes(this, super._source, $runtime, 284, fa);
                    spawnChildFromEnterElement(h, $__uri, $__local, $__qname, $attrs);
                }
                else {
                    unexpectedEnterElement($__qname);
                }
            }
            break;
        case 88:
            {
                if(($__uri.equals("http://www.w3.org/2001/XMLSchema") && $__local.equals("complexType"))) {
                    $runtime.onEnterElementConsumed($__uri, $__local, $__qname, $attrs);
                    action16();
                    $_ngcc_current_state = 84;
                }
                else {
                    unexpectedEnterElement($__qname);
                }
            }
            break;
        case 61:
            {
                if(($__uri.equals("http://www.w3.org/2001/XMLSchema") && $__local.equals("annotation"))) {
                    NGCCHandler h = new annotation(this, super._source, $runtime, 274, annotation,AnnotationContext.COMPLEXTYPE_DECL);
                    spawnChildFromEnterElement(h, $__uri, $__local, $__qname, $attrs);
                }
                else {
                    $_ngcc_current_state = 35;
                    $runtime.sendEnterElement(super._cookie, $__uri, $__local, $__qname, $attrs);
                }
            }
            break;
        case 28:
            {
                if((($__uri.equals("http://www.w3.org/2001/XMLSchema") && $__local.equals("annotation")) || (($__uri.equals("http://www.w3.org/2001/XMLSchema") && $__local.equals("restriction")) || ($__uri.equals("http://www.w3.org/2001/XMLSchema") && $__local.equals("extension"))))) {
                    NGCCHandler h = new foreignAttributes(this, super._source, $runtime, 232, fa);
                    spawnChildFromEnterElement(h, $__uri, $__local, $__qname, $attrs);
                }
                else {
                    unexpectedEnterElement($__qname);
                }
            }
            break;
        case 80:
            {
                if(($ai = $runtime.getAttributeIndex("","block"))>=0) {
                    $runtime.consumeAttribute($ai);
                    $runtime.sendEnterElement(super._cookie, $__uri, $__local, $__qname, $attrs);
                }
                else {
                    $_ngcc_current_state = 76;
                    $runtime.sendEnterElement(super._cookie, $__uri, $__local, $__qname, $attrs);
                }
            }
            break;
        case 12:
            {
                if((($__uri.equals("http://www.w3.org/2001/XMLSchema") && $__local.equals("annotation")) || (((($__uri.equals("http://www.w3.org/2001/XMLSchema") && $__local.equals("all")) || ($__uri.equals("http://www.w3.org/2001/XMLSchema") && $__local.equals("choice"))) || ($__uri.equals("http://www.w3.org/2001/XMLSchema") && $__local.equals("sequence"))) || (($__uri.equals("http://www.w3.org/2001/XMLSchema") && $__local.equals("anyAttribute")) || (($__uri.equals("http://www.w3.org/2001/XMLSchema") && $__local.equals("attributeGroup")) || (($__uri.equals("http://www.w3.org/2001/XMLSchema") && $__local.equals("attribute")) || (($__uri.equals("http://www.w3.org/2001/XMLSchema") && $__local.equals("any")) || (($__uri.equals("http://www.w3.org/2001/XMLSchema") && $__local.equals("element")) || ($__uri.equals("http://www.w3.org/2001/XMLSchema") && $__local.equals("group")))))))))) {
                    NGCCHandler h = new foreignAttributes(this, super._source, $runtime, 212, fa);
                    spawnChildFromEnterElement(h, $__uri, $__local, $__qname, $attrs);
                }
                else {
                    unexpectedEnterElement($__qname);
                }
            }
            break;
        case 35:
            {
                if(($__uri.equals("http://www.w3.org/2001/XMLSchema") && $__local.equals("restriction"))) {
                    $runtime.onEnterElementConsumed($__uri, $__local, $__qname, $attrs);
                    action15();
                    $_ngcc_current_state = 59;
                }
                else {
                    if(($__uri.equals("http://www.w3.org/2001/XMLSchema") && $__local.equals("extension"))) {
                        $runtime.onEnterElementConsumed($__uri, $__local, $__qname, $attrs);
                        action10();
                        $_ngcc_current_state = 44;
                    }
                    else {
                        unexpectedEnterElement($__qname);
                    }
                }
            }
            break;
        case 76:
            {
                if(($ai = $runtime.getAttributeIndex("","final"))>=0) {
                    $runtime.consumeAttribute($ai);
                    $runtime.sendEnterElement(super._cookie, $__uri, $__local, $__qname, $attrs);
                }
                else {
                    $_ngcc_current_state = 72;
                    $runtime.sendEnterElement(super._cookie, $__uri, $__local, $__qname, $attrs);
                }
            }
            break;
        case 51:
            {
                action13();
                $_ngcc_current_state = 49;
                $runtime.sendEnterElement(super._cookie, $__uri, $__local, $__qname, $attrs);
            }
            break;
        case 47:
            {
                if((($__uri.equals("http://www.w3.org/2001/XMLSchema") && $__local.equals("attributeGroup")) || (($__uri.equals("http://www.w3.org/2001/XMLSchema") && $__local.equals("anyAttribute")) || ($__uri.equals("http://www.w3.org/2001/XMLSchema") && $__local.equals("attribute"))))) {
                    NGCCHandler h = new attributeUses(this, super._source, $runtime, 254, result);
                    spawnChildFromEnterElement(h, $__uri, $__local, $__qname, $attrs);
                }
                else {
                    unexpectedEnterElement($__qname);
                }
            }
            break;
        case 68:
            {
                if(($ai = $runtime.getAttributeIndex("","name"))>=0) {
                    $runtime.consumeAttribute($ai);
                    $runtime.sendEnterElement(super._cookie, $__uri, $__local, $__qname, $attrs);
                }
                else {
                    $_ngcc_current_state = 67;
                    $runtime.sendEnterElement(super._cookie, $__uri, $__local, $__qname, $attrs);
                }
            }
            break;
        case 15:
            {
                if(($ai = $runtime.getAttributeIndex("","base"))>=0) {
                    $runtime.consumeAttribute($ai);
                    $runtime.sendEnterElement(super._cookie, $__uri, $__local, $__qname, $attrs);
                }
                else {
                    unexpectedEnterElement($__qname);
                }
            }
            break;
        case 37:
            {
                if((($__uri.equals("http://www.w3.org/2001/XMLSchema") && $__local.equals("attributeGroup")) || (($__uri.equals("http://www.w3.org/2001/XMLSchema") && $__local.equals("anyAttribute")) || ($__uri.equals("http://www.w3.org/2001/XMLSchema") && $__local.equals("attribute"))))) {
                    NGCCHandler h = new attributeUses(this, super._source, $runtime, 242, result);
                    spawnChildFromEnterElement(h, $__uri, $__local, $__qname, $attrs);
                }
                else {
                    unexpectedEnterElement($__qname);
                }
            }
            break;
        case 26:
            {
                if(($__uri.equals("http://www.w3.org/2001/XMLSchema") && $__local.equals("annotation"))) {
                    NGCCHandler h = new annotation(this, super._source, $runtime, 230, annotation,AnnotationContext.COMPLEXTYPE_DECL);
                    spawnChildFromEnterElement(h, $__uri, $__local, $__qname, $attrs);
                }
                else {
                    $_ngcc_current_state = 7;
                    $runtime.sendEnterElement(super._cookie, $__uri, $__local, $__qname, $attrs);
                }
            }
            break;
        case 56:
            {
                if((($__uri.equals("http://www.w3.org/2001/XMLSchema") && $__local.equals("annotation")) || (($__uri.equals("http://www.w3.org/2001/XMLSchema") && $__local.equals("attributeGroup")) || (($__uri.equals("http://www.w3.org/2001/XMLSchema") && $__local.equals("anyAttribute")) || (($__uri.equals("http://www.w3.org/2001/XMLSchema") && $__local.equals("attribute")) || (($__uri.equals("http://www.w3.org/2001/XMLSchema") && $__local.equals("simpleType")) || (((((((((((($__uri.equals("http://www.w3.org/2001/XMLSchema") && $__local.equals("minExclusive")) || ($__uri.equals("http://www.w3.org/2001/XMLSchema") && $__local.equals("maxExclusive"))) || ($__uri.equals("http://www.w3.org/2001/XMLSchema") && $__local.equals("minInclusive"))) || ($__uri.equals("http://www.w3.org/2001/XMLSchema") && $__local.equals("maxInclusive"))) || ($__uri.equals("http://www.w3.org/2001/XMLSchema") && $__local.equals("totalDigits"))) || ($__uri.equals("http://www.w3.org/2001/XMLSchema") && $__local.equals("fractionDigits"))) || ($__uri.equals("http://www.w3.org/2001/XMLSchema") && $__local.equals("length"))) || ($__uri.equals("http://www.w3.org/2001/XMLSchema") && $__local.equals("maxLength"))) || ($__uri.equals("http://www.w3.org/2001/XMLSchema") && $__local.equals("minLength"))) || ($__uri.equals("http://www.w3.org/2001/XMLSchema") && $__local.equals("enumeration"))) || ($__uri.equals("http://www.w3.org/2001/XMLSchema") && $__local.equals("whiteSpace"))) || ($__uri.equals("http://www.w3.org/2001/XMLSchema") && $__local.equals("pattern"))))))))) {
                    NGCCHandler h = new foreignAttributes(this, super._source, $runtime, 267, fa);
                    spawnChildFromEnterElement(h, $__uri, $__local, $__qname, $attrs);
                }
                else {
                    unexpectedEnterElement($__qname);
                }
            }
            break;
        case 24:
            {
                if(($ai = $runtime.getAttributeIndex("","base"))>=0) {
                    $runtime.consumeAttribute($ai);
                    $runtime.sendEnterElement(super._cookie, $__uri, $__local, $__qname, $attrs);
                }
                else {
                    unexpectedEnterElement($__qname);
                }
            }
            break;
        case 10:
            {
                if(($__uri.equals("http://www.w3.org/2001/XMLSchema") && $__local.equals("annotation"))) {
                    NGCCHandler h = new annotation(this, super._source, $runtime, 210, annotation,AnnotationContext.COMPLEXTYPE_DECL);
                    spawnChildFromEnterElement(h, $__uri, $__local, $__qname, $attrs);
                }
                else {
                    $_ngcc_current_state = 9;
                    $runtime.sendEnterElement(super._cookie, $__uri, $__local, $__qname, $attrs);
                }
            }
            break;
        case 41:
            {
                if((($__uri.equals("http://www.w3.org/2001/XMLSchema") && $__local.equals("annotation")) || (($__uri.equals("http://www.w3.org/2001/XMLSchema") && $__local.equals("attributeGroup")) || (($__uri.equals("http://www.w3.org/2001/XMLSchema") && $__local.equals("anyAttribute")) || ($__uri.equals("http://www.w3.org/2001/XMLSchema") && $__local.equals("attribute")))))) {
                    NGCCHandler h = new foreignAttributes(this, super._source, $runtime, 247, fa);
                    spawnChildFromEnterElement(h, $__uri, $__local, $__qname, $attrs);
                }
                else {
                    unexpectedEnterElement($__qname);
                }
            }
            break;
        case 84:
            {
                if(($ai = $runtime.getAttributeIndex("","abstract"))>=0) {
                    $runtime.consumeAttribute($ai);
                    $runtime.sendEnterElement(super._cookie, $__uri, $__local, $__qname, $attrs);
                }
                else {
                    $_ngcc_current_state = 80;
                    $runtime.sendEnterElement(super._cookie, $__uri, $__local, $__qname, $attrs);
                }
            }
            break;
        case 2:
            {
                if(($__uri.equals("http://www.w3.org/2001/XMLSchema") && $__local.equals("simpleContent"))) {
                    $runtime.onEnterElementConsumed($__uri, $__local, $__qname, $attrs);
                    $_ngcc_current_state = 63;
                }
                else {
                    if(($__uri.equals("http://www.w3.org/2001/XMLSchema") && $__local.equals("complexContent"))) {
                        $runtime.onEnterElementConsumed($__uri, $__local, $__qname, $attrs);
                        $_ngcc_current_state = 29;
                    }
                    else {
                        if((((($__uri.equals("http://www.w3.org/2001/XMLSchema") && $__local.equals("all")) || ($__uri.equals("http://www.w3.org/2001/XMLSchema") && $__local.equals("choice"))) || ($__uri.equals("http://www.w3.org/2001/XMLSchema") && $__local.equals("sequence"))) || (($__uri.equals("http://www.w3.org/2001/XMLSchema") && $__local.equals("anyAttribute")) || (($__uri.equals("http://www.w3.org/2001/XMLSchema") && $__local.equals("attributeGroup")) || (($__uri.equals("http://www.w3.org/2001/XMLSchema") && $__local.equals("attribute")) || (($__uri.equals("http://www.w3.org/2001/XMLSchema") && $__local.equals("any")) || (($__uri.equals("http://www.w3.org/2001/XMLSchema") && $__local.equals("element")) || ($__uri.equals("http://www.w3.org/2001/XMLSchema") && $__local.equals("group"))))))))) {
                            action1();
                            NGCCHandler h = new complexType_complexContent_body(this, super._source, $runtime, 205, result);
                            spawnChildFromEnterElement(h, $__uri, $__local, $__qname, $attrs);
                        }
                        else {
                            unexpectedEnterElement($__qname);
                        }
                    }
                }
            }
            break;
        case 65:
            {
                if(($__uri.equals("http://www.w3.org/2001/XMLSchema") && $__local.equals("annotation"))) {
                    NGCCHandler h = new annotation(this, super._source, $runtime, 282, null,AnnotationContext.COMPLEXTYPE_DECL);
                    spawnChildFromEnterElement(h, $__uri, $__local, $__qname, $attrs);
                }
                else {
                    $_ngcc_current_state = 2;
                    $runtime.sendEnterElement(super._cookie, $__uri, $__local, $__qname, $attrs);
                }
            }
            break;
        case 21:
            {
                if((($__uri.equals("http://www.w3.org/2001/XMLSchema") && $__local.equals("annotation")) || (((($__uri.equals("http://www.w3.org/2001/XMLSchema") && $__local.equals("all")) || ($__uri.equals("http://www.w3.org/2001/XMLSchema") && $__local.equals("choice"))) || ($__uri.equals("http://www.w3.org/2001/XMLSchema") && $__local.equals("sequence"))) || (($__uri.equals("http://www.w3.org/2001/XMLSchema") && $__local.equals("anyAttribute")) || (($__uri.equals("http://www.w3.org/2001/XMLSchema") && $__local.equals("attributeGroup")) || (($__uri.equals("http://www.w3.org/2001/XMLSchema") && $__local.equals("attribute")) || (($__uri.equals("http://www.w3.org/2001/XMLSchema") && $__local.equals("any")) || (($__uri.equals("http://www.w3.org/2001/XMLSchema") && $__local.equals("element")) || ($__uri.equals("http://www.w3.org/2001/XMLSchema") && $__local.equals("group")))))))))) {
                    NGCCHandler h = new foreignAttributes(this, super._source, $runtime, 223, fa);
                    spawnChildFromEnterElement(h, $__uri, $__local, $__qname, $attrs);
                }
                else {
                    unexpectedEnterElement($__qname);
                }
            }
            break;
        case 54:
            {
                if(($__uri.equals("http://www.w3.org/2001/XMLSchema") && $__local.equals("annotation"))) {
                    NGCCHandler h = new annotation(this, super._source, $runtime, 265, annotation,AnnotationContext.COMPLEXTYPE_DECL);
                    spawnChildFromEnterElement(h, $__uri, $__local, $__qname, $attrs);
                }
                else {
                    $_ngcc_current_state = 52;
                    $runtime.sendEnterElement(super._cookie, $__uri, $__local, $__qname, $attrs);
                }
            }
            break;
        case 52:
            {
                if(($__uri.equals("http://www.w3.org/2001/XMLSchema") && $__local.equals("simpleType"))) {
                    NGCCHandler h = new simpleType(this, super._source, $runtime, 262);
                    spawnChildFromEnterElement(h, $__uri, $__local, $__qname, $attrs);
                }
                else {
                    $_ngcc_current_state = 51;
                    $runtime.sendEnterElement(super._cookie, $__uri, $__local, $__qname, $attrs);
                }
            }
            break;
        case 39:
            {
                if(($__uri.equals("http://www.w3.org/2001/XMLSchema") && $__local.equals("annotation"))) {
                    NGCCHandler h = new annotation(this, super._source, $runtime, 245, annotation,AnnotationContext.COMPLEXTYPE_DECL);
                    spawnChildFromEnterElement(h, $__uri, $__local, $__qname, $attrs);
                }
                else {
                    $_ngcc_current_state = 38;
                    $runtime.sendEnterElement(super._cookie, $__uri, $__local, $__qname, $attrs);
                }
            }
            break;
        case 0:
            {
                revertToParentFromEnterElement(result, super._cookie, $__uri, $__local, $__qname, $attrs);
            }
            break;
        case 29:
            {
                if(($ai = $runtime.getAttributeIndex("","mixed"))>=0) {
                    $runtime.consumeAttribute($ai);
                    $runtime.sendEnterElement(super._cookie, $__uri, $__local, $__qname, $attrs);
                }
                else {
                    $_ngcc_current_state = 28;
                    $runtime.sendEnterElement(super._cookie, $__uri, $__local, $__qname, $attrs);
                }
            }
            break;
        case 9:
            {
                if((((($__uri.equals("http://www.w3.org/2001/XMLSchema") && $__local.equals("all")) || ($__uri.equals("http://www.w3.org/2001/XMLSchema") && $__local.equals("choice"))) || ($__uri.equals("http://www.w3.org/2001/XMLSchema") && $__local.equals("sequence"))) || (($__uri.equals("http://www.w3.org/2001/XMLSchema") && $__local.equals("anyAttribute")) || (($__uri.equals("http://www.w3.org/2001/XMLSchema") && $__local.equals("attributeGroup")) || (($__uri.equals("http://www.w3.org/2001/XMLSchema") && $__local.equals("attribute")) || (($__uri.equals("http://www.w3.org/2001/XMLSchema") && $__local.equals("any")) || (($__uri.equals("http://www.w3.org/2001/XMLSchema") && $__local.equals("element")) || ($__uri.equals("http://www.w3.org/2001/XMLSchema") && $__local.equals("group"))))))))) {
                    NGCCHandler h = new complexType_complexContent_body(this, super._source, $runtime, 208, result);
                    spawnChildFromEnterElement(h, $__uri, $__local, $__qname, $attrs);
                }
                else {
                    unexpectedEnterElement($__qname);
                }
            }
            break;
        case 19:
            {
                if(($__uri.equals("http://www.w3.org/2001/XMLSchema") && $__local.equals("annotation"))) {
                    NGCCHandler h = new annotation(this, super._source, $runtime, 221, annotation,AnnotationContext.COMPLEXTYPE_DECL);
                    spawnChildFromEnterElement(h, $__uri, $__local, $__qname, $attrs);
                }
                else {
                    $_ngcc_current_state = 18;
                    $runtime.sendEnterElement(super._cookie, $__uri, $__local, $__qname, $attrs);
                }
            }
            break;
        case 63:
            {
                if((($__uri.equals("http://www.w3.org/2001/XMLSchema") && $__local.equals("extension")) || (($__uri.equals("http://www.w3.org/2001/XMLSchema") && $__local.equals("restriction")) || ($__uri.equals("http://www.w3.org/2001/XMLSchema") && $__local.equals("annotation"))))) {
                    NGCCHandler h = new foreignAttributes(this, super._source, $runtime, 276, fa);
                    spawnChildFromEnterElement(h, $__uri, $__local, $__qname, $attrs);
                }
                else {
                    unexpectedEnterElement($__qname);
                }
            }
            break;
        case 59:
            {
                if(($ai = $runtime.getAttributeIndex("","base"))>=0) {
                    $runtime.consumeAttribute($ai);
                    $runtime.sendEnterElement(super._cookie, $__uri, $__local, $__qname, $attrs);
                }
                else {
                    unexpectedEnterElement($__qname);
                }
            }
            break;
        default:
            {
                unexpectedEnterElement($__qname);
            }
            break;
        }
    }

    public void leaveElement(String $__uri, String $__local, String $__qname) throws SAXException {
        int $ai;
        $uri = $__uri;
        $localName = $__local;
        $qname = $__qname;
        switch($_ngcc_current_state) {
        case 38:
            {
                action8();
                $_ngcc_current_state = 37;
                $runtime.sendLeaveElement(super._cookie, $__uri, $__local, $__qname);
            }
            break;
        case 48:
            {
                action11();
                $_ngcc_current_state = 47;
                $runtime.sendLeaveElement(super._cookie, $__uri, $__local, $__qname);
            }
            break;
        case 6:
            {
                if(($__uri.equals("http://www.w3.org/2001/XMLSchema") && $__local.equals("complexContent"))) {
                    $runtime.onLeaveElementConsumed($__uri, $__local, $__qname);
                    $_ngcc_current_state = 1;
                }
                else {
                    unexpectedLeaveElement($__qname);
                }
            }
            break;
        case 36:
            {
                if(($__uri.equals("http://www.w3.org/2001/XMLSchema") && $__local.equals("extension"))) {
                    $runtime.onLeaveElementConsumed($__uri, $__local, $__qname);
                    $_ngcc_current_state = 34;
                }
                else {
                    unexpectedLeaveElement($__qname);
                }
            }
            break;
        case 44:
            {
                if(($ai = $runtime.getAttributeIndex("","base"))>=0) {
                    $runtime.consumeAttribute($ai);
                    $runtime.sendLeaveElement(super._cookie, $__uri, $__local, $__qname);
                }
                else {
                    unexpectedLeaveElement($__qname);
                }
            }
            break;
        case 72:
            {
                if(($ai = $runtime.getAttributeIndex("","mixed"))>=0) {
                    $runtime.consumeAttribute($ai);
                    $runtime.sendLeaveElement(super._cookie, $__uri, $__local, $__qname);
                }
                else {
                    $_ngcc_current_state = 68;
                    $runtime.sendLeaveElement(super._cookie, $__uri, $__local, $__qname);
                }
            }
            break;
        case 49:
            {
                $_ngcc_current_state = 48;
                $runtime.sendLeaveElement(super._cookie, $__uri, $__local, $__qname);
            }
            break;
        case 18:
            {
                if(($__uri.equals("http://www.w3.org/2001/XMLSchema") && $__local.equals("restriction"))) {
                    NGCCHandler h = new complexType_complexContent_body(this, super._source, $runtime, 219, result);
                    spawnChildFromLeaveElement(h, $__uri, $__local, $__qname);
                }
                else {
                    unexpectedLeaveElement($__qname);
                }
            }
            break;
        case 67:
            {
                if(($__uri.equals("http://www.w3.org/2001/XMLSchema") && $__local.equals("complexType"))) {
                    NGCCHandler h = new foreignAttributes(this, super._source, $runtime, 284, fa);
                    spawnChildFromLeaveElement(h, $__uri, $__local, $__qname);
                }
                else {
                    unexpectedLeaveElement($__qname);
                }
            }
            break;
        case 61:
            {
                $_ngcc_current_state = 35;
                $runtime.sendLeaveElement(super._cookie, $__uri, $__local, $__qname);
            }
            break;
        case 34:
            {
                if(($__uri.equals("http://www.w3.org/2001/XMLSchema") && $__local.equals("simpleContent"))) {
                    $runtime.onLeaveElementConsumed($__uri, $__local, $__qname);
                    $_ngcc_current_state = 1;
                }
                else {
                    unexpectedLeaveElement($__qname);
                }
            }
            break;
        case 80:
            {
                if(($ai = $runtime.getAttributeIndex("","block"))>=0) {
                    $runtime.consumeAttribute($ai);
                    $runtime.sendLeaveElement(super._cookie, $__uri, $__local, $__qname);
                }
                else {
                    $_ngcc_current_state = 76;
                    $runtime.sendLeaveElement(super._cookie, $__uri, $__local, $__qname);
                }
            }
            break;
        case 12:
            {
                if(($__uri.equals("http://www.w3.org/2001/XMLSchema") && $__local.equals("extension"))) {
                    NGCCHandler h = new foreignAttributes(this, super._source, $runtime, 212, fa);
                    spawnChildFromLeaveElement(h, $__uri, $__local, $__qname);
                }
                else {
                    unexpectedLeaveElement($__qname);
                }
            }
            break;
        case 76:
            {
                if(($ai = $runtime.getAttributeIndex("","final"))>=0) {
                    $runtime.consumeAttribute($ai);
                    $runtime.sendLeaveElement(super._cookie, $__uri, $__local, $__qname);
                }
                else {
                    $_ngcc_current_state = 72;
                    $runtime.sendLeaveElement(super._cookie, $__uri, $__local, $__qname);
                }
            }
            break;
        case 51:
            {
                action13();
                $_ngcc_current_state = 49;
                $runtime.sendLeaveElement(super._cookie, $__uri, $__local, $__qname);
            }
            break;
        case 47:
            {
                if(($__uri.equals("http://www.w3.org/2001/XMLSchema") && $__local.equals("restriction"))) {
                    NGCCHandler h = new attributeUses(this, super._source, $runtime, 254, result);
                    spawnChildFromLeaveElement(h, $__uri, $__local, $__qname);
                }
                else {
                    unexpectedLeaveElement($__qname);
                }
            }
            break;
        case 68:
            {
                if(($ai = $runtime.getAttributeIndex("","name"))>=0) {
                    $runtime.consumeAttribute($ai);
                    $runtime.sendLeaveElement(super._cookie, $__uri, $__local, $__qname);
                }
                else {
                    $_ngcc_current_state = 67;
                    $runtime.sendLeaveElement(super._cookie, $__uri, $__local, $__qname);
                }
            }
            break;
        case 15:
            {
                if(($ai = $runtime.getAttributeIndex("","base"))>=0) {
                    $runtime.consumeAttribute($ai);
                    $runtime.sendLeaveElement(super._cookie, $__uri, $__local, $__qname);
                }
                else {
                    unexpectedLeaveElement($__qname);
                }
            }
            break;
        case 37:
            {
                if(($__uri.equals("http://www.w3.org/2001/XMLSchema") && $__local.equals("extension"))) {
                    NGCCHandler h = new attributeUses(this, super._source, $runtime, 242, result);
                    spawnChildFromLeaveElement(h, $__uri, $__local, $__qname);
                }
                else {
                    unexpectedLeaveElement($__qname);
                }
            }
            break;
        case 46:
            {
                if(($__uri.equals("http://www.w3.org/2001/XMLSchema") && $__local.equals("restriction"))) {
                    $runtime.onLeaveElementConsumed($__uri, $__local, $__qname);
                    $_ngcc_current_state = 34;
                }
                else {
                    unexpectedLeaveElement($__qname);
                }
            }
            break;
        case 26:
            {
                $_ngcc_current_state = 7;
                $runtime.sendLeaveElement(super._cookie, $__uri, $__local, $__qname);
            }
            break;
        case 56:
            {
                if(($__uri.equals("http://www.w3.org/2001/XMLSchema") && $__local.equals("restriction"))) {
                    NGCCHandler h = new foreignAttributes(this, super._source, $runtime, 267, fa);
                    spawnChildFromLeaveElement(h, $__uri, $__local, $__qname);
                }
                else {
                    unexpectedLeaveElement($__qname);
                }
            }
            break;
        case 24:
            {
                if(($ai = $runtime.getAttributeIndex("","base"))>=0) {
                    $runtime.consumeAttribute($ai);
                    $runtime.sendLeaveElement(super._cookie, $__uri, $__local, $__qname);
                }
                else {
                    unexpectedLeaveElement($__qname);
                }
            }
            break;
        case 10:
            {
                $_ngcc_current_state = 9;
                $runtime.sendLeaveElement(super._cookie, $__uri, $__local, $__qname);
            }
            break;
        case 41:
            {
                if(($__uri.equals("http://www.w3.org/2001/XMLSchema") && $__local.equals("extension"))) {
                    NGCCHandler h = new foreignAttributes(this, super._source, $runtime, 247, fa);
                    spawnChildFromLeaveElement(h, $__uri, $__local, $__qname);
                }
                else {
                    unexpectedLeaveElement($__qname);
                }
            }
            break;
        case 84:
            {
                if(($ai = $runtime.getAttributeIndex("","abstract"))>=0) {
                    $runtime.consumeAttribute($ai);
                    $runtime.sendLeaveElement(super._cookie, $__uri, $__local, $__qname);
                }
                else {
                    $_ngcc_current_state = 80;
                    $runtime.sendLeaveElement(super._cookie, $__uri, $__local, $__qname);
                }
            }
            break;
        case 2:
            {
                if(($__uri.equals("http://www.w3.org/2001/XMLSchema") && $__local.equals("complexType"))) {
                    action1();
                    NGCCHandler h = new complexType_complexContent_body(this, super._source, $runtime, 205, result);
                    spawnChildFromLeaveElement(h, $__uri, $__local, $__qname);
                }
                else {
                    unexpectedLeaveElement($__qname);
                }
            }
            break;
        case 65:
            {
                $_ngcc_current_state = 2;
                $runtime.sendLeaveElement(super._cookie, $__uri, $__local, $__qname);
            }
            break;
        case 17:
            {
                if(($__uri.equals("http://www.w3.org/2001/XMLSchema") && $__local.equals("restriction"))) {
                    $runtime.onLeaveElementConsumed($__uri, $__local, $__qname);
                    $_ngcc_current_state = 6;
                }
                else {
                    unexpectedLeaveElement($__qname);
                }
            }
            break;
        case 21:
            {
                if(($__uri.equals("http://www.w3.org/2001/XMLSchema") && $__local.equals("restriction"))) {
                    NGCCHandler h = new foreignAttributes(this, super._source, $runtime, 223, fa);
                    spawnChildFromLeaveElement(h, $__uri, $__local, $__qname);
                }
                else {
                    unexpectedLeaveElement($__qname);
                }
            }
            break;
        case 54:
            {
                $_ngcc_current_state = 52;
                $runtime.sendLeaveElement(super._cookie, $__uri, $__local, $__qname);
            }
            break;
        case 52:
            {
                $_ngcc_current_state = 51;
                $runtime.sendLeaveElement(super._cookie, $__uri, $__local, $__qname);
            }
            break;
        case 39:
            {
                $_ngcc_current_state = 38;
                $runtime.sendLeaveElement(super._cookie, $__uri, $__local, $__qname);
            }
            break;
        case 8:
            {
                if(($__uri.equals("http://www.w3.org/2001/XMLSchema") && $__local.equals("extension"))) {
                    $runtime.onLeaveElementConsumed($__uri, $__local, $__qname);
                    $_ngcc_current_state = 6;
                }
                else {
                    unexpectedLeaveElement($__qname);
                }
            }
            break;
        case 1:
            {
                if(($__uri.equals("http://www.w3.org/2001/XMLSchema") && $__local.equals("complexType"))) {
                    $runtime.onLeaveElementConsumed($__uri, $__local, $__qname);
                    $_ngcc_current_state = 0;
                }
                else {
                    unexpectedLeaveElement($__qname);
                }
            }
            break;
        case 0:
            {
                revertToParentFromLeaveElement(result, super._cookie, $__uri, $__local, $__qname);
            }
            break;
        case 29:
            {
                if(($ai = $runtime.getAttributeIndex("","mixed"))>=0) {
                    $runtime.consumeAttribute($ai);
                    $runtime.sendLeaveElement(super._cookie, $__uri, $__local, $__qname);
                }
                else {
                    $_ngcc_current_state = 28;
                    $runtime.sendLeaveElement(super._cookie, $__uri, $__local, $__qname);
                }
            }
            break;
        case 9:
            {
                if(($__uri.equals("http://www.w3.org/2001/XMLSchema") && $__local.equals("extension"))) {
                    NGCCHandler h = new complexType_complexContent_body(this, super._source, $runtime, 208, result);
                    spawnChildFromLeaveElement(h, $__uri, $__local, $__qname);
                }
                else {
                    unexpectedLeaveElement($__qname);
                }
            }
            break;
        case 19:
            {
                $_ngcc_current_state = 18;
                $runtime.sendLeaveElement(super._cookie, $__uri, $__local, $__qname);
            }
            break;
        case 59:
            {
                if(($ai = $runtime.getAttributeIndex("","base"))>=0) {
                    $runtime.consumeAttribute($ai);
                    $runtime.sendLeaveElement(super._cookie, $__uri, $__local, $__qname);
                }
                else {
                    unexpectedLeaveElement($__qname);
                }
            }
            break;
        default:
            {
                unexpectedLeaveElement($__qname);
            }
            break;
        }
    }

    public void enterAttribute(String $__uri, String $__local, String $__qname) throws SAXException {
        int $ai;
        $uri = $__uri;
        $localName = $__local;
        $qname = $__qname;
        switch($_ngcc_current_state) {
        case 68:
            {
                if(($__uri.equals("") && $__local.equals("name"))) {
                    $_ngcc_current_state = 70;
                }
                else {
                    $_ngcc_current_state = 67;
                    $runtime.sendEnterAttribute(super._cookie, $__uri, $__local, $__qname);
                }
            }
            break;
        case 38:
            {
                action8();
                $_ngcc_current_state = 37;
                $runtime.sendEnterAttribute(super._cookie, $__uri, $__local, $__qname);
            }
            break;
        case 48:
            {
                action11();
                $_ngcc_current_state = 47;
                $runtime.sendEnterAttribute(super._cookie, $__uri, $__local, $__qname);
            }
            break;
        case 15:
            {
                if(($__uri.equals("") && $__local.equals("base"))) {
                    $_ngcc_current_state = 14;
                }
                else {
                    unexpectedEnterAttribute($__qname);
                }
            }
            break;
        case 26:
            {
                $_ngcc_current_state = 7;
                $runtime.sendEnterAttribute(super._cookie, $__uri, $__local, $__qname);
            }
            break;
        case 24:
            {
                if(($__uri.equals("") && $__local.equals("base"))) {
                    $_ngcc_current_state = 23;
                }
                else {
                    unexpectedEnterAttribute($__qname);
                }
            }
            break;
        case 10:
            {
                $_ngcc_current_state = 9;
                $runtime.sendEnterAttribute(super._cookie, $__uri, $__local, $__qname);
            }
            break;
        case 84:
            {
                if(($__uri.equals("") && $__local.equals("abstract"))) {
                    $_ngcc_current_state = 86;
                }
                else {
                    $_ngcc_current_state = 80;
                    $runtime.sendEnterAttribute(super._cookie, $__uri, $__local, $__qname);
                }
            }
            break;
        case 44:
            {
                if(($__uri.equals("") && $__local.equals("base"))) {
                    $_ngcc_current_state = 43;
                }
                else {
                    unexpectedEnterAttribute($__qname);
                }
            }
            break;
        case 72:
            {
                if(($__uri.equals("") && $__local.equals("mixed"))) {
                    $_ngcc_current_state = 74;
                }
                else {
                    $_ngcc_current_state = 68;
                    $runtime.sendEnterAttribute(super._cookie, $__uri, $__local, $__qname);
                }
            }
            break;
        case 49:
            {
                $_ngcc_current_state = 48;
                $runtime.sendEnterAttribute(super._cookie, $__uri, $__local, $__qname);
            }
            break;
        case 65:
            {
                $_ngcc_current_state = 2;
                $runtime.sendEnterAttribute(super._cookie, $__uri, $__local, $__qname);
            }
            break;
        case 54:
            {
                $_ngcc_current_state = 52;
                $runtime.sendEnterAttribute(super._cookie, $__uri, $__local, $__qname);
            }
            break;
        case 52:
            {
                $_ngcc_current_state = 51;
                $runtime.sendEnterAttribute(super._cookie, $__uri, $__local, $__qname);
            }
            break;
        case 39:
            {
                $_ngcc_current_state = 38;
                $runtime.sendEnterAttribute(super._cookie, $__uri, $__local, $__qname);
            }
            break;
        case 61:
            {
                $_ngcc_current_state = 35;
                $runtime.sendEnterAttribute(super._cookie, $__uri, $__local, $__qname);
            }
            break;
        case 0:
            {
                revertToParentFromEnterAttribute(result, super._cookie, $__uri, $__local, $__qname);
            }
            break;
        case 80:
            {
                if(($__uri.equals("") && $__local.equals("block"))) {
                    $_ngcc_current_state = 82;
                }
                else {
                    $_ngcc_current_state = 76;
                    $runtime.sendEnterAttribute(super._cookie, $__uri, $__local, $__qname);
                }
            }
            break;
        case 29:
            {
                if(($__uri.equals("") && $__local.equals("mixed"))) {
                    $_ngcc_current_state = 31;
                }
                else {
                    $_ngcc_current_state = 28;
                    $runtime.sendEnterAttribute(super._cookie, $__uri, $__local, $__qname);
                }
            }
            break;
        case 76:
            {
                if(($__uri.equals("") && $__local.equals("final"))) {
                    $_ngcc_current_state = 78;
                }
                else {
                    $_ngcc_current_state = 72;
                    $runtime.sendEnterAttribute(super._cookie, $__uri, $__local, $__qname);
                }
            }
            break;
        case 51:
            {
                action13();
                $_ngcc_current_state = 49;
                $runtime.sendEnterAttribute(super._cookie, $__uri, $__local, $__qname);
            }
            break;
        case 19:
            {
                $_ngcc_current_state = 18;
                $runtime.sendEnterAttribute(super._cookie, $__uri, $__local, $__qname);
            }
            break;
        case 59:
            {
                if(($__uri.equals("") && $__local.equals("base"))) {
                    $_ngcc_current_state = 58;
                }
                else {
                    unexpectedEnterAttribute($__qname);
                }
            }
            break;
        default:
            {
                unexpectedEnterAttribute($__qname);
            }
            break;
        }
    }

    public void leaveAttribute(String $__uri, String $__local, String $__qname) throws SAXException {
        int $ai;
        $uri = $__uri;
        $localName = $__local;
        $qname = $__qname;
        switch($_ngcc_current_state) {
        case 81:
            {
                if(($__uri.equals("") && $__local.equals("block"))) {
                    $_ngcc_current_state = 76;
                }
                else {
                    unexpectedLeaveAttribute($__qname);
                }
            }
            break;
        case 22:
            {
                if(($__uri.equals("") && $__local.equals("base"))) {
                    $_ngcc_current_state = 21;
                }
                else {
                    unexpectedLeaveAttribute($__qname);
                }
            }
            break;
        case 38:
            {
                action8();
                $_ngcc_current_state = 37;
                $runtime.sendLeaveAttribute(super._cookie, $__uri, $__local, $__qname);
            }
            break;
        case 48:
            {
                action11();
                $_ngcc_current_state = 47;
                $runtime.sendLeaveAttribute(super._cookie, $__uri, $__local, $__qname);
            }
            break;
        case 73:
            {
                if(($__uri.equals("") && $__local.equals("mixed"))) {
                    $_ngcc_current_state = 68;
                }
                else {
                    unexpectedLeaveAttribute($__qname);
                }
            }
            break;
        case 30:
            {
                if(($__uri.equals("") && $__local.equals("mixed"))) {
                    $_ngcc_current_state = 28;
                }
                else {
                    unexpectedLeaveAttribute($__qname);
                }
            }
            break;
        case 72:
            {
                $_ngcc_current_state = 68;
                $runtime.sendLeaveAttribute(super._cookie, $__uri, $__local, $__qname);
            }
            break;
        case 49:
            {
                $_ngcc_current_state = 48;
                $runtime.sendLeaveAttribute(super._cookie, $__uri, $__local, $__qname);
            }
            break;
        case 61:
            {
                $_ngcc_current_state = 35;
                $runtime.sendLeaveAttribute(super._cookie, $__uri, $__local, $__qname);
            }
            break;
        case 80:
            {
                $_ngcc_current_state = 76;
                $runtime.sendLeaveAttribute(super._cookie, $__uri, $__local, $__qname);
            }
            break;
        case 69:
            {
                if(($__uri.equals("") && $__local.equals("name"))) {
                    $_ngcc_current_state = 67;
                }
                else {
                    unexpectedLeaveAttribute($__qname);
                }
            }
            break;
        case 76:
            {
                $_ngcc_current_state = 72;
                $runtime.sendLeaveAttribute(super._cookie, $__uri, $__local, $__qname);
            }
            break;
        case 51:
            {
                action13();
                $_ngcc_current_state = 49;
                $runtime.sendLeaveAttribute(super._cookie, $__uri, $__local, $__qname);
            }
            break;
        case 77:
            {
                if(($__uri.equals("") && $__local.equals("final"))) {
                    $_ngcc_current_state = 72;
                }
                else {
                    unexpectedLeaveAttribute($__qname);
                }
            }
            break;
        case 68:
            {
                $_ngcc_current_state = 67;
                $runtime.sendLeaveAttribute(super._cookie, $__uri, $__local, $__qname);
            }
            break;
        case 85:
            {
                if(($__uri.equals("") && $__local.equals("abstract"))) {
                    $_ngcc_current_state = 80;
                }
                else {
                    unexpectedLeaveAttribute($__qname);
                }
            }
            break;
        case 13:
            {
                if(($__uri.equals("") && $__local.equals("base"))) {
                    $_ngcc_current_state = 12;
                }
                else {
                    unexpectedLeaveAttribute($__qname);
                }
            }
            break;
        case 42:
            {
                if(($__uri.equals("") && $__local.equals("base"))) {
                    $_ngcc_current_state = 41;
                }
                else {
                    unexpectedLeaveAttribute($__qname);
                }
            }
            break;
        case 10:
            {
                $_ngcc_current_state = 9;
                $runtime.sendLeaveAttribute(super._cookie, $__uri, $__local, $__qname);
            }
            break;
        case 26:
            {
                $_ngcc_current_state = 7;
                $runtime.sendLeaveAttribute(super._cookie, $__uri, $__local, $__qname);
            }
            break;
        case 84:
            {
                $_ngcc_current_state = 80;
                $runtime.sendLeaveAttribute(super._cookie, $__uri, $__local, $__qname);
            }
            break;
        case 65:
            {
                $_ngcc_current_state = 2;
                $runtime.sendLeaveAttribute(super._cookie, $__uri, $__local, $__qname);
            }
            break;
        case 54:
            {
                $_ngcc_current_state = 52;
                $runtime.sendLeaveAttribute(super._cookie, $__uri, $__local, $__qname);
            }
            break;
        case 52:
            {
                $_ngcc_current_state = 51;
                $runtime.sendLeaveAttribute(super._cookie, $__uri, $__local, $__qname);
            }
            break;
        case 39:
            {
                $_ngcc_current_state = 38;
                $runtime.sendLeaveAttribute(super._cookie, $__uri, $__local, $__qname);
            }
            break;
        case 57:
            {
                if(($__uri.equals("") && $__local.equals("base"))) {
                    $_ngcc_current_state = 56;
                }
                else {
                    unexpectedLeaveAttribute($__qname);
                }
            }
            break;
        case 0:
            {
                revertToParentFromLeaveAttribute(result, super._cookie, $__uri, $__local, $__qname);
            }
            break;
        case 29:
            {
                $_ngcc_current_state = 28;
                $runtime.sendLeaveAttribute(super._cookie, $__uri, $__local, $__qname);
            }
            break;
        case 19:
            {
                $_ngcc_current_state = 18;
                $runtime.sendLeaveAttribute(super._cookie, $__uri, $__local, $__qname);
            }
            break;
        default:
            {
                unexpectedLeaveAttribute($__qname);
            }
            break;
        }
    }

    public void text(String $value) throws SAXException {
        int $ai;
        switch($_ngcc_current_state) {
        case 38:
            {
                action8();
                $_ngcc_current_state = 37;
                $runtime.sendText(super._cookie, $value);
            }
            break;
        case 48:
            {
                action11();
                $_ngcc_current_state = 47;
                $runtime.sendText(super._cookie, $value);
            }
            break;
        case 70:
            {
                name = $value;
                $_ngcc_current_state = 69;
            }
            break;
        case 82:
            {
                NGCCHandler h = new erSet(this, super._source, $runtime, 301);
                spawnChildFromText(h, $value);
            }
            break;
        case 78:
            {
                NGCCHandler h = new erSet(this, super._source, $runtime, 296);
                spawnChildFromText(h, $value);
            }
            break;
        case 72:
            {
                if(($ai = $runtime.getAttributeIndex("","mixed"))>=0) {
                    $runtime.consumeAttribute($ai);
                    $runtime.sendText(super._cookie, $value);
                }
                else {
                    $_ngcc_current_state = 68;
                    $runtime.sendText(super._cookie, $value);
                }
            }
            break;
        case 44:
            {
                if(($ai = $runtime.getAttributeIndex("","base"))>=0) {
                    $runtime.consumeAttribute($ai);
                    $runtime.sendText(super._cookie, $value);
                }
            }
            break;
        case 49:
            {
                $_ngcc_current_state = 48;
                $runtime.sendText(super._cookie, $value);
            }
            break;
        case 31:
            {
                mixedValue = $value;
                $_ngcc_current_state = 30;
            }
            break;
        case 61:
            {
                $_ngcc_current_state = 35;
                $runtime.sendText(super._cookie, $value);
            }
            break;
        case 80:
            {
                if(($ai = $runtime.getAttributeIndex("","block"))>=0) {
                    $runtime.consumeAttribute($ai);
                    $runtime.sendText(super._cookie, $value);
                }
                else {
                    $_ngcc_current_state = 76;
                    $runtime.sendText(super._cookie, $value);
                }
            }
            break;
        case 14:
            {
                NGCCHandler h = new qname(this, super._source, $runtime, 214);
                spawnChildFromText(h, $value);
            }
            break;
        case 74:
            {
                mixedValue = $value;
                $_ngcc_current_state = 73;
            }
            break;
        case 76:
            {
                if(($ai = $runtime.getAttributeIndex("","final"))>=0) {
                    $runtime.consumeAttribute($ai);
                    $runtime.sendText(super._cookie, $value);
                }
                else {
                    $_ngcc_current_state = 72;
                    $runtime.sendText(super._cookie, $value);
                }
            }
            break;
        case 51:
            {
                action13();
                $_ngcc_current_state = 49;
                $runtime.sendText(super._cookie, $value);
            }
            break;
        case 68:
            {
                if(($ai = $runtime.getAttributeIndex("","name"))>=0) {
                    $runtime.consumeAttribute($ai);
                    $runtime.sendText(super._cookie, $value);
                }
                else {
                    $_ngcc_current_state = 67;
                    $runtime.sendText(super._cookie, $value);
                }
            }
            break;
        case 15:
            {
                if(($ai = $runtime.getAttributeIndex("","base"))>=0) {
                    $runtime.consumeAttribute($ai);
                    $runtime.sendText(super._cookie, $value);
                }
            }
            break;
        case 58:
            {
                NGCCHandler h = new qname(this, super._source, $runtime, 269);
                spawnChildFromText(h, $value);
            }
            break;
        case 26:
            {
                $_ngcc_current_state = 7;
                $runtime.sendText(super._cookie, $value);
            }
            break;
        case 10:
            {
                $_ngcc_current_state = 9;
                $runtime.sendText(super._cookie, $value);
            }
            break;
        case 24:
            {
                if(($ai = $runtime.getAttributeIndex("","base"))>=0) {
                    $runtime.consumeAttribute($ai);
                    $runtime.sendText(super._cookie, $value);
                }
            }
            break;
        case 84:
            {
                if(($ai = $runtime.getAttributeIndex("","abstract"))>=0) {
                    $runtime.consumeAttribute($ai);
                    $runtime.sendText(super._cookie, $value);
                }
                else {
                    $_ngcc_current_state = 80;
                    $runtime.sendText(super._cookie, $value);
                }
            }
            break;
        case 65:
            {
                $_ngcc_current_state = 2;
                $runtime.sendText(super._cookie, $value);
            }
            break;
        case 54:
            {
                $_ngcc_current_state = 52;
                $runtime.sendText(super._cookie, $value);
            }
            break;
        case 52:
            {
                $_ngcc_current_state = 51;
                $runtime.sendText(super._cookie, $value);
            }
            break;
        case 39:
            {
                $_ngcc_current_state = 38;
                $runtime.sendText(super._cookie, $value);
            }
            break;
        case 0:
            {
                revertToParentFromText(result, super._cookie, $value);
            }
            break;
        case 86:
            {
                abstractValue = $value;
                $_ngcc_current_state = 85;
            }
            break;
        case 23:
            {
                NGCCHandler h = new qname(this, super._source, $runtime, 225);
                spawnChildFromText(h, $value);
            }
            break;
        case 29:
            {
                if(($ai = $runtime.getAttributeIndex("","mixed"))>=0) {
                    $runtime.consumeAttribute($ai);
                    $runtime.sendText(super._cookie, $value);
                }
                else {
                    $_ngcc_current_state = 28;
                    $runtime.sendText(super._cookie, $value);
                }
            }
            break;
        case 43:
            {
                NGCCHandler h = new qname(this, super._source, $runtime, 249);
                spawnChildFromText(h, $value);
            }
            break;
        case 19:
            {
                $_ngcc_current_state = 18;
                $runtime.sendText(super._cookie, $value);
            }
            break;
        case 59:
            {
                if(($ai = $runtime.getAttributeIndex("","base"))>=0) {
                    $runtime.consumeAttribute($ai);
                    $runtime.sendText(super._cookie, $value);
                }
            }
            break;
        }
    }

    public void onChildCompleted(Object $__result__, int $__cookie__, boolean $__needAttCheck__)throws SAXException {
        switch($__cookie__) {
        case 257:
            {
                facet = ((XSFacet)$__result__);
                action12();
                $_ngcc_current_state = 48;
            }
            break;
        case 301:
            {
                blockValue = ((Integer)$__result__);
                $_ngcc_current_state = 81;
            }
            break;
        case 258:
            {
                facet = ((XSFacet)$__result__);
                action12();
                $_ngcc_current_state = 48;
            }
            break;
        case 219:
            {
                explicitContent = ((ContentTypeImpl)$__result__);
                action5();
                $_ngcc_current_state = 17;
            }
            break;
        case 232:
            {
                fa = ((ForeignAttributesImpl)$__result__);
                $_ngcc_current_state = 26;
            }
            break;
        case 212:
            {
                fa = ((ForeignAttributesImpl)$__result__);
                $_ngcc_current_state = 10;
            }
            break;
        case 242:
            {
                $_ngcc_current_state = 36;
            }
            break;
        case 267:
            {
                fa = ((ForeignAttributesImpl)$__result__);
                $_ngcc_current_state = 54;
            }
            break;
        case 210:
            {
                annotation = ((AnnotationImpl)$__result__);
                $_ngcc_current_state = 9;
            }
            break;
        case 247:
            {
                fa = ((ForeignAttributesImpl)$__result__);
                $_ngcc_current_state = 39;
            }
            break;
        case 205:
            {
                explicitContent = ((ContentTypeImpl)$__result__);
                action0();
                $_ngcc_current_state = 1;
            }
            break;
        case 262:
            {
                baseContentType = ((SimpleTypeImpl)$__result__);
                $_ngcc_current_state = 51;
            }
            break;
        case 225:
            {
                baseTypeName = ((UName)$__result__);
                action6();
                $_ngcc_current_state = 22;
            }
            break;
        case 208:
            {
                explicitContent = ((ContentTypeImpl)$__result__);
                action2();
                $_ngcc_current_state = 8;
            }
            break;
        case 249:
            {
                baseTypeName = ((UName)$__result__);
                action9();
                $_ngcc_current_state = 42;
            }
            break;
        case 296:
            {
                finalValue = ((Integer)$__result__);
                $_ngcc_current_state = 77;
            }
            break;
        case 284:
            {
                fa = ((ForeignAttributesImpl)$__result__);
                $_ngcc_current_state = 65;
            }
            break;
        case 274:
            {
                annotation = ((AnnotationImpl)$__result__);
                $_ngcc_current_state = 35;
            }
            break;
        case 214:
            {
                baseTypeName = ((UName)$__result__);
                action3();
                $_ngcc_current_state = 13;
            }
            break;
        case 254:
            {
                $_ngcc_current_state = 46;
            }
            break;
        case 269:
            {
                baseTypeName = ((UName)$__result__);
                action14();
                $_ngcc_current_state = 57;
            }
            break;
        case 230:
            {
                annotation = ((AnnotationImpl)$__result__);
                $_ngcc_current_state = 7;
            }
            break;
        case 282:
            {
                annotation = ((AnnotationImpl)$__result__);
                $_ngcc_current_state = 2;
            }
            break;
        case 265:
            {
                annotation = ((AnnotationImpl)$__result__);
                $_ngcc_current_state = 52;
            }
            break;
        case 223:
            {
                fa = ((ForeignAttributesImpl)$__result__);
                $_ngcc_current_state = 19;
            }
            break;
        case 245:
            {
                annotation = ((AnnotationImpl)$__result__);
                $_ngcc_current_state = 38;
            }
            break;
        case 276:
            {
                fa = ((ForeignAttributesImpl)$__result__);
                $_ngcc_current_state = 61;
            }
            break;
        case 221:
            {
                annotation = ((AnnotationImpl)$__result__);
                $_ngcc_current_state = 18;
            }
            break;
        }
    }

    public boolean accepted() {
        return(($_ngcc_current_state == 0));
    }


      private ComplexTypeImpl result;
      private Ref.Type baseType;
      private Ref.ContentType contentType;

      // local variables for simpleContent/restriction
      private Ref.SimpleType baseContentType;
      private RestrictionSimpleTypeImpl contentSimpleType;

      private Locator locator,locator2;

      private static class BaseContentSimpleTypeRef implements Ref.SimpleType {
        private final Ref.Type baseType;
        private BaseContentSimpleTypeRef(Ref.Type _baseType ) { this.baseType = _baseType; }
        public XSSimpleType getType() {
          return (XSSimpleType)((XSComplexType)baseType.getType()).getContentType();
        }
      }


      // baseType and contentType must be computed before calling this method.
      private void makeResult( int derivationMethod ) {

        if(finalValue==null)
          finalValue = $runtime.finalDefault;
        if(blockValue==null)
          blockValue = $runtime.blockDefault;

        result = new ComplexTypeImpl(
            $runtime.document,
            annotation,
            locator,
            fa,
            name,
            name==null,
            $runtime.parseBoolean(abstractValue),
            derivationMethod,
            baseType,
            finalValue,
            blockValue,
            $runtime.parseBoolean(mixedValue)
        );
      }

      // I had to make them static inner classes (as opposed to anonymous ones),
      // so that they will not keep references to parser.

      private static class BaseComplexTypeContentRef implements Ref.ContentType {
        private final Ref.Type baseType;
        private BaseComplexTypeContentRef(Ref.Type _baseType) { this.baseType = _baseType; }
        public XSContentType getContentType() {
            return ((XSComplexType)baseType.getType()).getContentType();
        }
      }
      private static class InheritBaseContentTypeRef implements Ref.ContentType {
        private final Ref.Type baseType;
        private final XSContentType empty;
        private final XSContentType expContent;
        private final SchemaDocumentImpl currentDocument;
        private InheritBaseContentTypeRef(
          Ref.Type _baseType,XSContentType _explicitContent,NGCCRuntimeEx $runtime) {

          this.baseType = _baseType;
          this.currentDocument = $runtime.document;
          expContent = _explicitContent;
          this.empty = $runtime.parser.schemaSet.empty;
        }
          public XSContentType getContentType() {
              XSContentType baseContentType =
                  ((XSComplexType)baseType.getType()).getContentType();
              if(baseContentType==empty)
                  return expContent;
              else
                  return new ParticleImpl( currentDocument, null, new ModelGroupImpl(
                    currentDocument,
                      null, null, null, XSModelGroup.SEQUENCE,
                      new ParticleImpl[]{
                          (ParticleImpl)baseContentType,
                          (ParticleImpl)expContent}), null );
          }
      };

      private Ref.ContentType buildComplexExtensionContentModel( XSContentType explicitContent ) {

        if(explicitContent==$runtime.parser.schemaSet.empty)
          return new BaseComplexTypeContentRef(baseType);
        else
          return new InheritBaseContentTypeRef(baseType,explicitContent,$runtime);
      }

}
