# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 212-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53585);
 script_cve_id("CVE-2002-1373", "CVE-2002-1374", "CVE-2002-1375", "CVE-2002-1376");
 script_version ("$");
 script_tag(name:"cvss_base", value:"7.5");
 script_tag(name:"risk_factor", value:"High");
 name = "Debian Security Advisory DSA 212-1 (mysql)";
 script_name(name);

 desc = "The remote host is missing an update to mysql
announced via advisory DSA 212-1.

While performing an audit of MySQL e-matters found several problems:

* signed/unsigned problem in COM_TABLE_DUMP
Two sizes were taken as signed integers from a request and then cast
to unsigned integers without checking for negative numbers. Since the
resulting numbers where used for a memcpy() operation this could lead
to memory corruption.

* Password length handling in COM_CHANGE_USER
When re-authenticating to a different user MySQL did not perform
all checks that are performed on initial authentication. This created
two problems:
* it allowed for single-character password brute forcing (as was fixed in
February 2000 for initial login) which could be used by a normal user to
gain root privileges to the database
* it was possible to overflow the password buffer and force the server
to execute arbitrary code

* read_rows() overflow in libmysqlclient
When processing the rows returned by a SQL server there was no check
for overly large rows or terminating NUL characters. This can be used
to exploit SQL clients if they connect to a compromised MySQL server.

* read_one_row() overflow in libmysqlclient
When processing a row as returned by a SQL server the returned field
sizes were not verified. This can be used to exploit SQL clients if they
connect to a compromised MySQL server.

For Debian GNU/Linux 3.0/woody this has been fixed in version 3.23.49-8.2
and version 3.22.32-6.3 for Debian GNU/Linux 2.2/potato.

We recommend that you upgrade your mysql packages as soon as possible.


Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20212-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 212-1 (mysql)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"mysql-doc", ver:"3.22.32-6.3", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"mysql-server", ver:"3.22.32-6.3", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"mysql-client", ver:"3.22.32-6.3", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"mysql-doc", ver:"3.23.49-8.2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"mysql-server", ver:"3.23.49-8.2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"mysql-client", ver:"3.23.49-8.2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"mysql-common", ver:"3.23.49-8.2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libmysqlclient10-dev", ver:"3.23.49-8.2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libmysqlclient10", ver:"3.23.49-8.2", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
