###############################################################################
# OpenVAS Vulnerability Test
# $Id: ejabberd_detect.nasl 7287 2010-04-13 15:13:26Z chandra $
#
# ejabberd Detection
#
# Authors:
# Michael Meyer
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

# need desc here to modify it later in script.
desc = "Overview:
This host is running ejabberd, an instant messaging server.

See also:
http://www.process-one.net/en/ejabberd/

Risk factor : None";

if (description)
{
 script_id(100486);
 script_version ("1.0-$Revision: 7287 $");
 script_tag(name:"risk_factor", value:"None");
 script_name("ejabberd Detection");
 script_description(desc);
 script_summary("Checks for the presence of ejabberd");
 script_category(ACT_GATHER_INFO);
 script_family("Service detection");
 script_copyright("This script is Copyright (C) 2010 Greenbone Networks GmbH");
 script_dependencies("xmpp_detect.nasl");
 script_require_ports("Services/xmpp", 5222);
 exit(0);
}

include("global_settings.inc");

xmpp_port = get_kb_item("Services/xmpp");
if(!xmpp_port)xmpp_port=5222;
if(!get_port_state(xmpp_port))exit(0);

server = get_kb_item(string("xmpp/", xmpp_port, "/server"));
if("ejabberd" >< server) {
  version = get_kb_item(string("xmpp/", xmpp_port, "/version"));
  if(!isnull(version)) {
    set_kb_item(name: string("xmpp/", xmpp_port, "/ejabberd"), value: version);
    set_kb_item(name: string("cpe:/a:process-one:ejabberd:",version), value: TRUE);
    info = string("None\n\nejabberd version '", version, "' was detected by OpenVAS.\n");
    desc = ereg_replace(
         string:desc,
	 pattern:"None$",
	 replace:info
    );	 
    if(report_verbosity > 0) {
      security_note(port:xmpp_port,data:desc);
    }  
    KB_SET = TRUE; 
  }  
}  

include("http_func.inc");
include("http_keepalive.inc");

port = 5280;
if(!get_port_state(port))exit(0);

url = string("/admin/doc/README.txt");
req = http_get(item:url, port:port);
buf = http_keepalive_send_recv(port:port, data:req, bodyonly:FALSE);
if( buf == NULL )exit(0);

if("Release Notes" >< buf && "ejabberd" >< buf)
{
    ### try to get version 
    ver = eregmatch(string: buf, pattern: "ejabberd ([0-9.]+)",icase:TRUE);

    if ( !isnull(ver[1]) ) {
   
      version=chomp(ver[1]);

      if(!KB_SET) {
        set_kb_item(name: string("xmpp/", xmpp_port, "/ejabberd"), value: version);
	set_kb_item(name: string("cpe:/a:process-one:ejabberd:",version), value: TRUE);
      }  

      info = string("ejabberd Web Admin (ejabberd version '",version,"') is running at this port.\n");

      if(report_verbosity > 0) {
        security_note(port:port,data:info);
      }
      exit(0);
    }    
}

exit(0);

