###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for kdelibs4 MDVA-2010:024 (kdelibs4)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830818);
  script_version("$Revision: 7452 $: 1.0");
  script_tag(name:"risk_factor", value:"High");
  script_xref(name: "MDVA", value: "2010:024");
  script_name("Mandriva Update for kdelibs4 MDVA-2010:024 (kdelibs4)");
  desc = "

  Vulnerability Insight:

  - In Mandriva 2009 Spring, plasma crashes when moving a plasmoid from
  the taskbar to the desktop. This Update fixes this issue.
  
  - In mandriva 2009 Spring, we used a specific kde certificate
  file. This update allows KDE to use rootcert certificate bundle.

  Affected Software/OS:
  kdelibs4 on Mandriva Linux 2009.1,
  Mandriva Linux 2009.1/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2010-01/msg00037.php

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of kdelibs4");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (c) 2010 Greenbone Networks GmbH");
  script_family("Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2009.1")
{

  if(isrpmvuln(pkg:"kdelibs4-core", rpm:"kdelibs4-core~4.2.4~0.7mdv2009.1", rls:"MNDK_2009.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kdelibs4-devel", rpm:"kdelibs4-devel~4.2.4~0.7mdv2009.1", rls:"MNDK_2009.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkde3support4", rpm:"libkde3support4~4.2.4~0.7mdv2009.1", rls:"MNDK_2009.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkdecore5", rpm:"libkdecore5~4.2.4~0.7mdv2009.1", rls:"MNDK_2009.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkdefakes5", rpm:"libkdefakes5~4.2.4~0.7mdv2009.1", rls:"MNDK_2009.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkdesu5", rpm:"libkdesu5~4.2.4~0.7mdv2009.1", rls:"MNDK_2009.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkdeui5", rpm:"libkdeui5~4.2.4~0.7mdv2009.1", rls:"MNDK_2009.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkdnssd4", rpm:"libkdnssd4~4.2.4~0.7mdv2009.1", rls:"MNDK_2009.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkfile4", rpm:"libkfile4~4.2.4~0.7mdv2009.1", rls:"MNDK_2009.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkhtml5", rpm:"libkhtml5~4.2.4~0.7mdv2009.1", rls:"MNDK_2009.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkimproxy4", rpm:"libkimproxy4~4.2.4~0.7mdv2009.1", rls:"MNDK_2009.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkio5", rpm:"libkio5~4.2.4~0.7mdv2009.1", rls:"MNDK_2009.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkjs4", rpm:"libkjs4~4.2.4~0.7mdv2009.1", rls:"MNDK_2009.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkjsapi4", rpm:"libkjsapi4~4.2.4~0.7mdv2009.1", rls:"MNDK_2009.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkjsembed4", rpm:"libkjsembed4~4.2.4~0.7mdv2009.1", rls:"MNDK_2009.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkmediaplayer4", rpm:"libkmediaplayer4~4.2.4~0.7mdv2009.1", rls:"MNDK_2009.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libknewstuff2_4", rpm:"libknewstuff2_4~4.2.4~0.7mdv2009.1", rls:"MNDK_2009.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libknotifyconfig4", rpm:"libknotifyconfig4~4.2.4~0.7mdv2009.1", rls:"MNDK_2009.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkntlm4", rpm:"libkntlm4~4.2.4~0.7mdv2009.1", rls:"MNDK_2009.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkparts4", rpm:"libkparts4~4.2.4~0.7mdv2009.1", rls:"MNDK_2009.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkpty4", rpm:"libkpty4~4.2.4~0.7mdv2009.1", rls:"MNDK_2009.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkrosscore4", rpm:"libkrosscore4~4.2.4~0.7mdv2009.1", rls:"MNDK_2009.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkrossui4", rpm:"libkrossui4~4.2.4~0.7mdv2009.1", rls:"MNDK_2009.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libktexteditor4", rpm:"libktexteditor4~4.2.4~0.7mdv2009.1", rls:"MNDK_2009.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkunittest4", rpm:"libkunittest4~4.2.4~0.7mdv2009.1", rls:"MNDK_2009.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkutils4", rpm:"libkutils4~4.2.4~0.7mdv2009.1", rls:"MNDK_2009.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libnepomuk4", rpm:"libnepomuk4~4.2.4~0.7mdv2009.1", rls:"MNDK_2009.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libplasma3", rpm:"libplasma3~4.2.4~0.7mdv2009.1", rls:"MNDK_2009.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libsolid4", rpm:"libsolid4~4.2.4~0.7mdv2009.1", rls:"MNDK_2009.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libthreadweaver4", rpm:"libthreadweaver4~4.2.4~0.7mdv2009.1", rls:"MNDK_2009.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kdelibs4", rpm:"kdelibs4~4.2.4~0.7mdv2009.1", rls:"MNDK_2009.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64kde3support4", rpm:"lib64kde3support4~4.2.4~0.7mdv2009.1", rls:"MNDK_2009.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64kdecore5", rpm:"lib64kdecore5~4.2.4~0.7mdv2009.1", rls:"MNDK_2009.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64kdefakes5", rpm:"lib64kdefakes5~4.2.4~0.7mdv2009.1", rls:"MNDK_2009.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64kdesu5", rpm:"lib64kdesu5~4.2.4~0.7mdv2009.1", rls:"MNDK_2009.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64kdeui5", rpm:"lib64kdeui5~4.2.4~0.7mdv2009.1", rls:"MNDK_2009.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64kdnssd4", rpm:"lib64kdnssd4~4.2.4~0.7mdv2009.1", rls:"MNDK_2009.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64kfile4", rpm:"lib64kfile4~4.2.4~0.7mdv2009.1", rls:"MNDK_2009.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64khtml5", rpm:"lib64khtml5~4.2.4~0.7mdv2009.1", rls:"MNDK_2009.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64kimproxy4", rpm:"lib64kimproxy4~4.2.4~0.7mdv2009.1", rls:"MNDK_2009.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64kio5", rpm:"lib64kio5~4.2.4~0.7mdv2009.1", rls:"MNDK_2009.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64kjs4", rpm:"lib64kjs4~4.2.4~0.7mdv2009.1", rls:"MNDK_2009.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64kjsapi4", rpm:"lib64kjsapi4~4.2.4~0.7mdv2009.1", rls:"MNDK_2009.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64kjsembed4", rpm:"lib64kjsembed4~4.2.4~0.7mdv2009.1", rls:"MNDK_2009.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64kmediaplayer4", rpm:"lib64kmediaplayer4~4.2.4~0.7mdv2009.1", rls:"MNDK_2009.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64knewstuff2_4", rpm:"lib64knewstuff2_4~4.2.4~0.7mdv2009.1", rls:"MNDK_2009.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64knotifyconfig4", rpm:"lib64knotifyconfig4~4.2.4~0.7mdv2009.1", rls:"MNDK_2009.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64kntlm4", rpm:"lib64kntlm4~4.2.4~0.7mdv2009.1", rls:"MNDK_2009.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64kparts4", rpm:"lib64kparts4~4.2.4~0.7mdv2009.1", rls:"MNDK_2009.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64kpty4", rpm:"lib64kpty4~4.2.4~0.7mdv2009.1", rls:"MNDK_2009.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64krosscore4", rpm:"lib64krosscore4~4.2.4~0.7mdv2009.1", rls:"MNDK_2009.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64krossui4", rpm:"lib64krossui4~4.2.4~0.7mdv2009.1", rls:"MNDK_2009.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64ktexteditor4", rpm:"lib64ktexteditor4~4.2.4~0.7mdv2009.1", rls:"MNDK_2009.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64kunittest4", rpm:"lib64kunittest4~4.2.4~0.7mdv2009.1", rls:"MNDK_2009.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64kutils4", rpm:"lib64kutils4~4.2.4~0.7mdv2009.1", rls:"MNDK_2009.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64nepomuk4", rpm:"lib64nepomuk4~4.2.4~0.7mdv2009.1", rls:"MNDK_2009.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64plasma3", rpm:"lib64plasma3~4.2.4~0.7mdv2009.1", rls:"MNDK_2009.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64solid4", rpm:"lib64solid4~4.2.4~0.7mdv2009.1", rls:"MNDK_2009.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64threadweaver4", rpm:"lib64threadweaver4~4.2.4~0.7mdv2009.1", rls:"MNDK_2009.1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}