###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_google_chrome_mult_vuln_win01.nasl 7333 2010-02-22 18:43:29Z feb $
#
# Google Chrome Multiple Vulnerabilities - (Win)
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2010 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(902121);
  script_version("$Revision: 8288 $: 1.0");
  script_tag(name:"cvss_base", value:"9.3");
  script_tag(name:"risk_factor", value:"Critical");
  script_cve_id("CVE-2010-0650", "CVE-2010-0651", "CVE-2010-0655", "CVE-2010-0656",
                "CVE-2010-0657", "CVE-2010-0658", "CVE-2010-0659", "CVE-2010-0660",
                "CVE-2010-0661", "CVE-2010-0662", "CVE-2010-0663", "CVE-2010-0664");
  script_name("Google Chrome Multiple Vulnerabilities - (Win)");
  desc = "
  Overview: This host is installed with Google Chrome and is prone to multiple
  vulnerabilities.

  Vulnerability Insight:
  For more information about vulnerabilities on Google Chrome, refer to the
  links mentioned in References section.

  Impact:
  Successful exploitation will let the attacker bypass restrictions, disclose
  sensitive information or compromise a vulnerable system.

  Impact Level: Application

  Affected Software/OS:
  Google Chrome version prior to 4.0.249.78

  Fix: Upgrade to version 4.0.249.78 or later.
  http://www.google.com/chrome

  References:
  http://securitytracker.com/alerts/2010/Jan/1023506.html
  http://code.google.com/p/chromium/issues/detail?id=9877
  http://googlechromereleases.blogspot.com/2010/01/stable-channel-update_25.html

  CVSS Score:
    CVSS Base Score      : 9.3 (AV:N/AC:M/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score  : 6.9
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the version of Google Chrome");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2010 SecPod");
  script_family("General");
  script_dependencies("gb_google_chrome_detect_win.nasl");
  script_require_keys("GoogleChrome/Win/Ver");
  exit(0);
}


include("version_func.inc");

# Get for Chrome Version
chromeVer = get_kb_item("GoogleChrome/Win/Ver");
if(!chromeVer){
  exit(0);
}

# Check for Google Chrome version < 4.0.249.78
if(version_is_less(version:chromeVer, test_version:"4.0.249.78")){
  security_hole(0);
}
