#include "graph_data.hpp"


int8_t automorphisms[53][15] = {
	{  0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14},
	{  0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, -1, -1},
	{  0,  4,  3, 10,  9,  5,  6, 12, 11,  8,  7,  1,  2, -1, -1},
	{  0,  5,  6, 11, 12,  8,  7,  2,  1,  4,  3, 10,  9, -1, -1},
	{  0,  8,  7,  1,  2,  4,  3,  9, 10,  5,  6, 11, 12, -1, -1},
	{  0,  8,  7, 10,  9,  1,  2,  6,  5, 12, 11,  3,  4, -1, -1},
	{  0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, -1, -1},
	{  0, 12,  3,  2,  7, 10,  8,  4,  6, 11,  5,  9,  1, -1, -1},
	{  0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, -1, -1},
	{  0,  4, 11,  8,  1,  9, 12, 10,  3,  5,  7,  2,  6, -1, -1},
	{  0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, -1, -1},
	{  0,  2,  1,  6,  5,  4,  3,  9,  8,  7, 11, 10, 12, -1, -1},
	{  0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, -1, -1},
	{  0,  1,  7, 10, 11,  9,  6,  4,  2, 12,  5,  8,  3, -1, -1},
	{  0,  1, 11,  9,  2,  3,  6,  8,  4, 10, 12,  7,  5, -1, -1},
	{  0,  3,  6,  1, 11,  9,  2, 10, 12,  5,  7,  4,  8, -1, -1},
	{  0,  3, 11,  9, 12,  8,  2,  4, 10,  1,  5,  6,  7, -1, -1},
	{  0,  8,  2,  3, 11,  9, 12,  1,  5,  7,  6, 10,  4, -1, -1},
	{  0,  9,  2,  3,  6,  1, 11,  5,  7,  8,  4, 12, 10, -1, -1},
	{  0,  9,  6,  1,  7, 10, 11, 12,  5,  3,  8,  2,  4, -1, -1},
	{  0,  9, 12,  8,  2,  3, 11,  7,  6,  4, 10,  5,  1, -1, -1},
	{  0, 10, 11,  9,  6,  1,  7,  3,  8,  4,  2,  5, 12, -1, -1},
	{  0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, -1, -1},
	{  0,  3,  2,  8,  6,  5, 12, 11,  7,  4,  9,  1, 10, -1, -1},
	{  0,  3, 11, 10,  6,  9,  7,  4,  2, 12,  1,  8,  5, -1, -1},
	{  0,  3, 12,  9,  6,  8, 11,  7,  4,  2, 10,  5,  1, -1, -1},
	{  0,  5, 12,  3,  2,  8,  6,  4,  9, 10,  1,  7, 11, -1, -1},
	{  0,  8,  6,  5, 12,  3,  2, 10,  1, 11,  7,  9,  4, -1, -1},
	{  0,  8, 11,  3, 12,  9,  6,  2, 10,  1,  5,  4,  7, -1, -1},
	{  0,  9,  6,  8, 11,  3, 12,  1,  5,  7,  4, 10,  2, -1, -1},
	{  0,  9,  7,  3, 11, 10,  6, 12,  1,  5,  8,  2,  4, -1, -1},
	{  0, 10,  6,  9,  7,  3, 11,  5,  8,  4,  2,  1, 12, -1, -1},
	{  0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14},
	{  0,  3,  4,  6,  5,  2,  1,  9, 10, 14, 13, 11, 12,  8,  7},
	{  0,  4,  3,  1,  2,  5,  6, 10,  9, 13, 14,  7,  8, 12, 11},
	{  0,  6,  5,  1,  2,  4,  3, 14, 13,  7,  8, 11, 12, 10,  9},
	{  0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14},
	{  0, 12, 11, 10,  9, 13, 14,  8,  7,  4,  3,  2,  1,  5,  6},
	{  0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14},
	{  0,  9, 10, 13, 14, 11, 12,  8,  7,  1,  2,  5,  6,  3,  4},
	{  0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14},
	{  0,  6,  5,  4,  3,  2,  1, 11, 12, 10,  9,  7,  8, 14, 13},
	{  0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14},
	{  0, 12, 11, 10,  9, 13, 14,  8,  7,  4,  3,  2,  1,  5,  6},
	{  0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14},
	{  0,  9, 10, 13, 14, 11, 12,  8,  7,  1,  2,  5,  6,  3,  4},
	{  0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14},
	{  0,  3, 10, 14,  5,  9,  7, 13,  2,  8,  4, 11, 12,  1,  6},
	{  0, 13,  8,  1, 10,  4, 14,  6,  9,  5,  2, 11, 12,  7,  3},
	{  0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14},
	{  0, 11, 12, 14, 13,  9, 10,  7,  8,  3,  4,  6,  5,  1,  2},
	{  0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14},
	{  0, 13, 14, 11, 12,  5,  6, 10,  9,  1,  2,  7,  8,  4,  3},
};

graph_t graphs_sc[NUM_SC_GRAPHS] = {

{0,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,3,4},{1,3,5},{0,3,4},{0,3,5},{1,2,5},{1,2,4},{0,2,4},{0,2,5}}},

};

graph_t graphs_ico[NUM_ICO_GRAPHS] = {

{0,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{0,5,9},{1,2,8},{0,5,7},{2,7,8},{2,5,7},{1,4,8},{1,2,10},{5,9,10},{2,5,10},{4,8,11},{7,8,11},{0,7,11},{0,3,9},{0,3,11},{3,4,11},{3,6,9},{3,4,6},{6,9,10},{1,4,6},{1,6,10}}},

};

graph_t graphs_fcc[NUM_FCC_GRAPHS] = {

{0,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{0,4,8},{3,7,9},{2,5,11},{0,7,11},{1,5,9},{2,6,8},{3,4,10},{1,6,10},{3,4,7},{0,4,7},{0,2,11},{0,2,8},{5,7,11},{5,7,9},{1,2,6},{1,2,5},{1,3,10},{1,3,9},{4,6,10},{4,6,8}}},

{1,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{0,4,8},{3,7,9},{2,5,11},{0,7,11},{1,5,9},{2,6,8},{3,4,10},{1,6,10},{3,4,7},{0,4,7},{0,2,11},{0,2,8},{5,7,11},{5,7,9},{1,2,6},{1,2,5},{1,3,10},{1,3,9},{6,8,10},{4,8,10}}},

{2,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{0,4,8},{3,7,9},{2,5,11},{0,7,11},{1,5,9},{2,6,8},{3,4,10},{1,6,10},{3,4,7},{0,4,7},{0,2,11},{0,2,8},{5,7,11},{5,7,9},{1,2,6},{1,2,5},{3,9,10},{1,9,10},{6,8,10},{4,8,10}}},

{3,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{0,4,8},{3,7,9},{2,5,11},{0,7,11},{1,5,9},{2,6,8},{3,4,10},{1,6,10},{3,4,7},{0,4,7},{0,2,11},{0,2,8},{5,7,11},{5,7,9},{2,5,6},{1,5,6},{1,3,10},{1,3,9},{4,6,10},{4,6,8}}},

{4,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{0,4,8},{3,7,9},{2,5,11},{0,7,11},{1,5,9},{2,6,8},{3,4,10},{1,6,10},{3,4,7},{0,4,7},{0,2,11},{0,2,8},{5,7,11},{5,7,9},{2,5,6},{1,5,6},{1,3,10},{1,3,9},{6,8,10},{4,8,10}}},

{5,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{0,4,8},{3,7,9},{2,5,11},{0,7,11},{1,5,9},{2,6,8},{3,4,10},{1,6,10},{3,4,7},{0,4,7},{0,2,11},{0,2,8},{5,7,11},{5,7,9},{2,5,6},{1,5,6},{3,9,10},{1,9,10},{4,6,10},{4,6,8}}},

{6,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{0,4,8},{3,7,9},{2,5,11},{0,7,11},{1,5,9},{2,6,8},{3,4,10},{1,6,10},{3,4,7},{0,4,7},{0,2,11},{0,2,8},{7,9,11},{5,9,11},{1,2,6},{1,2,5},{3,9,10},{1,9,10},{4,6,10},{4,6,8}}},

{7,
0,
1,
5,
//{0,4,3,10,9,5,6,12,11,8,7,1,2},
//{0,5,6,11,12,8,7,2,1,4,3,10,9},
//{0,8,7,1,2,4,3,9,10,5,6,11,12},
//{0,8,7,10,9,1,2,6,5,12,11,3,4}},
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{0,4,8},{3,7,9},{2,5,11},{0,7,11},{1,5,9},{2,6,8},{3,4,10},{1,6,10},{3,4,7},{0,4,7},{0,2,11},{0,2,8},{7,9,11},{5,9,11},{2,5,6},{1,5,6},{1,3,10},{1,3,9},{6,8,10},{4,8,10}}},

};

graph_t graphs_hcp[NUM_HCP_GRAPHS] = {

{0,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,3,5},{5,6,10},{0,9,11},{1,9,11},{3,7,8},{2,7,8},{4,6,10},{0,2,4},{1,10,11},{1,5,10},{3,6,7},{3,5,6},{3,8,9},{1,3,9},{2,8,9},{0,2,9},{0,10,11},{0,4,10},{2,6,7},{2,4,6}}},

{1,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,3,5},{5,6,10},{0,9,11},{1,9,11},{3,7,8},{2,7,8},{4,6,10},{0,2,4},{1,10,11},{1,5,10},{3,6,7},{3,5,6},{3,8,9},{1,3,9},{2,8,9},{0,2,9},{0,10,11},{0,4,10},{4,6,7},{2,4,7}}},

{2,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,3,5},{5,6,10},{0,9,11},{1,9,11},{3,7,8},{2,7,8},{4,6,10},{0,2,4},{1,10,11},{1,5,10},{3,6,7},{3,5,6},{3,8,9},{1,3,9},{2,8,9},{0,2,9},{4,10,11},{0,4,11},{2,6,7},{2,4,6}}},

{3,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,3,5},{5,6,10},{0,9,11},{1,9,11},{3,7,8},{2,7,8},{4,6,10},{0,2,4},{1,10,11},{1,5,10},{3,6,7},{3,5,6},{3,8,9},{1,3,9},{2,8,9},{0,2,9},{4,10,11},{0,4,11},{4,6,7},{2,4,7}}},

{4,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,3,5},{5,6,10},{0,9,11},{1,9,11},{3,7,8},{2,7,8},{4,6,10},{0,2,4},{1,10,11},{1,5,10},{3,6,7},{3,5,6},{3,8,9},{1,3,9},{0,8,9},{0,2,8},{0,10,11},{0,4,10},{2,6,7},{2,4,6}}},

{5,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,3,5},{5,6,10},{0,9,11},{1,9,11},{3,7,8},{2,7,8},{4,6,10},{0,2,4},{1,10,11},{1,5,10},{3,6,7},{3,5,6},{3,8,9},{1,3,9},{0,8,9},{0,2,8},{0,10,11},{0,4,10},{4,6,7},{2,4,7}}},

{6,
0,
6,
2,
//{0,12,3,2,7,10,8,4,6,11,5,9,1}},
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,3,5},{5,6,10},{0,9,11},{1,9,11},{3,7,8},{2,7,8},{4,6,10},{0,2,4},{1,10,11},{1,5,10},{3,6,7},{3,5,6},{3,8,9},{1,3,9},{0,8,9},{0,2,8},{4,10,11},{0,4,11},{2,6,7},{2,4,6}}},

{7,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,3,5},{5,6,10},{0,9,11},{1,9,11},{3,7,8},{2,7,8},{4,6,10},{0,2,4},{1,10,11},{1,5,10},{3,6,7},{3,5,6},{3,8,9},{1,3,9},{0,8,9},{0,2,8},{4,10,11},{0,4,11},{4,6,7},{2,4,7}}},

{8,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,3,5},{5,6,10},{0,9,11},{1,9,11},{3,7,8},{2,7,8},{4,6,10},{0,2,4},{1,10,11},{1,5,10},{3,6,7},{3,5,6},{1,8,9},{1,3,8},{2,8,9},{0,2,9},{0,10,11},{0,4,10},{2,6,7},{2,4,6}}},

{9,
0,
8,
2,
//{0,4,11,8,1,9,12,10,3,5,7,2,6}},
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,3,5},{5,6,10},{0,9,11},{1,9,11},{3,7,8},{2,7,8},{4,6,10},{0,2,4},{1,10,11},{1,5,10},{3,6,7},{3,5,6},{1,8,9},{1,3,8},{2,8,9},{0,2,9},{0,10,11},{0,4,10},{4,6,7},{2,4,7}}},

{10,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,3,5},{5,6,10},{0,9,11},{1,9,11},{3,7,8},{2,7,8},{4,6,10},{0,2,4},{1,10,11},{1,5,10},{3,6,7},{3,5,6},{1,8,9},{1,3,8},{2,8,9},{0,2,9},{4,10,11},{0,4,11},{4,6,7},{2,4,7}}},

{11,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,3,5},{5,6,10},{0,9,11},{1,9,11},{3,7,8},{2,7,8},{4,6,10},{0,2,4},{1,10,11},{1,5,10},{3,6,7},{3,5,6},{1,8,9},{1,3,8},{0,8,9},{0,2,8},{0,10,11},{0,4,10},{4,6,7},{2,4,7}}},

{12,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,3,5},{5,6,10},{0,9,11},{1,9,11},{3,7,8},{2,7,8},{4,6,10},{0,2,4},{1,10,11},{1,5,10},{3,6,7},{3,5,6},{1,8,9},{1,3,8},{0,8,9},{0,2,8},{4,10,11},{0,4,11},{2,6,7},{2,4,6}}},

{13,
0,
10,
2,
//{0,2,1,6,5,4,3,9,8,7,11,10,12}},
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,3,5},{5,6,10},{0,9,11},{1,9,11},{3,7,8},{2,7,8},{4,6,10},{0,2,4},{1,10,11},{1,5,10},{5,6,7},{3,5,7},{3,8,9},{1,3,9},{2,8,9},{0,2,9},{0,10,11},{0,4,10},{4,6,7},{2,4,7}}},

{14,
0,
12,
10,
//{0,1,7,10,11,9,6,4,2,12,5,8,3},
//{0,1,11,9,2,3,6,8,4,10,12,7,5},
//{0,3,6,1,11,9,2,10,12,5,7,4,8},
//{0,3,11,9,12,8,2,4,10,1,5,6,7},
//{0,8,2,3,11,9,12,1,5,7,6,10,4},
//{0,9,2,3,6,1,11,5,7,8,4,12,10},
//{0,9,6,1,7,10,11,12,5,3,8,2,4},
//{0,9,12,8,2,3,11,7,6,4,10,5,1},
//{0,10,11,9,6,1,7,3,8,4,2,5,12}},
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,3,5},{5,6,10},{0,9,11},{1,9,11},{3,7,8},{2,7,8},{4,6,10},{0,2,4},{1,10,11},{1,5,10},{5,6,7},{3,5,7},{3,8,9},{1,3,9},{0,8,9},{0,2,8},{4,10,11},{0,4,11},{2,6,7},{2,4,6}}},

{15,
0,
22,
10,
//{0,3,2,8,6,5,12,11,7,4,9,1,10},
//{0,3,11,10,6,9,7,4,2,12,1,8,5},
//{0,3,12,9,6,8,11,7,4,2,10,5,1},
//{0,5,12,3,2,8,6,4,9,10,1,7,11},
//{0,8,6,5,12,3,2,10,1,11,7,9,4},
//{0,8,11,3,12,9,6,2,10,1,5,4,7},
//{0,9,6,8,11,3,12,1,5,7,4,10,2},
//{0,9,7,3,11,10,6,12,1,5,8,2,4},
//{0,10,6,9,7,3,11,5,8,4,2,1,12}},
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,3,5},{5,6,10},{0,9,11},{1,9,11},{3,7,8},{2,7,8},{4,6,10},{0,2,4},{5,10,11},{1,5,11},{3,6,7},{3,5,6},{1,8,9},{1,3,8},{2,8,9},{0,2,9},{0,10,11},{0,4,10},{4,6,7},{2,4,7}}},

};

graph_t graphs_bcc[NUM_BCC_GRAPHS] = {

{0,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{7,11,13},{1,11,13},{7,8,11},{4,8,11},{5,9,13},{1,9,13},{6,9,12},{3,9,12},{6,9,10},{5,9,10},{4,8,12},{0,8,12},{6,10,12},{0,10,12},{7,8,13},{2,8,13},{5,10,13},{2,10,13},{2,8,10},{0,8,10}}},

{1,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{7,11,13},{1,11,13},{7,8,11},{4,8,11},{5,9,13},{1,9,13},{6,9,12},{3,9,12},{6,9,10},{5,9,10},{4,8,12},{0,8,12},{6,10,12},{0,10,12},{7,8,13},{2,8,13},{5,10,13},{2,10,13},{0,2,10},{0,2,8}}},

{2,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{7,11,13},{1,11,13},{7,8,11},{4,8,11},{5,9,13},{1,9,13},{6,9,12},{3,9,12},{6,9,10},{5,9,10},{4,8,12},{0,8,12},{6,10,12},{0,10,12},{7,8,13},{2,8,13},{2,5,13},{2,5,10},{0,2,10},{0,2,8}}},

{3,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{7,11,13},{1,11,13},{7,8,11},{4,8,11},{5,9,13},{1,9,13},{6,9,12},{3,9,12},{6,9,10},{5,9,10},{4,8,12},{0,8,12},{6,10,12},{0,10,12},{2,7,13},{2,7,8},{2,5,13},{2,5,10},{0,2,10},{0,2,8}}},

{4,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{7,11,13},{1,11,13},{7,8,11},{4,8,11},{5,9,13},{1,9,13},{6,9,12},{3,9,12},{6,9,10},{5,9,10},{4,8,12},{0,8,12},{0,6,12},{0,6,10},{7,8,13},{2,8,13},{2,5,13},{2,5,10},{2,8,10},{0,8,10}}},

{5,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{7,11,13},{1,11,13},{7,8,11},{4,8,11},{5,9,13},{1,9,13},{6,9,12},{3,9,12},{6,9,10},{5,9,10},{4,8,12},{0,8,12},{0,6,12},{0,6,10},{7,8,13},{2,8,13},{2,5,13},{2,5,10},{0,2,10},{0,2,8}}},

{6,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{7,11,13},{1,11,13},{7,8,11},{4,8,11},{5,9,13},{1,9,13},{6,9,12},{3,9,12},{6,9,10},{5,9,10},{4,8,12},{0,8,12},{0,6,12},{0,6,10},{2,7,13},{2,7,8},{5,10,13},{2,10,13},{2,8,10},{0,8,10}}},

{7,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{7,11,13},{1,11,13},{7,8,11},{4,8,11},{5,9,13},{1,9,13},{6,9,12},{3,9,12},{6,9,10},{5,9,10},{4,8,12},{0,8,12},{0,6,12},{0,6,10},{2,7,13},{2,7,8},{5,10,13},{2,10,13},{0,2,10},{0,2,8}}},

{8,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{7,11,13},{1,11,13},{7,8,11},{4,8,11},{5,9,13},{1,9,13},{6,9,12},{3,9,12},{6,9,10},{5,9,10},{4,8,12},{0,8,12},{0,6,12},{0,6,10},{2,7,13},{2,7,8},{2,5,13},{2,5,10},{2,8,10},{0,8,10}}},

{9,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{7,11,13},{1,11,13},{7,8,11},{4,8,11},{5,9,13},{1,9,13},{6,9,12},{3,9,12},{6,9,10},{5,9,10},{4,8,12},{0,8,12},{0,6,12},{0,6,10},{2,7,13},{2,7,8},{2,5,13},{2,5,10},{0,2,10},{0,2,8}}},

{10,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{7,11,13},{1,11,13},{7,8,11},{4,8,11},{5,9,13},{1,9,13},{6,9,12},{3,9,12},{6,9,10},{5,9,10},{0,4,12},{0,4,8},{6,10,12},{0,10,12},{7,8,13},{2,8,13},{2,5,13},{2,5,10},{2,8,10},{0,8,10}}},

{11,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{7,11,13},{1,11,13},{7,8,11},{4,8,11},{5,9,13},{1,9,13},{6,9,12},{3,9,12},{6,9,10},{5,9,10},{0,4,12},{0,4,8},{6,10,12},{0,10,12},{7,8,13},{2,8,13},{2,5,13},{2,5,10},{0,2,10},{0,2,8}}},

{12,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{7,11,13},{1,11,13},{7,8,11},{4,8,11},{5,9,13},{1,9,13},{6,9,12},{3,9,12},{6,9,10},{5,9,10},{0,4,12},{0,4,8},{6,10,12},{0,10,12},{2,7,13},{2,7,8},{2,5,13},{2,5,10},{2,8,10},{0,8,10}}},

{13,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{7,11,13},{1,11,13},{7,8,11},{4,8,11},{5,9,13},{1,9,13},{6,9,12},{3,9,12},{6,9,10},{5,9,10},{0,4,12},{0,4,8},{6,10,12},{0,10,12},{2,7,13},{2,7,8},{2,5,13},{2,5,10},{0,2,10},{0,2,8}}},

{14,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{7,11,13},{1,11,13},{7,8,11},{4,8,11},{5,9,13},{1,9,13},{6,9,12},{3,9,12},{6,9,10},{5,9,10},{0,4,12},{0,4,8},{0,6,12},{0,6,10},{2,7,13},{2,7,8},{2,5,13},{2,5,10},{2,8,10},{0,8,10}}},

{15,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{7,11,13},{1,11,13},{7,8,11},{4,8,11},{5,9,13},{1,9,13},{6,9,12},{3,9,12},{6,9,10},{5,9,10},{0,4,12},{0,4,8},{0,6,12},{0,6,10},{2,7,13},{2,7,8},{2,5,13},{2,5,10},{0,2,10},{0,2,8}}},

{16,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{7,11,13},{1,11,13},{7,8,11},{4,8,11},{5,9,13},{1,9,13},{6,9,12},{3,9,12},{5,6,10},{5,6,9},{4,8,12},{0,8,12},{0,6,12},{0,6,10},{7,8,13},{2,8,13},{2,5,13},{2,5,10},{0,2,10},{0,2,8}}},

{17,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{7,11,13},{1,11,13},{7,8,11},{4,8,11},{5,9,13},{1,9,13},{6,9,12},{3,9,12},{5,6,10},{5,6,9},{4,8,12},{0,8,12},{0,6,12},{0,6,10},{2,7,13},{2,7,8},{5,10,13},{2,10,13},{2,8,10},{0,8,10}}},

{18,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{7,11,13},{1,11,13},{7,8,11},{4,8,11},{5,9,13},{1,9,13},{6,9,12},{3,9,12},{5,6,10},{5,6,9},{4,8,12},{0,8,12},{0,6,12},{0,6,10},{2,7,13},{2,7,8},{5,10,13},{2,10,13},{0,2,10},{0,2,8}}},

{19,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{7,11,13},{1,11,13},{7,8,11},{4,8,11},{5,9,13},{1,9,13},{6,9,12},{3,9,12},{5,6,10},{5,6,9},{4,8,12},{0,8,12},{0,6,12},{0,6,10},{2,7,13},{2,7,8},{2,5,13},{2,5,10},{2,8,10},{0,8,10}}},

{20,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{7,11,13},{1,11,13},{7,8,11},{4,8,11},{5,9,13},{1,9,13},{6,9,12},{3,9,12},{5,6,10},{5,6,9},{4,8,12},{0,8,12},{0,6,12},{0,6,10},{2,7,13},{2,7,8},{2,5,13},{2,5,10},{0,2,10},{0,2,8}}},

{21,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{7,11,13},{1,11,13},{7,8,11},{4,8,11},{5,9,13},{1,9,13},{6,9,12},{3,9,12},{5,6,10},{5,6,9},{0,4,12},{0,4,8},{6,10,12},{0,10,12},{2,7,13},{2,7,8},{5,10,13},{2,10,13},{2,8,10},{0,8,10}}},

{22,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{7,11,13},{1,11,13},{7,8,11},{4,8,11},{5,9,13},{1,9,13},{6,9,12},{3,9,12},{5,6,10},{5,6,9},{0,4,12},{0,4,8},{6,10,12},{0,10,12},{2,7,13},{2,7,8},{5,10,13},{2,10,13},{0,2,10},{0,2,8}}},

{23,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{7,11,13},{1,11,13},{7,8,11},{4,8,11},{5,9,13},{1,9,13},{6,9,12},{3,9,12},{5,6,10},{5,6,9},{0,4,12},{0,4,8},{6,10,12},{0,10,12},{2,7,13},{2,7,8},{2,5,13},{2,5,10},{2,8,10},{0,8,10}}},

{24,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{7,11,13},{1,11,13},{7,8,11},{4,8,11},{5,9,13},{1,9,13},{6,9,12},{3,9,12},{5,6,10},{5,6,9},{0,4,12},{0,4,8},{6,10,12},{0,10,12},{2,7,13},{2,7,8},{2,5,13},{2,5,10},{0,2,10},{0,2,8}}},

{25,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{7,11,13},{1,11,13},{7,8,11},{4,8,11},{5,9,13},{1,9,13},{6,9,12},{3,9,12},{5,6,10},{5,6,9},{0,4,12},{0,4,8},{0,6,12},{0,6,10},{2,7,13},{2,7,8},{5,10,13},{2,10,13},{2,8,10},{0,8,10}}},

{26,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{7,11,13},{1,11,13},{7,8,11},{4,8,11},{5,9,13},{1,9,13},{6,9,12},{3,9,12},{5,6,10},{5,6,9},{0,4,12},{0,4,8},{0,6,12},{0,6,10},{2,7,13},{2,7,8},{5,10,13},{2,10,13},{0,2,10},{0,2,8}}},

{27,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{7,11,13},{1,11,13},{7,8,11},{4,8,11},{5,9,13},{1,9,13},{6,9,12},{3,9,12},{5,6,10},{5,6,9},{0,4,12},{0,4,8},{0,6,12},{0,6,10},{2,7,13},{2,7,8},{2,5,13},{2,5,10},{2,8,10},{0,8,10}}},

{28,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{7,11,13},{1,11,13},{7,8,11},{4,8,11},{5,9,13},{1,9,13},{6,9,12},{3,9,12},{5,6,10},{5,6,9},{0,4,12},{0,4,8},{0,6,12},{0,6,10},{2,7,13},{2,7,8},{2,5,13},{2,5,10},{0,2,10},{0,2,8}}},

{29,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{7,11,13},{1,11,13},{7,8,11},{4,8,11},{5,9,13},{1,9,13},{3,6,12},{3,6,9},{6,9,10},{5,9,10},{4,8,12},{0,8,12},{6,10,12},{0,10,12},{2,7,13},{2,7,8},{5,10,13},{2,10,13},{2,8,10},{0,8,10}}},

{30,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{7,11,13},{1,11,13},{7,8,11},{4,8,11},{5,9,13},{1,9,13},{3,6,12},{3,6,9},{6,9,10},{5,9,10},{4,8,12},{0,8,12},{6,10,12},{0,10,12},{2,7,13},{2,7,8},{5,10,13},{2,10,13},{0,2,10},{0,2,8}}},

{31,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{7,11,13},{1,11,13},{7,8,11},{4,8,11},{5,9,13},{1,9,13},{3,6,12},{3,6,9},{6,9,10},{5,9,10},{4,8,12},{0,8,12},{6,10,12},{0,10,12},{2,7,13},{2,7,8},{2,5,13},{2,5,10},{2,8,10},{0,8,10}}},

{32,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{7,11,13},{1,11,13},{7,8,11},{4,8,11},{5,9,13},{1,9,13},{3,6,12},{3,6,9},{6,9,10},{5,9,10},{4,8,12},{0,8,12},{6,10,12},{0,10,12},{2,7,13},{2,7,8},{2,5,13},{2,5,10},{0,2,10},{0,2,8}}},

{33,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{7,11,13},{1,11,13},{7,8,11},{4,8,11},{5,9,13},{1,9,13},{3,6,12},{3,6,9},{6,9,10},{5,9,10},{4,8,12},{0,8,12},{0,6,12},{0,6,10},{2,7,13},{2,7,8},{5,10,13},{2,10,13},{0,2,10},{0,2,8}}},

{34,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{7,11,13},{1,11,13},{7,8,11},{4,8,11},{5,9,13},{1,9,13},{3,6,12},{3,6,9},{6,9,10},{5,9,10},{4,8,12},{0,8,12},{0,6,12},{0,6,10},{2,7,13},{2,7,8},{2,5,13},{2,5,10},{2,8,10},{0,8,10}}},

{35,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{7,11,13},{1,11,13},{7,8,11},{4,8,11},{5,9,13},{1,9,13},{3,6,12},{3,6,9},{6,9,10},{5,9,10},{4,8,12},{0,8,12},{0,6,12},{0,6,10},{2,7,13},{2,7,8},{2,5,13},{2,5,10},{0,2,10},{0,2,8}}},

{36,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{7,11,13},{1,11,13},{7,8,11},{4,8,11},{5,9,13},{1,9,13},{3,6,12},{3,6,9},{6,9,10},{5,9,10},{0,4,12},{0,4,8},{6,10,12},{0,10,12},{2,7,13},{2,7,8},{5,10,13},{2,10,13},{2,8,10},{0,8,10}}},

{37,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{7,11,13},{1,11,13},{7,8,11},{4,8,11},{5,9,13},{1,9,13},{3,6,12},{3,6,9},{6,9,10},{5,9,10},{0,4,12},{0,4,8},{6,10,12},{0,10,12},{2,7,13},{2,7,8},{5,10,13},{2,10,13},{0,2,10},{0,2,8}}},

{38,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{7,11,13},{1,11,13},{7,8,11},{4,8,11},{5,9,13},{1,9,13},{3,6,12},{3,6,9},{6,9,10},{5,9,10},{0,4,12},{0,4,8},{6,10,12},{0,10,12},{2,7,13},{2,7,8},{2,5,13},{2,5,10},{2,8,10},{0,8,10}}},

{39,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{7,11,13},{1,11,13},{7,8,11},{4,8,11},{5,9,13},{1,9,13},{3,6,12},{3,6,9},{6,9,10},{5,9,10},{0,4,12},{0,4,8},{6,10,12},{0,10,12},{2,7,13},{2,7,8},{2,5,13},{2,5,10},{0,2,10},{0,2,8}}},

{40,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{7,11,13},{1,11,13},{7,8,11},{4,8,11},{5,9,13},{1,9,13},{3,6,12},{3,6,9},{6,9,10},{5,9,10},{0,4,12},{0,4,8},{0,6,12},{0,6,10},{2,7,13},{2,7,8},{5,10,13},{2,10,13},{2,8,10},{0,8,10}}},

{41,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{7,11,13},{1,11,13},{7,8,11},{4,8,11},{5,9,13},{1,9,13},{3,6,12},{3,6,9},{6,9,10},{5,9,10},{0,4,12},{0,4,8},{0,6,12},{0,6,10},{2,7,13},{2,7,8},{5,10,13},{2,10,13},{0,2,10},{0,2,8}}},

{42,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{7,11,13},{1,11,13},{7,8,11},{4,8,11},{5,9,13},{1,9,13},{3,6,12},{3,6,9},{6,9,10},{5,9,10},{0,4,12},{0,4,8},{0,6,12},{0,6,10},{2,7,13},{2,7,8},{2,5,13},{2,5,10},{2,8,10},{0,8,10}}},

{43,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{7,11,13},{1,11,13},{7,8,11},{4,8,11},{5,9,13},{1,9,13},{3,6,12},{3,6,9},{6,9,10},{5,9,10},{0,4,12},{0,4,8},{0,6,12},{0,6,10},{2,7,13},{2,7,8},{2,5,13},{2,5,10},{0,2,10},{0,2,8}}},

{44,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{7,11,13},{1,11,13},{7,8,11},{4,8,11},{5,9,13},{1,9,13},{3,6,12},{3,6,9},{5,6,10},{5,6,9},{4,8,12},{0,8,12},{6,10,12},{0,10,12},{2,7,13},{2,7,8},{5,10,13},{2,10,13},{0,2,10},{0,2,8}}},

{45,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{7,11,13},{1,11,13},{7,8,11},{4,8,11},{5,9,13},{1,9,13},{3,6,12},{3,6,9},{5,6,10},{5,6,9},{4,8,12},{0,8,12},{6,10,12},{0,10,12},{2,7,13},{2,7,8},{2,5,13},{2,5,10},{0,2,10},{0,2,8}}},

{46,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{7,11,13},{1,11,13},{7,8,11},{4,8,11},{5,9,13},{1,9,13},{3,6,12},{3,6,9},{5,6,10},{5,6,9},{4,8,12},{0,8,12},{0,6,12},{0,6,10},{2,7,13},{2,7,8},{2,5,13},{2,5,10},{0,2,10},{0,2,8}}},

{47,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{7,11,13},{1,11,13},{7,8,11},{4,8,11},{5,9,13},{1,9,13},{3,6,12},{3,6,9},{5,6,10},{5,6,9},{0,4,12},{0,4,8},{6,10,12},{0,10,12},{2,7,13},{2,7,8},{5,10,13},{2,10,13},{2,8,10},{0,8,10}}},

{48,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{7,11,13},{1,11,13},{7,8,11},{4,8,11},{5,9,13},{1,9,13},{3,6,12},{3,6,9},{5,6,10},{5,6,9},{0,4,12},{0,4,8},{6,10,12},{0,10,12},{2,7,13},{2,7,8},{5,10,13},{2,10,13},{0,2,10},{0,2,8}}},

{49,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{7,11,13},{1,11,13},{7,8,11},{4,8,11},{5,9,13},{1,9,13},{3,6,12},{3,6,9},{5,6,10},{5,6,9},{0,4,12},{0,4,8},{6,10,12},{0,10,12},{2,7,13},{2,7,8},{2,5,13},{2,5,10},{2,8,10},{0,8,10}}},

{50,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{7,11,13},{1,11,13},{7,8,11},{4,8,11},{5,9,13},{1,9,13},{3,6,12},{3,6,9},{5,6,10},{5,6,9},{0,4,12},{0,4,8},{6,10,12},{0,10,12},{2,7,13},{2,7,8},{2,5,13},{2,5,10},{0,2,10},{0,2,8}}},

{51,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{7,11,13},{1,11,13},{7,8,11},{4,8,11},{5,9,13},{1,9,13},{3,6,12},{3,6,9},{5,6,10},{5,6,9},{0,4,12},{0,4,8},{0,6,12},{0,6,10},{2,7,13},{2,7,8},{5,10,13},{2,10,13},{2,8,10},{0,8,10}}},

{52,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{7,11,13},{1,11,13},{7,8,11},{4,8,11},{5,9,13},{1,9,13},{3,6,12},{3,6,9},{5,6,10},{5,6,9},{0,4,12},{0,4,8},{0,6,12},{0,6,10},{2,7,13},{2,7,8},{5,10,13},{2,10,13},{0,2,10},{0,2,8}}},

{53,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{7,11,13},{1,11,13},{7,8,11},{4,8,11},{5,9,13},{1,9,13},{3,6,12},{3,6,9},{5,6,10},{5,6,9},{0,4,12},{0,4,8},{0,6,12},{0,6,10},{2,7,13},{2,7,8},{2,5,13},{2,5,10},{2,8,10},{0,8,10}}},

{54,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{7,11,13},{1,11,13},{7,8,11},{4,8,11},{5,9,13},{1,9,13},{3,6,12},{3,6,9},{5,6,10},{5,6,9},{0,4,12},{0,4,8},{0,6,12},{0,6,10},{2,7,13},{2,7,8},{2,5,13},{2,5,10},{0,2,10},{0,2,8}}},

{55,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{7,11,13},{1,11,13},{7,8,11},{4,8,11},{1,5,13},{1,5,9},{3,6,12},{3,6,9},{6,9,10},{5,9,10},{0,4,12},{0,4,8},{6,10,12},{0,10,12},{2,7,13},{2,7,8},{5,10,13},{2,10,13},{2,8,10},{0,8,10}}},

{56,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{7,11,13},{1,11,13},{7,8,11},{4,8,11},{1,5,13},{1,5,9},{3,6,12},{3,6,9},{6,9,10},{5,9,10},{0,4,12},{0,4,8},{6,10,12},{0,10,12},{2,7,13},{2,7,8},{5,10,13},{2,10,13},{0,2,10},{0,2,8}}},

{57,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{7,11,13},{1,11,13},{7,8,11},{4,8,11},{1,5,13},{1,5,9},{3,6,12},{3,6,9},{6,9,10},{5,9,10},{0,4,12},{0,4,8},{6,10,12},{0,10,12},{2,7,13},{2,7,8},{2,5,13},{2,5,10},{0,2,10},{0,2,8}}},

{58,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{7,11,13},{1,11,13},{7,8,11},{4,8,11},{1,5,13},{1,5,9},{3,6,12},{3,6,9},{6,9,10},{5,9,10},{0,4,12},{0,4,8},{0,6,12},{0,6,10},{2,7,13},{2,7,8},{2,5,13},{2,5,10},{2,8,10},{0,8,10}}},

{59,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{7,11,13},{1,11,13},{7,8,11},{4,8,11},{1,5,13},{1,5,9},{3,6,12},{3,6,9},{6,9,10},{5,9,10},{0,4,12},{0,4,8},{0,6,12},{0,6,10},{2,7,13},{2,7,8},{2,5,13},{2,5,10},{0,2,10},{0,2,8}}},

{60,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{7,11,13},{1,11,13},{7,8,11},{4,8,11},{1,5,13},{1,5,9},{3,6,12},{3,6,9},{5,6,10},{5,6,9},{0,4,12},{0,4,8},{0,6,12},{0,6,10},{2,7,13},{2,7,8},{2,5,13},{2,5,10},{0,2,10},{0,2,8}}},

{61,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{7,11,13},{1,11,13},{4,7,11},{4,7,8},{5,9,13},{1,9,13},{6,9,12},{3,9,12},{5,6,10},{5,6,9},{4,8,12},{0,8,12},{0,6,12},{0,6,10},{7,8,13},{2,8,13},{2,5,13},{2,5,10},{2,8,10},{0,8,10}}},

{62,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{7,11,13},{1,11,13},{4,7,11},{4,7,8},{5,9,13},{1,9,13},{6,9,12},{3,9,12},{5,6,10},{5,6,9},{4,8,12},{0,8,12},{0,6,12},{0,6,10},{7,8,13},{2,8,13},{2,5,13},{2,5,10},{0,2,10},{0,2,8}}},

{63,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{7,11,13},{1,11,13},{4,7,11},{4,7,8},{5,9,13},{1,9,13},{6,9,12},{3,9,12},{5,6,10},{5,6,9},{4,8,12},{0,8,12},{0,6,12},{0,6,10},{2,7,13},{2,7,8},{5,10,13},{2,10,13},{2,8,10},{0,8,10}}},

{64,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{7,11,13},{1,11,13},{4,7,11},{4,7,8},{5,9,13},{1,9,13},{6,9,12},{3,9,12},{5,6,10},{5,6,9},{4,8,12},{0,8,12},{0,6,12},{0,6,10},{2,7,13},{2,7,8},{5,10,13},{2,10,13},{0,2,10},{0,2,8}}},

{65,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{7,11,13},{1,11,13},{4,7,11},{4,7,8},{5,9,13},{1,9,13},{6,9,12},{3,9,12},{5,6,10},{5,6,9},{4,8,12},{0,8,12},{0,6,12},{0,6,10},{2,7,13},{2,7,8},{2,5,13},{2,5,10},{2,8,10},{0,8,10}}},

{66,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{7,11,13},{1,11,13},{4,7,11},{4,7,8},{5,9,13},{1,9,13},{6,9,12},{3,9,12},{5,6,10},{5,6,9},{4,8,12},{0,8,12},{0,6,12},{0,6,10},{2,7,13},{2,7,8},{2,5,13},{2,5,10},{0,2,10},{0,2,8}}},

{67,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{7,11,13},{1,11,13},{4,7,11},{4,7,8},{5,9,13},{1,9,13},{6,9,12},{3,9,12},{5,6,10},{5,6,9},{0,4,12},{0,4,8},{6,10,12},{0,10,12},{7,8,13},{2,8,13},{2,5,13},{2,5,10},{2,8,10},{0,8,10}}},

{68,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{7,11,13},{1,11,13},{4,7,11},{4,7,8},{5,9,13},{1,9,13},{6,9,12},{3,9,12},{5,6,10},{5,6,9},{0,4,12},{0,4,8},{6,10,12},{0,10,12},{7,8,13},{2,8,13},{2,5,13},{2,5,10},{0,2,10},{0,2,8}}},

{69,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{7,11,13},{1,11,13},{4,7,11},{4,7,8},{5,9,13},{1,9,13},{6,9,12},{3,9,12},{5,6,10},{5,6,9},{0,4,12},{0,4,8},{6,10,12},{0,10,12},{2,7,13},{2,7,8},{2,5,13},{2,5,10},{2,8,10},{0,8,10}}},

{70,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{7,11,13},{1,11,13},{4,7,11},{4,7,8},{5,9,13},{1,9,13},{6,9,12},{3,9,12},{5,6,10},{5,6,9},{0,4,12},{0,4,8},{6,10,12},{0,10,12},{2,7,13},{2,7,8},{2,5,13},{2,5,10},{0,2,10},{0,2,8}}},

{71,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{7,11,13},{1,11,13},{4,7,11},{4,7,8},{5,9,13},{1,9,13},{6,9,12},{3,9,12},{5,6,10},{5,6,9},{0,4,12},{0,4,8},{0,6,12},{0,6,10},{2,7,13},{2,7,8},{2,5,13},{2,5,10},{2,8,10},{0,8,10}}},

{72,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{7,11,13},{1,11,13},{4,7,11},{4,7,8},{5,9,13},{1,9,13},{6,9,12},{3,9,12},{5,6,10},{5,6,9},{0,4,12},{0,4,8},{0,6,12},{0,6,10},{2,7,13},{2,7,8},{2,5,13},{2,5,10},{0,2,10},{0,2,8}}},

{73,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{7,11,13},{1,11,13},{4,7,11},{4,7,8},{5,9,13},{1,9,13},{3,6,12},{3,6,9},{6,9,10},{5,9,10},{4,8,12},{0,8,12},{6,10,12},{0,10,12},{7,8,13},{2,8,13},{2,5,13},{2,5,10},{2,8,10},{0,8,10}}},

{74,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{7,11,13},{1,11,13},{4,7,11},{4,7,8},{5,9,13},{1,9,13},{3,6,12},{3,6,9},{6,9,10},{5,9,10},{4,8,12},{0,8,12},{6,10,12},{0,10,12},{7,8,13},{2,8,13},{2,5,13},{2,5,10},{0,2,10},{0,2,8}}},

{75,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{7,11,13},{1,11,13},{4,7,11},{4,7,8},{5,9,13},{1,9,13},{3,6,12},{3,6,9},{6,9,10},{5,9,10},{4,8,12},{0,8,12},{6,10,12},{0,10,12},{2,7,13},{2,7,8},{2,5,13},{2,5,10},{2,8,10},{0,8,10}}},

{76,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{7,11,13},{1,11,13},{4,7,11},{4,7,8},{5,9,13},{1,9,13},{3,6,12},{3,6,9},{6,9,10},{5,9,10},{4,8,12},{0,8,12},{6,10,12},{0,10,12},{2,7,13},{2,7,8},{2,5,13},{2,5,10},{0,2,10},{0,2,8}}},

{77,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{7,11,13},{1,11,13},{4,7,11},{4,7,8},{5,9,13},{1,9,13},{3,6,12},{3,6,9},{6,9,10},{5,9,10},{4,8,12},{0,8,12},{0,6,12},{0,6,10},{7,8,13},{2,8,13},{2,5,13},{2,5,10},{0,2,10},{0,2,8}}},

{78,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{7,11,13},{1,11,13},{4,7,11},{4,7,8},{5,9,13},{1,9,13},{3,6,12},{3,6,9},{6,9,10},{5,9,10},{4,8,12},{0,8,12},{0,6,12},{0,6,10},{2,7,13},{2,7,8},{2,5,13},{2,5,10},{2,8,10},{0,8,10}}},

{79,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{7,11,13},{1,11,13},{4,7,11},{4,7,8},{5,9,13},{1,9,13},{3,6,12},{3,6,9},{6,9,10},{5,9,10},{4,8,12},{0,8,12},{0,6,12},{0,6,10},{2,7,13},{2,7,8},{2,5,13},{2,5,10},{0,2,10},{0,2,8}}},

{80,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{7,11,13},{1,11,13},{4,7,11},{4,7,8},{5,9,13},{1,9,13},{3,6,12},{3,6,9},{6,9,10},{5,9,10},{0,4,12},{0,4,8},{6,10,12},{0,10,12},{2,7,13},{2,7,8},{2,5,13},{2,5,10},{2,8,10},{0,8,10}}},

{81,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{7,11,13},{1,11,13},{4,7,11},{4,7,8},{5,9,13},{1,9,13},{3,6,12},{3,6,9},{6,9,10},{5,9,10},{0,4,12},{0,4,8},{6,10,12},{0,10,12},{2,7,13},{2,7,8},{2,5,13},{2,5,10},{0,2,10},{0,2,8}}},

{82,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{7,11,13},{1,11,13},{4,7,11},{4,7,8},{5,9,13},{1,9,13},{3,6,12},{3,6,9},{6,9,10},{5,9,10},{0,4,12},{0,4,8},{0,6,12},{0,6,10},{7,8,13},{2,8,13},{2,5,13},{2,5,10},{0,2,10},{0,2,8}}},

{83,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{7,11,13},{1,11,13},{4,7,11},{4,7,8},{5,9,13},{1,9,13},{3,6,12},{3,6,9},{6,9,10},{5,9,10},{0,4,12},{0,4,8},{0,6,12},{0,6,10},{2,7,13},{2,7,8},{2,5,13},{2,5,10},{2,8,10},{0,8,10}}},

{84,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{7,11,13},{1,11,13},{4,7,11},{4,7,8},{5,9,13},{1,9,13},{3,6,12},{3,6,9},{6,9,10},{5,9,10},{0,4,12},{0,4,8},{0,6,12},{0,6,10},{2,7,13},{2,7,8},{2,5,13},{2,5,10},{0,2,10},{0,2,8}}},

{85,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{7,11,13},{1,11,13},{4,7,11},{4,7,8},{5,9,13},{1,9,13},{3,6,12},{3,6,9},{5,6,10},{5,6,9},{4,8,12},{0,8,12},{6,10,12},{0,10,12},{2,7,13},{2,7,8},{5,10,13},{2,10,13},{2,8,10},{0,8,10}}},

{86,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{7,11,13},{1,11,13},{4,7,11},{4,7,8},{5,9,13},{1,9,13},{3,6,12},{3,6,9},{5,6,10},{5,6,9},{4,8,12},{0,8,12},{6,10,12},{0,10,12},{2,7,13},{2,7,8},{5,10,13},{2,10,13},{0,2,10},{0,2,8}}},

{87,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{7,11,13},{1,11,13},{4,7,11},{4,7,8},{5,9,13},{1,9,13},{3,6,12},{3,6,9},{5,6,10},{5,6,9},{4,8,12},{0,8,12},{6,10,12},{0,10,12},{2,7,13},{2,7,8},{2,5,13},{2,5,10},{2,8,10},{0,8,10}}},

{88,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{7,11,13},{1,11,13},{4,7,11},{4,7,8},{5,9,13},{1,9,13},{3,6,12},{3,6,9},{5,6,10},{5,6,9},{4,8,12},{0,8,12},{6,10,12},{0,10,12},{2,7,13},{2,7,8},{2,5,13},{2,5,10},{0,2,10},{0,2,8}}},

{89,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{7,11,13},{1,11,13},{4,7,11},{4,7,8},{5,9,13},{1,9,13},{3,6,12},{3,6,9},{5,6,10},{5,6,9},{4,8,12},{0,8,12},{0,6,12},{0,6,10},{2,7,13},{2,7,8},{5,10,13},{2,10,13},{2,8,10},{0,8,10}}},

{90,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{7,11,13},{1,11,13},{4,7,11},{4,7,8},{5,9,13},{1,9,13},{3,6,12},{3,6,9},{5,6,10},{5,6,9},{4,8,12},{0,8,12},{0,6,12},{0,6,10},{2,7,13},{2,7,8},{5,10,13},{2,10,13},{0,2,10},{0,2,8}}},

{91,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{7,11,13},{1,11,13},{4,7,11},{4,7,8},{5,9,13},{1,9,13},{3,6,12},{3,6,9},{5,6,10},{5,6,9},{4,8,12},{0,8,12},{0,6,12},{0,6,10},{2,7,13},{2,7,8},{2,5,13},{2,5,10},{2,8,10},{0,8,10}}},

{92,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{7,11,13},{1,11,13},{4,7,11},{4,7,8},{5,9,13},{1,9,13},{3,6,12},{3,6,9},{5,6,10},{5,6,9},{4,8,12},{0,8,12},{0,6,12},{0,6,10},{2,7,13},{2,7,8},{2,5,13},{2,5,10},{0,2,10},{0,2,8}}},

{93,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{7,11,13},{1,11,13},{4,7,11},{4,7,8},{5,9,13},{1,9,13},{3,6,12},{3,6,9},{5,6,10},{5,6,9},{0,4,12},{0,4,8},{6,10,12},{0,10,12},{2,7,13},{2,7,8},{5,10,13},{2,10,13},{2,8,10},{0,8,10}}},

{94,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{7,11,13},{1,11,13},{4,7,11},{4,7,8},{5,9,13},{1,9,13},{3,6,12},{3,6,9},{5,6,10},{5,6,9},{0,4,12},{0,4,8},{6,10,12},{0,10,12},{2,7,13},{2,7,8},{5,10,13},{2,10,13},{0,2,10},{0,2,8}}},

{95,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{7,11,13},{1,11,13},{4,7,11},{4,7,8},{5,9,13},{1,9,13},{3,6,12},{3,6,9},{5,6,10},{5,6,9},{0,4,12},{0,4,8},{6,10,12},{0,10,12},{2,7,13},{2,7,8},{2,5,13},{2,5,10},{2,8,10},{0,8,10}}},

{96,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{7,11,13},{1,11,13},{4,7,11},{4,7,8},{5,9,13},{1,9,13},{3,6,12},{3,6,9},{5,6,10},{5,6,9},{0,4,12},{0,4,8},{6,10,12},{0,10,12},{2,7,13},{2,7,8},{2,5,13},{2,5,10},{0,2,10},{0,2,8}}},

{97,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{7,11,13},{1,11,13},{4,7,11},{4,7,8},{5,9,13},{1,9,13},{3,6,12},{3,6,9},{5,6,10},{5,6,9},{0,4,12},{0,4,8},{0,6,12},{0,6,10},{2,7,13},{2,7,8},{5,10,13},{2,10,13},{2,8,10},{0,8,10}}},

{98,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{7,11,13},{1,11,13},{4,7,11},{4,7,8},{5,9,13},{1,9,13},{3,6,12},{3,6,9},{5,6,10},{5,6,9},{0,4,12},{0,4,8},{0,6,12},{0,6,10},{2,7,13},{2,7,8},{5,10,13},{2,10,13},{0,2,10},{0,2,8}}},

{99,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{7,11,13},{1,11,13},{4,7,11},{4,7,8},{5,9,13},{1,9,13},{3,6,12},{3,6,9},{5,6,10},{5,6,9},{0,4,12},{0,4,8},{0,6,12},{0,6,10},{2,7,13},{2,7,8},{2,5,13},{2,5,10},{2,8,10},{0,8,10}}},

{100,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{7,11,13},{1,11,13},{4,7,11},{4,7,8},{5,9,13},{1,9,13},{3,6,12},{3,6,9},{5,6,10},{5,6,9},{0,4,12},{0,4,8},{0,6,12},{0,6,10},{2,7,13},{2,7,8},{2,5,13},{2,5,10},{0,2,10},{0,2,8}}},

{101,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{7,11,13},{1,11,13},{4,7,11},{4,7,8},{1,5,13},{1,5,9},{6,9,12},{3,9,12},{6,9,10},{5,9,10},{4,8,12},{0,8,12},{0,6,12},{0,6,10},{7,8,13},{2,8,13},{5,10,13},{2,10,13},{2,8,10},{0,8,10}}},

{102,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{7,11,13},{1,11,13},{4,7,11},{4,7,8},{1,5,13},{1,5,9},{6,9,12},{3,9,12},{6,9,10},{5,9,10},{4,8,12},{0,8,12},{0,6,12},{0,6,10},{7,8,13},{2,8,13},{5,10,13},{2,10,13},{0,2,10},{0,2,8}}},

{103,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{7,11,13},{1,11,13},{4,7,11},{4,7,8},{1,5,13},{1,5,9},{6,9,12},{3,9,12},{6,9,10},{5,9,10},{4,8,12},{0,8,12},{0,6,12},{0,6,10},{7,8,13},{2,8,13},{2,5,13},{2,5,10},{0,2,10},{0,2,8}}},

{104,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{7,11,13},{1,11,13},{4,7,11},{4,7,8},{1,5,13},{1,5,9},{6,9,12},{3,9,12},{6,9,10},{5,9,10},{4,8,12},{0,8,12},{0,6,12},{0,6,10},{2,7,13},{2,7,8},{2,5,13},{2,5,10},{0,2,10},{0,2,8}}},

{105,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{7,11,13},{1,11,13},{4,7,11},{4,7,8},{1,5,13},{1,5,9},{6,9,12},{3,9,12},{6,9,10},{5,9,10},{0,4,12},{0,4,8},{0,6,12},{0,6,10},{7,8,13},{2,8,13},{5,10,13},{2,10,13},{2,8,10},{0,8,10}}},

{106,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{7,11,13},{1,11,13},{4,7,11},{4,7,8},{1,5,13},{1,5,9},{6,9,12},{3,9,12},{6,9,10},{5,9,10},{0,4,12},{0,4,8},{0,6,12},{0,6,10},{7,8,13},{2,8,13},{5,10,13},{2,10,13},{0,2,10},{0,2,8}}},

{107,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{7,11,13},{1,11,13},{4,7,11},{4,7,8},{1,5,13},{1,5,9},{6,9,12},{3,9,12},{6,9,10},{5,9,10},{0,4,12},{0,4,8},{0,6,12},{0,6,10},{7,8,13},{2,8,13},{2,5,13},{2,5,10},{2,8,10},{0,8,10}}},

{108,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{7,11,13},{1,11,13},{4,7,11},{4,7,8},{1,5,13},{1,5,9},{6,9,12},{3,9,12},{6,9,10},{5,9,10},{0,4,12},{0,4,8},{0,6,12},{0,6,10},{7,8,13},{2,8,13},{2,5,13},{2,5,10},{0,2,10},{0,2,8}}},

{109,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{7,11,13},{1,11,13},{4,7,11},{4,7,8},{1,5,13},{1,5,9},{6,9,12},{3,9,12},{6,9,10},{5,9,10},{0,4,12},{0,4,8},{0,6,12},{0,6,10},{2,7,13},{2,7,8},{5,10,13},{2,10,13},{2,8,10},{0,8,10}}},

{110,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{7,11,13},{1,11,13},{4,7,11},{4,7,8},{1,5,13},{1,5,9},{6,9,12},{3,9,12},{6,9,10},{5,9,10},{0,4,12},{0,4,8},{0,6,12},{0,6,10},{2,7,13},{2,7,8},{5,10,13},{2,10,13},{0,2,10},{0,2,8}}},

{111,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{7,11,13},{1,11,13},{4,7,11},{4,7,8},{1,5,13},{1,5,9},{6,9,12},{3,9,12},{6,9,10},{5,9,10},{0,4,12},{0,4,8},{0,6,12},{0,6,10},{2,7,13},{2,7,8},{2,5,13},{2,5,10},{2,8,10},{0,8,10}}},

{112,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{7,11,13},{1,11,13},{4,7,11},{4,7,8},{1,5,13},{1,5,9},{6,9,12},{3,9,12},{6,9,10},{5,9,10},{0,4,12},{0,4,8},{0,6,12},{0,6,10},{2,7,13},{2,7,8},{2,5,13},{2,5,10},{0,2,10},{0,2,8}}},

{113,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{7,11,13},{1,11,13},{4,7,11},{4,7,8},{1,5,13},{1,5,9},{6,9,12},{3,9,12},{5,6,10},{5,6,9},{0,4,12},{0,4,8},{0,6,12},{0,6,10},{7,8,13},{2,8,13},{5,10,13},{2,10,13},{2,8,10},{0,8,10}}},

{114,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{7,11,13},{1,11,13},{4,7,11},{4,7,8},{1,5,13},{1,5,9},{6,9,12},{3,9,12},{5,6,10},{5,6,9},{0,4,12},{0,4,8},{0,6,12},{0,6,10},{7,8,13},{2,8,13},{5,10,13},{2,10,13},{0,2,10},{0,2,8}}},

{115,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{7,11,13},{1,11,13},{4,7,11},{4,7,8},{1,5,13},{1,5,9},{6,9,12},{3,9,12},{5,6,10},{5,6,9},{0,4,12},{0,4,8},{0,6,12},{0,6,10},{7,8,13},{2,8,13},{2,5,13},{2,5,10},{2,8,10},{0,8,10}}},

{116,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{7,11,13},{1,11,13},{4,7,11},{4,7,8},{1,5,13},{1,5,9},{6,9,12},{3,9,12},{5,6,10},{5,6,9},{0,4,12},{0,4,8},{0,6,12},{0,6,10},{7,8,13},{2,8,13},{2,5,13},{2,5,10},{0,2,10},{0,2,8}}},

{117,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{7,11,13},{1,11,13},{4,7,11},{4,7,8},{1,5,13},{1,5,9},{6,9,12},{3,9,12},{5,6,10},{5,6,9},{0,4,12},{0,4,8},{0,6,12},{0,6,10},{2,7,13},{2,7,8},{5,10,13},{2,10,13},{2,8,10},{0,8,10}}},

{118,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{7,11,13},{1,11,13},{4,7,11},{4,7,8},{1,5,13},{1,5,9},{6,9,12},{3,9,12},{5,6,10},{5,6,9},{0,4,12},{0,4,8},{0,6,12},{0,6,10},{2,7,13},{2,7,8},{5,10,13},{2,10,13},{0,2,10},{0,2,8}}},

{119,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{7,11,13},{1,11,13},{4,7,11},{4,7,8},{1,5,13},{1,5,9},{6,9,12},{3,9,12},{5,6,10},{5,6,9},{0,4,12},{0,4,8},{0,6,12},{0,6,10},{2,7,13},{2,7,8},{2,5,13},{2,5,10},{2,8,10},{0,8,10}}},

{120,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{7,11,13},{1,11,13},{4,7,11},{4,7,8},{1,5,13},{1,5,9},{6,9,12},{3,9,12},{5,6,10},{5,6,9},{0,4,12},{0,4,8},{0,6,12},{0,6,10},{2,7,13},{2,7,8},{2,5,13},{2,5,10},{0,2,10},{0,2,8}}},

{121,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{7,11,13},{1,11,13},{4,7,11},{4,7,8},{1,5,13},{1,5,9},{3,6,12},{3,6,9},{6,9,10},{5,9,10},{4,8,12},{0,8,12},{6,10,12},{0,10,12},{7,8,13},{2,8,13},{5,10,13},{2,10,13},{0,2,10},{0,2,8}}},

{122,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{7,11,13},{1,11,13},{4,7,11},{4,7,8},{1,5,13},{1,5,9},{3,6,12},{3,6,9},{6,9,10},{5,9,10},{4,8,12},{0,8,12},{6,10,12},{0,10,12},{7,8,13},{2,8,13},{2,5,13},{2,5,10},{0,2,10},{0,2,8}}},

{123,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{7,11,13},{1,11,13},{4,7,11},{4,7,8},{1,5,13},{1,5,9},{3,6,12},{3,6,9},{6,9,10},{5,9,10},{4,8,12},{0,8,12},{6,10,12},{0,10,12},{2,7,13},{2,7,8},{5,10,13},{2,10,13},{0,2,10},{0,2,8}}},

{124,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{7,11,13},{1,11,13},{4,7,11},{4,7,8},{1,5,13},{1,5,9},{3,6,12},{3,6,9},{6,9,10},{5,9,10},{4,8,12},{0,8,12},{6,10,12},{0,10,12},{2,7,13},{2,7,8},{2,5,13},{2,5,10},{0,2,10},{0,2,8}}},

{125,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{7,11,13},{1,11,13},{4,7,11},{4,7,8},{1,5,13},{1,5,9},{3,6,12},{3,6,9},{6,9,10},{5,9,10},{4,8,12},{0,8,12},{0,6,12},{0,6,10},{7,8,13},{2,8,13},{5,10,13},{2,10,13},{0,2,10},{0,2,8}}},

{126,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{7,11,13},{1,11,13},{4,7,11},{4,7,8},{1,5,13},{1,5,9},{3,6,12},{3,6,9},{6,9,10},{5,9,10},{4,8,12},{0,8,12},{0,6,12},{0,6,10},{7,8,13},{2,8,13},{2,5,13},{2,5,10},{2,8,10},{0,8,10}}},

{127,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{7,11,13},{1,11,13},{4,7,11},{4,7,8},{1,5,13},{1,5,9},{3,6,12},{3,6,9},{6,9,10},{5,9,10},{4,8,12},{0,8,12},{0,6,12},{0,6,10},{7,8,13},{2,8,13},{2,5,13},{2,5,10},{0,2,10},{0,2,8}}},

{128,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{7,11,13},{1,11,13},{4,7,11},{4,7,8},{1,5,13},{1,5,9},{3,6,12},{3,6,9},{6,9,10},{5,9,10},{4,8,12},{0,8,12},{0,6,12},{0,6,10},{2,7,13},{2,7,8},{5,10,13},{2,10,13},{2,8,10},{0,8,10}}},

{129,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{7,11,13},{1,11,13},{4,7,11},{4,7,8},{1,5,13},{1,5,9},{3,6,12},{3,6,9},{6,9,10},{5,9,10},{4,8,12},{0,8,12},{0,6,12},{0,6,10},{2,7,13},{2,7,8},{5,10,13},{2,10,13},{0,2,10},{0,2,8}}},

{130,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{7,11,13},{1,11,13},{4,7,11},{4,7,8},{1,5,13},{1,5,9},{3,6,12},{3,6,9},{6,9,10},{5,9,10},{4,8,12},{0,8,12},{0,6,12},{0,6,10},{2,7,13},{2,7,8},{2,5,13},{2,5,10},{2,8,10},{0,8,10}}},

{131,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{7,11,13},{1,11,13},{4,7,11},{4,7,8},{1,5,13},{1,5,9},{3,6,12},{3,6,9},{6,9,10},{5,9,10},{4,8,12},{0,8,12},{0,6,12},{0,6,10},{2,7,13},{2,7,8},{2,5,13},{2,5,10},{0,2,10},{0,2,8}}},

{132,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{7,11,13},{1,11,13},{4,7,11},{4,7,8},{1,5,13},{1,5,9},{3,6,12},{3,6,9},{6,9,10},{5,9,10},{0,4,12},{0,4,8},{6,10,12},{0,10,12},{7,8,13},{2,8,13},{2,5,13},{2,5,10},{2,8,10},{0,8,10}}},

{133,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{7,11,13},{1,11,13},{4,7,11},{4,7,8},{1,5,13},{1,5,9},{3,6,12},{3,6,9},{6,9,10},{5,9,10},{0,4,12},{0,4,8},{6,10,12},{0,10,12},{7,8,13},{2,8,13},{2,5,13},{2,5,10},{0,2,10},{0,2,8}}},

{134,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{7,11,13},{1,11,13},{4,7,11},{4,7,8},{1,5,13},{1,5,9},{3,6,12},{3,6,9},{6,9,10},{5,9,10},{0,4,12},{0,4,8},{6,10,12},{0,10,12},{2,7,13},{2,7,8},{5,10,13},{2,10,13},{0,2,10},{0,2,8}}},

{135,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{7,11,13},{1,11,13},{4,7,11},{4,7,8},{1,5,13},{1,5,9},{3,6,12},{3,6,9},{6,9,10},{5,9,10},{0,4,12},{0,4,8},{6,10,12},{0,10,12},{2,7,13},{2,7,8},{2,5,13},{2,5,10},{2,8,10},{0,8,10}}},

{136,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{7,11,13},{1,11,13},{4,7,11},{4,7,8},{1,5,13},{1,5,9},{3,6,12},{3,6,9},{6,9,10},{5,9,10},{0,4,12},{0,4,8},{6,10,12},{0,10,12},{2,7,13},{2,7,8},{2,5,13},{2,5,10},{0,2,10},{0,2,8}}},

{137,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{7,11,13},{1,11,13},{4,7,11},{4,7,8},{1,5,13},{1,5,9},{3,6,12},{3,6,9},{6,9,10},{5,9,10},{0,4,12},{0,4,8},{0,6,12},{0,6,10},{7,8,13},{2,8,13},{5,10,13},{2,10,13},{0,2,10},{0,2,8}}},

{138,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{7,11,13},{1,11,13},{4,7,11},{4,7,8},{1,5,13},{1,5,9},{3,6,12},{3,6,9},{6,9,10},{5,9,10},{0,4,12},{0,4,8},{0,6,12},{0,6,10},{7,8,13},{2,8,13},{2,5,13},{2,5,10},{2,8,10},{0,8,10}}},

{139,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{7,11,13},{1,11,13},{4,7,11},{4,7,8},{1,5,13},{1,5,9},{3,6,12},{3,6,9},{6,9,10},{5,9,10},{0,4,12},{0,4,8},{0,6,12},{0,6,10},{7,8,13},{2,8,13},{2,5,13},{2,5,10},{0,2,10},{0,2,8}}},

{140,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{7,11,13},{1,11,13},{4,7,11},{4,7,8},{1,5,13},{1,5,9},{3,6,12},{3,6,9},{6,9,10},{5,9,10},{0,4,12},{0,4,8},{0,6,12},{0,6,10},{2,7,13},{2,7,8},{5,10,13},{2,10,13},{2,8,10},{0,8,10}}},

{141,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{7,11,13},{1,11,13},{4,7,11},{4,7,8},{1,5,13},{1,5,9},{3,6,12},{3,6,9},{6,9,10},{5,9,10},{0,4,12},{0,4,8},{0,6,12},{0,6,10},{2,7,13},{2,7,8},{5,10,13},{2,10,13},{0,2,10},{0,2,8}}},

{142,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{7,11,13},{1,11,13},{4,7,11},{4,7,8},{1,5,13},{1,5,9},{3,6,12},{3,6,9},{6,9,10},{5,9,10},{0,4,12},{0,4,8},{0,6,12},{0,6,10},{2,7,13},{2,7,8},{2,5,13},{2,5,10},{2,8,10},{0,8,10}}},

{143,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{7,11,13},{1,11,13},{4,7,11},{4,7,8},{1,5,13},{1,5,9},{3,6,12},{3,6,9},{6,9,10},{5,9,10},{0,4,12},{0,4,8},{0,6,12},{0,6,10},{2,7,13},{2,7,8},{2,5,13},{2,5,10},{0,2,10},{0,2,8}}},

{144,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{7,11,13},{1,11,13},{4,7,11},{4,7,8},{1,5,13},{1,5,9},{3,6,12},{3,6,9},{5,6,10},{5,6,9},{4,8,12},{0,8,12},{6,10,12},{0,10,12},{2,7,13},{2,7,8},{5,10,13},{2,10,13},{0,2,10},{0,2,8}}},

{145,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{7,11,13},{1,11,13},{4,7,11},{4,7,8},{1,5,13},{1,5,9},{3,6,12},{3,6,9},{5,6,10},{5,6,9},{4,8,12},{0,8,12},{6,10,12},{0,10,12},{2,7,13},{2,7,8},{2,5,13},{2,5,10},{0,2,10},{0,2,8}}},

{146,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{7,11,13},{1,11,13},{4,7,11},{4,7,8},{1,5,13},{1,5,9},{3,6,12},{3,6,9},{5,6,10},{5,6,9},{4,8,12},{0,8,12},{0,6,12},{0,6,10},{7,8,13},{2,8,13},{2,5,13},{2,5,10},{2,8,10},{0,8,10}}},

{147,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{7,11,13},{1,11,13},{4,7,11},{4,7,8},{1,5,13},{1,5,9},{3,6,12},{3,6,9},{5,6,10},{5,6,9},{4,8,12},{0,8,12},{0,6,12},{0,6,10},{7,8,13},{2,8,13},{2,5,13},{2,5,10},{0,2,10},{0,2,8}}},

{148,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{7,11,13},{1,11,13},{4,7,11},{4,7,8},{1,5,13},{1,5,9},{3,6,12},{3,6,9},{5,6,10},{5,6,9},{4,8,12},{0,8,12},{0,6,12},{0,6,10},{2,7,13},{2,7,8},{5,10,13},{2,10,13},{2,8,10},{0,8,10}}},

{149,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{7,11,13},{1,11,13},{4,7,11},{4,7,8},{1,5,13},{1,5,9},{3,6,12},{3,6,9},{5,6,10},{5,6,9},{4,8,12},{0,8,12},{0,6,12},{0,6,10},{2,7,13},{2,7,8},{5,10,13},{2,10,13},{0,2,10},{0,2,8}}},

{150,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{7,11,13},{1,11,13},{4,7,11},{4,7,8},{1,5,13},{1,5,9},{3,6,12},{3,6,9},{5,6,10},{5,6,9},{4,8,12},{0,8,12},{0,6,12},{0,6,10},{2,7,13},{2,7,8},{2,5,13},{2,5,10},{2,8,10},{0,8,10}}},

{151,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{7,11,13},{1,11,13},{4,7,11},{4,7,8},{1,5,13},{1,5,9},{3,6,12},{3,6,9},{5,6,10},{5,6,9},{4,8,12},{0,8,12},{0,6,12},{0,6,10},{2,7,13},{2,7,8},{2,5,13},{2,5,10},{0,2,10},{0,2,8}}},

{152,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{7,11,13},{1,11,13},{4,7,11},{4,7,8},{1,5,13},{1,5,9},{3,6,12},{3,6,9},{5,6,10},{5,6,9},{0,4,12},{0,4,8},{6,10,12},{0,10,12},{7,8,13},{2,8,13},{5,10,13},{2,10,13},{0,2,10},{0,2,8}}},

{153,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{7,11,13},{1,11,13},{4,7,11},{4,7,8},{1,5,13},{1,5,9},{3,6,12},{3,6,9},{5,6,10},{5,6,9},{0,4,12},{0,4,8},{6,10,12},{0,10,12},{7,8,13},{2,8,13},{2,5,13},{2,5,10},{2,8,10},{0,8,10}}},

{154,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{7,11,13},{1,11,13},{4,7,11},{4,7,8},{1,5,13},{1,5,9},{3,6,12},{3,6,9},{5,6,10},{5,6,9},{0,4,12},{0,4,8},{6,10,12},{0,10,12},{7,8,13},{2,8,13},{2,5,13},{2,5,10},{0,2,10},{0,2,8}}},

{155,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{7,11,13},{1,11,13},{4,7,11},{4,7,8},{1,5,13},{1,5,9},{3,6,12},{3,6,9},{5,6,10},{5,6,9},{0,4,12},{0,4,8},{6,10,12},{0,10,12},{2,7,13},{2,7,8},{5,10,13},{2,10,13},{2,8,10},{0,8,10}}},

{156,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{7,11,13},{1,11,13},{4,7,11},{4,7,8},{1,5,13},{1,5,9},{3,6,12},{3,6,9},{5,6,10},{5,6,9},{0,4,12},{0,4,8},{6,10,12},{0,10,12},{2,7,13},{2,7,8},{5,10,13},{2,10,13},{0,2,10},{0,2,8}}},

{157,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{7,11,13},{1,11,13},{4,7,11},{4,7,8},{1,5,13},{1,5,9},{3,6,12},{3,6,9},{5,6,10},{5,6,9},{0,4,12},{0,4,8},{6,10,12},{0,10,12},{2,7,13},{2,7,8},{2,5,13},{2,5,10},{2,8,10},{0,8,10}}},

{158,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{7,11,13},{1,11,13},{4,7,11},{4,7,8},{1,5,13},{1,5,9},{3,6,12},{3,6,9},{5,6,10},{5,6,9},{0,4,12},{0,4,8},{6,10,12},{0,10,12},{2,7,13},{2,7,8},{2,5,13},{2,5,10},{0,2,10},{0,2,8}}},

{159,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{7,11,13},{1,11,13},{4,7,11},{4,7,8},{1,5,13},{1,5,9},{3,6,12},{3,6,9},{5,6,10},{5,6,9},{0,4,12},{0,4,8},{0,6,12},{0,6,10},{7,8,13},{2,8,13},{5,10,13},{2,10,13},{0,2,10},{0,2,8}}},

{160,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{7,11,13},{1,11,13},{4,7,11},{4,7,8},{1,5,13},{1,5,9},{3,6,12},{3,6,9},{5,6,10},{5,6,9},{0,4,12},{0,4,8},{0,6,12},{0,6,10},{7,8,13},{2,8,13},{2,5,13},{2,5,10},{2,8,10},{0,8,10}}},

{161,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{7,11,13},{1,11,13},{4,7,11},{4,7,8},{1,5,13},{1,5,9},{3,6,12},{3,6,9},{5,6,10},{5,6,9},{0,4,12},{0,4,8},{0,6,12},{0,6,10},{7,8,13},{2,8,13},{2,5,13},{2,5,10},{0,2,10},{0,2,8}}},

{162,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{7,11,13},{1,11,13},{4,7,11},{4,7,8},{1,5,13},{1,5,9},{3,6,12},{3,6,9},{5,6,10},{5,6,9},{0,4,12},{0,4,8},{0,6,12},{0,6,10},{2,7,13},{2,7,8},{5,10,13},{2,10,13},{2,8,10},{0,8,10}}},

{163,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{7,11,13},{1,11,13},{4,7,11},{4,7,8},{1,5,13},{1,5,9},{3,6,12},{3,6,9},{5,6,10},{5,6,9},{0,4,12},{0,4,8},{0,6,12},{0,6,10},{2,7,13},{2,7,8},{5,10,13},{2,10,13},{0,2,10},{0,2,8}}},

{164,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{7,11,13},{1,11,13},{4,7,11},{4,7,8},{1,5,13},{1,5,9},{3,6,12},{3,6,9},{5,6,10},{5,6,9},{0,4,12},{0,4,8},{0,6,12},{0,6,10},{2,7,13},{2,7,8},{2,5,13},{2,5,10},{2,8,10},{0,8,10}}},

{165,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{7,11,13},{1,11,13},{4,7,11},{4,7,8},{1,5,13},{1,5,9},{3,6,12},{3,6,9},{5,6,10},{5,6,9},{0,4,12},{0,4,8},{0,6,12},{0,6,10},{2,7,13},{2,7,8},{2,5,13},{2,5,10},{0,2,10},{0,2,8}}},

{166,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{1,7,13},{1,7,11},{4,7,11},{4,7,8},{5,9,13},{1,9,13},{3,6,12},{3,6,9},{5,6,10},{5,6,9},{4,8,12},{0,8,12},{0,6,12},{0,6,10},{7,8,13},{2,8,13},{2,5,13},{2,5,10},{0,2,10},{0,2,8}}},

{167,
0,
32,
4,
//{0,3,4,6,5,2,1,9,10,14,13,11,12,8,7},
//{0,4,3,1,2,5,6,10,9,13,14,7,8,12,11},
//{0,6,5,1,2,4,3,14,13,7,8,11,12,10,9}},
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{1,7,13},{1,7,11},{4,7,11},{4,7,8},{5,9,13},{1,9,13},{3,6,12},{3,6,9},{5,6,10},{5,6,9},{4,8,12},{0,8,12},{0,6,12},{0,6,10},{2,7,13},{2,7,8},{5,10,13},{2,10,13},{2,8,10},{0,8,10}}},

{168,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{1,7,13},{1,7,11},{4,7,11},{4,7,8},{5,9,13},{1,9,13},{3,6,12},{3,6,9},{5,6,10},{5,6,9},{4,8,12},{0,8,12},{0,6,12},{0,6,10},{2,7,13},{2,7,8},{5,10,13},{2,10,13},{0,2,10},{0,2,8}}},

{169,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{1,7,13},{1,7,11},{4,7,11},{4,7,8},{5,9,13},{1,9,13},{3,6,12},{3,6,9},{5,6,10},{5,6,9},{4,8,12},{0,8,12},{0,6,12},{0,6,10},{2,7,13},{2,7,8},{2,5,13},{2,5,10},{2,8,10},{0,8,10}}},

{170,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{1,7,13},{1,7,11},{4,7,11},{4,7,8},{5,9,13},{1,9,13},{3,6,12},{3,6,9},{5,6,10},{5,6,9},{4,8,12},{0,8,12},{0,6,12},{0,6,10},{2,7,13},{2,7,8},{2,5,13},{2,5,10},{0,2,10},{0,2,8}}},

{171,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{1,7,13},{1,7,11},{4,7,11},{4,7,8},{5,9,13},{1,9,13},{3,6,12},{3,6,9},{5,6,10},{5,6,9},{0,4,12},{0,4,8},{6,10,12},{0,10,12},{7,8,13},{2,8,13},{2,5,13},{2,5,10},{2,8,10},{0,8,10}}},

{172,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{1,7,13},{1,7,11},{4,7,11},{4,7,8},{5,9,13},{1,9,13},{3,6,12},{3,6,9},{5,6,10},{5,6,9},{0,4,12},{0,4,8},{6,10,12},{0,10,12},{7,8,13},{2,8,13},{2,5,13},{2,5,10},{0,2,10},{0,2,8}}},

{173,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{1,7,13},{1,7,11},{4,7,11},{4,7,8},{5,9,13},{1,9,13},{3,6,12},{3,6,9},{5,6,10},{5,6,9},{0,4,12},{0,4,8},{6,10,12},{0,10,12},{2,7,13},{2,7,8},{2,5,13},{2,5,10},{2,8,10},{0,8,10}}},

{174,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{1,7,13},{1,7,11},{4,7,11},{4,7,8},{5,9,13},{1,9,13},{3,6,12},{3,6,9},{5,6,10},{5,6,9},{0,4,12},{0,4,8},{6,10,12},{0,10,12},{2,7,13},{2,7,8},{2,5,13},{2,5,10},{0,2,10},{0,2,8}}},

{175,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{1,7,13},{1,7,11},{4,7,11},{4,7,8},{5,9,13},{1,9,13},{3,6,12},{3,6,9},{5,6,10},{5,6,9},{0,4,12},{0,4,8},{0,6,12},{0,6,10},{2,7,13},{2,7,8},{2,5,13},{2,5,10},{2,8,10},{0,8,10}}},

{176,
0,
36,
2,
//{0,12,11,10,9,13,14,8,7,4,3,2,1,5,6}},
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{1,7,13},{1,7,11},{4,7,11},{4,7,8},{5,9,13},{1,9,13},{3,6,12},{3,6,9},{5,6,10},{5,6,9},{0,4,12},{0,4,8},{0,6,12},{0,6,10},{2,7,13},{2,7,8},{2,5,13},{2,5,10},{0,2,10},{0,2,8}}},

{177,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{1,7,13},{1,7,11},{4,7,11},{4,7,8},{1,5,13},{1,5,9},{6,9,12},{3,9,12},{5,6,10},{5,6,9},{0,4,12},{0,4,8},{0,6,12},{0,6,10},{7,8,13},{2,8,13},{5,10,13},{2,10,13},{2,8,10},{0,8,10}}},

{178,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{1,7,13},{1,7,11},{4,7,11},{4,7,8},{1,5,13},{1,5,9},{6,9,12},{3,9,12},{5,6,10},{5,6,9},{0,4,12},{0,4,8},{0,6,12},{0,6,10},{7,8,13},{2,8,13},{5,10,13},{2,10,13},{0,2,10},{0,2,8}}},

{179,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{1,7,13},{1,7,11},{4,7,11},{4,7,8},{1,5,13},{1,5,9},{6,9,12},{3,9,12},{5,6,10},{5,6,9},{0,4,12},{0,4,8},{0,6,12},{0,6,10},{7,8,13},{2,8,13},{2,5,13},{2,5,10},{0,2,10},{0,2,8}}},

{180,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{1,7,13},{1,7,11},{4,7,11},{4,7,8},{1,5,13},{1,5,9},{6,9,12},{3,9,12},{5,6,10},{5,6,9},{0,4,12},{0,4,8},{0,6,12},{0,6,10},{2,7,13},{2,7,8},{2,5,13},{2,5,10},{0,2,10},{0,2,8}}},

{181,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{1,7,13},{1,7,11},{4,7,11},{4,7,8},{1,5,13},{1,5,9},{3,6,12},{3,6,9},{6,9,10},{5,9,10},{4,8,12},{0,8,12},{0,6,12},{0,6,10},{7,8,13},{2,8,13},{5,10,13},{2,10,13},{0,2,10},{0,2,8}}},

{182,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{1,7,13},{1,7,11},{4,7,11},{4,7,8},{1,5,13},{1,5,9},{3,6,12},{3,6,9},{6,9,10},{5,9,10},{4,8,12},{0,8,12},{0,6,12},{0,6,10},{7,8,13},{2,8,13},{2,5,13},{2,5,10},{0,2,10},{0,2,8}}},

{183,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{1,7,13},{1,7,11},{4,7,11},{4,7,8},{1,5,13},{1,5,9},{3,6,12},{3,6,9},{6,9,10},{5,9,10},{4,8,12},{0,8,12},{0,6,12},{0,6,10},{2,7,13},{2,7,8},{5,10,13},{2,10,13},{0,2,10},{0,2,8}}},

{184,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{1,7,13},{1,7,11},{4,7,11},{4,7,8},{1,5,13},{1,5,9},{3,6,12},{3,6,9},{6,9,10},{5,9,10},{4,8,12},{0,8,12},{0,6,12},{0,6,10},{2,7,13},{2,7,8},{2,5,13},{2,5,10},{0,2,10},{0,2,8}}},

{185,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{1,7,13},{1,7,11},{4,7,11},{4,7,8},{1,5,13},{1,5,9},{3,6,12},{3,6,9},{6,9,10},{5,9,10},{0,4,12},{0,4,8},{6,10,12},{0,10,12},{7,8,13},{2,8,13},{2,5,13},{2,5,10},{0,2,10},{0,2,8}}},

{186,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{1,7,13},{1,7,11},{4,7,11},{4,7,8},{1,5,13},{1,5,9},{3,6,12},{3,6,9},{6,9,10},{5,9,10},{0,4,12},{0,4,8},{6,10,12},{0,10,12},{2,7,13},{2,7,8},{2,5,13},{2,5,10},{0,2,10},{0,2,8}}},

{187,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{1,7,13},{1,7,11},{4,7,11},{4,7,8},{1,5,13},{1,5,9},{3,6,12},{3,6,9},{6,9,10},{5,9,10},{0,4,12},{0,4,8},{0,6,12},{0,6,10},{7,8,13},{2,8,13},{2,5,13},{2,5,10},{2,8,10},{0,8,10}}},

{188,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{1,7,13},{1,7,11},{4,7,11},{4,7,8},{1,5,13},{1,5,9},{3,6,12},{3,6,9},{6,9,10},{5,9,10},{0,4,12},{0,4,8},{0,6,12},{0,6,10},{7,8,13},{2,8,13},{2,5,13},{2,5,10},{0,2,10},{0,2,8}}},

{189,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{1,7,13},{1,7,11},{4,7,11},{4,7,8},{1,5,13},{1,5,9},{3,6,12},{3,6,9},{6,9,10},{5,9,10},{0,4,12},{0,4,8},{0,6,12},{0,6,10},{2,7,13},{2,7,8},{5,10,13},{2,10,13},{0,2,10},{0,2,8}}},

{190,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{1,7,13},{1,7,11},{4,7,11},{4,7,8},{1,5,13},{1,5,9},{3,6,12},{3,6,9},{6,9,10},{5,9,10},{0,4,12},{0,4,8},{0,6,12},{0,6,10},{2,7,13},{2,7,8},{2,5,13},{2,5,10},{2,8,10},{0,8,10}}},

{191,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{1,7,13},{1,7,11},{4,7,11},{4,7,8},{1,5,13},{1,5,9},{3,6,12},{3,6,9},{6,9,10},{5,9,10},{0,4,12},{0,4,8},{0,6,12},{0,6,10},{2,7,13},{2,7,8},{2,5,13},{2,5,10},{0,2,10},{0,2,8}}},

{192,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{1,7,13},{1,7,11},{4,7,11},{4,7,8},{1,5,13},{1,5,9},{3,6,12},{3,6,9},{5,6,10},{5,6,9},{4,8,12},{0,8,12},{0,6,12},{0,6,10},{2,7,13},{2,7,8},{5,10,13},{2,10,13},{0,2,10},{0,2,8}}},

{193,
0,
38,
2,
//{0,9,10,13,14,11,12,8,7,1,2,5,6,3,4}},
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{1,7,13},{1,7,11},{4,7,11},{4,7,8},{1,5,13},{1,5,9},{3,6,12},{3,6,9},{5,6,10},{5,6,9},{4,8,12},{0,8,12},{0,6,12},{0,6,10},{2,7,13},{2,7,8},{2,5,13},{2,5,10},{0,2,10},{0,2,8}}},

{194,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{1,7,13},{1,7,11},{4,7,11},{4,7,8},{1,5,13},{1,5,9},{3,6,12},{3,6,9},{5,6,10},{5,6,9},{0,4,12},{0,4,8},{6,10,12},{0,10,12},{7,8,13},{2,8,13},{5,10,13},{2,10,13},{0,2,10},{0,2,8}}},

{195,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{1,7,13},{1,7,11},{4,7,11},{4,7,8},{1,5,13},{1,5,9},{3,6,12},{3,6,9},{5,6,10},{5,6,9},{0,4,12},{0,4,8},{6,10,12},{0,10,12},{7,8,13},{2,8,13},{2,5,13},{2,5,10},{0,2,10},{0,2,8}}},

{196,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{1,7,13},{1,7,11},{4,7,11},{4,7,8},{1,5,13},{1,5,9},{3,6,12},{3,6,9},{5,6,10},{5,6,9},{0,4,12},{0,4,8},{6,10,12},{0,10,12},{2,7,13},{2,7,8},{5,10,13},{2,10,13},{0,2,10},{0,2,8}}},

{197,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{1,7,13},{1,7,11},{4,7,11},{4,7,8},{1,5,13},{1,5,9},{3,6,12},{3,6,9},{5,6,10},{5,6,9},{0,4,12},{0,4,8},{6,10,12},{0,10,12},{2,7,13},{2,7,8},{2,5,13},{2,5,10},{2,8,10},{0,8,10}}},

{198,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{1,7,13},{1,7,11},{4,7,11},{4,7,8},{1,5,13},{1,5,9},{3,6,12},{3,6,9},{5,6,10},{5,6,9},{0,4,12},{0,4,8},{6,10,12},{0,10,12},{2,7,13},{2,7,8},{2,5,13},{2,5,10},{0,2,10},{0,2,8}}},

{199,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{1,7,13},{1,7,11},{4,7,11},{4,7,8},{1,5,13},{1,5,9},{3,6,12},{3,6,9},{5,6,10},{5,6,9},{0,4,12},{0,4,8},{0,6,12},{0,6,10},{7,8,13},{2,8,13},{5,10,13},{2,10,13},{0,2,10},{0,2,8}}},

{200,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{1,7,13},{1,7,11},{4,7,11},{4,7,8},{1,5,13},{1,5,9},{3,6,12},{3,6,9},{5,6,10},{5,6,9},{0,4,12},{0,4,8},{0,6,12},{0,6,10},{7,8,13},{2,8,13},{2,5,13},{2,5,10},{2,8,10},{0,8,10}}},

{201,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{1,7,13},{1,7,11},{4,7,11},{4,7,8},{1,5,13},{1,5,9},{3,6,12},{3,6,9},{5,6,10},{5,6,9},{0,4,12},{0,4,8},{0,6,12},{0,6,10},{7,8,13},{2,8,13},{2,5,13},{2,5,10},{0,2,10},{0,2,8}}},

{202,
0,
40,
2,
//{0,6,5,4,3,2,1,11,12,10,9,7,8,14,13}},
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{1,7,13},{1,7,11},{4,7,11},{4,7,8},{1,5,13},{1,5,9},{3,6,12},{3,6,9},{5,6,10},{5,6,9},{0,4,12},{0,4,8},{0,6,12},{0,6,10},{2,7,13},{2,7,8},{5,10,13},{2,10,13},{2,8,10},{0,8,10}}},

{203,
0,
42,
2,
//{0,12,11,10,9,13,14,8,7,4,3,2,1,5,6}},
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{1,7,13},{1,7,11},{4,7,11},{4,7,8},{1,5,13},{1,5,9},{3,6,12},{3,6,9},{5,6,10},{5,6,9},{0,4,12},{0,4,8},{0,6,12},{0,6,10},{2,7,13},{2,7,8},{5,10,13},{2,10,13},{0,2,10},{0,2,8}}},

{204,
0,
44,
2,
//{0,9,10,13,14,11,12,8,7,1,2,5,6,3,4}},
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{1,7,13},{1,7,11},{4,7,11},{4,7,8},{1,5,13},{1,5,9},{3,6,12},{3,6,9},{5,6,10},{5,6,9},{0,4,12},{0,4,8},{0,6,12},{0,6,10},{2,7,13},{2,7,8},{2,5,13},{2,5,10},{2,8,10},{0,8,10}}},

{205,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{4,11,12},{3,11,12},{1,7,13},{1,7,11},{4,7,11},{4,7,8},{1,5,13},{1,5,9},{3,6,12},{3,6,9},{5,6,10},{5,6,9},{0,4,12},{0,4,8},{0,6,12},{0,6,10},{2,7,13},{2,7,8},{2,5,13},{2,5,10},{0,2,10},{0,2,8}}},

{206,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{3,4,12},{3,4,11},{1,7,13},{1,7,11},{7,8,11},{4,8,11},{1,5,13},{1,5,9},{3,6,12},{3,6,9},{6,9,10},{5,9,10},{0,4,12},{0,4,8},{0,6,12},{0,6,10},{2,7,13},{2,7,8},{2,5,13},{2,5,10},{2,8,10},{0,8,10}}},

{207,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{3,4,12},{3,4,11},{1,7,13},{1,7,11},{7,8,11},{4,8,11},{1,5,13},{1,5,9},{3,6,12},{3,6,9},{6,9,10},{5,9,10},{0,4,12},{0,4,8},{0,6,12},{0,6,10},{2,7,13},{2,7,8},{2,5,13},{2,5,10},{0,2,10},{0,2,8}}},

{208,
0,
46,
3,
//{0,3,10,14,5,9,7,13,2,8,4,11,12,1,6},
//{0,13,8,1,10,4,14,6,9,5,2,11,12,7,3}},
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{3,4,12},{3,4,11},{1,7,13},{1,7,11},{7,8,11},{4,8,11},{1,5,13},{1,5,9},{3,6,12},{3,6,9},{5,6,10},{5,6,9},{0,4,12},{0,4,8},{6,10,12},{0,10,12},{2,7,13},{2,7,8},{5,10,13},{2,10,13},{0,2,10},{0,2,8}}},

{209,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{3,4,12},{3,4,11},{1,7,13},{1,7,11},{7,8,11},{4,8,11},{1,5,13},{1,5,9},{3,6,12},{3,6,9},{5,6,10},{5,6,9},{0,4,12},{0,4,8},{6,10,12},{0,10,12},{2,7,13},{2,7,8},{2,5,13},{2,5,10},{0,2,10},{0,2,8}}},

{210,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{3,4,12},{3,4,11},{1,7,13},{1,7,11},{7,8,11},{4,8,11},{1,5,13},{1,5,9},{3,6,12},{3,6,9},{5,6,10},{5,6,9},{0,4,12},{0,4,8},{0,6,12},{0,6,10},{2,7,13},{2,7,8},{2,5,13},{2,5,10},{0,2,10},{0,2,8}}},

{211,
0,
49,
2,
//{0,11,12,14,13,9,10,7,8,3,4,6,5,1,2}},
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{3,4,12},{3,4,11},{1,7,13},{1,7,11},{4,7,11},{4,7,8},{1,5,13},{1,5,9},{3,6,12},{3,6,9},{5,6,10},{5,6,9},{4,8,12},{0,8,12},{0,6,12},{0,6,10},{2,7,13},{2,7,8},{5,10,13},{2,10,13},{0,2,10},{0,2,8}}},

{212,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{3,4,12},{3,4,11},{1,7,13},{1,7,11},{4,7,11},{4,7,8},{1,5,13},{1,5,9},{3,6,12},{3,6,9},{5,6,10},{5,6,9},{4,8,12},{0,8,12},{0,6,12},{0,6,10},{2,7,13},{2,7,8},{2,5,13},{2,5,10},{0,2,10},{0,2,8}}},

{213,
0,
51,
2,
//{0,13,14,11,12,5,6,10,9,1,2,7,8,4,3}},
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{3,4,12},{3,4,11},{1,7,13},{1,7,11},{4,7,11},{4,7,8},{1,5,13},{1,5,9},{3,6,12},{3,6,9},{5,6,10},{5,6,9},{0,4,12},{0,4,8},{6,10,12},{0,10,12},{7,8,13},{2,8,13},{2,5,13},{2,5,10},{0,2,10},{0,2,8}}},

{214,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{3,4,12},{3,4,11},{1,7,13},{1,7,11},{4,7,11},{4,7,8},{1,5,13},{1,5,9},{3,6,12},{3,6,9},{5,6,10},{5,6,9},{0,4,12},{0,4,8},{6,10,12},{0,10,12},{2,7,13},{2,7,8},{2,5,13},{2,5,10},{0,2,10},{0,2,8}}},

{215,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{3,4,12},{3,4,11},{1,7,13},{1,7,11},{4,7,11},{4,7,8},{1,5,13},{1,5,9},{3,6,12},{3,6,9},{5,6,10},{5,6,9},{0,4,12},{0,4,8},{0,6,12},{0,6,10},{2,7,13},{2,7,8},{2,5,13},{2,5,10},{2,8,10},{0,8,10}}},

{216,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{3,9,11},{1,9,11},{3,4,12},{3,4,11},{1,7,13},{1,7,11},{4,7,11},{4,7,8},{1,5,13},{1,5,9},{3,6,12},{3,6,9},{5,6,10},{5,6,9},{0,4,12},{0,4,8},{0,6,12},{0,6,10},{2,7,13},{2,7,8},{2,5,13},{2,5,10},{0,2,10},{0,2,8}}},

{217,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,3,11},{1,3,9},{3,4,12},{3,4,11},{1,7,13},{1,7,11},{4,7,11},{4,7,8},{1,5,13},{1,5,9},{3,6,12},{3,6,9},{5,6,10},{5,6,9},{0,4,12},{0,4,8},{0,6,12},{0,6,10},{2,7,13},{2,7,8},{2,5,13},{2,5,10},{0,2,10},{0,2,8}}},

};

