--
-- Copyright 2025 The Android Open Source Project
--
-- Licensed under the Apache License, Version 2.0 (the "License");
-- you may not use this file except in compliance with the License.
-- You may obtain a copy of the License at
--
--     https://www.apache.org/licenses/LICENSE-2.0
--
-- Unless required by applicable law or agreed to in writing, software
-- distributed under the License is distributed on an "AS IS" BASIS,
-- WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
-- See the License for the specific language governing permissions and
-- limitations under the License.

INCLUDE PERFETTO MODULE wattson.utils;

CREATE PERFETTO TABLE _tg5_l3_lut AS
WITH
  data(device, freq_khz, dep_policy, dep_freq, l3_hit, l3_miss) AS (
    SELECT
      *
    FROM (VALUES
      ("Tensor G5", 268000, _dsu_dep!(), 115000000, 0.1096, 0.1484),
      ("Tensor G5", 268000, _dsu_dep!(), 268000000, 0.1603, 0.15),
      ("Tensor G5", 268000, _dsu_dep!(), 400000000, 0.1088, 0.1989),
      ("Tensor G5", 268000, _dsu_dep!(), 537000000, 0.1495, 0.1862),
      ("Tensor G5", 268000, _dsu_dep!(), 691000000, 0.1491, 0.1763),
      ("Tensor G5", 268000, _dsu_dep!(), 768000000, 0.1586, 0.1999),
      ("Tensor G5", 268000, _dsu_dep!(), 844000000, 0.1495, 6.8313),
      ("Tensor G5", 268000, _dsu_dep!(), 960000000, 0.1513, 0.2175),
      ("Tensor G5", 268000, _dsu_dep!(), 1056000000, 0.1767, 0.2546),
      ("Tensor G5", 268000, _dsu_dep!(), 1132000000, 0.1893, 0.3096),
      ("Tensor G5", 268000, _dsu_dep!(), 1228000000, 0.1963, 0.4018),
      ("Tensor G5", 268000, _dsu_dep!(), 1324000000, 0.2142, 22.534),
      ("Tensor G5", 268000, _dsu_dep!(), 1420000000, 0.1716, 0.3265),
      ("Tensor G5", 268000, _dsu_dep!(), 1516000000, 0.1727, 0.4936),
      ("Tensor G5", 268000, _dsu_dep!(), 1612000000, 0.2809, 0.3208),
      ("Tensor G5", 268000, _dsu_dep!(), 1728000000, 0.2871, 0.3911),
      ("Tensor G5", 268000, _dsu_dep!(), 1843000000, 0.3139, 0.4534),
      ("Tensor G5", 268000, _dsu_dep!(), 1920000000, 0.3256, 0.5752),
      ("Tensor G5", 268000, _dsu_dep!(), 1996000000, 0.3684, 0.9744),
      ("Tensor G5", 268000, _dsu_dep!(), 2092000000, 0.2165, 0.7048),
      ("Tensor G5", 268000, _dsu_dep!(), 2188000000, 0.2103, 0.8444),
      ("Tensor G5", 345000, _dsu_dep!(), 115000000, 0.1522, 0.195),
      ("Tensor G5", 345000, _dsu_dep!(), 268000000, 0.2311, 0.1862),
      ("Tensor G5", 345000, _dsu_dep!(), 400000000, 0.1207, 0.1636),
      ("Tensor G5", 345000, _dsu_dep!(), 537000000, 0.1273, 0.1573),
      ("Tensor G5", 345000, _dsu_dep!(), 691000000, 0.1184, 0.2618),
      ("Tensor G5", 345000, _dsu_dep!(), 768000000, 0.142, 0.2482),
      ("Tensor G5", 345000, _dsu_dep!(), 844000000, 0.1446, 0.2664),
      ("Tensor G5", 345000, _dsu_dep!(), 960000000, 0.1687, 0.2662),
      ("Tensor G5", 345000, _dsu_dep!(), 1056000000, 0.1709, 0.2462),
      ("Tensor G5", 345000, _dsu_dep!(), 1132000000, 0.1808, 0.3296),
      ("Tensor G5", 345000, _dsu_dep!(), 1228000000, 0.2105, 0.4074),
      ("Tensor G5", 345000, _dsu_dep!(), 1324000000, 0.2069, 0.3526),
      ("Tensor G5", 345000, _dsu_dep!(), 1420000000, 0.2409, 0.2047),
      ("Tensor G5", 345000, _dsu_dep!(), 1516000000, 0.2518, 0.4096),
      ("Tensor G5", 345000, _dsu_dep!(), 1612000000, 0.2511, 0.4804),
      ("Tensor G5", 345000, _dsu_dep!(), 1728000000, 0.2823, 0.4971),
      ("Tensor G5", 345000, _dsu_dep!(), 1843000000, 0.2927, 0.5702),
      ("Tensor G5", 345000, _dsu_dep!(), 1920000000, 0.2052, 0.4422),
      ("Tensor G5", 345000, _dsu_dep!(), 1996000000, 0.4153, 0.3802),
      ("Tensor G5", 345000, _dsu_dep!(), 2092000000, 0.3097, 0.5162),
      ("Tensor G5", 345000, _dsu_dep!(), 2188000000, 0.5075, 0.7948),
      ("Tensor G5", 422000, _dsu_dep!(), 115000000, 0.1601, 0.1432),
      ("Tensor G5", 422000, _dsu_dep!(), 268000000, 0.166, 0.1341),
      ("Tensor G5", 422000, _dsu_dep!(), 400000000, 0.1538, 0.1711),
      ("Tensor G5", 422000, _dsu_dep!(), 537000000, 0.1179, 0.2207),
      ("Tensor G5", 422000, _dsu_dep!(), 691000000, 0.1304, 0.1672),
      ("Tensor G5", 422000, _dsu_dep!(), 768000000, 0.1588, 0.2404),
      ("Tensor G5", 422000, _dsu_dep!(), 844000000, 0.1435, 0.2624),
      ("Tensor G5", 422000, _dsu_dep!(), 960000000, 0.1502, 0.3262),
      ("Tensor G5", 422000, _dsu_dep!(), 1056000000, 0.1573, 0.2803),
      ("Tensor G5", 422000, _dsu_dep!(), 1132000000, 0.0958, 0.386),
      ("Tensor G5", 422000, _dsu_dep!(), 1228000000, 0.1969, 0.2835),
      ("Tensor G5", 422000, _dsu_dep!(), 1324000000, 0.1636, 0.3339),
      ("Tensor G5", 422000, _dsu_dep!(), 1420000000, 0.2266, 0.2891),
      ("Tensor G5", 422000, _dsu_dep!(), 1516000000, 0.2091, 0.4236),
      ("Tensor G5", 422000, _dsu_dep!(), 1612000000, 0.2490, 0.3549),
      ("Tensor G5", 422000, _dsu_dep!(), 1728000000, 0.3082, 0.3632),
      ("Tensor G5", 422000, _dsu_dep!(), 1843000000, 0.3012, 0.3561),
      ("Tensor G5", 422000, _dsu_dep!(), 1920000000, 0.1777, 0.5647),
      ("Tensor G5", 422000, _dsu_dep!(), 1996000000, 0.3266, 0.43),
      ("Tensor G5", 422000, _dsu_dep!(), 2092000000, 0.454, 0.6733),
      ("Tensor G5", 422000, _dsu_dep!(), 2188000000, 0.4805, 0.6816),
      ("Tensor G5", 460000, _dsu_dep!(), 115000000, 0.1651, 0.204),
      ("Tensor G5", 460000, _dsu_dep!(), 268000000, 0.1438, 0.1276),
      ("Tensor G5", 460000, _dsu_dep!(), 400000000, 0.1075, 0.1939),
      ("Tensor G5", 460000, _dsu_dep!(), 537000000, 0.1261, 0.1285),
      ("Tensor G5", 460000, _dsu_dep!(), 691000000, 0.1256, 0.2624),
      ("Tensor G5", 460000, _dsu_dep!(), 768000000, 0.1384, 0.204),
      ("Tensor G5", 460000, _dsu_dep!(), 844000000, 0.1257, 0.2887),
      ("Tensor G5", 460000, _dsu_dep!(), 960000000, 0.153, 0.245),
      ("Tensor G5", 460000, _dsu_dep!(), 1056000000, 0.1455, 0.3272),
      ("Tensor G5", 460000, _dsu_dep!(), 1132000000, 0.1422, 0.4246),
      ("Tensor G5", 460000, _dsu_dep!(), 1228000000, 0.1987, 0.3256),
      ("Tensor G5", 460000, _dsu_dep!(), 1324000000, 0.22, 0.3311),
      ("Tensor G5", 460000, _dsu_dep!(), 1420000000, 0.2231, 0.3838),
      ("Tensor G5", 460000, _dsu_dep!(), 1516000000, 0.2031, 0.3308),
      ("Tensor G5", 460000, _dsu_dep!(), 1612000000, 0.2589, 0.4011),
      ("Tensor G5", 460000, _dsu_dep!(), 1728000000, 0.3040, 0.3885),
      ("Tensor G5", 460000, _dsu_dep!(), 1843000000, 0.3109, 0.3531),
      ("Tensor G5", 460000, _dsu_dep!(), 1920000000, 0.3399, 0.4649),
      ("Tensor G5", 460000, _dsu_dep!(), 1996000000, 0.337, 0.4433),
      ("Tensor G5", 460000, _dsu_dep!(), 2092000000, 0.4644, 0.4299),
      ("Tensor G5", 460000, _dsu_dep!(), 2188000000, 0.5037, 0.4928),
      ("Tensor G5", 533000, _dsu_dep!(), 115000000, 0.1575, 0.1441),
      ("Tensor G5", 533000, _dsu_dep!(), 268000000, 0.1462, 0.1353),
      ("Tensor G5", 533000, _dsu_dep!(), 400000000, 0.1451, 0.1754),
      ("Tensor G5", 533000, _dsu_dep!(), 537000000, 0.1875, 6.2512),
      ("Tensor G5", 533000, _dsu_dep!(), 691000000, 0.1315, 0.1762),
      ("Tensor G5", 533000, _dsu_dep!(), 768000000, 0.1412, 0.3602),
      ("Tensor G5", 533000, _dsu_dep!(), 844000000, 0.1767, 0.2519),
      ("Tensor G5", 533000, _dsu_dep!(), 960000000, 0.1543, 0.3237),
      ("Tensor G5", 533000, _dsu_dep!(), 1056000000, 0.1698, 0.3625),
      ("Tensor G5", 533000, _dsu_dep!(), 1132000000, 0.1917, 0.3437),
      ("Tensor G5", 533000, _dsu_dep!(), 1228000000, 0.2033, 0.2077),
      ("Tensor G5", 533000, _dsu_dep!(), 1324000000, 0.2092, 0.377),
      ("Tensor G5", 533000, _dsu_dep!(), 1420000000, 0.1063, 0.4008),
      ("Tensor G5", 533000, _dsu_dep!(), 1516000000, 0.2536, 0.4216),
      ("Tensor G5", 533000, _dsu_dep!(), 1612000000, 0.2602, 0.2967),
      ("Tensor G5", 533000, _dsu_dep!(), 1728000000, 0.3103, 0.2283),
      ("Tensor G5", 533000, _dsu_dep!(), 1843000000, 0.2857, 0.4644),
      ("Tensor G5", 533000, _dsu_dep!(), 1920000000, 0.3088, 0.4967),
      ("Tensor G5", 533000, _dsu_dep!(), 1996000000, 0.266, 0.4850),
      ("Tensor G5", 533000, _dsu_dep!(), 2092000000, 0.4351, 0.7022),
      ("Tensor G5", 533000, _dsu_dep!(), 2188000000, 0.4447, 0.4921),
      ("Tensor G5", 729000, _dsu_dep!(), 115000000, 0.2143, 0.1696),
      ("Tensor G5", 729000, _dsu_dep!(), 268000000, 0.1731, 0.1759),
      ("Tensor G5", 729000, _dsu_dep!(), 400000000, 0.1494, 0.196),
      ("Tensor G5", 729000, _dsu_dep!(), 537000000, 0.14, 0.2668),
      ("Tensor G5", 729000, _dsu_dep!(), 691000000, 0.1472, 0.2284),
      ("Tensor G5", 729000, _dsu_dep!(), 768000000, 0.1319, 0.262),
      ("Tensor G5", 729000, _dsu_dep!(), 844000000, 0.1354, 0.3745),
      ("Tensor G5", 729000, _dsu_dep!(), 960000000, 0.1384, 0.3165),
      ("Tensor G5", 729000, _dsu_dep!(), 1056000000, 0.1647, 0.3725),
      ("Tensor G5", 729000, _dsu_dep!(), 1132000000, 0.1996, 0.33),
      ("Tensor G5", 729000, _dsu_dep!(), 1228000000, 0.1985, 0.2897),
      ("Tensor G5", 729000, _dsu_dep!(), 1324000000, 0.215, 0.2930),
      ("Tensor G5", 729000, _dsu_dep!(), 1420000000, 0.2036, 0.2291),
      ("Tensor G5", 729000, _dsu_dep!(), 1516000000, 0.2385, 0.3767),
      ("Tensor G5", 729000, _dsu_dep!(), 1612000000, 0.2523, 0.4113),
      ("Tensor G5", 729000, _dsu_dep!(), 1728000000, 0.2945, 0.2853),
      ("Tensor G5", 729000, _dsu_dep!(), 1843000000, 0.3399, 0.4153),
      ("Tensor G5", 729000, _dsu_dep!(), 1920000000, 0.3445, 0.4327),
      ("Tensor G5", 729000, _dsu_dep!(), 1996000000, 0.1737, 0.5003),
      ("Tensor G5", 729000, _dsu_dep!(), 2092000000, 0.4652, 0.5378),
      ("Tensor G5", 729000, _dsu_dep!(), 2188000000, 0.4582, 0.6071),
      ("Tensor G5", 883000, _dsu_dep!(), 115000000, 0.202, 0.2491),
      ("Tensor G5", 883000, _dsu_dep!(), 268000000, 0.1966, 0.1789),
      ("Tensor G5", 883000, _dsu_dep!(), 400000000, 0.1675, 0.1921),
      ("Tensor G5", 883000, _dsu_dep!(), 537000000, 0.1349, 0.2125),
      ("Tensor G5", 883000, _dsu_dep!(), 691000000, 0.1623, 0.2692),
      ("Tensor G5", 883000, _dsu_dep!(), 768000000, 0.1659, 0.1773),
      ("Tensor G5", 883000, _dsu_dep!(), 844000000, 0.1258, 0.2663),
      ("Tensor G5", 883000, _dsu_dep!(), 960000000, 0.1843, 0.2412),
      ("Tensor G5", 883000, _dsu_dep!(), 1056000000, 0.2039, 0.2743),
      ("Tensor G5", 883000, _dsu_dep!(), 1132000000, 0.0848, 0.4186),
      ("Tensor G5", 883000, _dsu_dep!(), 1228000000, 0.1583, 0.2785),
      ("Tensor G5", 883000, _dsu_dep!(), 1324000000, 0.2235, 0.1911),
      ("Tensor G5", 883000, _dsu_dep!(), 1420000000, 0.2303, 0.3561),
      ("Tensor G5", 883000, _dsu_dep!(), 1516000000, 0.195, 0.3763),
      ("Tensor G5", 883000, _dsu_dep!(), 1612000000, 0.2839, 0.3873),
      ("Tensor G5", 883000, _dsu_dep!(), 1728000000, 0.2971, 0.5389),
      ("Tensor G5", 883000, _dsu_dep!(), 1843000000, 0.1643, 0.7782),
      ("Tensor G5", 883000, _dsu_dep!(), 1920000000, 0.3829, 0.4392),
      ("Tensor G5", 883000, _dsu_dep!(), 1996000000, 0.39, 0.376),
      ("Tensor G5", 883000, _dsu_dep!(), 2092000000, 0.4458, 0.5296),
      ("Tensor G5", 883000, _dsu_dep!(), 2188000000, 0.4588, 0.4416),
      ("Tensor G5", 1036000, _dsu_dep!(), 115000000, 0.2181, 0.1638),
      ("Tensor G5", 1036000, _dsu_dep!(), 268000000, 0.2075, 0.1466),
      ("Tensor G5", 1036000, _dsu_dep!(), 400000000, 0.1804, 0.2125),
      ("Tensor G5", 1036000, _dsu_dep!(), 537000000, 0.1559, 0.1926),
      ("Tensor G5", 1036000, _dsu_dep!(), 691000000, 0.155, 0.2547),
      ("Tensor G5", 1036000, _dsu_dep!(), 768000000, 0.123, 0.5322),
      ("Tensor G5", 1036000, _dsu_dep!(), 844000000, 0.1474, 0.2743),
      ("Tensor G5", 1036000, _dsu_dep!(), 960000000, 0.1687, 0.2686),
      ("Tensor G5", 1036000, _dsu_dep!(), 1056000000, 0.182, 0.3021),
      ("Tensor G5", 1036000, _dsu_dep!(), 1132000000, 0.1840, 0.2234),
      ("Tensor G5", 1036000, _dsu_dep!(), 1228000000, 0.1698, 0.2769),
      ("Tensor G5", 1036000, _dsu_dep!(), 1324000000, 0.1056, 0.337),
      ("Tensor G5", 1036000, _dsu_dep!(), 1420000000, 0.2004, 0.3431),
      ("Tensor G5", 1036000, _dsu_dep!(), 1516000000, 0.2392, 0.3476),
      ("Tensor G5", 1036000, _dsu_dep!(), 1612000000, 0.27, 0.35),
      ("Tensor G5", 1036000, _dsu_dep!(), 1728000000, 0.2964, 0.3646),
      ("Tensor G5", 1036000, _dsu_dep!(), 1843000000, 0.2966, 0.3378),
      ("Tensor G5", 1036000, _dsu_dep!(), 1920000000, 0.3823, 0.5215),
      ("Tensor G5", 1036000, _dsu_dep!(), 1996000000, 0.3764, 0.6542),
      ("Tensor G5", 1036000, _dsu_dep!(), 2092000000, 0.3531, 0.8952),
      ("Tensor G5", 1036000, _dsu_dep!(), 2188000000, 0.5176, 0.3729),
      ("Tensor G5", 1190000, _dsu_dep!(), 115000000, 0.21, 0.3403),
      ("Tensor G5", 1190000, _dsu_dep!(), 268000000, 0.1794, 0.2271),
      ("Tensor G5", 1190000, _dsu_dep!(), 400000000, 0.1604, 0.2157),
      ("Tensor G5", 1190000, _dsu_dep!(), 537000000, 0.1828, 0.1426),
      ("Tensor G5", 1190000, _dsu_dep!(), 691000000, 0.1673, 0.1555),
      ("Tensor G5", 1190000, _dsu_dep!(), 768000000, 0.1654, 0.2941),
      ("Tensor G5", 1190000, _dsu_dep!(), 844000000, 0.1618, 0.2666),
      ("Tensor G5", 1190000, _dsu_dep!(), 960000000, 0.1752, 0.1551),
      ("Tensor G5", 1190000, _dsu_dep!(), 1056000000, 0.1868, 0.298),
      ("Tensor G5", 1190000, _dsu_dep!(), 1132000000, 0.1857, 0.2223),
      ("Tensor G5", 1190000, _dsu_dep!(), 1228000000, 0.2031, 0.2645),
      ("Tensor G5", 1190000, _dsu_dep!(), 1324000000, 0.1763, 0.3173),
      ("Tensor G5", 1190000, _dsu_dep!(), 1420000000, 0.2207, 0.3266),
      ("Tensor G5", 1190000, _dsu_dep!(), 1516000000, 0.2105, 0.319),
      ("Tensor G5", 1190000, _dsu_dep!(), 1612000000, 0.2854, 0.2594),
      ("Tensor G5", 1190000, _dsu_dep!(), 1728000000, 0.3071, 0.3061),
      ("Tensor G5", 1190000, _dsu_dep!(), 1843000000, 0.3332, 0.2915),
      ("Tensor G5", 1190000, _dsu_dep!(), 1920000000, 0.3649, 0.4683),
      ("Tensor G5", 1190000, _dsu_dep!(), 1996000000, 0.3586, 0.3071),
      ("Tensor G5", 1190000, _dsu_dep!(), 2092000000, 0.4528, 0.4337),
      ("Tensor G5", 1190000, _dsu_dep!(), 2188000000, 0.2092, 1.0424),
      ("Tensor G5", 1286000, _dsu_dep!(), 115000000, 0.0932, 0.3813),
      ("Tensor G5", 1286000, _dsu_dep!(), 268000000, 0.2062, 0.2542),
      ("Tensor G5", 1286000, _dsu_dep!(), 400000000, 0.1953, 0.1992),
      ("Tensor G5", 1286000, _dsu_dep!(), 537000000, 0.0601, 0.3414),
      ("Tensor G5", 1286000, _dsu_dep!(), 691000000, 0.1871, 0.2674),
      ("Tensor G5", 1286000, _dsu_dep!(), 768000000, 0.1766, 0.3547),
      ("Tensor G5", 1286000, _dsu_dep!(), 844000000, 0.2322, 0.3326),
      ("Tensor G5", 1286000, _dsu_dep!(), 960000000, 0.1820, 0.1999),
      ("Tensor G5", 1286000, _dsu_dep!(), 1056000000, 0.1629, 0.2539),
      ("Tensor G5", 1286000, _dsu_dep!(), 1132000000, 0.1895, 0.2977),
      ("Tensor G5", 1286000, _dsu_dep!(), 1228000000, 0.2067, 0.3987),
      ("Tensor G5", 1286000, _dsu_dep!(), 1324000000, -0.142, -0.052),
      ("Tensor G5", 1286000, _dsu_dep!(), 1420000000, 0.1138, 0.1704),
      ("Tensor G5", 1286000, _dsu_dep!(), 1516000000, 0.0424, 0.0779),
      ("Tensor G5", 1286000, _dsu_dep!(), 1612000000, 0.0301, 0.1918),
      ("Tensor G5", 1286000, _dsu_dep!(), 1728000000, -0.015, 0.0857),
      ("Tensor G5", 1286000, _dsu_dep!(), 1843000000, 0.3095, 0.5025),
      ("Tensor G5", 1286000, _dsu_dep!(), 1920000000, 0.3982, 0.4315),
      ("Tensor G5", 1286000, _dsu_dep!(), 1996000000, 0.4114, 0.5939),
      ("Tensor G5", 1286000, _dsu_dep!(), 2092000000, 0.4539, 0.5138),
      ("Tensor G5", 1286000, _dsu_dep!(), 2188000000, 0.4886, 0.5855),
      ("Tensor G5", 1363000, _dsu_dep!(), 115000000, 0.1114, 0.4418),
      ("Tensor G5", 1363000, _dsu_dep!(), 268000000, 0.1823, 0.1804),
      ("Tensor G5", 1363000, _dsu_dep!(), 400000000, 0.1981, 0.2165),
      ("Tensor G5", 1363000, _dsu_dep!(), 537000000, 0.1669, 0.2468),
      ("Tensor G5", 1363000, _dsu_dep!(), 691000000, 0.1898, 0.2182),
      ("Tensor G5", 1363000, _dsu_dep!(), 768000000, 0.1881, 0.3358),
      ("Tensor G5", 1363000, _dsu_dep!(), 844000000, 0.2157, 0.3614),
      ("Tensor G5", 1363000, _dsu_dep!(), 960000000, 0.1548, 0.2503),
      ("Tensor G5", 1363000, _dsu_dep!(), 1056000000, 0.1978, 0.3034),
      ("Tensor G5", 1363000, _dsu_dep!(), 1132000000, 0.1899, 0.2391),
      ("Tensor G5", 1363000, _dsu_dep!(), 1228000000, 0.2054, 0.2715),
      ("Tensor G5", 1363000, _dsu_dep!(), 1324000000, 0.2168, 0.2990),
      ("Tensor G5", 1363000, _dsu_dep!(), 1420000000, 0.2279, 0.2975),
      ("Tensor G5", 1363000, _dsu_dep!(), 1516000000, 0.2527, 0.3),
      ("Tensor G5", 1363000, _dsu_dep!(), 1612000000, 0.2979, 0.3576),
      ("Tensor G5", 1363000, _dsu_dep!(), 1728000000, 0.3251, 0.4953),
      ("Tensor G5", 1363000, _dsu_dep!(), 1843000000, 0.263, 0.3917),
      ("Tensor G5", 1363000, _dsu_dep!(), 1920000000, 0.3323, 0.479),
      ("Tensor G5", 1363000, _dsu_dep!(), 1996000000, 0.4094, 0.4462),
      ("Tensor G5", 1363000, _dsu_dep!(), 2092000000, 0.4005, 0.5543),
      ("Tensor G5", 1363000, _dsu_dep!(), 2188000000, 0.4513, 0.3705),
      ("Tensor G5", 1459000, _dsu_dep!(), 115000000, 0.1204, 0.3199),
      ("Tensor G5", 1459000, _dsu_dep!(), 268000000, 0.2152, 0.254),
      ("Tensor G5", 1459000, _dsu_dep!(), 400000000, 0.1929, 0.2961),
      ("Tensor G5", 1459000, _dsu_dep!(), 537000000, 0.1773, 0.2965),
      ("Tensor G5", 1459000, _dsu_dep!(), 691000000, 0.1847, 0.2885),
      ("Tensor G5", 1459000, _dsu_dep!(), 768000000, 0.1551, 0.1883),
      ("Tensor G5", 1459000, _dsu_dep!(), 844000000, 0.1946, 0.3561),
      ("Tensor G5", 1459000, _dsu_dep!(), 960000000, 0.1889, 0.3829),
      ("Tensor G5", 1459000, _dsu_dep!(), 1056000000, 0.1423, 0.3766),
      ("Tensor G5", 1459000, _dsu_dep!(), 1132000000, 0.2002, 0.2371),
      ("Tensor G5", 1459000, _dsu_dep!(), 1228000000, 0.216, 0.3038),
      ("Tensor G5", 1459000, _dsu_dep!(), 1324000000, 0.1485, 0.3341),
      ("Tensor G5", 1459000, _dsu_dep!(), 1420000000, 0.1596, 0.3352),
      ("Tensor G5", 1459000, _dsu_dep!(), 1516000000, 0.2406, 0.3815),
      ("Tensor G5", 1459000, _dsu_dep!(), 1612000000, 0.2214, 0.3719),
      ("Tensor G5", 1459000, _dsu_dep!(), 1728000000, 0.3056, 0.3596),
      ("Tensor G5", 1459000, _dsu_dep!(), 1843000000, 0.3325, 0.4306),
      ("Tensor G5", 1459000, _dsu_dep!(), 1920000000, 0.3375, 0.6518),
      ("Tensor G5", 1459000, _dsu_dep!(), 1996000000, 0.3969, 0.4834),
      ("Tensor G5", 1459000, _dsu_dep!(), 2092000000, 0.3996, 0.4151),
      ("Tensor G5", 1459000, _dsu_dep!(), 2188000000, 0.3327, 1.0129),
      ("Tensor G5", 1555000, _dsu_dep!(), 115000000, 0.1470, 0.4342),
      ("Tensor G5", 1555000, _dsu_dep!(), 268000000, 0.22, 0.2744),
      ("Tensor G5", 1555000, _dsu_dep!(), 400000000, 0.2428, 0.2656),
      ("Tensor G5", 1555000, _dsu_dep!(), 537000000, 0.2055, 0.2905),
      ("Tensor G5", 1555000, _dsu_dep!(), 691000000, 0.2016, 0.5079),
      ("Tensor G5", 1555000, _dsu_dep!(), 768000000, 0.1805, 0.3647),
      ("Tensor G5", 1555000, _dsu_dep!(), 844000000, 0.1886, 0.3669),
      ("Tensor G5", 1555000, _dsu_dep!(), 960000000, 0.1651, 0.3832),
      ("Tensor G5", 1555000, _dsu_dep!(), 1056000000, 0.2096, 0.3302),
      ("Tensor G5", 1555000, _dsu_dep!(), 1132000000, 0.2284, 0.3751),
      ("Tensor G5", 1555000, _dsu_dep!(), 1228000000, 0.1713, 0.3956),
      ("Tensor G5", 1555000, _dsu_dep!(), 1324000000, 0.2307, 0.3587),
      ("Tensor G5", 1555000, _dsu_dep!(), 1420000000, 0.2276, 0.396),
      ("Tensor G5", 1555000, _dsu_dep!(), 1516000000, 0.251, 0.2996),
      ("Tensor G5", 1555000, _dsu_dep!(), 1612000000, 0.2231, 0.5059),
      ("Tensor G5", 1555000, _dsu_dep!(), 1728000000, 0.2933, 0.5490),
      ("Tensor G5", 1555000, _dsu_dep!(), 1843000000, 0.3412, 0.4248),
      ("Tensor G5", 1555000, _dsu_dep!(), 1920000000, 0.3772, 0.2708),
      ("Tensor G5", 1555000, _dsu_dep!(), 1996000000, 0.3805, 0.4879),
      ("Tensor G5", 1555000, _dsu_dep!(), 2092000000, 0.3814, 0.713),
      ("Tensor G5", 1555000, _dsu_dep!(), 2188000000, 0.3337, 0.6041),
      ("Tensor G5", 1632000, _dsu_dep!(), 115000000, 0.2124, 0.4291),
      ("Tensor G5", 1632000, _dsu_dep!(), 268000000, 0.2329, 0.2808),
      ("Tensor G5", 1632000, _dsu_dep!(), 400000000, 0.2324, 0.2568),
      ("Tensor G5", 1632000, _dsu_dep!(), 537000000, 0.2115, 11.699),
      ("Tensor G5", 1632000, _dsu_dep!(), 691000000, 0.2033, 0.2900),
      ("Tensor G5", 1632000, _dsu_dep!(), 768000000, 0.2163, 0.3491),
      ("Tensor G5", 1632000, _dsu_dep!(), 844000000, 0.2236, 0.3558),
      ("Tensor G5", 1632000, _dsu_dep!(), 960000000, 0.1695, 0.3829),
      ("Tensor G5", 1632000, _dsu_dep!(), 1056000000, 0.2267, 0.3246),
      ("Tensor G5", 1632000, _dsu_dep!(), 1132000000, 0.2215, 0.3009),
      ("Tensor G5", 1632000, _dsu_dep!(), 1228000000, 0.1996, 0.3095),
      ("Tensor G5", 1632000, _dsu_dep!(), 1324000000, 0.1971, 0.4314),
      ("Tensor G5", 1632000, _dsu_dep!(), 1420000000, 0.2359, 0.3931),
      ("Tensor G5", 1632000, _dsu_dep!(), 1516000000, 0.1146, 0.3732),
      ("Tensor G5", 1632000, _dsu_dep!(), 1612000000, 0.2656, 0.2729),
      ("Tensor G5", 1632000, _dsu_dep!(), 1728000000, 0.2861, 0.2673),
      ("Tensor G5", 1632000, _dsu_dep!(), 1843000000, 0.346, 0.5312),
      ("Tensor G5", 1632000, _dsu_dep!(), 1920000000, 0.1896, 0.6942),
      ("Tensor G5", 1632000, _dsu_dep!(), 1996000000, 0.3400, 0.5261),
      ("Tensor G5", 1632000, _dsu_dep!(), 2092000000, 0.435, 0.6862),
      ("Tensor G5", 1632000, _dsu_dep!(), 2188000000, 0.4348, 0.8778),
      ("Tensor G5", 1766000, _dsu_dep!(), 115000000, 0.2871, 0.3695),
      ("Tensor G5", 1766000, _dsu_dep!(), 268000000, 0.2682, 0.2392),
      ("Tensor G5", 1766000, _dsu_dep!(), 400000000, 0.2186, 0.3338),
      ("Tensor G5", 1766000, _dsu_dep!(), 537000000, 0.2624, 0.3108),
      ("Tensor G5", 1766000, _dsu_dep!(), 691000000, 0.2267, 0.3222),
      ("Tensor G5", 1766000, _dsu_dep!(), 768000000, 0.2107, 0.4472),
      ("Tensor G5", 1766000, _dsu_dep!(), 844000000, 0.2129, 0.3108),
      ("Tensor G5", 1766000, _dsu_dep!(), 960000000, 0.2445, 0.3611),
      ("Tensor G5", 1766000, _dsu_dep!(), 1056000000, 0.1073, 0.4906),
      ("Tensor G5", 1766000, _dsu_dep!(), 1132000000, 0.2468, 0.4093),
      ("Tensor G5", 1766000, _dsu_dep!(), 1228000000, 0.2264, 0.4356),
      ("Tensor G5", 1766000, _dsu_dep!(), 1324000000, 0.1714, 0.3935),
      ("Tensor G5", 1766000, _dsu_dep!(), 1420000000, 0.2524, 0.3091),
      ("Tensor G5", 1766000, _dsu_dep!(), 1516000000, 0.2651, 0.4433),
      ("Tensor G5", 1766000, _dsu_dep!(), 1612000000, 0.2093, 0.733),
      ("Tensor G5", 1766000, _dsu_dep!(), 1728000000, 0.2913, 0.3617),
      ("Tensor G5", 1766000, _dsu_dep!(), 1843000000, 0.3608, 0.5116),
      ("Tensor G5", 1766000, _dsu_dep!(), 1920000000, 0.2915, 0.4919),
      ("Tensor G5", 1766000, _dsu_dep!(), 1996000000, 0.3513, 0.2989),
      ("Tensor G5", 1766000, _dsu_dep!(), 2092000000, 0.4145, 0.7738),
      ("Tensor G5", 1766000, _dsu_dep!(), 2188000000, 0.2372, 0.6006),
      ("Tensor G5", 1881000, _dsu_dep!(), 115000000, 0.3476, 0.4273),
      ("Tensor G5", 1881000, _dsu_dep!(), 268000000, 0.2761, 0.318),
      ("Tensor G5", 1881000, _dsu_dep!(), 400000000, 0.24, 0.3145),
      ("Tensor G5", 1881000, _dsu_dep!(), 537000000, 0.262, 0.3373),
      ("Tensor G5", 1881000, _dsu_dep!(), 691000000, 0.2807, 0.3893),
      ("Tensor G5", 1881000, _dsu_dep!(), 768000000, 0.2221, 0.4449),
      ("Tensor G5", 1881000, _dsu_dep!(), 844000000, 0.2055, 0.4472),
      ("Tensor G5", 1881000, _dsu_dep!(), 960000000, 0.2511, 0.3165),
      ("Tensor G5", 1881000, _dsu_dep!(), 1056000000, 0.2469, 0.2483),
      ("Tensor G5", 1881000, _dsu_dep!(), 1132000000, 0.2491, 0.4923),
      ("Tensor G5", 1881000, _dsu_dep!(), 1228000000, 0.2519, 0.3244),
      ("Tensor G5", 1881000, _dsu_dep!(), 1324000000, 0.2676, 0.5411),
      ("Tensor G5", 1881000, _dsu_dep!(), 1420000000, 0.2641, 0.2735),
      ("Tensor G5", 1881000, _dsu_dep!(), 1516000000, 0.2393, 0.3807),
      ("Tensor G5", 1881000, _dsu_dep!(), 1612000000, 0.2311, 0.5302),
      ("Tensor G5", 1881000, _dsu_dep!(), 1728000000, 0.2256, 0.3213),
      ("Tensor G5", 1881000, _dsu_dep!(), 1843000000, 0.2789, 0.4710),
      ("Tensor G5", 1881000, _dsu_dep!(), 1920000000, 0.3497, 0.4614),
      ("Tensor G5", 1881000, _dsu_dep!(), 1996000000, 0.3088, 0.6546),
      ("Tensor G5", 1881000, _dsu_dep!(), 2092000000, 0.4274, 0.7133),
      ("Tensor G5", 1881000, _dsu_dep!(), 2188000000, 0.4428, 0.8129),
      ("Tensor G5", 1996000, _dsu_dep!(), 115000000, 0.3520, 0.3168),
      ("Tensor G5", 1996000, _dsu_dep!(), 268000000, 0.2607, 0.4108),
      ("Tensor G5", 1996000, _dsu_dep!(), 400000000, 0.2538, 0.3641),
      ("Tensor G5", 1996000, _dsu_dep!(), 537000000, 0.1820, 0.7486),
      ("Tensor G5", 1996000, _dsu_dep!(), 691000000, 0.2382, 0.4454),
      ("Tensor G5", 1996000, _dsu_dep!(), 768000000, 0.2328, 0.5745),
      ("Tensor G5", 1996000, _dsu_dep!(), 844000000, 0.2891, 0.4183),
      ("Tensor G5", 1996000, _dsu_dep!(), 960000000, 0.232, 0.3792),
      ("Tensor G5", 1996000, _dsu_dep!(), 1056000000, 0.2841, 0.4266),
      ("Tensor G5", 1996000, _dsu_dep!(), 1132000000, 0.2283, 0.5786),
      ("Tensor G5", 1996000, _dsu_dep!(), 1228000000, 0.1972, 0.4419),
      ("Tensor G5", 1996000, _dsu_dep!(), 1324000000, 0.1561, 0.4602),
      ("Tensor G5", 1996000, _dsu_dep!(), 1420000000, 0.3003, 0.4203),
      ("Tensor G5", 1996000, _dsu_dep!(), 1516000000, 0.3037, 0.4552),
      ("Tensor G5", 1996000, _dsu_dep!(), 1612000000, 0.218, 0.6278),
      ("Tensor G5", 1996000, _dsu_dep!(), 1728000000, 0.3288, 0.3823),
      ("Tensor G5", 1996000, _dsu_dep!(), 1843000000, 0.3427, 0.4182),
      ("Tensor G5", 1996000, _dsu_dep!(), 1920000000, 0.3808, 0.6083),
      ("Tensor G5", 1996000, _dsu_dep!(), 1996000000, 0.1738, 0.4082),
      ("Tensor G5", 1996000, _dsu_dep!(), 2092000000, 0.4273, 0.5363),
      ("Tensor G5", 1996000, _dsu_dep!(), 2188000000, 0.3972, 0.4524),
      ("Tensor G5", 2016000, _dsu_dep!(), 115000000, 0.2433, 0.447),
      ("Tensor G5", 2016000, _dsu_dep!(), 268000000, 0.2679, 0.3328),
      ("Tensor G5", 2016000, _dsu_dep!(), 400000000, 0.2983, 0.3725),
      ("Tensor G5", 2016000, _dsu_dep!(), 537000000, 0.3251, 0.3428),
      ("Tensor G5", 2016000, _dsu_dep!(), 691000000, 0.2804, 0.2545),
      ("Tensor G5", 2016000, _dsu_dep!(), 768000000, 0.2824, 0.5095),
      ("Tensor G5", 2016000, _dsu_dep!(), 844000000, 0.2517, 0.4909),
      ("Tensor G5", 2016000, _dsu_dep!(), 960000000, 0.2804, 0.3634),
      ("Tensor G5", 2016000, _dsu_dep!(), 1056000000, 0.2524, 0.3324),
      ("Tensor G5", 2016000, _dsu_dep!(), 1132000000, 0.2794, 0.3238),
      ("Tensor G5", 2016000, _dsu_dep!(), 1228000000, 0.2807, 0.3461),
      ("Tensor G5", 2016000, _dsu_dep!(), 1324000000, 0.2863, 0.5673),
      ("Tensor G5", 2016000, _dsu_dep!(), 1420000000, 0.3645, 0.3403),
      ("Tensor G5", 2016000, _dsu_dep!(), 1516000000, 0.245, 0.5254),
      ("Tensor G5", 2016000, _dsu_dep!(), 1612000000, 0.2309, 0.6037),
      ("Tensor G5", 2016000, _dsu_dep!(), 1728000000, 0.2668, 0.4946),
      ("Tensor G5", 2016000, _dsu_dep!(), 1843000000, 0.3026, 0.6272),
      ("Tensor G5", 2016000, _dsu_dep!(), 1920000000, 0.3879, 0.6073),
      ("Tensor G5", 2016000, _dsu_dep!(), 1996000000, 0.374, 0.4027),
      ("Tensor G5", 2016000, _dsu_dep!(), 2092000000, 0.4634, 0.5438),
      ("Tensor G5", 2016000, _dsu_dep!(), 2188000000, 0.4491, 0.7081),
      ("Tensor G5", 2054000, _dsu_dep!(), 115000000, 0.3228, 0.3829),
      ("Tensor G5", 2054000, _dsu_dep!(), 268000000, 0.2783, 0.3625),
      ("Tensor G5", 2054000, _dsu_dep!(), 400000000, 0.3147, 0.283),
      ("Tensor G5", 2054000, _dsu_dep!(), 537000000, 0.283, 0.4224),
      ("Tensor G5", 2054000, _dsu_dep!(), 691000000, 0.1618, 0.5269),
      ("Tensor G5", 2054000, _dsu_dep!(), 768000000, 0.2415, 0.4877),
      ("Tensor G5", 2054000, _dsu_dep!(), 844000000, 0.3019, 0.3428),
      ("Tensor G5", 2054000, _dsu_dep!(), 960000000, 0.2153, 0.4231),
      ("Tensor G5", 2054000, _dsu_dep!(), 1056000000, 0.2966, 0.4831),
      ("Tensor G5", 2054000, _dsu_dep!(), 1132000000, 0.309, 0.4705),
      ("Tensor G5", 2054000, _dsu_dep!(), 1228000000, 0.2889, 0.4501),
      ("Tensor G5", 2054000, _dsu_dep!(), 1324000000, 0.3135, 0.6828),
      ("Tensor G5", 2054000, _dsu_dep!(), 1420000000, 0.3409, 0.5490),
      ("Tensor G5", 2054000, _dsu_dep!(), 1516000000, 0.3153, 0.3259),
      ("Tensor G5", 2054000, _dsu_dep!(), 1612000000, 0.3197, 0.5847),
      ("Tensor G5", 2054000, _dsu_dep!(), 1728000000, 0.3186, 0.5825),
      ("Tensor G5", 2054000, _dsu_dep!(), 1843000000, 0.3456, 0.4538),
      ("Tensor G5", 2054000, _dsu_dep!(), 1920000000, 0.2944, 0.3929),
      ("Tensor G5", 2054000, _dsu_dep!(), 1996000000, 0.3575, 0.406),
      ("Tensor G5", 2054000, _dsu_dep!(), 2092000000, 0.4072, 0.8127),
      ("Tensor G5", 2054000, _dsu_dep!(), 2188000000, 0.4752, 0.5146),
      ("Tensor G5", 2092000, _dsu_dep!(), 115000000, 0.3096, 0.3571),
      ("Tensor G5", 2092000, _dsu_dep!(), 268000000, 0.3187, 0.4034),
      ("Tensor G5", 2092000, _dsu_dep!(), 400000000, 0.3196, 0.3981),
      ("Tensor G5", 2092000, _dsu_dep!(), 537000000, 0.3198, 0.3992),
      ("Tensor G5", 2092000, _dsu_dep!(), 691000000, 0.3077, 0.5161),
      ("Tensor G5", 2092000, _dsu_dep!(), 768000000, 0.2976, 0.4976),
      ("Tensor G5", 2092000, _dsu_dep!(), 844000000, 0.221, 0.5945),
      ("Tensor G5", 2092000, _dsu_dep!(), 960000000, 0.3047, 0.3559),
      ("Tensor G5", 2092000, _dsu_dep!(), 1056000000, 0.2080, 0.3991),
      ("Tensor G5", 2092000, _dsu_dep!(), 1132000000, 0.3034, 0.5344),
      ("Tensor G5", 2092000, _dsu_dep!(), 1228000000, 0.3053, 0.5314),
      ("Tensor G5", 2092000, _dsu_dep!(), 1324000000, 0.1538, 31.397),
      ("Tensor G5", 2092000, _dsu_dep!(), 1420000000, 0.3446, 0.3589),
      ("Tensor G5", 2092000, _dsu_dep!(), 1516000000, 0.3363, 0.4872),
      ("Tensor G5", 2092000, _dsu_dep!(), 1612000000, 0.3423, 0.5387),
      ("Tensor G5", 2092000, _dsu_dep!(), 1728000000, 0.3464, 0.4640),
      ("Tensor G5", 2092000, _dsu_dep!(), 1843000000, 0.3728, 0.5651),
      ("Tensor G5", 2092000, _dsu_dep!(), 1920000000, 0.3946, 0.3228),
      ("Tensor G5", 2092000, _dsu_dep!(), 1996000000, 0.3678, 0.3802),
      ("Tensor G5", 2092000, _dsu_dep!(), 2092000000, 0.4238, 0.4055),
      ("Tensor G5", 2092000, _dsu_dep!(), 2188000000, 0.4652, 0.4393),
      ("Tensor G5", 2169000, _dsu_dep!(), 115000000, 0.3441, 0.4047),
      ("Tensor G5", 2169000, _dsu_dep!(), 268000000, 0.2531, 0.4981),
      ("Tensor G5", 2169000, _dsu_dep!(), 400000000, 0.3047, 0.5037),
      ("Tensor G5", 2169000, _dsu_dep!(), 537000000, 0.3091, 0.3904),
      ("Tensor G5", 2169000, _dsu_dep!(), 691000000, 0.3236, 0.5714),
      ("Tensor G5", 2169000, _dsu_dep!(), 768000000, 0.2832, 0.4033),
      ("Tensor G5", 2169000, _dsu_dep!(), 844000000, 0.3264, 0.4072),
      ("Tensor G5", 2169000, _dsu_dep!(), 960000000, 0.2455, 0.4045),
      ("Tensor G5", 2169000, _dsu_dep!(), 1056000000, 0.3238, 0.3717),
      ("Tensor G5", 2169000, _dsu_dep!(), 1132000000, 0.3303, 0.4531),
      ("Tensor G5", 2169000, _dsu_dep!(), 1228000000, 0.3202, 0.5501),
      ("Tensor G5", 2169000, _dsu_dep!(), 1324000000, 0.3329, 0.4658),
      ("Tensor G5", 2169000, _dsu_dep!(), 1420000000, 0.37, 0.4666),
      ("Tensor G5", 2169000, _dsu_dep!(), 1516000000, 0.3593, 0.3602),
      ("Tensor G5", 2169000, _dsu_dep!(), 1612000000, 0.3253, 0.7185),
      ("Tensor G5", 2169000, _dsu_dep!(), 1728000000, 0.2935, 0.5328),
      ("Tensor G5", 2169000, _dsu_dep!(), 1843000000, 0.3935, 0.3907),
      ("Tensor G5", 2169000, _dsu_dep!(), 1920000000, 0.3439, 0.5322),
      ("Tensor G5", 2169000, _dsu_dep!(), 1996000000, 0.4164, 0.6431),
      ("Tensor G5", 2169000, _dsu_dep!(), 2092000000, 0.3067, 0.6504),
      ("Tensor G5", 2169000, _dsu_dep!(), 2188000000, 0.4595, 0.6651),
      ("Tensor G5", 2246000, _dsu_dep!(), 115000000, 0.5018, 0.334),
      ("Tensor G5", 2246000, _dsu_dep!(), 268000000, 0.1858, 0.5702),
      ("Tensor G5", 2246000, _dsu_dep!(), 400000000, 0.3575, 0.4385),
      ("Tensor G5", 2246000, _dsu_dep!(), 537000000, 0.317, 0.5159),
      ("Tensor G5", 2246000, _dsu_dep!(), 691000000, 0.3315, 0.4771),
      ("Tensor G5", 2246000, _dsu_dep!(), 768000000, 0.1644, 0.5081),
      ("Tensor G5", 2246000, _dsu_dep!(), 844000000, 0.3641, 0.5874),
      ("Tensor G5", 2246000, _dsu_dep!(), 960000000, 0.3196, 0.4443),
      ("Tensor G5", 2246000, _dsu_dep!(), 1056000000, 0.3679, 0.2638),
      ("Tensor G5", 2246000, _dsu_dep!(), 1132000000, 0.3306, 0.4363),
      ("Tensor G5", 2246000, _dsu_dep!(), 1228000000, 0.3679, 0.6061),
      ("Tensor G5", 2246000, _dsu_dep!(), 1324000000, 0.3273, 0.4928),
      ("Tensor G5", 2246000, _dsu_dep!(), 1420000000, 0.3646, 0.6653),
      ("Tensor G5", 2246000, _dsu_dep!(), 1516000000, 0.3953, 0.4656),
      ("Tensor G5", 2246000, _dsu_dep!(), 1612000000, 0.391, 0.7046),
      ("Tensor G5", 2246000, _dsu_dep!(), 1728000000, 0.3948, 0.4969),
      ("Tensor G5", 2246000, _dsu_dep!(), 1843000000, 0.4446, 0.7071),
      ("Tensor G5", 2246000, _dsu_dep!(), 1920000000, 0.4609, 0.5365),
      ("Tensor G5", 2246000, _dsu_dep!(), 1996000000, 0.3605, 0.6287),
      ("Tensor G5", 2246000, _dsu_dep!(), 2092000000, 0.2661, 0.6364),
      ("Tensor G5", 2246000, _dsu_dep!(), 2188000000, 0.4526, 0.8995)) AS _values
  )
SELECT
  *
FROM data;
