/* ========================================================================
 * PlantUML : a free UML diagram generator
 * ========================================================================
 *
 * (C) Copyright 2009-2014, Arnaud Roques
 *
 * Project Info:  http://plantuml.sourceforge.net
 * 
 * This file is part of PlantUML.
 *
 * Licensed under The MIT License (Massachusetts Institute of Technology License)
 * 
 * See http://opensource.org/licenses/MIT
 * 
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR
 * IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 * 
 *
 * Original Author:  Arnaud Roques
 */
package net.sourceforge.plantuml.sequencediagram.teoz;

import java.awt.geom.Dimension2D;
import java.util.Iterator;

import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.SkinParamBackcolored;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.UDrawable;
import net.sourceforge.plantuml.skin.Area;
import net.sourceforge.plantuml.skin.Component;
import net.sourceforge.plantuml.skin.ComponentType;
import net.sourceforge.plantuml.skin.Context2D;
import net.sourceforge.plantuml.skin.Skin;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class LiveBoxes implements UDrawable {

	private final EventsHistory eventsHistory;
	private final Skin skin;
	private final ISkinParam skinParam;
	private final double totalHeight;
	private final Context2D context;

	public LiveBoxes(EventsHistory eventsHistory, Skin skin, ISkinParam skinParam, double totalHeight, Context2D context) {
		this.eventsHistory = eventsHistory;
		this.skin = skin;
		this.skinParam = skinParam;
		this.totalHeight = totalHeight;
		this.context = context;
	}

	public void drawU(UGraphic ug) {
		final Stairs2 stairs = eventsHistory.getStairs(totalHeight);
		final int max = stairs.getMaxValue();
		for (int i = 1; i <= max; i++) {
			drawOneLevel(ug, i, stairs, context);
		}
	}

	private void drawOneLevel(UGraphic ug, int levelToDraw, Stairs2 stairs, Context2D context) {
		final Component comp1 = skin.createComponent(ComponentType.ALIVE_BOX_CLOSE_CLOSE, null, skinParam, null);
		final Component cross = skin.createComponent(ComponentType.DESTROY, null, skinParam, null);
		final Dimension2D dimCross = cross.getPreferredDimension(ug.getStringBounder());
		final double width = comp1.getPreferredWidth(ug.getStringBounder());
		ug = ug.apply(new UTranslate((levelToDraw - 1) * width / 2.0, 0));

		double y1 = Double.MAX_VALUE;
		HtmlColor color = null;
		for (Iterator<StairsPosition> it = stairs.getYs().iterator(); it.hasNext();) {
			final StairsPosition yposition = it.next();
			System.err.println("LiveBoxes::drawOneLevel " + levelToDraw + " " + yposition);
			final IntegerColored integerColored = stairs.getValue(yposition.getValue());
			System.err.println("integerColored=" + integerColored);
			final int level = integerColored.getValue();
			if (y1 == Double.MAX_VALUE && level == levelToDraw) {
				y1 = yposition.getValue();
				color = integerColored.getColor();
			} else if (y1 != Double.MAX_VALUE && (it.hasNext() == false || level < levelToDraw)) {
				final double y2 = yposition.getValue();
				final Area area = new Area(width, y2 - y1);

				final ISkinParam skinParam2 = new SkinParamBackcolored(skinParam, color);
				final Component comp = skin
						.createComponent(ComponentType.ALIVE_BOX_CLOSE_CLOSE, null, skinParam2, null);

				comp.drawU(ug.apply(new UTranslate(-width / 2, y1)), area, context);
				System.err.println("LiveBoxes::drawOneLevel one block " + y1 + " " + y2);
				if (yposition.isDestroy()) {
					System.err.println("LiveBoxes::drawOneLevel DESTROY " + yposition);
					cross.drawU(ug.apply(new UTranslate(-dimCross.getWidth() / 2, y2 - dimCross.getHeight() / 2)),
							null, context);
				} else {
					System.err.println("LiveBoxes::drawOneLevel NOTDESTROY " + yposition);
				}
				y1 = Double.MAX_VALUE;
			}
		}
	}

	private UGraphic withColor(UGraphic ug) {
		return ug;
	}

}
