/***************************************************************************
 *   Copyright (C) 2008 by Swizec <swizec@swizec.com>                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 3 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA .        *
 ***************************************************************************/

// Here we avoid loading the header multiple times
#ifndef Plasma_Teacooker_HEADER
#define Plasma_Teacooker_HEADER

// We need the Plasma Applet headers
#include <Plasma/Applet>
#include <Plasma/Svg>
#include <QTimer>
#include <KConfigDialog>
#include <QWidget>

#include <Phonon/MediaObject>
 
class QSizeF;
class QTimer;
class QAction;
 
class Plasma_Teacooker : public Plasma::Applet
{
    Q_OBJECT
    public:
        // Basic Create/Destroy
        Plasma_Teacooker(QObject *parent, const QVariantList &args);
        ~Plasma_Teacooker();

        // The paintInterface procedure paints the applet to screen
        void paintInterface(QPainter *painter,
                const QStyleOptionGraphicsItem *option,
                const QRect& contentsRect);
        void init();
        QSizeF contentSizeHint() const;
        Qt::Orientations expandingDirections() const;

	QList<QAction*> contextualActions();

    signals:
	void contentsChanged();

    public slots:
        void refresh();
	void pressed();
	void createMenu();
	void popup();
	void slotOpen();
	void resetTea();
	void startTea();
	void stopTea();
	void refreshCountdown();

    protected:

    private:
        void paintImage(QPainter *p, const QRect &contentsRect);
        QTimer* timer;
	int animCounter;
	bool animEnd;
	int timerPause;
	bool steeping;
	QString countdown;
	int countdownSeconds;
	QTimer* countdownT;

	QAction *m_actionResetTea;
	QAction *m_actionStopTea;
	QString m_activeTea;

	QMap<QString, int> m_teas;

	void teaDone( QString tea );

	Phonon::MediaObject *sound;
};
 
// This is the command that links your applet to the .desktop file
K_EXPORT_PLASMA_APPLET(plasma-teacooker, Plasma_Teacooker)
#endif 
