#!/usr/bin/env bash

set -eo pipefail

if [ -d "$BUILD_DIR" ]; then
  rm -Rf "$BUILD_DIR"
fi

mkdir -p "${BUILD_DIR}"
cd "${BUILD_DIR}"

if [ "$POLYBAR_BUILD_TYPE" != "minimal" ]; then
  ENABLE_PULSEAUDIO=ON
  ENABLE_NETWORK=ON
  ENABLE_MPD=ON
  ENABLE_CURL=ON
  ENABLE_ALSA=ON
  ENABLE_I3=ON
  WITH_XRM=ON
  WITH_XKB=ON
  WITH_XRANDR_MONITORS=ON
  WITH_XCURSOR=ON
fi

if [ "$POLYBAR_BUILD_TYPE" = "tests" ]; then
  BUILD_TESTS=ON
fi

cmake \
  -DCMAKE_CXX_COMPILER="${CXX}" \
  -DCMAKE_CXX_FLAGS="${CXXFLAGS} -Werror" \
  -DCMAKE_BUILD_TYPE="${BUILD_TYPE}" \
  -DBUILD_TESTS:BOOL="${BUILD_TESTS:-OFF}" \
  -DBUILD_DOC:BOOL="${BUILD_DOC:-OFF}" \
  -DWITH_XRANDR=ON \
  -DENABLE_PULSEAUDIO="${ENABLE_PULSEAUDIO:-OFF}" \
  -DENABLE_NETWORK="${ENABLE_NETWORK:-OFF}" \
  -DENABLE_MPD="${ENABLE_MPD:-OFF}" \
  -DENABLE_CURL="${ENABLE_CURL:-OFF}" \
  -DENABLE_ALSA="${ENABLE_ALSA:-OFF}" \
  -DENABLE_I3="${ENABLE_I3:-OFF}" \
  -DWITH_XRM="${WITH_XRM:-OFF}" \
  -DWITH_XKB="${WITH_XKB:-OFF}" \
  -DWITH_XRANDR_MONITORS="${WITH_XRANDR_MONITORS:-OFF}" \
  -DWITH_XCURSOR="${WITH_XCURSOR:-OFF}" \
  ..
