#!/bin/sh -e

# Called by "uscan --upstream-version 0"
# With "--upstream-version <version> ../popfile_<version>.orig.zip"

VER=$2
ZIPFILE=$3
SRCDIR=popfile-$VER+dfsg
TGZFILE=popfile_$VER+dfsg.orig.tar.gz
TMPDIR=/tmp/popfilesrc_$$

mkdir -p $TMPDIR/$SRCDIR
unzip -q $ZIPFILE -d $TMPDIR/$SRCDIR
# Remove carriage returns
for curfile in `find $TMPDIR -type f -regex ".*\.p[lm]$"`; do
	sed -e "s/\r$//" -i "$curfile"
done
tar -C $TMPDIR -zcf ../$TGZFILE $SRCDIR
rm -Rf $TMPDIR
