# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class UpgradeDetails(Model):
    """Details for upgrading vault.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar operation_id: ID of the vault upgrade operation.
    :vartype operation_id: str
    :ivar start_time_utc: UTC time at which the upgrade operation has started.
    :vartype start_time_utc: datetime
    :ivar last_updated_time_utc: UTC time at which the upgrade operation
     status was last updated.
    :vartype last_updated_time_utc: datetime
    :ivar end_time_utc: UTC time at which the upgrade operation has ended.
    :vartype end_time_utc: datetime
    :ivar status: Status of the vault upgrade operation. Possible values
     include: 'Unknown', 'InProgress', 'Upgraded', 'Failed'
    :vartype status: str or :class:`VaultUpgradeState
     <azure.mgmt.recoveryservices.models.VaultUpgradeState>`
    :ivar message: Message to the user containing information about the
     upgrade operation.
    :vartype message: str
    :ivar trigger_type: The way the vault upgradation was triggered. Possible
     values include: 'UserTriggered', 'ForcedUpgrade'
    :vartype trigger_type: str or :class:`TriggerType
     <azure.mgmt.recoveryservices.models.TriggerType>`
    :ivar upgraded_resource_id: Resource ID of the upgraded vault.
    :vartype upgraded_resource_id: str
    :ivar previous_resource_id: Resource ID of the vault before the upgrade.
    :vartype previous_resource_id: str
    """

    _validation = {
        'operation_id': {'readonly': True},
        'start_time_utc': {'readonly': True},
        'last_updated_time_utc': {'readonly': True},
        'end_time_utc': {'readonly': True},
        'status': {'readonly': True},
        'message': {'readonly': True},
        'trigger_type': {'readonly': True},
        'upgraded_resource_id': {'readonly': True},
        'previous_resource_id': {'readonly': True},
    }

    _attribute_map = {
        'operation_id': {'key': 'operationId', 'type': 'str'},
        'start_time_utc': {'key': 'startTimeUtc', 'type': 'iso-8601'},
        'last_updated_time_utc': {'key': 'lastUpdatedTimeUtc', 'type': 'iso-8601'},
        'end_time_utc': {'key': 'endTimeUtc', 'type': 'iso-8601'},
        'status': {'key': 'status', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'trigger_type': {'key': 'triggerType', 'type': 'str'},
        'upgraded_resource_id': {'key': 'upgradedResourceId', 'type': 'str'},
        'previous_resource_id': {'key': 'previousResourceId', 'type': 'str'},
    }

    def __init__(self):
        self.operation_id = None
        self.start_time_utc = None
        self.last_updated_time_utc = None
        self.end_time_utc = None
        self.status = None
        self.message = None
        self.trigger_type = None
        self.upgraded_resource_id = None
        self.previous_resource_id = None
