# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.workloadorchestration import WorkloadOrchestrationMgmtClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestWorkloadOrchestrationMgmtTargetsOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(WorkloadOrchestrationMgmtClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_targets_get(self, resource_group):
        response = self.client.targets.get(
            resource_group_name=resource_group.name,
            target_name="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_targets_begin_create_or_update(self, resource_group):
        response = self.client.targets.begin_create_or_update(
            resource_group_name=resource_group.name,
            target_name="str",
            resource={
                "location": "str",
                "eTag": "str",
                "extendedLocation": {"name": "str", "type": "str"},
                "id": "str",
                "name": "str",
                "properties": {
                    "capabilities": ["str"],
                    "contextId": "str",
                    "description": "str",
                    "displayName": "str",
                    "hierarchyLevel": "str",
                    "targetSpecification": {"str": {}},
                    "provisioningState": "str",
                    "solutionScope": "str",
                    "state": "str",
                    "status": {
                        "deployed": 0,
                        "expectedRunningJobId": 0,
                        "generation": 0,
                        "lastModified": "2020-02-20 00:00:00",
                        "runningJobId": 0,
                        "status": "str",
                        "statusDetails": "str",
                        "targetStatuses": [
                            {"componentStatuses": [{"name": "str", "status": "str"}], "name": "str", "status": "str"}
                        ],
                    },
                },
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "tags": {"str": "str"},
                "type": "str",
            },
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_targets_begin_update(self, resource_group):
        response = self.client.targets.begin_update(
            resource_group_name=resource_group.name,
            target_name="str",
            properties={
                "location": "str",
                "eTag": "str",
                "extendedLocation": {"name": "str", "type": "str"},
                "id": "str",
                "name": "str",
                "properties": {
                    "capabilities": ["str"],
                    "contextId": "str",
                    "description": "str",
                    "displayName": "str",
                    "hierarchyLevel": "str",
                    "targetSpecification": {"str": {}},
                    "provisioningState": "str",
                    "solutionScope": "str",
                    "state": "str",
                    "status": {
                        "deployed": 0,
                        "expectedRunningJobId": 0,
                        "generation": 0,
                        "lastModified": "2020-02-20 00:00:00",
                        "runningJobId": 0,
                        "status": "str",
                        "statusDetails": "str",
                        "targetStatuses": [
                            {"componentStatuses": [{"name": "str", "status": "str"}], "name": "str", "status": "str"}
                        ],
                    },
                },
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "tags": {"str": "str"},
                "type": "str",
            },
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_targets_begin_delete(self, resource_group):
        response = self.client.targets.begin_delete(
            resource_group_name=resource_group.name,
            target_name="str",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_targets_list_by_resource_group(self, resource_group):
        response = self.client.targets.list_by_resource_group(
            resource_group_name=resource_group.name,
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_targets_list_by_subscription(self, resource_group):
        response = self.client.targets.list_by_subscription()
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_targets_begin_install_solution(self, resource_group):
        response = self.client.targets.begin_install_solution(
            resource_group_name=resource_group.name,
            target_name="str",
            body={"solutionVersionId": "str"},
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_targets_begin_uninstall_solution(self, resource_group):
        response = self.client.targets.begin_uninstall_solution(
            resource_group_name=resource_group.name,
            target_name="str",
            body={"solutionTemplateId": "str", "solutionInstanceName": "str"},
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_targets_begin_remove_revision(self, resource_group):
        response = self.client.targets.begin_remove_revision(
            resource_group_name=resource_group.name,
            target_name="str",
            body={"solutionTemplateId": "str", "solutionVersion": "str"},
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_targets_begin_resolve_configuration(self, resource_group):
        response = self.client.targets.begin_resolve_configuration(
            resource_group_name=resource_group.name,
            target_name="str",
            body={
                "solutionTemplateVersionId": "str",
                "solutionDependencies": [
                    {
                        "dependencies": [...],
                        "solutionInstanceName": "str",
                        "solutionTemplateId": "str",
                        "solutionTemplateVersion": "str",
                        "solutionVersionId": "str",
                        "targetId": "str",
                    }
                ],
                "solutionInstanceName": "str",
            },
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_targets_begin_review_solution_version(self, resource_group):
        response = self.client.targets.begin_review_solution_version(
            resource_group_name=resource_group.name,
            target_name="str",
            body={
                "solutionTemplateVersionId": "str",
                "solutionDependencies": [
                    {
                        "dependencies": [...],
                        "solutionInstanceName": "str",
                        "solutionTemplateId": "str",
                        "solutionTemplateVersion": "str",
                        "solutionVersionId": "str",
                        "targetId": "str",
                    }
                ],
                "solutionInstanceName": "str",
            },
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_targets_begin_publish_solution_version(self, resource_group):
        response = self.client.targets.begin_publish_solution_version(
            resource_group_name=resource_group.name,
            target_name="str",
            body={"solutionVersionId": "str"},
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_targets_begin_update_external_validation_status(self, resource_group):
        response = self.client.targets.begin_update_external_validation_status(
            resource_group_name=resource_group.name,
            target_name="str",
            body={
                "externalValidationId": "str",
                "solutionVersionId": "str",
                "validationStatus": "str",
                "errorDetails": {
                    "additionalInfo": [{"info": {}, "type": "str"}],
                    "code": "str",
                    "details": [...],
                    "message": "str",
                    "target": "str",
                },
            },
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...
