//
// C++ Implementation: signal
//
// Description: 
//
//
// Author: Harald Krippel <harald@the-develop.net>, (C) 2008
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "signal.hpp"


//-------- QCSignals Singleton ---

 QCSignals * QCSignals::theInstancePtr = 0;

QCSignals::QCSignals (QObject *parent): QObject(parent)
{

}

// destructor
QCSignals::~QCSignals ()
{

}

QCSignals * QCSignals::theInstance(QObject *parent) {
    if (theInstancePtr == 0) {
        theInstancePtr = new QCSignals(parent);
    }
    return theInstancePtr;
}

void QCSignals::signal(int signalTyp, int arg) {
    Q_UNUSED(arg);

    switch(signalTyp) {
        case SIGNAL_SCRIPT_ERROR:
           emit scriptError();
           return;
        case SIGNAL_SOUND_ERROR:
           emit soundError();
           return;
        default:
           emit unknownSignal();
    }
}
