CONFIG += warn_on \
					thread \
					qt
TEMPLATE = app
MOC_DIR= ../tmp
OBJECTS_DIR=../tmp
TARGET=qsstv
QT += network

QMAKE_CXXFLAGS_DEBUG -= -O2
QMAKE_CXXFLAGS_DEBUG += -g3 -O0
QMAKE_STRIP = echo
VERSION=7.1.7

message(directory2 $$PWD)

SOURCES += main.cpp \
    imageviewer.cpp \
    global.cpp \
    configdialog.cpp \
    logging.cpp \
    supportfunctions.cpp \
    sstvparam.cpp \
    editor/editor.cpp \
    editor/editorview.cpp \
    editor/editorscene.cpp \
    editor/gradientdialog.cpp \
    editor/graphicitems.cpp \
    wavio.cpp \
    dispatcher.cpp \
    fftdisplay.cpp \
    soundio.cpp \
    filterparam.cpp \
    rxfunctions.cpp \
    txfunctions.cpp \
    filter.cpp \
    syncprocessor.cpp \
    modes/modebase.cpp \
    modes/modegbr.cpp \
    modes/modegbr2.cpp \
    modes/modergb.cpp \
    modes/moderobot1.cpp \
    modes/moderobot2.cpp \
    synthes.cpp \
    modes/modepd.cpp \
    modes/modebw.cpp \
    modes/modeavt.cpp \
    ftp.cpp \
    widgets/qvumeter.cpp \
    videocapture.cpp \
    cw.cpp \
    cameracontrol.cpp \
    configparams.cpp \
    rigcontrol.cpp \
    mainwindow.cpp \
    gallerywidget.cpp \
    rxwidget.cpp \
    txwidget.cpp

RESOURCES += qsstv.qrc
FORMS += \
    configform.ui \
    dirform.ui \
    freqform.ui \
    slantform.ui \
    soundcontrol.ui \
    editor/editorform.ui \
    editor/gradientform.ui \
    editor/textform.ui \
    calibrationform.ui \
    loggingform.ui \
    cameracontrol.ui \
    mainwindow.ui \
    gallerywidget.ui \
    rxwidget.ui \
    txwidget.ui \
    sweepform.ui


HEADERS += imageviewer.h \
    global.h \
    configdialog.h \
    sstvparam.h \
    logging.h \
    supportfunctions.h \
    editor/editor.h \
    editor/editorview.h \
    editor/editorscene.h \
    editor/gradientdialog.h \
    editor/graphicitems.h \
    wavio.h \
    dispatcher.h \
    dispatchevents.h \
    buffermanag.h \
    fftdisplay.h \
    soundio.h \
    filterparam.h \
    rxfunctions.h \
    txfunctions.h \
    filter.h \
    syncprocessor.h \
    nco.h \
    modes/modebase.h \
    modes/modegbr.h \
    modes/modes.h \
    modes/modegbr2.h \
    modes/modergb.h \
    modes/moderobot1.h \
    modes/moderobot2.h \
    synthes.h \
    modes/modepd.h \
    modes/modebw.h \
    modes/modeavt.h \
    ftp.h \
    widgets/qvumeter.h \
    videocapture.h \
    cw.h \
    cameracontrol.h \
    configparams.h \
    rigcontrol.h \
    hamlib.h \
    editor/qdialog_p.h \
    mainwindow.h \
    gallerywidget.h \
    rxwidget.h \
    txwidget.h


CONFIG(release, debug|release):message(Release build!) #will print
CONFIG(debug, debug|release):message(Debug build!) #no print

#CONFIG(debug, debug|release):POST_TARGETDEPS += ../qwt/libqwt.a
#CONFIG(debug, debug|release):INCLUDEPATH += ../qwt
#CONFIG(debug, debug|release):LIBS += ../qwt/libqwt.a

CONFIG(debug, debug|release){
message(Debug build!)
POST_TARGETDEPS += ../qwt/libqwt.a
INCLUDEPATH += ../qwt
LIBS += ../qwt/libqwt.a
HEADERS +=    scopeview.h scopeplot.h
SOURCES +=   scopeview.cpp scopeplot.cpp
FORMS += plotform.ui
}

message($$VERSION)



OTHER_FILES += \
    documentation/manual.txt \
    documentation/manual.doxy \
    tar_exclude \
    documentation/qsstv.css \
    ../INSTALL \
    ../COPYING


CONFIG(debug ,debug|release){
FILE=$$PWD
message(file: $$FILE)
DIRNAME = $$dirname(FILE)
TARNAME=$$TARGET
TARNAME=$$join(TARNAME,,,_$$VERSION)
TARNAME=$$join(TARNAME,,,.tgz)
DIRNAME= ../../
DIRNAME=$$join(DIRNAME,,,$$TARGET)
DIRNAME=$$join(DIRNAME,,,_$$VERSION)
message(my $$DIRNAME $$TARNAME)
#tarx.commands= tar -cvhzf $$TARNAME -X $$PWD/tar_exclude  $$DIRNAME
tarx.commands=tar -cvhzf $$TARNAME -X $$PWD/tar_exclude $$DIRNAME
POST_TARGETDEPS       +=    tarx
QMAKE_EXTRA_TARGETS   +=   tarx
}

CONFIG(debug ,debug|release){
dox.commands = cd $$PWD/documentation ;doxygen  manual.doxy;
dox.depends= FORCE
PRE_TARGETDEPS       +=    dox
QMAKE_EXTRA_TARGETS   +=   dox
message(dox will be generated)
}
dox.path=/usr/share/doc/$$TARGET
dox.files= $$PWD/documentation/html/*

 LIBS += -L/usr/lib64 \
  -lfftw3 \
  -lasound \
  -lhamlib

target.path=/usr/local/bin
target.extra = strip $(TARGET); cp -f $(TARGET) $${PREFIX}/bin/$(TARGET)
INSTALLS +=target
INSTALLS +=dox
