% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_compare_profiles.R
\name{plot_compare_profiles}
\alias{plot_compare_profiles}
\title{Compare two 96 mutation profiles}
\usage{
plot_compare_profiles(
  profile1,
  profile2,
  profile_names = c("profile 1", "profile 2"),
  profile_ymax = 0.2,
  diff_ylim = c(-0.02, 0.02),
  colors = NA,
  condensed = FALSE
)
}
\arguments{
\item{profile1}{First 96 mutation profile}

\item{profile2}{Second 96 mutation profile}

\item{profile_names}{Character vector with names of the mutations profiles
used for plotting, default = c("profile 1", "profile 2")}

\item{profile_ymax}{Maximum value of y-axis (relative contribution) for
profile plotting. This can only be used to increase the y axis.
If bars fall outside this limit, the maximum value is
automatically increased. default = 0.2.}

\item{diff_ylim}{Y-axis limits for profile difference plot,
default = c(-0.02, 0.02)}

\item{colors}{6 value color vector}

\item{condensed}{More condensed plotting format. Default = F.}
}
\value{
96 spectrum plot of profile 1, profile 2 and their difference
}
\description{
Plots two 96 mutation profiles and their difference, reports the residual
sum of squares (RSS).
}
\examples{
## See the 'mut_matrix()' example for how we obtained the following
## mutation matrix.
mut_mat <- readRDS(system.file("states/mut_mat_data.rds",
  package = "MutationalPatterns"
))

## Extracting signatures can be computationally intensive, so
## we use pre-computed data generated with the following command:
# nmf_res <- extract_signatures(mut_mat, rank = 2)

nmf_res <- readRDS(system.file("states/nmf_res_data.rds",
  package = "MutationalPatterns"
))

## Compare the reconstructed 96-profile of sample 1 with the original profile
## The same thing could be done with a reconstructed profile from signature refitting.
plot_compare_profiles(mut_mat[, 1],
  nmf_res$reconstructed[, 1],
  profile_names = c("Original", "Reconstructed")
)

## You could also compare regular mutation profiles with eachother.
plot_compare_profiles(
  mut_mat[, 1],
  mut_mat[, 2]
)


## You can also change the y limits.
## This can be done separately for the profiles and the different facets.
plot_compare_profiles(mut_mat[, 1],
  mut_mat[, 2],
  profile_ymax = 0.3,
  diff_ylim = c(-0.03, 0.03)
)
}
\seealso{
\code{\link{mut_matrix}},
\code{\link{extract_signatures}},
\code{\link{plot_compare_indels}},
\code{\link{plot_compare_dbs}},
\code{\link{plot_compare_mbs}}
}
