% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/batchtools_local.R
\name{batchtools_local}
\alias{batchtools_local}
\alias{batchtools_interactive}
\alias{batchtools_bash}
\title{batchtools local and interactive futures}
\usage{
batchtools_local(..., envir = parent.frame())
}
\arguments{
\item{envir}{The environment in which global environment
should be located.}

\item{\ldots}{Additional arguments passed to \code{\link[=BatchtoolsUniprocessFuture]{BatchtoolsUniprocessFuture()}}.}
}
\value{
An object of class \code{BatchtoolsUniprocessFuture}.
}
\description{
A batchtools local future is an synchronous uniprocess future that
will be evaluated in a background R session.
A batchtools interactive future is an synchronous uniprocess future
that will be evaluated in the current R session (and variables will
be assigned to the calling environment rather than to a local one).
Both types of futures will block until the futures are resolved.
}
\details{
batchtools local futures rely on the batchtools backend set up by
\code{\link[batchtools:makeClusterFunctionsInteractive]{batchtools::makeClusterFunctionsInteractive(external = TRUE)}}
and batchtools interactive futures on the one set up by
\code{\link[batchtools:makeClusterFunctionsInteractive]{batchtools::makeClusterFunctionsInteractive()}}.
These are supported by all operating systems.

An alternative to batchtools local futures is to use
\link[future:cluster]{cluster} futures of the \pkg{future}
package with a single local background session, i.e.
\code{plan(cluster, workers = "localhost")}.

An alternative to batchtools interactive futures is to use
\code{plan(sequential, split = TRUE)} futures of the \pkg{future} package.
}
\examples{
## Use local batchtools futures
plan(batchtools_local)

## A global variable
a <- 1

## Create explicit future
f <- future({
  b <- 3
  c <- 2
  a * b * c
})
v <- value(f)
print(v)


## Create implicit future
v \%<-\% {
  b <- 3
  c <- 2
  a * b * c
}
print(v)
}
