% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/round.mpoly.R
\name{round.mpoly}
\alias{round.mpoly}
\title{Round the coefficients of a polynomial}
\usage{
\method{round}{mpoly}(x, digits = 3)
}
\arguments{
\item{x}{an mpoly object}

\item{digits}{number of digits to round to}
}
\value{
the rounded mpoly object
}
\description{
Round the coefficients of an mpoly object.
}
\examples{

p <- mp("x + 3.14159265")^4
p
round(p)
round(p, 0)

\dontrun{
library(plyr)
library(ggplot2)
library(stringr)

n <- 101
s <- seq(-5, 5, length.out = n)

# one dimensional case
df <- data.frame(x = s)
df <- mutate(df, y = -x^2 + 2*x - 3 + rnorm(n, 0, 2))
qplot(x, y, data = df)
mod <- lm(y ~ x + I(x^2), data = df)
p <- as.mpoly(mod)
qplot(x, y, data = df) +
  stat_function(fun = as.function(p), colour = 'red')

p
round(p, 1)
qplot(x, y, data = df) +
  stat_function(fun = as.function(p), colour = 'red') +
  stat_function(fun = as.function(round(p,1)), colour = 'blue')


}

}
\seealso{
\code{\link[=mp]{mp()}}
}
\author{
David Kahle \email{david@kahle.io}
}
