% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jacobi.R
\name{jacobi}
\alias{jacobi}
\title{Jacobi polynomials}
\usage{
jacobi(
  degree,
  alpha = 1,
  beta = 1,
  kind = "p",
  indeterminate = "x",
  normalized = FALSE
)
}
\arguments{
\item{degree}{degree of polynomial}

\item{alpha}{the first parameter, also called p}

\item{beta}{the second parameter, also called q}

\item{kind}{"g" or "p"}

\item{indeterminate}{indeterminate}

\item{normalized}{provide normalized coefficients}
}
\value{
a mpoly object or mpolyList object
}
\description{
Jacobi polynomials as computed by orthopolynom.
}
\examples{

jacobi(0)
jacobi(1)
jacobi(2)
jacobi(3)
jacobi(4)
jacobi(5)
jacobi(6)
jacobi(10, 2, 2, normalized = TRUE)

jacobi(0:5)
jacobi(0:5, normalized = TRUE)
jacobi(0:5, kind = "g")
jacobi(0:5, indeterminate = "t")



# visualize the jacobi polynomials

library(ggplot2); theme_set(theme_classic())
library(tidyr)

s <- seq(-1, 1, length.out = 201)
N <- 5 # number of jacobi polynomials to plot
(jacPolys <- jacobi(0:N, 2, 2))

df <- data.frame(s, as.function(jacPolys)(s))
names(df) <- c("x", paste0("P_", 0:N))
mdf <- gather(df, degree, value, -x)
qplot(x, value, data = mdf, geom = "line", color = degree)

qplot(x, value, data = mdf, geom = "line", color = degree) +
  coord_cartesian(ylim = c(-30, 30))



}
\seealso{
\code{\link[orthopolynom:jacobi.g.polynomials]{orthopolynom::jacobi.g.polynomials()}},
\code{\link[orthopolynom:jacobi.p.polynomials]{orthopolynom::jacobi.p.polynomials()}},
\url{https://en.wikipedia.org/wiki/Jacobi_polynomials}
}
\author{
David Kahle calling code from the orthopolynom package
}
