% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/internal.R, R/accessors.R
\name{internal}
\alias{internal}
\alias{token}
\alias{text}
\alias{nodes}
\alias{start_line}
\alias{start_col}
\alias{end_line}
\alias{end_col}
\alias{filename}
\alias{lines}
\alias{is_terminal}
\alias{is_first_on_line}
\alias{is_last_on_line}
\alias{spans_multiple_lines}
\alias{terminal_ids_on_line}
\alias{ids_starting_on_line}
\alias{ids_ending_on_line}
\alias{prev_terminal}
\alias{expr_text}
\title{Make a function operate internal to parsetools}
\usage{
internal(fun, id = pd$id)

token(id = pd$id, pd = get("pd", parent.frame()))

text(id = pd$id, pd = get("pd", parent.frame()))

nodes(id, pd = get("pd", parent.frame()))

start_line(id, pd = get("pd", parent.frame()))

start_col(id, pd = get("pd", parent.frame()))

end_line(id, pd = get("pd", parent.frame()))

end_col(id, pd = get("pd", parent.frame()))

filename(pd = get("pd", parent.frame()))

lines(id, pd = get("pd", parent.frame()))

is_terminal(id, pd = get("pd", parent.frame()))

is_first_on_line(id, pd = get("pd", parent.frame()))

is_last_on_line(id, pd = get("pd", parent.frame()))

spans_multiple_lines(id, pd = get("pd", parent.frame()))

terminal_ids_on_line(line, pd = get("pd", parent.frame()))

ids_starting_on_line(line, pd = get("pd", parent.frame()))

ids_ending_on_line(line, pd = get("pd", parent.frame()))

prev_terminal(id = pd$id, pd = get("pd", parent.frame()))

expr_text(id, pd = get("pd", parent.frame()))
}
\arguments{
\item{fun}{The function to make internal}

\item{id}{the ID of the expression}

\item{pd}{the parse data.}

\item{line}{a line number}
}
\description{
Convert a function to look for pd object in the \code{parent.frame()},
and the id to extract from the pd unless overwritten.

These functions are for internal use but are documented
here for reference.
}
\section{Functions}{
\itemize{
\item \code{token}: Extract the token

\item \code{text}: Extract the text

\item \code{nodes}: Extract only the specified node(s).

\item \code{start_line}: Get the line the expression starts on.

\item \code{start_col}: Get the column the expression starts on.

\item \code{end_line}: Get the line the expression ends on.

\item \code{end_col}: Get the column the expression ends on.

\item \code{filename}: Extract the filename if available, otherwise return "<UNKNOWN>".

\item \code{lines}: Extract the lines of text.

\item \code{is_terminal}: does id represent a terminal node.

\item \code{is_first_on_line}: is an expression the first one on a line?

\item \code{is_last_on_line}: Is expression the last terminal node on the line?

\item \code{spans_multiple_lines}: does the expression span multiple lines?

\item \code{terminal_ids_on_line}: Get the ids on a given line that are terminal nodes.

\item \code{ids_starting_on_line}: Get ids for nodes that start on the given line

\item \code{ids_ending_on_line}: Get ids for nodes that end on the given line

\item \code{prev_terminal}: Get the id for the terminal expression that is immediately prior to the one given.

\item \code{expr_text}: If id represents an \code{expr} token reiterate on the firstborn.
Throws an error if anything but an expression or text if found.
}}

