% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/performance_mae.R
\name{performance_mae}
\alias{performance_mae}
\alias{mae}
\title{Mean Absolute Error of Models}
\usage{
performance_mae(model, ...)

mae(model, ...)
}
\arguments{
\item{model}{A model.}

\item{...}{Arguments passed down to \code{lme4::bootMer()} or \code{boot::boot()}
for bootstrapped ICC, R2, RMSE etc.; for \code{variance_decomposition()},
arguments are passed down to \code{brms::posterior_predict()}.}
}
\value{
Numeric, the mean absolute error of \code{model}.
}
\description{
Compute mean absolute error of models.
}
\examples{
data(mtcars)
m <- lm(mpg ~ hp + gear, data = mtcars)
performance_mae(m)
}
