% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/arg.R
\name{check_exclusive}
\alias{check_exclusive}
\title{Check that arguments are mutually exclusive}
\usage{
check_exclusive(
  ...,
  .require = TRUE,
  .frame = caller_env(),
  .error_call = .frame
)
}
\arguments{
\item{...}{Function arguments.}

\item{.require}{Whether at least one argument must be supplied.}

\item{.frame}{Environment where the arguments in \code{...} are defined.}

\item{.error_call}{The execution environment of a currently
running function, e.g. \code{caller_env()}. The function will be
mentioned in error messages as the source of the error. See the
\code{call} argument of \code{\link[=abort]{abort()}} for more information.}
}
\value{
The supplied argument name as a string. If \code{.require} is
\code{FALSE} and no argument is supplied, the empty string \code{""} is
returned.
}
\description{
\code{check_exclusive()} checks that only one argument is supplied out of
a set of mutually exclusive arguments. An informative error is
thrown if multiple arguments are supplied.
}
\examples{
f <- function(x, y) {
  switch(
    check_exclusive(x, y),
    x = message("`x` was supplied."),
    y = message("`y` was supplied.")
  )
}

# Supplying zero or multiple arguments is forbidden
try(f())
try(f(NULL, NULL))

# The user must supply one of the mutually exclusive arguments
f(NULL)
f(y = NULL)


# With `.require` you can allow zero arguments
f <- function(x, y) {
  switch(
    check_exclusive(x, y, .require = FALSE),
    x = message("`x` was supplied."),
    y = message("`y` was supplied."),
    message("No arguments were supplied")
  )
}
f()
}
