// direct method for Stokes problem : block one pressure pont (ddl)
// work well if the same point is blocked for the velocity (2 or 3 ddl)
// otherwise: does not work with velocity Neumann or symmetry conditions
// e.g. does not work with incompressible embankment problem
#include "rheolef.h"
#include "rheolef/uzawa_abtb.h"
using namespace rheolef;
using namespace std;
#include "cavity.h"
int main(int argc, char**argv) {
  geo  omega_h (argv[1]);
  size_t d = omega_h.dimension();
  space Vh = cavity_space (omega_h, "P2");
  space Qh (omega_h, "P1");
  if (d == 2) Qh.block ("left_bottom"); else Qh.block ("left_bottom_back");
  space Xh = Vh*Qh;
  field xh(Xh);
  field uh = cavity_field (Vh, 1);
  xh[0] = uh[0];
  xh[1] = uh[1];
  if (d == 3) xh[2] = uh[2];
  xh[d] = field(Qh, 0);
  form a (Vh, Vh, "2D_D");
  form b (Vh, Qh, "div"); b = -b;
  form zero = form_nul(Qh, Qh);
  form_manip A_manip;
  A_manip << size(2,2)
          << a << trans(b)
	  << b << zero;
  form A;
  A_manip >> A;
  ssk<Float> fact_A = ldlt(A.uu);
  xh.u = fact_A.solve (-(A.ub*xh.b));
  uh[0] = xh[0];
  uh[1] = xh[1];
  if (d == 3) uh[2] = xh[2];
  cout << catchmark("lambda") << 0
       << catchmark("u")      << uh
       << catchmark("p")      << field(xh[d]);
  return 0;
}
