/*************************************************************** */
/* Rule Set Based Access Control                                 */
/*                                                               */
/* Author and (c) 1999-2005: Michal Purzynski <michal@rsbac.org> */
/*                                                               */
/* Last modified: 10/Apr/2006                                    */
/*************************************************************** */

#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <rsbac/types.h>
#include <rsbac/getname.h>
#include <rsbac/syscalls.h>
#include <rsbac/error.h>
#include "nls.h"
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

char * progname;

void use(void)
    {
      printf(gettext("%s (RSBAC %s)\n***\n"), progname, VERSION);
      printf(gettext("Use: %s rc_fd_type mode filename\n\n"), progname);  
    }

int main(int argc, char ** argv)
{
  int res = 0;
  int mode;
  rsbac_rc_type_id_t type;

  locale_init();
  progname = argv[0];
  if (argc > 3)
    {
      type = strtol(argv[1],0,10);
      mode = strtol(argv[2],0,8);
      printf("type: %u, mode: %o, name: %s\n", type, mode, argv[3]);
      res = rsbac_rc_select_fd_create_type(type);
      error_exit(res);
      res = creat(argv[3],mode);
      error_exit(res);
    }
  else
    {
      use();
      return 1;
    }
    
  return (res);
}

