//===- Enzyme.h - Automatic Differentiation Transformation Pass    -------===//
//
//                             Enzyme Project
//
// Part of the Enzyme Project, under the Apache License v2.0 with LLVM
// Exceptions. See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
// If using this code in an academic setting, please cite the following:
// @incollection{enzymeNeurips,
// title = {Instead of Rewriting Foreign Code for Machine Learning,
//          Automatically Synthesize Fast Gradients},
// author = {Moses, William S. and Churavy, Valentin},
// booktitle = {Advances in Neural Information Processing Systems 33},
// year = {2020},
// note = {To appear in},
// }
//
//===----------------------------------------------------------------------===//
//
// This file declares Enzyme, a transformation pass that takes replaces calls
// to function calls to *__enzyme_autodiff* with a call to the derivative of
// the function passed as the first argument.
//
//===----------------------------------------------------------------------===//

#include "llvm/Pass.h"
#if LLVM_VERSION_MAJOR >= 12
#include "llvm/Passes/PassBuilder.h"
#endif

llvm::ModulePass *createEnzymePass(bool PostOpt = false);
#if LLVM_VERSION_MAJOR >= 12
void augmentPassBuilder(llvm::PassBuilder &PB);
#endif