/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.swift.util;

import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.swift.util.SwiftObjectPath;

public final class SwiftUtils {
    public static final String READ = "read(buffer, offset, length)";

    public static String joinPaths(String path1, String path2) {
        StringBuilder result = new StringBuilder(path1.length() + path2.length() + 1);
        result.append(path1);
        boolean insertSlash = true;
        if (path1.endsWith("/")) {
            insertSlash = false;
        } else if (path2.startsWith("/")) {
            insertSlash = false;
        }
        if (insertSlash) {
            result.append("/");
        }
        result.append(path2);
        return result.toString();
    }

    public static boolean isDirectory(FileStatus fileStatus) {
        return fileStatus.isDir() || SwiftUtils.isFilePretendingToBeDirectory(fileStatus);
    }

    public static boolean isFilePretendingToBeDirectory(FileStatus fileStatus) {
        return fileStatus.getLen() == 0L;
    }

    public static boolean isRootDir(SwiftObjectPath swiftObject) {
        return swiftObject.objectMatches("") || swiftObject.objectMatches("/");
    }

    public static void debug(Log log, String text, Object ... args) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format(text, args));
        }
    }

    public static void debugEx(Log log, String text, Exception ex) {
        if (log.isDebugEnabled()) {
            log.debug((Object)(text + ex), (Throwable)ex);
        }
    }

    public static void trace(Log log, String text, Object ... args) {
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format(text, args));
        }
    }

    public static String partitionFilenameFromNumber(int partNumber) {
        return String.format("%06d", partNumber);
    }

    public static String ls(FileSystem fileSystem, Path path) throws IOException {
        FileStatus[] stats;
        if (path == null) {
            return "/";
        }
        String pathtext = "ls " + path;
        try {
            stats = fileSystem.listStatus(path);
        }
        catch (FileNotFoundException e) {
            return pathtext + " -file not found";
        }
        catch (IOException e) {
            return pathtext + " -failed: " + e;
        }
        return pathtext + SwiftUtils.fileStatsToString(stats, "\n");
    }

    public static String fileStatsToString(FileStatus[] stats, String separator) {
        StringBuilder buf = new StringBuilder(stats.length * 128);
        for (int i = 0; i < stats.length; ++i) {
            buf.append(String.format("[%02d] %s", i, stats[i])).append(separator);
        }
        return buf.toString();
    }

    public static void validateReadArgs(byte[] buffer, int off, int len) {
        if (buffer == null) {
            throw new NullPointerException("Null byte array inread(buffer, offset, length)");
        }
        if (off < 0) {
            throw new IndexOutOfBoundsException("Negative buffer offset " + off + " in " + READ);
        }
        if (len < 0) {
            throw new IndexOutOfBoundsException("Negative read length " + len + " in " + READ);
        }
        if (off > buffer.length) {
            throw new IndexOutOfBoundsException("Buffer offset of " + off + "beyond buffer size of " + buffer.length + " in " + READ);
        }
    }
}

