#include "ScilabPreferences.hxx"
/* Generated by GIWS (version 2.0.2) with command:
giws --disable-return-size-array --output-dir src/jni/ --throws-exception-on-error --description-file src/jni/ScilabPreferences.giws.xml
*/
/*

This is generated code.

This software is a computer program whose purpose is to hide the complexity
of accessing Java objects/methods from C++ code.

Copyright (C) 2012 - 2016 - Scilab Enterprises

This file is hereby licensed under the terms of the GNU GPL v2.0,
pursuant to article 5.3.4 of the CeCILL v.2.1.
This file was originally licensed under the terms of the CeCILL v2.1,
and continues to be available under such terms.
For more information, see the COPYING file which you should have received
along with this program.
*/

namespace org_scilab_modules_preferences {

                // Static declarations (if any)
                
// Returns the current env

JNIEnv * ScilabPreferences::getCurrentEnv() {
JNIEnv * curEnv = NULL;
jint res=this->jvm->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
if (res != JNI_OK) {
throw GiwsException::JniException(getCurrentEnv());
}
return curEnv;
}
// Destructor

ScilabPreferences::~ScilabPreferences() {
JNIEnv * curEnv = NULL;
this->jvm->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
curEnv->DeleteGlobalRef(this->instance);
curEnv->DeleteGlobalRef(this->instanceClass);
}
// Constructors
ScilabPreferences::ScilabPreferences(JavaVM * jvm_) {
jmethodID constructObject = NULL ;
jobject localInstance ;
jclass localClass ;

const std::string construct="<init>";
const std::string param="()V";
jvm=jvm_;

JNIEnv * curEnv = getCurrentEnv();

localClass = curEnv->FindClass( this->className().c_str() ) ;
if (localClass == NULL) {
  throw GiwsException::JniClassNotFoundException(curEnv, this->className());
}

this->instanceClass = static_cast<jclass>(curEnv->NewGlobalRef(localClass));

/* localClass is not needed anymore */
curEnv->DeleteLocalRef(localClass);

if (this->instanceClass == NULL) {
throw GiwsException::JniObjectCreationException(curEnv, this->className());
}


constructObject = curEnv->GetMethodID( this->instanceClass, construct.c_str() , param.c_str() ) ;
if(constructObject == NULL){
throw GiwsException::JniObjectCreationException(curEnv, this->className());
}

localInstance = curEnv->NewObject( this->instanceClass, constructObject ) ;
if(localInstance == NULL){
throw GiwsException::JniObjectCreationException(curEnv, this->className());
}
 
this->instance = curEnv->NewGlobalRef(localInstance) ;
if(this->instance == NULL){
throw GiwsException::JniObjectCreationException(curEnv, this->className());
}
/* localInstance not needed anymore */
curEnv->DeleteLocalRef(localInstance);

                /* Methods ID set to NULL */
voidaddToolboxInfosjstringjava_lang_Stringjstringjava_lang_Stringjstringjava_lang_StringID=NULL;
voidremoveToolboxInfosjstringjava_lang_StringID=NULL;
voidopenPreferencesID=NULL;


}

ScilabPreferences::ScilabPreferences(JavaVM * jvm_, jobject JObj) {
        jvm=jvm_;

        JNIEnv * curEnv = getCurrentEnv();

jclass localClass = curEnv->GetObjectClass(JObj);
        this->instanceClass = static_cast<jclass>(curEnv->NewGlobalRef(localClass));
        curEnv->DeleteLocalRef(localClass);

        if (this->instanceClass == NULL) {
throw GiwsException::JniObjectCreationException(curEnv, this->className());
        }

        this->instance = curEnv->NewGlobalRef(JObj) ;
        if(this->instance == NULL){
throw GiwsException::JniObjectCreationException(curEnv, this->className());
        }
        /* Methods ID set to NULL */
        voidaddToolboxInfosjstringjava_lang_Stringjstringjava_lang_Stringjstringjava_lang_StringID=NULL;
voidremoveToolboxInfosjstringjava_lang_StringID=NULL;
voidopenPreferencesID=NULL;


}

// Generic methods

void ScilabPreferences::synchronize() {
if (getCurrentEnv()->MonitorEnter(instance) != JNI_OK) {
throw GiwsException::JniMonitorException(getCurrentEnv(), "ScilabPreferences");
}
}

void ScilabPreferences::endSynchronize() {
if ( getCurrentEnv()->MonitorExit(instance) != JNI_OK) {
throw GiwsException::JniMonitorException(getCurrentEnv(), "ScilabPreferences");
}
}
// Method(s)

void ScilabPreferences::addToolboxInfos (JavaVM * jvm_, char const* name, char const* path, char const* prefFile){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = initClass(curEnv);
if ( cls == NULL) {
throw GiwsException::JniCallMethodException(curEnv);
}

static jmethodID voidaddToolboxInfosjstringjava_lang_Stringjstringjava_lang_Stringjstringjava_lang_StringID = curEnv->GetStaticMethodID(cls, "addToolboxInfos", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V" ) ;
if (voidaddToolboxInfosjstringjava_lang_Stringjstringjava_lang_Stringjstringjava_lang_StringID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "addToolboxInfos");
}

jstring name_ = curEnv->NewStringUTF( name );
if (name != NULL && name_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}


jstring path_ = curEnv->NewStringUTF( path );
if (path != NULL && path_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}


jstring prefFile_ = curEnv->NewStringUTF( prefFile );
if (prefFile != NULL && prefFile_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}


                         curEnv->CallStaticVoidMethod(cls, voidaddToolboxInfosjstringjava_lang_Stringjstringjava_lang_Stringjstringjava_lang_StringID ,name_, path_, prefFile_);
                        curEnv->DeleteLocalRef(name_);
curEnv->DeleteLocalRef(path_);
curEnv->DeleteLocalRef(prefFile_);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void ScilabPreferences::removeToolboxInfos (JavaVM * jvm_, char const* path){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = initClass(curEnv);
if ( cls == NULL) {
throw GiwsException::JniCallMethodException(curEnv);
}

static jmethodID voidremoveToolboxInfosjstringjava_lang_StringID = curEnv->GetStaticMethodID(cls, "removeToolboxInfos", "(Ljava/lang/String;)V" ) ;
if (voidremoveToolboxInfosjstringjava_lang_StringID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "removeToolboxInfos");
}

jstring path_ = curEnv->NewStringUTF( path );
if (path != NULL && path_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}


                         curEnv->CallStaticVoidMethod(cls, voidremoveToolboxInfosjstringjava_lang_StringID ,path_);
                        curEnv->DeleteLocalRef(path_);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void ScilabPreferences::openPreferences (JavaVM * jvm_){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = initClass(curEnv);
if ( cls == NULL) {
throw GiwsException::JniCallMethodException(curEnv);
}

static jmethodID voidopenPreferencesID = curEnv->GetStaticMethodID(cls, "openPreferences", "()V" ) ;
if (voidopenPreferencesID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "openPreferences");
}

                         curEnv->CallStaticVoidMethod(cls, voidopenPreferencesID );
                        if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

}
