/*
 * Sentinella
 * http://sentinella.sourceforge.net/
 * Copyright (c) 2009 Carlos Olmedo Escobar <carlos.olmedo.e@gmail.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#ifndef CPU_H_
#define CPU_H_

#include <libsysactivity/libsysactivity.h>
#include <errno.h>
#include <stdlib.h>
#include "AbstractLoopCondition.h"

class CPU : public AbstractLoopCondition {

public:
	CPU(const qint64 msecsLimit, const qint64 interval, const int percentageLimit, const bool bigger);
	~CPU();

protected:
	bool evaluate();

private:
	int percentageLimit;
	bool bigger;
	uint16_t numberOfCPUs;
	struct sa_cpu* cpus;

};

#endif /* CPU_H_ */
