// Copyright 2018 ThousandEyes Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package utils

import (
	"testing"
)

func TestMacColonToDash(t *testing.T) {
	testNormMac := func(givenMac, expectedMac string) {
		if MacColonToDash(givenMac) != expectedMac {
			t.Errorf("Expected: %s\nGot: %s", expectedMac, givenMac)
		}
	}
	testNormMac("ff:ff:ff:ff:ff:ff", "ff-ff-ff-ff-ff-ff")
	testNormMac("ff-ff-ff-ff-ff-ff", "ff-ff-ff-ff-ff-ff")
}

func TestMacDashToColon(t *testing.T) {
	testNormMac := func(givenMac, expectedMac string) {
		if MacDashToColon(givenMac) != expectedMac {
			t.Errorf("Expected: %s\nGot: %s", expectedMac, givenMac)
		}
	}
	testNormMac("ff-ff-ff-ff-ff-ff", "ff:ff:ff:ff:ff:ff")
	testNormMac("ff.ff.ff.ff.ff.ff", "ff.ff.ff.ff.ff.ff")
}
