2.4 Dauer und Hüllkurven

# Dauer und Hüllkurven

Wie wir schon vorher gesehen haben, können wir mit dem `sleep`-Kommando 
steuern, wann ein Klang zu spielen anfängt. Bislang konnten wir aber 
noch nicht die Dauer eines Klangs steuern (außer bei Samples, die wir 
strecken oder verdichten können).

Um die *Dauer von Klängen* auf einfache, aber tiefgehende Weise zu 
beeinflussen, bietet Sonic Pi das Prinzip der *ADSR-Hüllkurve* [^6]. 
(Wir werden später sehen, was ADSR genau bedeutet). Eine Hüllkurve 
hat zwei nutzbringende Eigenschaften:

* Kontrolle über die Dauer eines Klangs
* Kontrolle über die Amplitude (Lautstärke) eines Klangs

## Dauer

Die Dauer bestimmt, wie lange ein Klang klingt. Eine erhöhte Dauer 
bedeutet, dass Du den Klang länger hören kannst. Alle Klänge in Sonic 
Pi haben eine Hüllkurve, die beeinflusst werden kann, und die gesamte 
Dauer dieser Hüllkurve bestimmt die Dauer des Klangs. Deshalb kann man 
über die Kontrolle der Hüllkurve die Dauer des Klangs beeinflussen.
 
## Amplitude

Die ADSR-Hüllkurve kontrolliert nicht nur die Dauer, sondern ermöglicht 
Dir auch die *genaue Kontrolle über die Amplitude eines Klangs*. Alle 
Klänge beginnen und enden mit Stille; dazwischen ist irgendetwas 
hörbar. Hüllkurven erlauben Dir, die Amplitude der hörbaren Anteile des 
Klanges zu verschieben, zu verlängern und zu verkürzen. Es ist so, als 
würdest Du jemanden sagen, wie er die Lautstärke einer Musik lauter und 
leiser dreht. Du könntest denjenigen z.B. bitten: "Fang bitte mit einer 
Stille an, dreh dann die Lautstärke langsam bis zum Anschlag hoch, 
lass es eine Weile so und blende dann schnell runter, bis man nichts 
mehr hört". Genau dafür sind in Sonic Pi die Hüllkurven da.

Wie wir vorher schon gesehen haben, bedeutet eine Amplitude von 0 
Stille und eine Amplitude von 1 entspricht der normalen Lautstärke.

## Release-Zeit

Standardmäßig haben alle Synths eine Release-Zeit von der Länge 1. Das 
bedeutet, sie haben eine Dauer von 1 Schlagzeit (die in der Grundeinstellung
1 Sekunde lang ist), bevor sie verklungen  sind. Über das das
`release`-Argument der Funktion `play` können wir diese Dauer verändern.
Damit ein Synth 2 Schläge lang spielt, übergeben wir z.B. einen
`release` von `2`:

```
play 60, release: 2
```

Mit einer sehr kurzen Release-Zeit können wir den
Synth-Klang auch sehr kurz machen:

```
play 60, release: 0.2
```

Also was ist nun die Release-Zeit? Es ist die Zeit, die der Klang 
braucht, um von der vollen Höhe der Kurve (typischerweise der Wert 1) 
bis auf Null abzufallen. Das nennt man auch die *Release-Phase* und es 
ist ein linearer Übergang (d.h. eine gerade Linie). Die folgende 
Abbildung zeigt, wie ein solcher Übergang aussieht:

![release envelope](../images/tutorial/env-release.png)

Die senkrechte Linie ganz links im Bild zeigt, dass der Klang mit einer 
Amplitude von 0 startet, jedoch sofort auf die volle Höhe geht (das ist 
die Attack-Phase, die wir gleich ansehen werden). Wenn die volle Höhe 
erreicht ist, geht die Amplitude in einer geraden Linie bis auf Null 
zurück, wobei dies so lange dauert, wie es mit `release` festgelegt 
wurde. *Je länger die Release-Zeit eines Synth, desto länger klingt 
dieser aus.*

Deshalb kannst Du die Länge eines Klangs ändern, wenn Du seine 
Release-Zeit änderst. Spiele einmal mit unterschiedlichen Release-Zeiten 
herum.

## Attack-Zeit

Standardmäßig ist die Attack-Phase für alle Synths 0, was bedeutet, 
dass diese sofort von der Amplitude 0 auf 1 hochgehen. Dies gibt dem 
Synth einen perkussiven Klang. Vielleicht möchtest Du den Klang jedoch 
einblenden. Dies kannst Du mit dem `attack`-Argument erreichen. Blende 
einige Klänge ein:

```
play 60, attack: 2
sleep 3
play 65, attack: 0.5
```

Du kannst mehrere Argumente zur selben Zeit anwenden. Zum Beispiel für 
eine kurze Attack- und eine lange Release-Zeit:

```
play 60, attack: 0.7, release: 4
```

Diese Hüllkurve mit einem kurzen Attack und langem Release sieht so aus:

![attack release envelope](../images/tutorial/env-attack-release.png)

Natürlich kann man die Dinge auch umdrehen. Versuche einen langen 
Attack und einen kurzen Release:

```
play 60, attack: 4, release: 0.7
```

![long attack short release envelope](../images/tutorial/env-long-attack-short-release.png)

Schließlich kannst Du auch einen kurzen Attack und Release für kürzere 
Klänge verwenden.

```
play 60, attack: 0.5, release: 0.5
```

![short attack short release envelope](../images/tutorial/env-short-attack-short-release.png)

## Sustain-Zeit

Zusätzlich zu den Attack- und Release-Zeiten kannst Du auch die 
Sustain-Zeit bestimmen. Das ist die Zeitdauer, die der Klang anhält, 
wenn er die eingestellte Lautstärke erreicht hat, also zwischen dem 
Attack- und dem Release-Stadium.

```
play 60, attack: 0.3, sustain: 1, release: 1
```

![ASR envelope](../images/tutorial/env-attack-sustain-release.png)

Die Sustain-Zeit kann man gut dafür gebrauchen, um wichtige Klänge in 
einem Mix hervorzuheben, bevor möglicherweise der Release einsetzt. 
Natürlich kann man ohne weiteres sowohl den Attack als auch den Release 
auf 0 setzen und nur den Sustain gebrauchen. Damit bekommt man einen 
Klang ohne Ein- und Ausblendung. Aber vorsicht, ein Release von 0 kann 
Klickgeräusche in der Aufnahme verursachen. Meist ist es besser, 
einen geringen Wert wie z.B. 0.2 zu verwenden.

## Decay-Zeit

Und schließlich, falls Du alles ganz genau beeinflussen möchtest, 
kannst Du noch die Decay-Zeit festlegen. Das ist eine Phase der 
Hüllkurve, die zwischen die Attack- und die Release-Phase passt; sie 
gibt die Zeit an, wo die Amplitude vom `attack_level` zum 
`sustain_level` hinunterfällt. Normalerweise steht das Decay-Argument 
auf 0, während sowohl das Attack- als auch das Sustain-Level auf 1 
stehen. Damit die Decay-Zeit einen hörbaren Effekt hat, müssen Attack
und Sustain also auch angegeben werden:

```
play 60, attack: 0.1, attack_level: 1, decay: 0.2, sustain_level: 0.4, sustain: 1, release: 0.5
```

![ADSR envelope](../images/tutorial/env-attack-decay-sustain-release.png)

## ADSR-Hüllkurven

Fassen wir noch einmal zusammen: Die ADSR-Hüllkurven von Sonic Pi
bestehen aus den folgenden Phasen:

1. *attack* - die Zeit, welche die Amplitude von 0 bis zum `attack_level` benötigt,
2. *decay* - die Zeit, in der die Amplitude vom `attack_level` zum `sustain_level` übergeht,
3. *sustain* - die Zeit, in der sich die Amplitude auf dem `sustain_level` hält,
4. *release* - die Zeit, welche die Amplitude vom `sustain_level` auf 0 bringt

Eins ist wichtig: der Klang dauert so lange wie die Summe aller Zeiten 
der unterschiedlichen Phasen. Deshalb hat der folgende Klang eine Dauer 
von 0.5 + 1 + 2 + 0.5 = 4 Schlägen:

```
play 60, attack: 0.5, decay: 1, sustain_level: 0.4, sustain: 2, release: 0.5
```

Jetzt weisst Du, wie Du Deine Klänge mit Hüllkurven verändern kannst...

[^6]: Der englische Begriff für *Hüllkurve* heißt *Envelope*.

    *ADSR* steht als Kurzform für die Begriffe *Attack*, *Decay*,
    *Sustain* und *Release*, die in diesem Kapitel erklärt werden.
