9.2 Boucles en 'live'

# Boucles en "live"

Ok, ainsi cette section est la véritable perle. Si vous ne lisez qu'une 
section, ce devrait être celle-ci. Si vous avez lu la section 
précédente sur les fondamentaux du codage en "live", `live_loop` est 
une manière simple de faire exactement la même chose mais sans avoir 
tant à écrire.

Si vous n'avez pas lu la section précédente, `live_loop` est la 
meilleure façon d'improviser avec Sonic Pi.

Jouons. Ecrivez le code suivant dans un buffer :

```
live_loop :foo do
  play 60
  sleep 1
end
```

Maintenant pressez le bouton "Run". Vous entendez un beep basique à 
chaque temps. Rien de plaisant pour l'instant. Toutefois, ne pressez 
pas tout de suite le bouton "Stop". Changez le `60` en `65` et pressez 
"Run" à nouveau.

Woah ! Ça a changé *automatiquement* sans manquer un temps. C'est du 
codage en "live".

Pourquoi ne pas le modifier pour ressembler plus à une basse ? Modifiez 
juste votre code pendant que ça joue :

```
live_loop :foo do
  use_synth :prophet
  play :e1, release: 8
  sleep 8
end
```

Puis pressez "Run".

Faisons bouger le cutoff aléatoirement :

```
live_loop :foo do
  use_synth :prophet
  play :e1, release: 8, cutoff: rrand(70, 130)
  sleep 8
end
```

Puis pressez "Run" à nouveau.

Ajoutez de la batterie :

```
live_loop :foo do
  sample :loop_garzul
  use_synth :prophet
  play :e1, release: 8, cutoff: rrand(70, 130)
  sleep 8
end
```

Changez la note de `e1` en `c1` :

```
live_loop :foo do
  sample :loop_garzul
  use_synth :prophet
  play :c1, release: 8, cutoff: rrand(70, 130)
  sleep 8
end
```

Maintenant, arrêtez de me suivre et jouez vous-même ! Prenez du plaisir !
