from pathlib import Path
from typing import TYPE_CHECKING

import numpy as np
from spglib import get_symmetry

if TYPE_CHECKING:
    from conftest import CrystalData

# TODO: Move this to static list
sym_ops_str = """ 1  0  0  0  1  0  0  0  1    0.0000000    0.0000000    0.0000000
-1  0  0  0 -1  0  0  0 -1    0.0000000    0.0000000    0.0000000
 0  0 -1  0  1  0  1  0  0    0.0000000    0.0000000    0.0000000
 0  0  1  0 -1  0 -1  0  0    0.0000000    0.0000000    0.0000000
-1  0  0  0  1  0  0  0 -1    0.0000000    0.0000000    0.0000000
 1  0  0  0 -1  0  0  0  1    0.0000000    0.0000000    0.0000000
 0  0  1  0  1  0 -1  0  0    0.0000000    0.0000000    0.0000000
 0  0 -1  0 -1  0  1  0  0    0.0000000    0.0000000    0.0000000
 1  0  0  0 -1  0  0  0 -1    0.0000000    0.0000000    0.0000000
-1  0  0  0  1  0  0  0  1    0.0000000    0.0000000    0.0000000
 0  0 -1  0 -1  0 -1  0  0    0.0000000    0.0000000    0.0000000
 0  0  1  0  1  0  1  0  0    0.0000000    0.0000000    0.0000000
-1  0  0  0 -1  0  0  0  1    0.0000000    0.0000000    0.0000000
 1  0  0  0  1  0  0  0 -1    0.0000000    0.0000000    0.0000000
 0  0  1  0 -1  0  1  0  0    0.0000000    0.0000000    0.0000000
 0  0 -1  0  1  0 -1  0  0    0.0000000    0.0000000    0.0000000
 0  1  0  0  0  1  1  0  0    0.0000000    0.0000000    0.0000000
 0 -1  0  0  0 -1 -1  0  0    0.0000000    0.0000000    0.0000000
 0  1  0  1  0  0  0  0 -1    0.0000000    0.0000000    0.0000000
 0 -1  0 -1  0  0  0  0  1    0.0000000    0.0000000    0.0000000
 0  1  0  0  0 -1 -1  0  0    0.0000000    0.0000000    0.0000000
 0 -1  0  0  0  1  1  0  0    0.0000000    0.0000000    0.0000000
 0  1  0 -1  0  0  0  0  1    0.0000000    0.0000000    0.0000000
 0 -1  0  1  0  0  0  0 -1    0.0000000    0.0000000    0.0000000
 0 -1  0  0  0 -1  1  0  0    0.0000000    0.0000000    0.0000000
 0  1  0  0  0  1 -1  0  0    0.0000000    0.0000000    0.0000000
 0 -1  0 -1  0  0  0  0 -1    0.0000000    0.0000000    0.0000000
 0  1  0  1  0  0  0  0  1    0.0000000    0.0000000    0.0000000
 0 -1  0  0  0  1 -1  0  0    0.0000000    0.0000000    0.0000000
 0  1  0  0  0 -1  1  0  0    0.0000000    0.0000000    0.0000000
 0 -1  0  1  0  0  0  0  1    0.0000000    0.0000000    0.0000000
 0  1  0 -1  0  0  0  0 -1    0.0000000    0.0000000    0.0000000
 0  0  1  1  0  0  0  1  0    0.0000000    0.0000000    0.0000000
 0  0 -1 -1  0  0  0 -1  0    0.0000000    0.0000000    0.0000000
 1  0  0  0  0 -1  0  1  0    0.0000000    0.0000000    0.0000000
-1  0  0  0  0  1  0 -1  0    0.0000000    0.0000000    0.0000000
 0  0 -1 -1  0  0  0  1  0    0.0000000    0.0000000    0.0000000
 0  0  1  1  0  0  0 -1  0    0.0000000    0.0000000    0.0000000
-1  0  0  0  0  1  0  1  0    0.0000000    0.0000000    0.0000000
 1  0  0  0  0 -1  0 -1  0    0.0000000    0.0000000    0.0000000
 0  0 -1  1  0  0  0 -1  0    0.0000000    0.0000000    0.0000000
 0  0  1 -1  0  0  0  1  0    0.0000000    0.0000000    0.0000000
-1  0  0  0  0 -1  0 -1  0    0.0000000    0.0000000    0.0000000
 1  0  0  0  0  1  0  1  0    0.0000000    0.0000000    0.0000000
 0  0  1 -1  0  0  0 -1  0    0.0000000    0.0000000    0.0000000
 0  0 -1  1  0  0  0  1  0    0.0000000    0.0000000    0.0000000
 1  0  0  0  0  1  0 -1  0    0.0000000    0.0000000    0.0000000
-1  0  0  0  0 -1  0  1  0    0.0000000    0.0000000    0.0000000
 1  0  0  0  1  0  0  0  1    0.7500000    0.7500000    0.0000000
-1  0  0  0 -1  0  0  0 -1    0.7500000    0.7500000    0.0000000
 0  0 -1  0  1  0  1  0  0    0.7500000    0.7500000    0.0000000
 0  0  1  0 -1  0 -1  0  0    0.7500000    0.7500000    0.0000000
-1  0  0  0  1  0  0  0 -1    0.7500000    0.7500000    0.0000000
 1  0  0  0 -1  0  0  0  1    0.7500000    0.7500000    0.0000000
 0  0  1  0  1  0 -1  0  0    0.7500000    0.7500000    0.0000000
 0  0 -1  0 -1  0  1  0  0    0.7500000    0.7500000    0.0000000
 1  0  0  0 -1  0  0  0 -1    0.7500000    0.7500000    0.0000000
-1  0  0  0  1  0  0  0  1    0.7500000    0.7500000    0.0000000
 0  0 -1  0 -1  0 -1  0  0    0.7500000    0.7500000    0.0000000
 0  0  1  0  1  0  1  0  0    0.7500000    0.7500000    0.0000000
-1  0  0  0 -1  0  0  0  1    0.7500000    0.7500000    0.0000000
 1  0  0  0  1  0  0  0 -1    0.7500000    0.7500000    0.0000000
 0  0  1  0 -1  0  1  0  0    0.7500000    0.7500000    0.0000000
 0  0 -1  0  1  0 -1  0  0    0.7500000    0.7500000    0.0000000
 0  1  0  0  0  1  1  0  0    0.7500000    0.7500000    0.0000000
 0 -1  0  0  0 -1 -1  0  0    0.7500000    0.7500000    0.0000000
 0  1  0  1  0  0  0  0 -1    0.7500000    0.7500000    0.0000000
 0 -1  0 -1  0  0  0  0  1    0.7500000    0.7500000    0.0000000
 0  1  0  0  0 -1 -1  0  0    0.7500000    0.7500000    0.0000000
 0 -1  0  0  0  1  1  0  0    0.7500000    0.7500000    0.0000000
 0  1  0 -1  0  0  0  0  1    0.7500000    0.7500000    0.0000000
 0 -1  0  1  0  0  0  0 -1    0.7500000    0.7500000    0.0000000
 0 -1  0  0  0 -1  1  0  0    0.7500000    0.7500000    0.0000000
 0  1  0  0  0  1 -1  0  0    0.7500000    0.7500000    0.0000000
 0 -1  0 -1  0  0  0  0 -1    0.7500000    0.7500000    0.0000000
 0  1  0  1  0  0  0  0  1    0.7500000    0.7500000    0.0000000
 0 -1  0  0  0  1 -1  0  0    0.7500000    0.7500000    0.0000000
 0  1  0  0  0 -1  1  0  0    0.7500000    0.7500000    0.0000000
 0 -1  0  1  0  0  0  0  1    0.7500000    0.7500000    0.0000000
 0  1  0 -1  0  0  0  0 -1    0.7500000    0.7500000    0.0000000
 0  0  1  1  0  0  0  1  0    0.7500000    0.7500000    0.0000000
 0  0 -1 -1  0  0  0 -1  0    0.7500000    0.7500000    0.0000000
 1  0  0  0  0 -1  0  1  0    0.7500000    0.7500000    0.0000000
-1  0  0  0  0  1  0 -1  0    0.7500000    0.7500000    0.0000000
 0  0 -1 -1  0  0  0  1  0    0.7500000    0.7500000    0.0000000
 0  0  1  1  0  0  0 -1  0    0.7500000    0.7500000    0.0000000
-1  0  0  0  0  1  0  1  0    0.7500000    0.7500000    0.0000000
 1  0  0  0  0 -1  0 -1  0    0.7500000    0.7500000    0.0000000
 0  0 -1  1  0  0  0 -1  0    0.7500000    0.7500000    0.0000000
 0  0  1 -1  0  0  0  1  0    0.7500000    0.7500000    0.0000000
-1  0  0  0  0 -1  0 -1  0    0.7500000    0.7500000    0.0000000
 1  0  0  0  0  1  0  1  0    0.7500000    0.7500000    0.0000000
 0  0  1 -1  0  0  0 -1  0    0.7500000    0.7500000    0.0000000
 0  0 -1  1  0  0  0  1  0    0.7500000    0.7500000    0.0000000
 1  0  0  0  0  1  0 -1  0    0.7500000    0.7500000    0.0000000
-1  0  0  0  0 -1  0  1  0    0.7500000    0.7500000    0.0000000
 1  0  0  0  1  0  0  0  1    0.5000000    0.5000000    0.0000000
-1  0  0  0 -1  0  0  0 -1    0.5000000    0.5000000    0.0000000
 0  0 -1  0  1  0  1  0  0    0.5000000    0.5000000    0.0000000
 0  0  1  0 -1  0 -1  0  0    0.5000000    0.5000000    0.0000000
-1  0  0  0  1  0  0  0 -1    0.5000000    0.5000000    0.0000000
 1  0  0  0 -1  0  0  0  1    0.5000000    0.5000000    0.0000000
 0  0  1  0  1  0 -1  0  0    0.5000000    0.5000000    0.0000000
 0  0 -1  0 -1  0  1  0  0    0.5000000    0.5000000    0.0000000
 1  0  0  0 -1  0  0  0 -1    0.5000000    0.5000000    0.0000000
-1  0  0  0  1  0  0  0  1    0.5000000    0.5000000    0.0000000
 0  0 -1  0 -1  0 -1  0  0    0.5000000    0.5000000    0.0000000
 0  0  1  0  1  0  1  0  0    0.5000000    0.5000000    0.0000000
-1  0  0  0 -1  0  0  0  1    0.5000000    0.5000000    0.0000000
 1  0  0  0  1  0  0  0 -1    0.5000000    0.5000000    0.0000000
 0  0  1  0 -1  0  1  0  0    0.5000000    0.5000000    0.0000000
 0  0 -1  0  1  0 -1  0  0    0.5000000    0.5000000    0.0000000
 0  1  0  0  0  1  1  0  0    0.5000000    0.5000000    0.0000000
 0 -1  0  0  0 -1 -1  0  0    0.5000000    0.5000000    0.0000000
 0  1  0  1  0  0  0  0 -1    0.5000000    0.5000000    0.0000000
 0 -1  0 -1  0  0  0  0  1    0.5000000    0.5000000    0.0000000
 0  1  0  0  0 -1 -1  0  0    0.5000000    0.5000000    0.0000000
 0 -1  0  0  0  1  1  0  0    0.5000000    0.5000000    0.0000000
 0  1  0 -1  0  0  0  0  1    0.5000000    0.5000000    0.0000000
 0 -1  0  1  0  0  0  0 -1    0.5000000    0.5000000    0.0000000
 0 -1  0  0  0 -1  1  0  0    0.5000000    0.5000000    0.0000000
 0  1  0  0  0  1 -1  0  0    0.5000000    0.5000000    0.0000000
 0 -1  0 -1  0  0  0  0 -1    0.5000000    0.5000000    0.0000000
 0  1  0  1  0  0  0  0  1    0.5000000    0.5000000    0.0000000
 0 -1  0  0  0  1 -1  0  0    0.5000000    0.5000000    0.0000000
 0  1  0  0  0 -1  1  0  0    0.5000000    0.5000000    0.0000000
 0 -1  0  1  0  0  0  0  1    0.5000000    0.5000000    0.0000000
 0  1  0 -1  0  0  0  0 -1    0.5000000    0.5000000    0.0000000
 0  0  1  1  0  0  0  1  0    0.5000000    0.5000000    0.0000000
 0  0 -1 -1  0  0  0 -1  0    0.5000000    0.5000000    0.0000000
 1  0  0  0  0 -1  0  1  0    0.5000000    0.5000000    0.0000000
-1  0  0  0  0  1  0 -1  0    0.5000000    0.5000000    0.0000000
 0  0 -1 -1  0  0  0  1  0    0.5000000    0.5000000    0.0000000
 0  0  1  1  0  0  0 -1  0    0.5000000    0.5000000    0.0000000
-1  0  0  0  0  1  0  1  0    0.5000000    0.5000000    0.0000000
 1  0  0  0  0 -1  0 -1  0    0.5000000    0.5000000    0.0000000
 0  0 -1  1  0  0  0 -1  0    0.5000000    0.5000000    0.0000000
 0  0  1 -1  0  0  0  1  0    0.5000000    0.5000000    0.0000000
-1  0  0  0  0 -1  0 -1  0    0.5000000    0.5000000    0.0000000
 1  0  0  0  0  1  0  1  0    0.5000000    0.5000000    0.0000000
 0  0  1 -1  0  0  0 -1  0    0.5000000    0.5000000    0.0000000
 0  0 -1  1  0  0  0  1  0    0.5000000    0.5000000    0.0000000
 1  0  0  0  0  1  0 -1  0    0.5000000    0.5000000    0.0000000
-1  0  0  0  0 -1  0  1  0    0.5000000    0.5000000    0.0000000
 1  0  0  0  1  0  0  0  1    0.2500000    0.2500000    0.0000000
-1  0  0  0 -1  0  0  0 -1    0.2500000    0.2500000    0.0000000
 0  0 -1  0  1  0  1  0  0    0.2500000    0.2500000    0.0000000
 0  0  1  0 -1  0 -1  0  0    0.2500000    0.2500000    0.0000000
-1  0  0  0  1  0  0  0 -1    0.2500000    0.2500000    0.0000000
 1  0  0  0 -1  0  0  0  1    0.2500000    0.2500000    0.0000000
 0  0  1  0  1  0 -1  0  0    0.2500000    0.2500000    0.0000000
 0  0 -1  0 -1  0  1  0  0    0.2500000    0.2500000    0.0000000
 1  0  0  0 -1  0  0  0 -1    0.2500000    0.2500000    0.0000000
-1  0  0  0  1  0  0  0  1    0.2500000    0.2500000    0.0000000
 0  0 -1  0 -1  0 -1  0  0    0.2500000    0.2500000    0.0000000
 0  0  1  0  1  0  1  0  0    0.2500000    0.2500000    0.0000000
-1  0  0  0 -1  0  0  0  1    0.2500000    0.2500000    0.0000000
 1  0  0  0  1  0  0  0 -1    0.2500000    0.2500000    0.0000000
 0  0  1  0 -1  0  1  0  0    0.2500000    0.2500000    0.0000000
 0  0 -1  0  1  0 -1  0  0    0.2500000    0.2500000    0.0000000
 0  1  0  0  0  1  1  0  0    0.2500000    0.2500000    0.0000000
 0 -1  0  0  0 -1 -1  0  0    0.2500000    0.2500000    0.0000000
 0  1  0  1  0  0  0  0 -1    0.2500000    0.2500000    0.0000000
 0 -1  0 -1  0  0  0  0  1    0.2500000    0.2500000    0.0000000
 0  1  0  0  0 -1 -1  0  0    0.2500000    0.2500000    0.0000000
 0 -1  0  0  0  1  1  0  0    0.2500000    0.2500000    0.0000000
 0  1  0 -1  0  0  0  0  1    0.2500000    0.2500000    0.0000000
 0 -1  0  1  0  0  0  0 -1    0.2500000    0.2500000    0.0000000
 0 -1  0  0  0 -1  1  0  0    0.2500000    0.2500000    0.0000000
 0  1  0  0  0  1 -1  0  0    0.2500000    0.2500000    0.0000000
 0 -1  0 -1  0  0  0  0 -1    0.2500000    0.2500000    0.0000000
 0  1  0  1  0  0  0  0  1    0.2500000    0.2500000    0.0000000
 0 -1  0  0  0  1 -1  0  0    0.2500000    0.2500000    0.0000000
 0  1  0  0  0 -1  1  0  0    0.2500000    0.2500000    0.0000000
 0 -1  0  1  0  0  0  0  1    0.2500000    0.2500000    0.0000000
 0  1  0 -1  0  0  0  0 -1    0.2500000    0.2500000    0.0000000
 0  0  1  1  0  0  0  1  0    0.2500000    0.2500000    0.0000000
 0  0 -1 -1  0  0  0 -1  0    0.2500000    0.2500000    0.0000000
 1  0  0  0  0 -1  0  1  0    0.2500000    0.2500000    0.0000000
-1  0  0  0  0  1  0 -1  0    0.2500000    0.2500000    0.0000000
 0  0 -1 -1  0  0  0  1  0    0.2500000    0.2500000    0.0000000
 0  0  1  1  0  0  0 -1  0    0.2500000    0.2500000    0.0000000
-1  0  0  0  0  1  0  1  0    0.2500000    0.2500000    0.0000000
 1  0  0  0  0 -1  0 -1  0    0.2500000    0.2500000    0.0000000
 0  0 -1  1  0  0  0 -1  0    0.2500000    0.2500000    0.0000000
 0  0  1 -1  0  0  0  1  0    0.2500000    0.2500000    0.0000000
-1  0  0  0  0 -1  0 -1  0    0.2500000    0.2500000    0.0000000
 1  0  0  0  0  1  0  1  0    0.2500000    0.2500000    0.0000000
 0  0  1 -1  0  0  0 -1  0    0.2500000    0.2500000    0.0000000
 0  0 -1  1  0  0  0  1  0    0.2500000    0.2500000    0.0000000
 1  0  0  0  0  1  0 -1  0    0.2500000    0.2500000    0.0000000
-1  0  0  0  0 -1  0  1  0    0.2500000    0.2500000    0.0000000
 1  0  0  0  1  0  0  0  1    0.2500000    0.0000000    0.7500000
-1  0  0  0 -1  0  0  0 -1    0.2500000    0.0000000    0.7500000
 0  0 -1  0  1  0  1  0  0    0.2500000    0.0000000    0.7500000
 0  0  1  0 -1  0 -1  0  0    0.2500000    0.0000000    0.7500000
-1  0  0  0  1  0  0  0 -1    0.2500000    0.0000000    0.7500000
 1  0  0  0 -1  0  0  0  1    0.2500000    0.0000000    0.7500000
 0  0  1  0  1  0 -1  0  0    0.2500000    0.0000000    0.7500000
 0  0 -1  0 -1  0  1  0  0    0.2500000    0.0000000    0.7500000
 1  0  0  0 -1  0  0  0 -1    0.2500000    0.0000000    0.7500000
-1  0  0  0  1  0  0  0  1    0.2500000    0.0000000    0.7500000
 0  0 -1  0 -1  0 -1  0  0    0.2500000    0.0000000    0.7500000
 0  0  1  0  1  0  1  0  0    0.2500000    0.0000000    0.7500000
-1  0  0  0 -1  0  0  0  1    0.2500000    0.0000000    0.7500000
 1  0  0  0  1  0  0  0 -1    0.2500000    0.0000000    0.7500000
 0  0  1  0 -1  0  1  0  0    0.2500000    0.0000000    0.7500000
 0  0 -1  0  1  0 -1  0  0    0.2500000    0.0000000    0.7500000
 0  1  0  0  0  1  1  0  0    0.2500000    0.0000000    0.7500000
 0 -1  0  0  0 -1 -1  0  0    0.2500000    0.0000000    0.7500000
 0  1  0  1  0  0  0  0 -1    0.2500000    0.0000000    0.7500000
 0 -1  0 -1  0  0  0  0  1    0.2500000    0.0000000    0.7500000
 0  1  0  0  0 -1 -1  0  0    0.2500000    0.0000000    0.7500000
 0 -1  0  0  0  1  1  0  0    0.2500000    0.0000000    0.7500000
 0  1  0 -1  0  0  0  0  1    0.2500000    0.0000000    0.7500000
 0 -1  0  1  0  0  0  0 -1    0.2500000    0.0000000    0.7500000
 0 -1  0  0  0 -1  1  0  0    0.2500000    0.0000000    0.7500000
 0  1  0  0  0  1 -1  0  0    0.2500000    0.0000000    0.7500000
 0 -1  0 -1  0  0  0  0 -1    0.2500000    0.0000000    0.7500000
 0  1  0  1  0  0  0  0  1    0.2500000    0.0000000    0.7500000
 0 -1  0  0  0  1 -1  0  0    0.2500000    0.0000000    0.7500000
 0  1  0  0  0 -1  1  0  0    0.2500000    0.0000000    0.7500000
 0 -1  0  1  0  0  0  0  1    0.2500000    0.0000000    0.7500000
 0  1  0 -1  0  0  0  0 -1    0.2500000    0.0000000    0.7500000
 0  0  1  1  0  0  0  1  0    0.2500000    0.0000000    0.7500000
 0  0 -1 -1  0  0  0 -1  0    0.2500000    0.0000000    0.7500000
 1  0  0  0  0 -1  0  1  0    0.2500000    0.0000000    0.7500000
-1  0  0  0  0  1  0 -1  0    0.2500000    0.0000000    0.7500000
 0  0 -1 -1  0  0  0  1  0    0.2500000    0.0000000    0.7500000
 0  0  1  1  0  0  0 -1  0    0.2500000    0.0000000    0.7500000
-1  0  0  0  0  1  0  1  0    0.2500000    0.0000000    0.7500000
 1  0  0  0  0 -1  0 -1  0    0.2500000    0.0000000    0.7500000
 0  0 -1  1  0  0  0 -1  0    0.2500000    0.0000000    0.7500000
 0  0  1 -1  0  0  0  1  0    0.2500000    0.0000000    0.7500000
-1  0  0  0  0 -1  0 -1  0    0.2500000    0.0000000    0.7500000
 1  0  0  0  0  1  0  1  0    0.2500000    0.0000000    0.7500000
 0  0  1 -1  0  0  0 -1  0    0.2500000    0.0000000    0.7500000
 0  0 -1  1  0  0  0  1  0    0.2500000    0.0000000    0.7500000
 1  0  0  0  0  1  0 -1  0    0.2500000    0.0000000    0.7500000
-1  0  0  0  0 -1  0  1  0    0.2500000    0.0000000    0.7500000
 1  0  0  0  1  0  0  0  1    0.0000000    0.7500000    0.7500000
-1  0  0  0 -1  0  0  0 -1    0.0000000    0.7500000    0.7500000
 0  0 -1  0  1  0  1  0  0    0.0000000    0.7500000    0.7500000
 0  0  1  0 -1  0 -1  0  0    0.0000000    0.7500000    0.7500000
-1  0  0  0  1  0  0  0 -1    0.0000000    0.7500000    0.7500000
 1  0  0  0 -1  0  0  0  1    0.0000000    0.7500000    0.7500000
 0  0  1  0  1  0 -1  0  0    0.0000000    0.7500000    0.7500000
 0  0 -1  0 -1  0  1  0  0    0.0000000    0.7500000    0.7500000
 1  0  0  0 -1  0  0  0 -1    0.0000000    0.7500000    0.7500000
-1  0  0  0  1  0  0  0  1    0.0000000    0.7500000    0.7500000
 0  0 -1  0 -1  0 -1  0  0    0.0000000    0.7500000    0.7500000
 0  0  1  0  1  0  1  0  0    0.0000000    0.7500000    0.7500000
-1  0  0  0 -1  0  0  0  1    0.0000000    0.7500000    0.7500000
 1  0  0  0  1  0  0  0 -1    0.0000000    0.7500000    0.7500000
 0  0  1  0 -1  0  1  0  0    0.0000000    0.7500000    0.7500000
 0  0 -1  0  1  0 -1  0  0    0.0000000    0.7500000    0.7500000
 0  1  0  0  0  1  1  0  0    0.0000000    0.7500000    0.7500000
 0 -1  0  0  0 -1 -1  0  0    0.0000000    0.7500000    0.7500000
 0  1  0  1  0  0  0  0 -1    0.0000000    0.7500000    0.7500000
 0 -1  0 -1  0  0  0  0  1    0.0000000    0.7500000    0.7500000
 0  1  0  0  0 -1 -1  0  0    0.0000000    0.7500000    0.7500000
 0 -1  0  0  0  1  1  0  0    0.0000000    0.7500000    0.7500000
 0  1  0 -1  0  0  0  0  1    0.0000000    0.7500000    0.7500000
 0 -1  0  1  0  0  0  0 -1    0.0000000    0.7500000    0.7500000
 0 -1  0  0  0 -1  1  0  0    0.0000000    0.7500000    0.7500000
 0  1  0  0  0  1 -1  0  0    0.0000000    0.7500000    0.7500000
 0 -1  0 -1  0  0  0  0 -1    0.0000000    0.7500000    0.7500000
 0  1  0  1  0  0  0  0  1    0.0000000    0.7500000    0.7500000
 0 -1  0  0  0  1 -1  0  0    0.0000000    0.7500000    0.7500000
 0  1  0  0  0 -1  1  0  0    0.0000000    0.7500000    0.7500000
 0 -1  0  1  0  0  0  0  1    0.0000000    0.7500000    0.7500000
 0  1  0 -1  0  0  0  0 -1    0.0000000    0.7500000    0.7500000
 0  0  1  1  0  0  0  1  0    0.0000000    0.7500000    0.7500000
 0  0 -1 -1  0  0  0 -1  0    0.0000000    0.7500000    0.7500000
 1  0  0  0  0 -1  0  1  0    0.0000000    0.7500000    0.7500000
-1  0  0  0  0  1  0 -1  0    0.0000000    0.7500000    0.7500000
 0  0 -1 -1  0  0  0  1  0    0.0000000    0.7500000    0.7500000
 0  0  1  1  0  0  0 -1  0    0.0000000    0.7500000    0.7500000
-1  0  0  0  0  1  0  1  0    0.0000000    0.7500000    0.7500000
 1  0  0  0  0 -1  0 -1  0    0.0000000    0.7500000    0.7500000
 0  0 -1  1  0  0  0 -1  0    0.0000000    0.7500000    0.7500000
 0  0  1 -1  0  0  0  1  0    0.0000000    0.7500000    0.7500000
-1  0  0  0  0 -1  0 -1  0    0.0000000    0.7500000    0.7500000
 1  0  0  0  0  1  0  1  0    0.0000000    0.7500000    0.7500000
 0  0  1 -1  0  0  0 -1  0    0.0000000    0.7500000    0.7500000
 0  0 -1  1  0  0  0  1  0    0.0000000    0.7500000    0.7500000
 1  0  0  0  0  1  0 -1  0    0.0000000    0.7500000    0.7500000
-1  0  0  0  0 -1  0  1  0    0.0000000    0.7500000    0.7500000
 1  0  0  0  1  0  0  0  1    0.7500000    0.5000000    0.7500000
-1  0  0  0 -1  0  0  0 -1    0.7500000    0.5000000    0.7500000
 0  0 -1  0  1  0  1  0  0    0.7500000    0.5000000    0.7500000
 0  0  1  0 -1  0 -1  0  0    0.7500000    0.5000000    0.7500000
-1  0  0  0  1  0  0  0 -1    0.7500000    0.5000000    0.7500000
 1  0  0  0 -1  0  0  0  1    0.7500000    0.5000000    0.7500000
 0  0  1  0  1  0 -1  0  0    0.7500000    0.5000000    0.7500000
 0  0 -1  0 -1  0  1  0  0    0.7500000    0.5000000    0.7500000
 1  0  0  0 -1  0  0  0 -1    0.7500000    0.5000000    0.7500000
-1  0  0  0  1  0  0  0  1    0.7500000    0.5000000    0.7500000
 0  0 -1  0 -1  0 -1  0  0    0.7500000    0.5000000    0.7500000
 0  0  1  0  1  0  1  0  0    0.7500000    0.5000000    0.7500000
-1  0  0  0 -1  0  0  0  1    0.7500000    0.5000000    0.7500000
 1  0  0  0  1  0  0  0 -1    0.7500000    0.5000000    0.7500000
 0  0  1  0 -1  0  1  0  0    0.7500000    0.5000000    0.7500000
 0  0 -1  0  1  0 -1  0  0    0.7500000    0.5000000    0.7500000
 0  1  0  0  0  1  1  0  0    0.7500000    0.5000000    0.7500000
 0 -1  0  0  0 -1 -1  0  0    0.7500000    0.5000000    0.7500000
 0  1  0  1  0  0  0  0 -1    0.7500000    0.5000000    0.7500000
 0 -1  0 -1  0  0  0  0  1    0.7500000    0.5000000    0.7500000
 0  1  0  0  0 -1 -1  0  0    0.7500000    0.5000000    0.7500000
 0 -1  0  0  0  1  1  0  0    0.7500000    0.5000000    0.7500000
 0  1  0 -1  0  0  0  0  1    0.7500000    0.5000000    0.7500000
 0 -1  0  1  0  0  0  0 -1    0.7500000    0.5000000    0.7500000
 0 -1  0  0  0 -1  1  0  0    0.7500000    0.5000000    0.7500000
 0  1  0  0  0  1 -1  0  0    0.7500000    0.5000000    0.7500000
 0 -1  0 -1  0  0  0  0 -1    0.7500000    0.5000000    0.7500000
 0  1  0  1  0  0  0  0  1    0.7500000    0.5000000    0.7500000
 0 -1  0  0  0  1 -1  0  0    0.7500000    0.5000000    0.7500000
 0  1  0  0  0 -1  1  0  0    0.7500000    0.5000000    0.7500000
 0 -1  0  1  0  0  0  0  1    0.7500000    0.5000000    0.7500000
 0  1  0 -1  0  0  0  0 -1    0.7500000    0.5000000    0.7500000
 0  0  1  1  0  0  0  1  0    0.7500000    0.5000000    0.7500000
 0  0 -1 -1  0  0  0 -1  0    0.7500000    0.5000000    0.7500000
 1  0  0  0  0 -1  0  1  0    0.7500000    0.5000000    0.7500000
-1  0  0  0  0  1  0 -1  0    0.7500000    0.5000000    0.7500000
 0  0 -1 -1  0  0  0  1  0    0.7500000    0.5000000    0.7500000
 0  0  1  1  0  0  0 -1  0    0.7500000    0.5000000    0.7500000
-1  0  0  0  0  1  0  1  0    0.7500000    0.5000000    0.7500000
 1  0  0  0  0 -1  0 -1  0    0.7500000    0.5000000    0.7500000
 0  0 -1  1  0  0  0 -1  0    0.7500000    0.5000000    0.7500000
 0  0  1 -1  0  0  0  1  0    0.7500000    0.5000000    0.7500000
-1  0  0  0  0 -1  0 -1  0    0.7500000    0.5000000    0.7500000
 1  0  0  0  0  1  0  1  0    0.7500000    0.5000000    0.7500000
 0  0  1 -1  0  0  0 -1  0    0.7500000    0.5000000    0.7500000
 0  0 -1  1  0  0  0  1  0    0.7500000    0.5000000    0.7500000
 1  0  0  0  0  1  0 -1  0    0.7500000    0.5000000    0.7500000
-1  0  0  0  0 -1  0  1  0    0.7500000    0.5000000    0.7500000
 1  0  0  0  1  0  0  0  1    0.5000000    0.2500000    0.7500000
-1  0  0  0 -1  0  0  0 -1    0.5000000    0.2500000    0.7500000
 0  0 -1  0  1  0  1  0  0    0.5000000    0.2500000    0.7500000
 0  0  1  0 -1  0 -1  0  0    0.5000000    0.2500000    0.7500000
-1  0  0  0  1  0  0  0 -1    0.5000000    0.2500000    0.7500000
 1  0  0  0 -1  0  0  0  1    0.5000000    0.2500000    0.7500000
 0  0  1  0  1  0 -1  0  0    0.5000000    0.2500000    0.7500000
 0  0 -1  0 -1  0  1  0  0    0.5000000    0.2500000    0.7500000
 1  0  0  0 -1  0  0  0 -1    0.5000000    0.2500000    0.7500000
-1  0  0  0  1  0  0  0  1    0.5000000    0.2500000    0.7500000
 0  0 -1  0 -1  0 -1  0  0    0.5000000    0.2500000    0.7500000
 0  0  1  0  1  0  1  0  0    0.5000000    0.2500000    0.7500000
-1  0  0  0 -1  0  0  0  1    0.5000000    0.2500000    0.7500000
 1  0  0  0  1  0  0  0 -1    0.5000000    0.2500000    0.7500000
 0  0  1  0 -1  0  1  0  0    0.5000000    0.2500000    0.7500000
 0  0 -1  0  1  0 -1  0  0    0.5000000    0.2500000    0.7500000
 0  1  0  0  0  1  1  0  0    0.5000000    0.2500000    0.7500000
 0 -1  0  0  0 -1 -1  0  0    0.5000000    0.2500000    0.7500000
 0  1  0  1  0  0  0  0 -1    0.5000000    0.2500000    0.7500000
 0 -1  0 -1  0  0  0  0  1    0.5000000    0.2500000    0.7500000
 0  1  0  0  0 -1 -1  0  0    0.5000000    0.2500000    0.7500000
 0 -1  0  0  0  1  1  0  0    0.5000000    0.2500000    0.7500000
 0  1  0 -1  0  0  0  0  1    0.5000000    0.2500000    0.7500000
 0 -1  0  1  0  0  0  0 -1    0.5000000    0.2500000    0.7500000
 0 -1  0  0  0 -1  1  0  0    0.5000000    0.2500000    0.7500000
 0  1  0  0  0  1 -1  0  0    0.5000000    0.2500000    0.7500000
 0 -1  0 -1  0  0  0  0 -1    0.5000000    0.2500000    0.7500000
 0  1  0  1  0  0  0  0  1    0.5000000    0.2500000    0.7500000
 0 -1  0  0  0  1 -1  0  0    0.5000000    0.2500000    0.7500000
 0  1  0  0  0 -1  1  0  0    0.5000000    0.2500000    0.7500000
 0 -1  0  1  0  0  0  0  1    0.5000000    0.2500000    0.7500000
 0  1  0 -1  0  0  0  0 -1    0.5000000    0.2500000    0.7500000
 0  0  1  1  0  0  0  1  0    0.5000000    0.2500000    0.7500000
 0  0 -1 -1  0  0  0 -1  0    0.5000000    0.2500000    0.7500000
 1  0  0  0  0 -1  0  1  0    0.5000000    0.2500000    0.7500000
-1  0  0  0  0  1  0 -1  0    0.5000000    0.2500000    0.7500000
 0  0 -1 -1  0  0  0  1  0    0.5000000    0.2500000    0.7500000
 0  0  1  1  0  0  0 -1  0    0.5000000    0.2500000    0.7500000
-1  0  0  0  0  1  0  1  0    0.5000000    0.2500000    0.7500000
 1  0  0  0  0 -1  0 -1  0    0.5000000    0.2500000    0.7500000
 0  0 -1  1  0  0  0 -1  0    0.5000000    0.2500000    0.7500000
 0  0  1 -1  0  0  0  1  0    0.5000000    0.2500000    0.7500000
-1  0  0  0  0 -1  0 -1  0    0.5000000    0.2500000    0.7500000
 1  0  0  0  0  1  0  1  0    0.5000000    0.2500000    0.7500000
 0  0  1 -1  0  0  0 -1  0    0.5000000    0.2500000    0.7500000
 0  0 -1  1  0  0  0  1  0    0.5000000    0.2500000    0.7500000
 1  0  0  0  0  1  0 -1  0    0.5000000    0.2500000    0.7500000
-1  0  0  0  0 -1  0  1  0    0.5000000    0.2500000    0.7500000
 1  0  0  0  1  0  0  0  1    0.5000000    0.0000000    0.5000000
-1  0  0  0 -1  0  0  0 -1    0.5000000    0.0000000    0.5000000
 0  0 -1  0  1  0  1  0  0    0.5000000    0.0000000    0.5000000
 0  0  1  0 -1  0 -1  0  0    0.5000000    0.0000000    0.5000000
-1  0  0  0  1  0  0  0 -1    0.5000000    0.0000000    0.5000000
 1  0  0  0 -1  0  0  0  1    0.5000000    0.0000000    0.5000000
 0  0  1  0  1  0 -1  0  0    0.5000000    0.0000000    0.5000000
 0  0 -1  0 -1  0  1  0  0    0.5000000    0.0000000    0.5000000
 1  0  0  0 -1  0  0  0 -1    0.5000000    0.0000000    0.5000000
-1  0  0  0  1  0  0  0  1    0.5000000    0.0000000    0.5000000
 0  0 -1  0 -1  0 -1  0  0    0.5000000    0.0000000    0.5000000
 0  0  1  0  1  0  1  0  0    0.5000000    0.0000000    0.5000000
-1  0  0  0 -1  0  0  0  1    0.5000000    0.0000000    0.5000000
 1  0  0  0  1  0  0  0 -1    0.5000000    0.0000000    0.5000000
 0  0  1  0 -1  0  1  0  0    0.5000000    0.0000000    0.5000000
 0  0 -1  0  1  0 -1  0  0    0.5000000    0.0000000    0.5000000
 0  1  0  0  0  1  1  0  0    0.5000000    0.0000000    0.5000000
 0 -1  0  0  0 -1 -1  0  0    0.5000000    0.0000000    0.5000000
 0  1  0  1  0  0  0  0 -1    0.5000000    0.0000000    0.5000000
 0 -1  0 -1  0  0  0  0  1    0.5000000    0.0000000    0.5000000
 0  1  0  0  0 -1 -1  0  0    0.5000000    0.0000000    0.5000000
 0 -1  0  0  0  1  1  0  0    0.5000000    0.0000000    0.5000000
 0  1  0 -1  0  0  0  0  1    0.5000000    0.0000000    0.5000000
 0 -1  0  1  0  0  0  0 -1    0.5000000    0.0000000    0.5000000
 0 -1  0  0  0 -1  1  0  0    0.5000000    0.0000000    0.5000000
 0  1  0  0  0  1 -1  0  0    0.5000000    0.0000000    0.5000000
 0 -1  0 -1  0  0  0  0 -1    0.5000000    0.0000000    0.5000000
 0  1  0  1  0  0  0  0  1    0.5000000    0.0000000    0.5000000
 0 -1  0  0  0  1 -1  0  0    0.5000000    0.0000000    0.5000000
 0  1  0  0  0 -1  1  0  0    0.5000000    0.0000000    0.5000000
 0 -1  0  1  0  0  0  0  1    0.5000000    0.0000000    0.5000000
 0  1  0 -1  0  0  0  0 -1    0.5000000    0.0000000    0.5000000
 0  0  1  1  0  0  0  1  0    0.5000000    0.0000000    0.5000000
 0  0 -1 -1  0  0  0 -1  0    0.5000000    0.0000000    0.5000000
 1  0  0  0  0 -1  0  1  0    0.5000000    0.0000000    0.5000000
-1  0  0  0  0  1  0 -1  0    0.5000000    0.0000000    0.5000000
 0  0 -1 -1  0  0  0  1  0    0.5000000    0.0000000    0.5000000
 0  0  1  1  0  0  0 -1  0    0.5000000    0.0000000    0.5000000
-1  0  0  0  0  1  0  1  0    0.5000000    0.0000000    0.5000000
 1  0  0  0  0 -1  0 -1  0    0.5000000    0.0000000    0.5000000
 0  0 -1  1  0  0  0 -1  0    0.5000000    0.0000000    0.5000000
 0  0  1 -1  0  0  0  1  0    0.5000000    0.0000000    0.5000000
-1  0  0  0  0 -1  0 -1  0    0.5000000    0.0000000    0.5000000
 1  0  0  0  0  1  0  1  0    0.5000000    0.0000000    0.5000000
 0  0  1 -1  0  0  0 -1  0    0.5000000    0.0000000    0.5000000
 0  0 -1  1  0  0  0  1  0    0.5000000    0.0000000    0.5000000
 1  0  0  0  0  1  0 -1  0    0.5000000    0.0000000    0.5000000
-1  0  0  0  0 -1  0  1  0    0.5000000    0.0000000    0.5000000
 1  0  0  0  1  0  0  0  1    0.2500000    0.7500000    0.5000000
-1  0  0  0 -1  0  0  0 -1    0.2500000    0.7500000    0.5000000
 0  0 -1  0  1  0  1  0  0    0.2500000    0.7500000    0.5000000
 0  0  1  0 -1  0 -1  0  0    0.2500000    0.7500000    0.5000000
-1  0  0  0  1  0  0  0 -1    0.2500000    0.7500000    0.5000000
 1  0  0  0 -1  0  0  0  1    0.2500000    0.7500000    0.5000000
 0  0  1  0  1  0 -1  0  0    0.2500000    0.7500000    0.5000000
 0  0 -1  0 -1  0  1  0  0    0.2500000    0.7500000    0.5000000
 1  0  0  0 -1  0  0  0 -1    0.2500000    0.7500000    0.5000000
-1  0  0  0  1  0  0  0  1    0.2500000    0.7500000    0.5000000
 0  0 -1  0 -1  0 -1  0  0    0.2500000    0.7500000    0.5000000
 0  0  1  0  1  0  1  0  0    0.2500000    0.7500000    0.5000000
-1  0  0  0 -1  0  0  0  1    0.2500000    0.7500000    0.5000000
 1  0  0  0  1  0  0  0 -1    0.2500000    0.7500000    0.5000000
 0  0  1  0 -1  0  1  0  0    0.2500000    0.7500000    0.5000000
 0  0 -1  0  1  0 -1  0  0    0.2500000    0.7500000    0.5000000
 0  1  0  0  0  1  1  0  0    0.2500000    0.7500000    0.5000000
 0 -1  0  0  0 -1 -1  0  0    0.2500000    0.7500000    0.5000000
 0  1  0  1  0  0  0  0 -1    0.2500000    0.7500000    0.5000000
 0 -1  0 -1  0  0  0  0  1    0.2500000    0.7500000    0.5000000
 0  1  0  0  0 -1 -1  0  0    0.2500000    0.7500000    0.5000000
 0 -1  0  0  0  1  1  0  0    0.2500000    0.7500000    0.5000000
 0  1  0 -1  0  0  0  0  1    0.2500000    0.7500000    0.5000000
 0 -1  0  1  0  0  0  0 -1    0.2500000    0.7500000    0.5000000
 0 -1  0  0  0 -1  1  0  0    0.2500000    0.7500000    0.5000000
 0  1  0  0  0  1 -1  0  0    0.2500000    0.7500000    0.5000000
 0 -1  0 -1  0  0  0  0 -1    0.2500000    0.7500000    0.5000000
 0  1  0  1  0  0  0  0  1    0.2500000    0.7500000    0.5000000
 0 -1  0  0  0  1 -1  0  0    0.2500000    0.7500000    0.5000000
 0  1  0  0  0 -1  1  0  0    0.2500000    0.7500000    0.5000000
 0 -1  0  1  0  0  0  0  1    0.2500000    0.7500000    0.5000000
 0  1  0 -1  0  0  0  0 -1    0.2500000    0.7500000    0.5000000
 0  0  1  1  0  0  0  1  0    0.2500000    0.7500000    0.5000000
 0  0 -1 -1  0  0  0 -1  0    0.2500000    0.7500000    0.5000000
 1  0  0  0  0 -1  0  1  0    0.2500000    0.7500000    0.5000000
-1  0  0  0  0  1  0 -1  0    0.2500000    0.7500000    0.5000000
 0  0 -1 -1  0  0  0  1  0    0.2500000    0.7500000    0.5000000
 0  0  1  1  0  0  0 -1  0    0.2500000    0.7500000    0.5000000
-1  0  0  0  0  1  0  1  0    0.2500000    0.7500000    0.5000000
 1  0  0  0  0 -1  0 -1  0    0.2500000    0.7500000    0.5000000
 0  0 -1  1  0  0  0 -1  0    0.2500000    0.7500000    0.5000000
 0  0  1 -1  0  0  0  1  0    0.2500000    0.7500000    0.5000000
-1  0  0  0  0 -1  0 -1  0    0.2500000    0.7500000    0.5000000
 1  0  0  0  0  1  0  1  0    0.2500000    0.7500000    0.5000000
 0  0  1 -1  0  0  0 -1  0    0.2500000    0.7500000    0.5000000
 0  0 -1  1  0  0  0  1  0    0.2500000    0.7500000    0.5000000
 1  0  0  0  0  1  0 -1  0    0.2500000    0.7500000    0.5000000
-1  0  0  0  0 -1  0  1  0    0.2500000    0.7500000    0.5000000
 1  0  0  0  1  0  0  0  1    0.0000000    0.5000000    0.5000000
-1  0  0  0 -1  0  0  0 -1    0.0000000    0.5000000    0.5000000
 0  0 -1  0  1  0  1  0  0    0.0000000    0.5000000    0.5000000
 0  0  1  0 -1  0 -1  0  0    0.0000000    0.5000000    0.5000000
-1  0  0  0  1  0  0  0 -1    0.0000000    0.5000000    0.5000000
 1  0  0  0 -1  0  0  0  1    0.0000000    0.5000000    0.5000000
 0  0  1  0  1  0 -1  0  0    0.0000000    0.5000000    0.5000000
 0  0 -1  0 -1  0  1  0  0    0.0000000    0.5000000    0.5000000
 1  0  0  0 -1  0  0  0 -1    0.0000000    0.5000000    0.5000000
-1  0  0  0  1  0  0  0  1    0.0000000    0.5000000    0.5000000
 0  0 -1  0 -1  0 -1  0  0    0.0000000    0.5000000    0.5000000
 0  0  1  0  1  0  1  0  0    0.0000000    0.5000000    0.5000000
-1  0  0  0 -1  0  0  0  1    0.0000000    0.5000000    0.5000000
 1  0  0  0  1  0  0  0 -1    0.0000000    0.5000000    0.5000000
 0  0  1  0 -1  0  1  0  0    0.0000000    0.5000000    0.5000000
 0  0 -1  0  1  0 -1  0  0    0.0000000    0.5000000    0.5000000
 0  1  0  0  0  1  1  0  0    0.0000000    0.5000000    0.5000000
 0 -1  0  0  0 -1 -1  0  0    0.0000000    0.5000000    0.5000000
 0  1  0  1  0  0  0  0 -1    0.0000000    0.5000000    0.5000000
 0 -1  0 -1  0  0  0  0  1    0.0000000    0.5000000    0.5000000
 0  1  0  0  0 -1 -1  0  0    0.0000000    0.5000000    0.5000000
 0 -1  0  0  0  1  1  0  0    0.0000000    0.5000000    0.5000000
 0  1  0 -1  0  0  0  0  1    0.0000000    0.5000000    0.5000000
 0 -1  0  1  0  0  0  0 -1    0.0000000    0.5000000    0.5000000
 0 -1  0  0  0 -1  1  0  0    0.0000000    0.5000000    0.5000000
 0  1  0  0  0  1 -1  0  0    0.0000000    0.5000000    0.5000000
 0 -1  0 -1  0  0  0  0 -1    0.0000000    0.5000000    0.5000000
 0  1  0  1  0  0  0  0  1    0.0000000    0.5000000    0.5000000
 0 -1  0  0  0  1 -1  0  0    0.0000000    0.5000000    0.5000000
 0  1  0  0  0 -1  1  0  0    0.0000000    0.5000000    0.5000000
 0 -1  0  1  0  0  0  0  1    0.0000000    0.5000000    0.5000000
 0  1  0 -1  0  0  0  0 -1    0.0000000    0.5000000    0.5000000
 0  0  1  1  0  0  0  1  0    0.0000000    0.5000000    0.5000000
 0  0 -1 -1  0  0  0 -1  0    0.0000000    0.5000000    0.5000000
 1  0  0  0  0 -1  0  1  0    0.0000000    0.5000000    0.5000000
-1  0  0  0  0  1  0 -1  0    0.0000000    0.5000000    0.5000000
 0  0 -1 -1  0  0  0  1  0    0.0000000    0.5000000    0.5000000
 0  0  1  1  0  0  0 -1  0    0.0000000    0.5000000    0.5000000
-1  0  0  0  0  1  0  1  0    0.0000000    0.5000000    0.5000000
 1  0  0  0  0 -1  0 -1  0    0.0000000    0.5000000    0.5000000
 0  0 -1  1  0  0  0 -1  0    0.0000000    0.5000000    0.5000000
 0  0  1 -1  0  0  0  1  0    0.0000000    0.5000000    0.5000000
-1  0  0  0  0 -1  0 -1  0    0.0000000    0.5000000    0.5000000
 1  0  0  0  0  1  0  1  0    0.0000000    0.5000000    0.5000000
 0  0  1 -1  0  0  0 -1  0    0.0000000    0.5000000    0.5000000
 0  0 -1  1  0  0  0  1  0    0.0000000    0.5000000    0.5000000
 1  0  0  0  0  1  0 -1  0    0.0000000    0.5000000    0.5000000
-1  0  0  0  0 -1  0  1  0    0.0000000    0.5000000    0.5000000
 1  0  0  0  1  0  0  0  1    0.7500000    0.2500000    0.5000000
-1  0  0  0 -1  0  0  0 -1    0.7500000    0.2500000    0.5000000
 0  0 -1  0  1  0  1  0  0    0.7500000    0.2500000    0.5000000
 0  0  1  0 -1  0 -1  0  0    0.7500000    0.2500000    0.5000000
-1  0  0  0  1  0  0  0 -1    0.7500000    0.2500000    0.5000000
 1  0  0  0 -1  0  0  0  1    0.7500000    0.2500000    0.5000000
 0  0  1  0  1  0 -1  0  0    0.7500000    0.2500000    0.5000000
 0  0 -1  0 -1  0  1  0  0    0.7500000    0.2500000    0.5000000
 1  0  0  0 -1  0  0  0 -1    0.7500000    0.2500000    0.5000000
-1  0  0  0  1  0  0  0  1    0.7500000    0.2500000    0.5000000
 0  0 -1  0 -1  0 -1  0  0    0.7500000    0.2500000    0.5000000
 0  0  1  0  1  0  1  0  0    0.7500000    0.2500000    0.5000000
-1  0  0  0 -1  0  0  0  1    0.7500000    0.2500000    0.5000000
 1  0  0  0  1  0  0  0 -1    0.7500000    0.2500000    0.5000000
 0  0  1  0 -1  0  1  0  0    0.7500000    0.2500000    0.5000000
 0  0 -1  0  1  0 -1  0  0    0.7500000    0.2500000    0.5000000
 0  1  0  0  0  1  1  0  0    0.7500000    0.2500000    0.5000000
 0 -1  0  0  0 -1 -1  0  0    0.7500000    0.2500000    0.5000000
 0  1  0  1  0  0  0  0 -1    0.7500000    0.2500000    0.5000000
 0 -1  0 -1  0  0  0  0  1    0.7500000    0.2500000    0.5000000
 0  1  0  0  0 -1 -1  0  0    0.7500000    0.2500000    0.5000000
 0 -1  0  0  0  1  1  0  0    0.7500000    0.2500000    0.5000000
 0  1  0 -1  0  0  0  0  1    0.7500000    0.2500000    0.5000000
 0 -1  0  1  0  0  0  0 -1    0.7500000    0.2500000    0.5000000
 0 -1  0  0  0 -1  1  0  0    0.7500000    0.2500000    0.5000000
 0  1  0  0  0  1 -1  0  0    0.7500000    0.2500000    0.5000000
 0 -1  0 -1  0  0  0  0 -1    0.7500000    0.2500000    0.5000000
 0  1  0  1  0  0  0  0  1    0.7500000    0.2500000    0.5000000
 0 -1  0  0  0  1 -1  0  0    0.7500000    0.2500000    0.5000000
 0  1  0  0  0 -1  1  0  0    0.7500000    0.2500000    0.5000000
 0 -1  0  1  0  0  0  0  1    0.7500000    0.2500000    0.5000000
 0  1  0 -1  0  0  0  0 -1    0.7500000    0.2500000    0.5000000
 0  0  1  1  0  0  0  1  0    0.7500000    0.2500000    0.5000000
 0  0 -1 -1  0  0  0 -1  0    0.7500000    0.2500000    0.5000000
 1  0  0  0  0 -1  0  1  0    0.7500000    0.2500000    0.5000000
-1  0  0  0  0  1  0 -1  0    0.7500000    0.2500000    0.5000000
 0  0 -1 -1  0  0  0  1  0    0.7500000    0.2500000    0.5000000
 0  0  1  1  0  0  0 -1  0    0.7500000    0.2500000    0.5000000
-1  0  0  0  0  1  0  1  0    0.7500000    0.2500000    0.5000000
 1  0  0  0  0 -1  0 -1  0    0.7500000    0.2500000    0.5000000
 0  0 -1  1  0  0  0 -1  0    0.7500000    0.2500000    0.5000000
 0  0  1 -1  0  0  0  1  0    0.7500000    0.2500000    0.5000000
-1  0  0  0  0 -1  0 -1  0    0.7500000    0.2500000    0.5000000
 1  0  0  0  0  1  0  1  0    0.7500000    0.2500000    0.5000000
 0  0  1 -1  0  0  0 -1  0    0.7500000    0.2500000    0.5000000
 0  0 -1  1  0  0  0  1  0    0.7500000    0.2500000    0.5000000
 1  0  0  0  0  1  0 -1  0    0.7500000    0.2500000    0.5000000
-1  0  0  0  0 -1  0  1  0    0.7500000    0.2500000    0.5000000
 1  0  0  0  1  0  0  0  1    0.7500000    0.0000000    0.2500000
-1  0  0  0 -1  0  0  0 -1    0.7500000    0.0000000    0.2500000
 0  0 -1  0  1  0  1  0  0    0.7500000    0.0000000    0.2500000
 0  0  1  0 -1  0 -1  0  0    0.7500000    0.0000000    0.2500000
-1  0  0  0  1  0  0  0 -1    0.7500000    0.0000000    0.2500000
 1  0  0  0 -1  0  0  0  1    0.7500000    0.0000000    0.2500000
 0  0  1  0  1  0 -1  0  0    0.7500000    0.0000000    0.2500000
 0  0 -1  0 -1  0  1  0  0    0.7500000    0.0000000    0.2500000
 1  0  0  0 -1  0  0  0 -1    0.7500000    0.0000000    0.2500000
-1  0  0  0  1  0  0  0  1    0.7500000    0.0000000    0.2500000
 0  0 -1  0 -1  0 -1  0  0    0.7500000    0.0000000    0.2500000
 0  0  1  0  1  0  1  0  0    0.7500000    0.0000000    0.2500000
-1  0  0  0 -1  0  0  0  1    0.7500000    0.0000000    0.2500000
 1  0  0  0  1  0  0  0 -1    0.7500000    0.0000000    0.2500000
 0  0  1  0 -1  0  1  0  0    0.7500000    0.0000000    0.2500000
 0  0 -1  0  1  0 -1  0  0    0.7500000    0.0000000    0.2500000
 0  1  0  0  0  1  1  0  0    0.7500000    0.0000000    0.2500000
 0 -1  0  0  0 -1 -1  0  0    0.7500000    0.0000000    0.2500000
 0  1  0  1  0  0  0  0 -1    0.7500000    0.0000000    0.2500000
 0 -1  0 -1  0  0  0  0  1    0.7500000    0.0000000    0.2500000
 0  1  0  0  0 -1 -1  0  0    0.7500000    0.0000000    0.2500000
 0 -1  0  0  0  1  1  0  0    0.7500000    0.0000000    0.2500000
 0  1  0 -1  0  0  0  0  1    0.7500000    0.0000000    0.2500000
 0 -1  0  1  0  0  0  0 -1    0.7500000    0.0000000    0.2500000
 0 -1  0  0  0 -1  1  0  0    0.7500000    0.0000000    0.2500000
 0  1  0  0  0  1 -1  0  0    0.7500000    0.0000000    0.2500000
 0 -1  0 -1  0  0  0  0 -1    0.7500000    0.0000000    0.2500000
 0  1  0  1  0  0  0  0  1    0.7500000    0.0000000    0.2500000
 0 -1  0  0  0  1 -1  0  0    0.7500000    0.0000000    0.2500000
 0  1  0  0  0 -1  1  0  0    0.7500000    0.0000000    0.2500000
 0 -1  0  1  0  0  0  0  1    0.7500000    0.0000000    0.2500000
 0  1  0 -1  0  0  0  0 -1    0.7500000    0.0000000    0.2500000
 0  0  1  1  0  0  0  1  0    0.7500000    0.0000000    0.2500000
 0  0 -1 -1  0  0  0 -1  0    0.7500000    0.0000000    0.2500000
 1  0  0  0  0 -1  0  1  0    0.7500000    0.0000000    0.2500000
-1  0  0  0  0  1  0 -1  0    0.7500000    0.0000000    0.2500000
 0  0 -1 -1  0  0  0  1  0    0.7500000    0.0000000    0.2500000
 0  0  1  1  0  0  0 -1  0    0.7500000    0.0000000    0.2500000
-1  0  0  0  0  1  0  1  0    0.7500000    0.0000000    0.2500000
 1  0  0  0  0 -1  0 -1  0    0.7500000    0.0000000    0.2500000
 0  0 -1  1  0  0  0 -1  0    0.7500000    0.0000000    0.2500000
 0  0  1 -1  0  0  0  1  0    0.7500000    0.0000000    0.2500000
-1  0  0  0  0 -1  0 -1  0    0.7500000    0.0000000    0.2500000
 1  0  0  0  0  1  0  1  0    0.7500000    0.0000000    0.2500000
 0  0  1 -1  0  0  0 -1  0    0.7500000    0.0000000    0.2500000
 0  0 -1  1  0  0  0  1  0    0.7500000    0.0000000    0.2500000
 1  0  0  0  0  1  0 -1  0    0.7500000    0.0000000    0.2500000
-1  0  0  0  0 -1  0  1  0    0.7500000    0.0000000    0.2500000
 1  0  0  0  1  0  0  0  1    0.5000000    0.7500000    0.2500000
-1  0  0  0 -1  0  0  0 -1    0.5000000    0.7500000    0.2500000
 0  0 -1  0  1  0  1  0  0    0.5000000    0.7500000    0.2500000
 0  0  1  0 -1  0 -1  0  0    0.5000000    0.7500000    0.2500000
-1  0  0  0  1  0  0  0 -1    0.5000000    0.7500000    0.2500000
 1  0  0  0 -1  0  0  0  1    0.5000000    0.7500000    0.2500000
 0  0  1  0  1  0 -1  0  0    0.5000000    0.7500000    0.2500000
 0  0 -1  0 -1  0  1  0  0    0.5000000    0.7500000    0.2500000
 1  0  0  0 -1  0  0  0 -1    0.5000000    0.7500000    0.2500000
-1  0  0  0  1  0  0  0  1    0.5000000    0.7500000    0.2500000
 0  0 -1  0 -1  0 -1  0  0    0.5000000    0.7500000    0.2500000
 0  0  1  0  1  0  1  0  0    0.5000000    0.7500000    0.2500000
-1  0  0  0 -1  0  0  0  1    0.5000000    0.7500000    0.2500000
 1  0  0  0  1  0  0  0 -1    0.5000000    0.7500000    0.2500000
 0  0  1  0 -1  0  1  0  0    0.5000000    0.7500000    0.2500000
 0  0 -1  0  1  0 -1  0  0    0.5000000    0.7500000    0.2500000
 0  1  0  0  0  1  1  0  0    0.5000000    0.7500000    0.2500000
 0 -1  0  0  0 -1 -1  0  0    0.5000000    0.7500000    0.2500000
 0  1  0  1  0  0  0  0 -1    0.5000000    0.7500000    0.2500000
 0 -1  0 -1  0  0  0  0  1    0.5000000    0.7500000    0.2500000
 0  1  0  0  0 -1 -1  0  0    0.5000000    0.7500000    0.2500000
 0 -1  0  0  0  1  1  0  0    0.5000000    0.7500000    0.2500000
 0  1  0 -1  0  0  0  0  1    0.5000000    0.7500000    0.2500000
 0 -1  0  1  0  0  0  0 -1    0.5000000    0.7500000    0.2500000
 0 -1  0  0  0 -1  1  0  0    0.5000000    0.7500000    0.2500000
 0  1  0  0  0  1 -1  0  0    0.5000000    0.7500000    0.2500000
 0 -1  0 -1  0  0  0  0 -1    0.5000000    0.7500000    0.2500000
 0  1  0  1  0  0  0  0  1    0.5000000    0.7500000    0.2500000
 0 -1  0  0  0  1 -1  0  0    0.5000000    0.7500000    0.2500000
 0  1  0  0  0 -1  1  0  0    0.5000000    0.7500000    0.2500000
 0 -1  0  1  0  0  0  0  1    0.5000000    0.7500000    0.2500000
 0  1  0 -1  0  0  0  0 -1    0.5000000    0.7500000    0.2500000
 0  0  1  1  0  0  0  1  0    0.5000000    0.7500000    0.2500000
 0  0 -1 -1  0  0  0 -1  0    0.5000000    0.7500000    0.2500000
 1  0  0  0  0 -1  0  1  0    0.5000000    0.7500000    0.2500000
-1  0  0  0  0  1  0 -1  0    0.5000000    0.7500000    0.2500000
 0  0 -1 -1  0  0  0  1  0    0.5000000    0.7500000    0.2500000
 0  0  1  1  0  0  0 -1  0    0.5000000    0.7500000    0.2500000
-1  0  0  0  0  1  0  1  0    0.5000000    0.7500000    0.2500000
 1  0  0  0  0 -1  0 -1  0    0.5000000    0.7500000    0.2500000
 0  0 -1  1  0  0  0 -1  0    0.5000000    0.7500000    0.2500000
 0  0  1 -1  0  0  0  1  0    0.5000000    0.7500000    0.2500000
-1  0  0  0  0 -1  0 -1  0    0.5000000    0.7500000    0.2500000
 1  0  0  0  0  1  0  1  0    0.5000000    0.7500000    0.2500000
 0  0  1 -1  0  0  0 -1  0    0.5000000    0.7500000    0.2500000
 0  0 -1  1  0  0  0  1  0    0.5000000    0.7500000    0.2500000
 1  0  0  0  0  1  0 -1  0    0.5000000    0.7500000    0.2500000
-1  0  0  0  0 -1  0  1  0    0.5000000    0.7500000    0.2500000
 1  0  0  0  1  0  0  0  1    0.2500000    0.5000000    0.2500000
-1  0  0  0 -1  0  0  0 -1    0.2500000    0.5000000    0.2500000
 0  0 -1  0  1  0  1  0  0    0.2500000    0.5000000    0.2500000
 0  0  1  0 -1  0 -1  0  0    0.2500000    0.5000000    0.2500000
-1  0  0  0  1  0  0  0 -1    0.2500000    0.5000000    0.2500000
 1  0  0  0 -1  0  0  0  1    0.2500000    0.5000000    0.2500000
 0  0  1  0  1  0 -1  0  0    0.2500000    0.5000000    0.2500000
 0  0 -1  0 -1  0  1  0  0    0.2500000    0.5000000    0.2500000
 1  0  0  0 -1  0  0  0 -1    0.2500000    0.5000000    0.2500000
-1  0  0  0  1  0  0  0  1    0.2500000    0.5000000    0.2500000
 0  0 -1  0 -1  0 -1  0  0    0.2500000    0.5000000    0.2500000
 0  0  1  0  1  0  1  0  0    0.2500000    0.5000000    0.2500000
-1  0  0  0 -1  0  0  0  1    0.2500000    0.5000000    0.2500000
 1  0  0  0  1  0  0  0 -1    0.2500000    0.5000000    0.2500000
 0  0  1  0 -1  0  1  0  0    0.2500000    0.5000000    0.2500000
 0  0 -1  0  1  0 -1  0  0    0.2500000    0.5000000    0.2500000
 0  1  0  0  0  1  1  0  0    0.2500000    0.5000000    0.2500000
 0 -1  0  0  0 -1 -1  0  0    0.2500000    0.5000000    0.2500000
 0  1  0  1  0  0  0  0 -1    0.2500000    0.5000000    0.2500000
 0 -1  0 -1  0  0  0  0  1    0.2500000    0.5000000    0.2500000
 0  1  0  0  0 -1 -1  0  0    0.2500000    0.5000000    0.2500000
 0 -1  0  0  0  1  1  0  0    0.2500000    0.5000000    0.2500000
 0  1  0 -1  0  0  0  0  1    0.2500000    0.5000000    0.2500000
 0 -1  0  1  0  0  0  0 -1    0.2500000    0.5000000    0.2500000
 0 -1  0  0  0 -1  1  0  0    0.2500000    0.5000000    0.2500000
 0  1  0  0  0  1 -1  0  0    0.2500000    0.5000000    0.2500000
 0 -1  0 -1  0  0  0  0 -1    0.2500000    0.5000000    0.2500000
 0  1  0  1  0  0  0  0  1    0.2500000    0.5000000    0.2500000
 0 -1  0  0  0  1 -1  0  0    0.2500000    0.5000000    0.2500000
 0  1  0  0  0 -1  1  0  0    0.2500000    0.5000000    0.2500000
 0 -1  0  1  0  0  0  0  1    0.2500000    0.5000000    0.2500000
 0  1  0 -1  0  0  0  0 -1    0.2500000    0.5000000    0.2500000
 0  0  1  1  0  0  0  1  0    0.2500000    0.5000000    0.2500000
 0  0 -1 -1  0  0  0 -1  0    0.2500000    0.5000000    0.2500000
 1  0  0  0  0 -1  0  1  0    0.2500000    0.5000000    0.2500000
-1  0  0  0  0  1  0 -1  0    0.2500000    0.5000000    0.2500000
 0  0 -1 -1  0  0  0  1  0    0.2500000    0.5000000    0.2500000
 0  0  1  1  0  0  0 -1  0    0.2500000    0.5000000    0.2500000
-1  0  0  0  0  1  0  1  0    0.2500000    0.5000000    0.2500000
 1  0  0  0  0 -1  0 -1  0    0.2500000    0.5000000    0.2500000
 0  0 -1  1  0  0  0 -1  0    0.2500000    0.5000000    0.2500000
 0  0  1 -1  0  0  0  1  0    0.2500000    0.5000000    0.2500000
-1  0  0  0  0 -1  0 -1  0    0.2500000    0.5000000    0.2500000
 1  0  0  0  0  1  0  1  0    0.2500000    0.5000000    0.2500000
 0  0  1 -1  0  0  0 -1  0    0.2500000    0.5000000    0.2500000
 0  0 -1  1  0  0  0  1  0    0.2500000    0.5000000    0.2500000
 1  0  0  0  0  1  0 -1  0    0.2500000    0.5000000    0.2500000
-1  0  0  0  0 -1  0  1  0    0.2500000    0.5000000    0.2500000
 1  0  0  0  1  0  0  0  1    0.0000000    0.2500000    0.2500000
-1  0  0  0 -1  0  0  0 -1    0.0000000    0.2500000    0.2500000
 0  0 -1  0  1  0  1  0  0    0.0000000    0.2500000    0.2500000
 0  0  1  0 -1  0 -1  0  0    0.0000000    0.2500000    0.2500000
-1  0  0  0  1  0  0  0 -1    0.0000000    0.2500000    0.2500000
 1  0  0  0 -1  0  0  0  1    0.0000000    0.2500000    0.2500000
 0  0  1  0  1  0 -1  0  0    0.0000000    0.2500000    0.2500000
 0  0 -1  0 -1  0  1  0  0    0.0000000    0.2500000    0.2500000
 1  0  0  0 -1  0  0  0 -1    0.0000000    0.2500000    0.2500000
-1  0  0  0  1  0  0  0  1    0.0000000    0.2500000    0.2500000
 0  0 -1  0 -1  0 -1  0  0    0.0000000    0.2500000    0.2500000
 0  0  1  0  1  0  1  0  0    0.0000000    0.2500000    0.2500000
-1  0  0  0 -1  0  0  0  1    0.0000000    0.2500000    0.2500000
 1  0  0  0  1  0  0  0 -1    0.0000000    0.2500000    0.2500000
 0  0  1  0 -1  0  1  0  0    0.0000000    0.2500000    0.2500000
 0  0 -1  0  1  0 -1  0  0    0.0000000    0.2500000    0.2500000
 0  1  0  0  0  1  1  0  0    0.0000000    0.2500000    0.2500000
 0 -1  0  0  0 -1 -1  0  0    0.0000000    0.2500000    0.2500000
 0  1  0  1  0  0  0  0 -1    0.0000000    0.2500000    0.2500000
 0 -1  0 -1  0  0  0  0  1    0.0000000    0.2500000    0.2500000
 0  1  0  0  0 -1 -1  0  0    0.0000000    0.2500000    0.2500000
 0 -1  0  0  0  1  1  0  0    0.0000000    0.2500000    0.2500000
 0  1  0 -1  0  0  0  0  1    0.0000000    0.2500000    0.2500000
 0 -1  0  1  0  0  0  0 -1    0.0000000    0.2500000    0.2500000
 0 -1  0  0  0 -1  1  0  0    0.0000000    0.2500000    0.2500000
 0  1  0  0  0  1 -1  0  0    0.0000000    0.2500000    0.2500000
 0 -1  0 -1  0  0  0  0 -1    0.0000000    0.2500000    0.2500000
 0  1  0  1  0  0  0  0  1    0.0000000    0.2500000    0.2500000
 0 -1  0  0  0  1 -1  0  0    0.0000000    0.2500000    0.2500000
 0  1  0  0  0 -1  1  0  0    0.0000000    0.2500000    0.2500000
 0 -1  0  1  0  0  0  0  1    0.0000000    0.2500000    0.2500000
 0  1  0 -1  0  0  0  0 -1    0.0000000    0.2500000    0.2500000
 0  0  1  1  0  0  0  1  0    0.0000000    0.2500000    0.2500000
 0  0 -1 -1  0  0  0 -1  0    0.0000000    0.2500000    0.2500000
 1  0  0  0  0 -1  0  1  0    0.0000000    0.2500000    0.2500000
-1  0  0  0  0  1  0 -1  0    0.0000000    0.2500000    0.2500000
 0  0 -1 -1  0  0  0  1  0    0.0000000    0.2500000    0.2500000
 0  0  1  1  0  0  0 -1  0    0.0000000    0.2500000    0.2500000
-1  0  0  0  0  1  0  1  0    0.0000000    0.2500000    0.2500000
 1  0  0  0  0 -1  0 -1  0    0.0000000    0.2500000    0.2500000
 0  0 -1  1  0  0  0 -1  0    0.0000000    0.2500000    0.2500000
 0  0  1 -1  0  0  0  1  0    0.0000000    0.2500000    0.2500000
-1  0  0  0  0 -1  0 -1  0    0.0000000    0.2500000    0.2500000
 1  0  0  0  0  1  0  1  0    0.0000000    0.2500000    0.2500000
 0  0  1 -1  0  0  0 -1  0    0.0000000    0.2500000    0.2500000
 0  0 -1  1  0  0  0  1  0    0.0000000    0.2500000    0.2500000
 1  0  0  0  0  1  0 -1  0    0.0000000    0.2500000    0.2500000
-1  0  0  0  0 -1  0  1  0    0.0000000    0.2500000    0.2500000
 1  0  0  0  1  0  0  0  1    0.7500000    0.2500000    0.0000000
-1  0  0  0 -1  0  0  0 -1    0.7500000    0.2500000    0.0000000
 0  0 -1  0  1  0  1  0  0    0.7500000    0.2500000    0.0000000
 0  0  1  0 -1  0 -1  0  0    0.7500000    0.2500000    0.0000000
-1  0  0  0  1  0  0  0 -1    0.7500000    0.2500000    0.0000000
 1  0  0  0 -1  0  0  0  1    0.7500000    0.2500000    0.0000000
 0  0  1  0  1  0 -1  0  0    0.7500000    0.2500000    0.0000000
 0  0 -1  0 -1  0  1  0  0    0.7500000    0.2500000    0.0000000
 1  0  0  0 -1  0  0  0 -1    0.7500000    0.2500000    0.0000000
-1  0  0  0  1  0  0  0  1    0.7500000    0.2500000    0.0000000
 0  0 -1  0 -1  0 -1  0  0    0.7500000    0.2500000    0.0000000
 0  0  1  0  1  0  1  0  0    0.7500000    0.2500000    0.0000000
-1  0  0  0 -1  0  0  0  1    0.7500000    0.2500000    0.0000000
 1  0  0  0  1  0  0  0 -1    0.7500000    0.2500000    0.0000000
 0  0  1  0 -1  0  1  0  0    0.7500000    0.2500000    0.0000000
 0  0 -1  0  1  0 -1  0  0    0.7500000    0.2500000    0.0000000
 0  1  0  0  0  1  1  0  0    0.7500000    0.2500000    0.0000000
 0 -1  0  0  0 -1 -1  0  0    0.7500000    0.2500000    0.0000000
 0  1  0  1  0  0  0  0 -1    0.7500000    0.2500000    0.0000000
 0 -1  0 -1  0  0  0  0  1    0.7500000    0.2500000    0.0000000
 0  1  0  0  0 -1 -1  0  0    0.7500000    0.2500000    0.0000000
 0 -1  0  0  0  1  1  0  0    0.7500000    0.2500000    0.0000000
 0  1  0 -1  0  0  0  0  1    0.7500000    0.2500000    0.0000000
 0 -1  0  1  0  0  0  0 -1    0.7500000    0.2500000    0.0000000
 0 -1  0  0  0 -1  1  0  0    0.7500000    0.2500000    0.0000000
 0  1  0  0  0  1 -1  0  0    0.7500000    0.2500000    0.0000000
 0 -1  0 -1  0  0  0  0 -1    0.7500000    0.2500000    0.0000000
 0  1  0  1  0  0  0  0  1    0.7500000    0.2500000    0.0000000
 0 -1  0  0  0  1 -1  0  0    0.7500000    0.2500000    0.0000000
 0  1  0  0  0 -1  1  0  0    0.7500000    0.2500000    0.0000000
 0 -1  0  1  0  0  0  0  1    0.7500000    0.2500000    0.0000000
 0  1  0 -1  0  0  0  0 -1    0.7500000    0.2500000    0.0000000
 0  0  1  1  0  0  0  1  0    0.7500000    0.2500000    0.0000000
 0  0 -1 -1  0  0  0 -1  0    0.7500000    0.2500000    0.0000000
 1  0  0  0  0 -1  0  1  0    0.7500000    0.2500000    0.0000000
-1  0  0  0  0  1  0 -1  0    0.7500000    0.2500000    0.0000000
 0  0 -1 -1  0  0  0  1  0    0.7500000    0.2500000    0.0000000
 0  0  1  1  0  0  0 -1  0    0.7500000    0.2500000    0.0000000
-1  0  0  0  0  1  0  1  0    0.7500000    0.2500000    0.0000000
 1  0  0  0  0 -1  0 -1  0    0.7500000    0.2500000    0.0000000
 0  0 -1  1  0  0  0 -1  0    0.7500000    0.2500000    0.0000000
 0  0  1 -1  0  0  0  1  0    0.7500000    0.2500000    0.0000000
-1  0  0  0  0 -1  0 -1  0    0.7500000    0.2500000    0.0000000
 1  0  0  0  0  1  0  1  0    0.7500000    0.2500000    0.0000000
 0  0  1 -1  0  0  0 -1  0    0.7500000    0.2500000    0.0000000
 0  0 -1  1  0  0  0  1  0    0.7500000    0.2500000    0.0000000
 1  0  0  0  0  1  0 -1  0    0.7500000    0.2500000    0.0000000
-1  0  0  0  0 -1  0  1  0    0.7500000    0.2500000    0.0000000
 1  0  0  0  1  0  0  0  1    0.5000000    0.0000000    0.0000000
-1  0  0  0 -1  0  0  0 -1    0.5000000    0.0000000    0.0000000
 0  0 -1  0  1  0  1  0  0    0.5000000    0.0000000    0.0000000
 0  0  1  0 -1  0 -1  0  0    0.5000000    0.0000000    0.0000000
-1  0  0  0  1  0  0  0 -1    0.5000000    0.0000000    0.0000000
 1  0  0  0 -1  0  0  0  1    0.5000000    0.0000000    0.0000000
 0  0  1  0  1  0 -1  0  0    0.5000000    0.0000000    0.0000000
 0  0 -1  0 -1  0  1  0  0    0.5000000    0.0000000    0.0000000
 1  0  0  0 -1  0  0  0 -1    0.5000000    0.0000000    0.0000000
-1  0  0  0  1  0  0  0  1    0.5000000    0.0000000    0.0000000
 0  0 -1  0 -1  0 -1  0  0    0.5000000    0.0000000    0.0000000
 0  0  1  0  1  0  1  0  0    0.5000000    0.0000000    0.0000000
-1  0  0  0 -1  0  0  0  1    0.5000000    0.0000000    0.0000000
 1  0  0  0  1  0  0  0 -1    0.5000000    0.0000000    0.0000000
 0  0  1  0 -1  0  1  0  0    0.5000000    0.0000000    0.0000000
 0  0 -1  0  1  0 -1  0  0    0.5000000    0.0000000    0.0000000
 0  1  0  0  0  1  1  0  0    0.5000000    0.0000000    0.0000000
 0 -1  0  0  0 -1 -1  0  0    0.5000000    0.0000000    0.0000000
 0  1  0  1  0  0  0  0 -1    0.5000000    0.0000000    0.0000000
 0 -1  0 -1  0  0  0  0  1    0.5000000    0.0000000    0.0000000
 0  1  0  0  0 -1 -1  0  0    0.5000000    0.0000000    0.0000000
 0 -1  0  0  0  1  1  0  0    0.5000000    0.0000000    0.0000000
 0  1  0 -1  0  0  0  0  1    0.5000000    0.0000000    0.0000000
 0 -1  0  1  0  0  0  0 -1    0.5000000    0.0000000    0.0000000
 0 -1  0  0  0 -1  1  0  0    0.5000000    0.0000000    0.0000000
 0  1  0  0  0  1 -1  0  0    0.5000000    0.0000000    0.0000000
 0 -1  0 -1  0  0  0  0 -1    0.5000000    0.0000000    0.0000000
 0  1  0  1  0  0  0  0  1    0.5000000    0.0000000    0.0000000
 0 -1  0  0  0  1 -1  0  0    0.5000000    0.0000000    0.0000000
 0  1  0  0  0 -1  1  0  0    0.5000000    0.0000000    0.0000000
 0 -1  0  1  0  0  0  0  1    0.5000000    0.0000000    0.0000000
 0  1  0 -1  0  0  0  0 -1    0.5000000    0.0000000    0.0000000
 0  0  1  1  0  0  0  1  0    0.5000000    0.0000000    0.0000000
 0  0 -1 -1  0  0  0 -1  0    0.5000000    0.0000000    0.0000000
 1  0  0  0  0 -1  0  1  0    0.5000000    0.0000000    0.0000000
-1  0  0  0  0  1  0 -1  0    0.5000000    0.0000000    0.0000000
 0  0 -1 -1  0  0  0  1  0    0.5000000    0.0000000    0.0000000
 0  0  1  1  0  0  0 -1  0    0.5000000    0.0000000    0.0000000
-1  0  0  0  0  1  0  1  0    0.5000000    0.0000000    0.0000000
 1  0  0  0  0 -1  0 -1  0    0.5000000    0.0000000    0.0000000
 0  0 -1  1  0  0  0 -1  0    0.5000000    0.0000000    0.0000000
 0  0  1 -1  0  0  0  1  0    0.5000000    0.0000000    0.0000000
-1  0  0  0  0 -1  0 -1  0    0.5000000    0.0000000    0.0000000
 1  0  0  0  0  1  0  1  0    0.5000000    0.0000000    0.0000000
 0  0  1 -1  0  0  0 -1  0    0.5000000    0.0000000    0.0000000
 0  0 -1  1  0  0  0  1  0    0.5000000    0.0000000    0.0000000
 1  0  0  0  0  1  0 -1  0    0.5000000    0.0000000    0.0000000
-1  0  0  0  0 -1  0  1  0    0.5000000    0.0000000    0.0000000
 1  0  0  0  1  0  0  0  1    0.2500000    0.7500000    0.0000000
-1  0  0  0 -1  0  0  0 -1    0.2500000    0.7500000    0.0000000
 0  0 -1  0  1  0  1  0  0    0.2500000    0.7500000    0.0000000
 0  0  1  0 -1  0 -1  0  0    0.2500000    0.7500000    0.0000000
-1  0  0  0  1  0  0  0 -1    0.2500000    0.7500000    0.0000000
 1  0  0  0 -1  0  0  0  1    0.2500000    0.7500000    0.0000000
 0  0  1  0  1  0 -1  0  0    0.2500000    0.7500000    0.0000000
 0  0 -1  0 -1  0  1  0  0    0.2500000    0.7500000    0.0000000
 1  0  0  0 -1  0  0  0 -1    0.2500000    0.7500000    0.0000000
-1  0  0  0  1  0  0  0  1    0.2500000    0.7500000    0.0000000
 0  0 -1  0 -1  0 -1  0  0    0.2500000    0.7500000    0.0000000
 0  0  1  0  1  0  1  0  0    0.2500000    0.7500000    0.0000000
-1  0  0  0 -1  0  0  0  1    0.2500000    0.7500000    0.0000000
 1  0  0  0  1  0  0  0 -1    0.2500000    0.7500000    0.0000000
 0  0  1  0 -1  0  1  0  0    0.2500000    0.7500000    0.0000000
 0  0 -1  0  1  0 -1  0  0    0.2500000    0.7500000    0.0000000
 0  1  0  0  0  1  1  0  0    0.2500000    0.7500000    0.0000000
 0 -1  0  0  0 -1 -1  0  0    0.2500000    0.7500000    0.0000000
 0  1  0  1  0  0  0  0 -1    0.2500000    0.7500000    0.0000000
 0 -1  0 -1  0  0  0  0  1    0.2500000    0.7500000    0.0000000
 0  1  0  0  0 -1 -1  0  0    0.2500000    0.7500000    0.0000000
 0 -1  0  0  0  1  1  0  0    0.2500000    0.7500000    0.0000000
 0  1  0 -1  0  0  0  0  1    0.2500000    0.7500000    0.0000000
 0 -1  0  1  0  0  0  0 -1    0.2500000    0.7500000    0.0000000
 0 -1  0  0  0 -1  1  0  0    0.2500000    0.7500000    0.0000000
 0  1  0  0  0  1 -1  0  0    0.2500000    0.7500000    0.0000000
 0 -1  0 -1  0  0  0  0 -1    0.2500000    0.7500000    0.0000000
 0  1  0  1  0  0  0  0  1    0.2500000    0.7500000    0.0000000
 0 -1  0  0  0  1 -1  0  0    0.2500000    0.7500000    0.0000000
 0  1  0  0  0 -1  1  0  0    0.2500000    0.7500000    0.0000000
 0 -1  0  1  0  0  0  0  1    0.2500000    0.7500000    0.0000000
 0  1  0 -1  0  0  0  0 -1    0.2500000    0.7500000    0.0000000
 0  0  1  1  0  0  0  1  0    0.2500000    0.7500000    0.0000000
 0  0 -1 -1  0  0  0 -1  0    0.2500000    0.7500000    0.0000000
 1  0  0  0  0 -1  0  1  0    0.2500000    0.7500000    0.0000000
-1  0  0  0  0  1  0 -1  0    0.2500000    0.7500000    0.0000000
 0  0 -1 -1  0  0  0  1  0    0.2500000    0.7500000    0.0000000
 0  0  1  1  0  0  0 -1  0    0.2500000    0.7500000    0.0000000
-1  0  0  0  0  1  0  1  0    0.2500000    0.7500000    0.0000000
 1  0  0  0  0 -1  0 -1  0    0.2500000    0.7500000    0.0000000
 0  0 -1  1  0  0  0 -1  0    0.2500000    0.7500000    0.0000000
 0  0  1 -1  0  0  0  1  0    0.2500000    0.7500000    0.0000000
-1  0  0  0  0 -1  0 -1  0    0.2500000    0.7500000    0.0000000
 1  0  0  0  0  1  0  1  0    0.2500000    0.7500000    0.0000000
 0  0  1 -1  0  0  0 -1  0    0.2500000    0.7500000    0.0000000
 0  0 -1  1  0  0  0  1  0    0.2500000    0.7500000    0.0000000
 1  0  0  0  0  1  0 -1  0    0.2500000    0.7500000    0.0000000
-1  0  0  0  0 -1  0  1  0    0.2500000    0.7500000    0.0000000
 1  0  0  0  1  0  0  0  1    0.0000000    0.5000000    0.0000000
-1  0  0  0 -1  0  0  0 -1    0.0000000    0.5000000    0.0000000
 0  0 -1  0  1  0  1  0  0    0.0000000    0.5000000    0.0000000
 0  0  1  0 -1  0 -1  0  0    0.0000000    0.5000000    0.0000000
-1  0  0  0  1  0  0  0 -1    0.0000000    0.5000000    0.0000000
 1  0  0  0 -1  0  0  0  1    0.0000000    0.5000000    0.0000000
 0  0  1  0  1  0 -1  0  0    0.0000000    0.5000000    0.0000000
 0  0 -1  0 -1  0  1  0  0    0.0000000    0.5000000    0.0000000
 1  0  0  0 -1  0  0  0 -1    0.0000000    0.5000000    0.0000000
-1  0  0  0  1  0  0  0  1    0.0000000    0.5000000    0.0000000
 0  0 -1  0 -1  0 -1  0  0    0.0000000    0.5000000    0.0000000
 0  0  1  0  1  0  1  0  0    0.0000000    0.5000000    0.0000000
-1  0  0  0 -1  0  0  0  1    0.0000000    0.5000000    0.0000000
 1  0  0  0  1  0  0  0 -1    0.0000000    0.5000000    0.0000000
 0  0  1  0 -1  0  1  0  0    0.0000000    0.5000000    0.0000000
 0  0 -1  0  1  0 -1  0  0    0.0000000    0.5000000    0.0000000
 0  1  0  0  0  1  1  0  0    0.0000000    0.5000000    0.0000000
 0 -1  0  0  0 -1 -1  0  0    0.0000000    0.5000000    0.0000000
 0  1  0  1  0  0  0  0 -1    0.0000000    0.5000000    0.0000000
 0 -1  0 -1  0  0  0  0  1    0.0000000    0.5000000    0.0000000
 0  1  0  0  0 -1 -1  0  0    0.0000000    0.5000000    0.0000000
 0 -1  0  0  0  1  1  0  0    0.0000000    0.5000000    0.0000000
 0  1  0 -1  0  0  0  0  1    0.0000000    0.5000000    0.0000000
 0 -1  0  1  0  0  0  0 -1    0.0000000    0.5000000    0.0000000
 0 -1  0  0  0 -1  1  0  0    0.0000000    0.5000000    0.0000000
 0  1  0  0  0  1 -1  0  0    0.0000000    0.5000000    0.0000000
 0 -1  0 -1  0  0  0  0 -1    0.0000000    0.5000000    0.0000000
 0  1  0  1  0  0  0  0  1    0.0000000    0.5000000    0.0000000
 0 -1  0  0  0  1 -1  0  0    0.0000000    0.5000000    0.0000000
 0  1  0  0  0 -1  1  0  0    0.0000000    0.5000000    0.0000000
 0 -1  0  1  0  0  0  0  1    0.0000000    0.5000000    0.0000000
 0  1  0 -1  0  0  0  0 -1    0.0000000    0.5000000    0.0000000
 0  0  1  1  0  0  0  1  0    0.0000000    0.5000000    0.0000000
 0  0 -1 -1  0  0  0 -1  0    0.0000000    0.5000000    0.0000000
 1  0  0  0  0 -1  0  1  0    0.0000000    0.5000000    0.0000000
-1  0  0  0  0  1  0 -1  0    0.0000000    0.5000000    0.0000000
 0  0 -1 -1  0  0  0  1  0    0.0000000    0.5000000    0.0000000
 0  0  1  1  0  0  0 -1  0    0.0000000    0.5000000    0.0000000
-1  0  0  0  0  1  0  1  0    0.0000000    0.5000000    0.0000000
 1  0  0  0  0 -1  0 -1  0    0.0000000    0.5000000    0.0000000
 0  0 -1  1  0  0  0 -1  0    0.0000000    0.5000000    0.0000000
 0  0  1 -1  0  0  0  1  0    0.0000000    0.5000000    0.0000000
-1  0  0  0  0 -1  0 -1  0    0.0000000    0.5000000    0.0000000
 1  0  0  0  0  1  0  1  0    0.0000000    0.5000000    0.0000000
 0  0  1 -1  0  0  0 -1  0    0.0000000    0.5000000    0.0000000
 0  0 -1  1  0  0  0  1  0    0.0000000    0.5000000    0.0000000
 1  0  0  0  0  1  0 -1  0    0.0000000    0.5000000    0.0000000
-1  0  0  0  0 -1  0  1  0    0.0000000    0.5000000    0.0000000
 1  0  0  0  1  0  0  0  1    0.0000000    0.2500000    0.7500000
-1  0  0  0 -1  0  0  0 -1    0.0000000    0.2500000    0.7500000
 0  0 -1  0  1  0  1  0  0    0.0000000    0.2500000    0.7500000
 0  0  1  0 -1  0 -1  0  0    0.0000000    0.2500000    0.7500000
-1  0  0  0  1  0  0  0 -1    0.0000000    0.2500000    0.7500000
 1  0  0  0 -1  0  0  0  1    0.0000000    0.2500000    0.7500000
 0  0  1  0  1  0 -1  0  0    0.0000000    0.2500000    0.7500000
 0  0 -1  0 -1  0  1  0  0    0.0000000    0.2500000    0.7500000
 1  0  0  0 -1  0  0  0 -1    0.0000000    0.2500000    0.7500000
-1  0  0  0  1  0  0  0  1    0.0000000    0.2500000    0.7500000
 0  0 -1  0 -1  0 -1  0  0    0.0000000    0.2500000    0.7500000
 0  0  1  0  1  0  1  0  0    0.0000000    0.2500000    0.7500000
-1  0  0  0 -1  0  0  0  1    0.0000000    0.2500000    0.7500000
 1  0  0  0  1  0  0  0 -1    0.0000000    0.2500000    0.7500000
 0  0  1  0 -1  0  1  0  0    0.0000000    0.2500000    0.7500000
 0  0 -1  0  1  0 -1  0  0    0.0000000    0.2500000    0.7500000
 0  1  0  0  0  1  1  0  0    0.0000000    0.2500000    0.7500000
 0 -1  0  0  0 -1 -1  0  0    0.0000000    0.2500000    0.7500000
 0  1  0  1  0  0  0  0 -1    0.0000000    0.2500000    0.7500000
 0 -1  0 -1  0  0  0  0  1    0.0000000    0.2500000    0.7500000
 0  1  0  0  0 -1 -1  0  0    0.0000000    0.2500000    0.7500000
 0 -1  0  0  0  1  1  0  0    0.0000000    0.2500000    0.7500000
 0  1  0 -1  0  0  0  0  1    0.0000000    0.2500000    0.7500000
 0 -1  0  1  0  0  0  0 -1    0.0000000    0.2500000    0.7500000
 0 -1  0  0  0 -1  1  0  0    0.0000000    0.2500000    0.7500000
 0  1  0  0  0  1 -1  0  0    0.0000000    0.2500000    0.7500000
 0 -1  0 -1  0  0  0  0 -1    0.0000000    0.2500000    0.7500000
 0  1  0  1  0  0  0  0  1    0.0000000    0.2500000    0.7500000
 0 -1  0  0  0  1 -1  0  0    0.0000000    0.2500000    0.7500000
 0  1  0  0  0 -1  1  0  0    0.0000000    0.2500000    0.7500000
 0 -1  0  1  0  0  0  0  1    0.0000000    0.2500000    0.7500000
 0  1  0 -1  0  0  0  0 -1    0.0000000    0.2500000    0.7500000
 0  0  1  1  0  0  0  1  0    0.0000000    0.2500000    0.7500000
 0  0 -1 -1  0  0  0 -1  0    0.0000000    0.2500000    0.7500000
 1  0  0  0  0 -1  0  1  0    0.0000000    0.2500000    0.7500000
-1  0  0  0  0  1  0 -1  0    0.0000000    0.2500000    0.7500000
 0  0 -1 -1  0  0  0  1  0    0.0000000    0.2500000    0.7500000
 0  0  1  1  0  0  0 -1  0    0.0000000    0.2500000    0.7500000
-1  0  0  0  0  1  0  1  0    0.0000000    0.2500000    0.7500000
 1  0  0  0  0 -1  0 -1  0    0.0000000    0.2500000    0.7500000
 0  0 -1  1  0  0  0 -1  0    0.0000000    0.2500000    0.7500000
 0  0  1 -1  0  0  0  1  0    0.0000000    0.2500000    0.7500000
-1  0  0  0  0 -1  0 -1  0    0.0000000    0.2500000    0.7500000
 1  0  0  0  0  1  0  1  0    0.0000000    0.2500000    0.7500000
 0  0  1 -1  0  0  0 -1  0    0.0000000    0.2500000    0.7500000
 0  0 -1  1  0  0  0  1  0    0.0000000    0.2500000    0.7500000
 1  0  0  0  0  1  0 -1  0    0.0000000    0.2500000    0.7500000
-1  0  0  0  0 -1  0  1  0    0.0000000    0.2500000    0.7500000
 1  0  0  0  1  0  0  0  1    0.7500000    0.0000000    0.7500000
-1  0  0  0 -1  0  0  0 -1    0.7500000    0.0000000    0.7500000
 0  0 -1  0  1  0  1  0  0    0.7500000    0.0000000    0.7500000
 0  0  1  0 -1  0 -1  0  0    0.7500000    0.0000000    0.7500000
-1  0  0  0  1  0  0  0 -1    0.7500000    0.0000000    0.7500000
 1  0  0  0 -1  0  0  0  1    0.7500000    0.0000000    0.7500000
 0  0  1  0  1  0 -1  0  0    0.7500000    0.0000000    0.7500000
 0  0 -1  0 -1  0  1  0  0    0.7500000    0.0000000    0.7500000
 1  0  0  0 -1  0  0  0 -1    0.7500000    0.0000000    0.7500000
-1  0  0  0  1  0  0  0  1    0.7500000    0.0000000    0.7500000
 0  0 -1  0 -1  0 -1  0  0    0.7500000    0.0000000    0.7500000
 0  0  1  0  1  0  1  0  0    0.7500000    0.0000000    0.7500000
-1  0  0  0 -1  0  0  0  1    0.7500000    0.0000000    0.7500000
 1  0  0  0  1  0  0  0 -1    0.7500000    0.0000000    0.7500000
 0  0  1  0 -1  0  1  0  0    0.7500000    0.0000000    0.7500000
 0  0 -1  0  1  0 -1  0  0    0.7500000    0.0000000    0.7500000
 0  1  0  0  0  1  1  0  0    0.7500000    0.0000000    0.7500000
 0 -1  0  0  0 -1 -1  0  0    0.7500000    0.0000000    0.7500000
 0  1  0  1  0  0  0  0 -1    0.7500000    0.0000000    0.7500000
 0 -1  0 -1  0  0  0  0  1    0.7500000    0.0000000    0.7500000
 0  1  0  0  0 -1 -1  0  0    0.7500000    0.0000000    0.7500000
 0 -1  0  0  0  1  1  0  0    0.7500000    0.0000000    0.7500000
 0  1  0 -1  0  0  0  0  1    0.7500000    0.0000000    0.7500000
 0 -1  0  1  0  0  0  0 -1    0.7500000    0.0000000    0.7500000
 0 -1  0  0  0 -1  1  0  0    0.7500000    0.0000000    0.7500000
 0  1  0  0  0  1 -1  0  0    0.7500000    0.0000000    0.7500000
 0 -1  0 -1  0  0  0  0 -1    0.7500000    0.0000000    0.7500000
 0  1  0  1  0  0  0  0  1    0.7500000    0.0000000    0.7500000
 0 -1  0  0  0  1 -1  0  0    0.7500000    0.0000000    0.7500000
 0  1  0  0  0 -1  1  0  0    0.7500000    0.0000000    0.7500000
 0 -1  0  1  0  0  0  0  1    0.7500000    0.0000000    0.7500000
 0  1  0 -1  0  0  0  0 -1    0.7500000    0.0000000    0.7500000
 0  0  1  1  0  0  0  1  0    0.7500000    0.0000000    0.7500000
 0  0 -1 -1  0  0  0 -1  0    0.7500000    0.0000000    0.7500000
 1  0  0  0  0 -1  0  1  0    0.7500000    0.0000000    0.7500000
-1  0  0  0  0  1  0 -1  0    0.7500000    0.0000000    0.7500000
 0  0 -1 -1  0  0  0  1  0    0.7500000    0.0000000    0.7500000
 0  0  1  1  0  0  0 -1  0    0.7500000    0.0000000    0.7500000
-1  0  0  0  0  1  0  1  0    0.7500000    0.0000000    0.7500000
 1  0  0  0  0 -1  0 -1  0    0.7500000    0.0000000    0.7500000
 0  0 -1  1  0  0  0 -1  0    0.7500000    0.0000000    0.7500000
 0  0  1 -1  0  0  0  1  0    0.7500000    0.0000000    0.7500000
-1  0  0  0  0 -1  0 -1  0    0.7500000    0.0000000    0.7500000
 1  0  0  0  0  1  0  1  0    0.7500000    0.0000000    0.7500000
 0  0  1 -1  0  0  0 -1  0    0.7500000    0.0000000    0.7500000
 0  0 -1  1  0  0  0  1  0    0.7500000    0.0000000    0.7500000
 1  0  0  0  0  1  0 -1  0    0.7500000    0.0000000    0.7500000
-1  0  0  0  0 -1  0  1  0    0.7500000    0.0000000    0.7500000
 1  0  0  0  1  0  0  0  1    0.5000000    0.7500000    0.7500000
-1  0  0  0 -1  0  0  0 -1    0.5000000    0.7500000    0.7500000
 0  0 -1  0  1  0  1  0  0    0.5000000    0.7500000    0.7500000
 0  0  1  0 -1  0 -1  0  0    0.5000000    0.7500000    0.7500000
-1  0  0  0  1  0  0  0 -1    0.5000000    0.7500000    0.7500000
 1  0  0  0 -1  0  0  0  1    0.5000000    0.7500000    0.7500000
 0  0  1  0  1  0 -1  0  0    0.5000000    0.7500000    0.7500000
 0  0 -1  0 -1  0  1  0  0    0.5000000    0.7500000    0.7500000
 1  0  0  0 -1  0  0  0 -1    0.5000000    0.7500000    0.7500000
-1  0  0  0  1  0  0  0  1    0.5000000    0.7500000    0.7500000
 0  0 -1  0 -1  0 -1  0  0    0.5000000    0.7500000    0.7500000
 0  0  1  0  1  0  1  0  0    0.5000000    0.7500000    0.7500000
-1  0  0  0 -1  0  0  0  1    0.5000000    0.7500000    0.7500000
 1  0  0  0  1  0  0  0 -1    0.5000000    0.7500000    0.7500000
 0  0  1  0 -1  0  1  0  0    0.5000000    0.7500000    0.7500000
 0  0 -1  0  1  0 -1  0  0    0.5000000    0.7500000    0.7500000
 0  1  0  0  0  1  1  0  0    0.5000000    0.7500000    0.7500000
 0 -1  0  0  0 -1 -1  0  0    0.5000000    0.7500000    0.7500000
 0  1  0  1  0  0  0  0 -1    0.5000000    0.7500000    0.7500000
 0 -1  0 -1  0  0  0  0  1    0.5000000    0.7500000    0.7500000
 0  1  0  0  0 -1 -1  0  0    0.5000000    0.7500000    0.7500000
 0 -1  0  0  0  1  1  0  0    0.5000000    0.7500000    0.7500000
 0  1  0 -1  0  0  0  0  1    0.5000000    0.7500000    0.7500000
 0 -1  0  1  0  0  0  0 -1    0.5000000    0.7500000    0.7500000
 0 -1  0  0  0 -1  1  0  0    0.5000000    0.7500000    0.7500000
 0  1  0  0  0  1 -1  0  0    0.5000000    0.7500000    0.7500000
 0 -1  0 -1  0  0  0  0 -1    0.5000000    0.7500000    0.7500000
 0  1  0  1  0  0  0  0  1    0.5000000    0.7500000    0.7500000
 0 -1  0  0  0  1 -1  0  0    0.5000000    0.7500000    0.7500000
 0  1  0  0  0 -1  1  0  0    0.5000000    0.7500000    0.7500000
 0 -1  0  1  0  0  0  0  1    0.5000000    0.7500000    0.7500000
 0  1  0 -1  0  0  0  0 -1    0.5000000    0.7500000    0.7500000
 0  0  1  1  0  0  0  1  0    0.5000000    0.7500000    0.7500000
 0  0 -1 -1  0  0  0 -1  0    0.5000000    0.7500000    0.7500000
 1  0  0  0  0 -1  0  1  0    0.5000000    0.7500000    0.7500000
-1  0  0  0  0  1  0 -1  0    0.5000000    0.7500000    0.7500000
 0  0 -1 -1  0  0  0  1  0    0.5000000    0.7500000    0.7500000
 0  0  1  1  0  0  0 -1  0    0.5000000    0.7500000    0.7500000
-1  0  0  0  0  1  0  1  0    0.5000000    0.7500000    0.7500000
 1  0  0  0  0 -1  0 -1  0    0.5000000    0.7500000    0.7500000
 0  0 -1  1  0  0  0 -1  0    0.5000000    0.7500000    0.7500000
 0  0  1 -1  0  0  0  1  0    0.5000000    0.7500000    0.7500000
-1  0  0  0  0 -1  0 -1  0    0.5000000    0.7500000    0.7500000
 1  0  0  0  0  1  0  1  0    0.5000000    0.7500000    0.7500000
 0  0  1 -1  0  0  0 -1  0    0.5000000    0.7500000    0.7500000
 0  0 -1  1  0  0  0  1  0    0.5000000    0.7500000    0.7500000
 1  0  0  0  0  1  0 -1  0    0.5000000    0.7500000    0.7500000
-1  0  0  0  0 -1  0  1  0    0.5000000    0.7500000    0.7500000
 1  0  0  0  1  0  0  0  1    0.2500000    0.5000000    0.7500000
-1  0  0  0 -1  0  0  0 -1    0.2500000    0.5000000    0.7500000
 0  0 -1  0  1  0  1  0  0    0.2500000    0.5000000    0.7500000
 0  0  1  0 -1  0 -1  0  0    0.2500000    0.5000000    0.7500000
-1  0  0  0  1  0  0  0 -1    0.2500000    0.5000000    0.7500000
 1  0  0  0 -1  0  0  0  1    0.2500000    0.5000000    0.7500000
 0  0  1  0  1  0 -1  0  0    0.2500000    0.5000000    0.7500000
 0  0 -1  0 -1  0  1  0  0    0.2500000    0.5000000    0.7500000
 1  0  0  0 -1  0  0  0 -1    0.2500000    0.5000000    0.7500000
-1  0  0  0  1  0  0  0  1    0.2500000    0.5000000    0.7500000
 0  0 -1  0 -1  0 -1  0  0    0.2500000    0.5000000    0.7500000
 0  0  1  0  1  0  1  0  0    0.2500000    0.5000000    0.7500000
-1  0  0  0 -1  0  0  0  1    0.2500000    0.5000000    0.7500000
 1  0  0  0  1  0  0  0 -1    0.2500000    0.5000000    0.7500000
 0  0  1  0 -1  0  1  0  0    0.2500000    0.5000000    0.7500000
 0  0 -1  0  1  0 -1  0  0    0.2500000    0.5000000    0.7500000
 0  1  0  0  0  1  1  0  0    0.2500000    0.5000000    0.7500000
 0 -1  0  0  0 -1 -1  0  0    0.2500000    0.5000000    0.7500000
 0  1  0  1  0  0  0  0 -1    0.2500000    0.5000000    0.7500000
 0 -1  0 -1  0  0  0  0  1    0.2500000    0.5000000    0.7500000
 0  1  0  0  0 -1 -1  0  0    0.2500000    0.5000000    0.7500000
 0 -1  0  0  0  1  1  0  0    0.2500000    0.5000000    0.7500000
 0  1  0 -1  0  0  0  0  1    0.2500000    0.5000000    0.7500000
 0 -1  0  1  0  0  0  0 -1    0.2500000    0.5000000    0.7500000
 0 -1  0  0  0 -1  1  0  0    0.2500000    0.5000000    0.7500000
 0  1  0  0  0  1 -1  0  0    0.2500000    0.5000000    0.7500000
 0 -1  0 -1  0  0  0  0 -1    0.2500000    0.5000000    0.7500000
 0  1  0  1  0  0  0  0  1    0.2500000    0.5000000    0.7500000
 0 -1  0  0  0  1 -1  0  0    0.2500000    0.5000000    0.7500000
 0  1  0  0  0 -1  1  0  0    0.2500000    0.5000000    0.7500000
 0 -1  0  1  0  0  0  0  1    0.2500000    0.5000000    0.7500000
 0  1  0 -1  0  0  0  0 -1    0.2500000    0.5000000    0.7500000
 0  0  1  1  0  0  0  1  0    0.2500000    0.5000000    0.7500000
 0  0 -1 -1  0  0  0 -1  0    0.2500000    0.5000000    0.7500000
 1  0  0  0  0 -1  0  1  0    0.2500000    0.5000000    0.7500000
-1  0  0  0  0  1  0 -1  0    0.2500000    0.5000000    0.7500000
 0  0 -1 -1  0  0  0  1  0    0.2500000    0.5000000    0.7500000
 0  0  1  1  0  0  0 -1  0    0.2500000    0.5000000    0.7500000
-1  0  0  0  0  1  0  1  0    0.2500000    0.5000000    0.7500000
 1  0  0  0  0 -1  0 -1  0    0.2500000    0.5000000    0.7500000
 0  0 -1  1  0  0  0 -1  0    0.2500000    0.5000000    0.7500000
 0  0  1 -1  0  0  0  1  0    0.2500000    0.5000000    0.7500000
-1  0  0  0  0 -1  0 -1  0    0.2500000    0.5000000    0.7500000
 1  0  0  0  0  1  0  1  0    0.2500000    0.5000000    0.7500000
 0  0  1 -1  0  0  0 -1  0    0.2500000    0.5000000    0.7500000
 0  0 -1  1  0  0  0  1  0    0.2500000    0.5000000    0.7500000
 1  0  0  0  0  1  0 -1  0    0.2500000    0.5000000    0.7500000
-1  0  0  0  0 -1  0  1  0    0.2500000    0.5000000    0.7500000
 1  0  0  0  1  0  0  0  1    0.2500000    0.2500000    0.5000000
-1  0  0  0 -1  0  0  0 -1    0.2500000    0.2500000    0.5000000
 0  0 -1  0  1  0  1  0  0    0.2500000    0.2500000    0.5000000
 0  0  1  0 -1  0 -1  0  0    0.2500000    0.2500000    0.5000000
-1  0  0  0  1  0  0  0 -1    0.2500000    0.2500000    0.5000000
 1  0  0  0 -1  0  0  0  1    0.2500000    0.2500000    0.5000000
 0  0  1  0  1  0 -1  0  0    0.2500000    0.2500000    0.5000000
 0  0 -1  0 -1  0  1  0  0    0.2500000    0.2500000    0.5000000
 1  0  0  0 -1  0  0  0 -1    0.2500000    0.2500000    0.5000000
-1  0  0  0  1  0  0  0  1    0.2500000    0.2500000    0.5000000
 0  0 -1  0 -1  0 -1  0  0    0.2500000    0.2500000    0.5000000
 0  0  1  0  1  0  1  0  0    0.2500000    0.2500000    0.5000000
-1  0  0  0 -1  0  0  0  1    0.2500000    0.2500000    0.5000000
 1  0  0  0  1  0  0  0 -1    0.2500000    0.2500000    0.5000000
 0  0  1  0 -1  0  1  0  0    0.2500000    0.2500000    0.5000000
 0  0 -1  0  1  0 -1  0  0    0.2500000    0.2500000    0.5000000
 0  1  0  0  0  1  1  0  0    0.2500000    0.2500000    0.5000000
 0 -1  0  0  0 -1 -1  0  0    0.2500000    0.2500000    0.5000000
 0  1  0  1  0  0  0  0 -1    0.2500000    0.2500000    0.5000000
 0 -1  0 -1  0  0  0  0  1    0.2500000    0.2500000    0.5000000
 0  1  0  0  0 -1 -1  0  0    0.2500000    0.2500000    0.5000000
 0 -1  0  0  0  1  1  0  0    0.2500000    0.2500000    0.5000000
 0  1  0 -1  0  0  0  0  1    0.2500000    0.2500000    0.5000000
 0 -1  0  1  0  0  0  0 -1    0.2500000    0.2500000    0.5000000
 0 -1  0  0  0 -1  1  0  0    0.2500000    0.2500000    0.5000000
 0  1  0  0  0  1 -1  0  0    0.2500000    0.2500000    0.5000000
 0 -1  0 -1  0  0  0  0 -1    0.2500000    0.2500000    0.5000000
 0  1  0  1  0  0  0  0  1    0.2500000    0.2500000    0.5000000
 0 -1  0  0  0  1 -1  0  0    0.2500000    0.2500000    0.5000000
 0  1  0  0  0 -1  1  0  0    0.2500000    0.2500000    0.5000000
 0 -1  0  1  0  0  0  0  1    0.2500000    0.2500000    0.5000000
 0  1  0 -1  0  0  0  0 -1    0.2500000    0.2500000    0.5000000
 0  0  1  1  0  0  0  1  0    0.2500000    0.2500000    0.5000000
 0  0 -1 -1  0  0  0 -1  0    0.2500000    0.2500000    0.5000000
 1  0  0  0  0 -1  0  1  0    0.2500000    0.2500000    0.5000000
-1  0  0  0  0  1  0 -1  0    0.2500000    0.2500000    0.5000000
 0  0 -1 -1  0  0  0  1  0    0.2500000    0.2500000    0.5000000
 0  0  1  1  0  0  0 -1  0    0.2500000    0.2500000    0.5000000
-1  0  0  0  0  1  0  1  0    0.2500000    0.2500000    0.5000000
 1  0  0  0  0 -1  0 -1  0    0.2500000    0.2500000    0.5000000
 0  0 -1  1  0  0  0 -1  0    0.2500000    0.2500000    0.5000000
 0  0  1 -1  0  0  0  1  0    0.2500000    0.2500000    0.5000000
-1  0  0  0  0 -1  0 -1  0    0.2500000    0.2500000    0.5000000
 1  0  0  0  0  1  0  1  0    0.2500000    0.2500000    0.5000000
 0  0  1 -1  0  0  0 -1  0    0.2500000    0.2500000    0.5000000
 0  0 -1  1  0  0  0  1  0    0.2500000    0.2500000    0.5000000
 1  0  0  0  0  1  0 -1  0    0.2500000    0.2500000    0.5000000
-1  0  0  0  0 -1  0  1  0    0.2500000    0.2500000    0.5000000
 1  0  0  0  1  0  0  0  1    0.0000000    0.0000000    0.5000000
-1  0  0  0 -1  0  0  0 -1    0.0000000    0.0000000    0.5000000
 0  0 -1  0  1  0  1  0  0    0.0000000    0.0000000    0.5000000
 0  0  1  0 -1  0 -1  0  0    0.0000000    0.0000000    0.5000000
-1  0  0  0  1  0  0  0 -1    0.0000000    0.0000000    0.5000000
 1  0  0  0 -1  0  0  0  1    0.0000000    0.0000000    0.5000000
 0  0  1  0  1  0 -1  0  0    0.0000000    0.0000000    0.5000000
 0  0 -1  0 -1  0  1  0  0    0.0000000    0.0000000    0.5000000
 1  0  0  0 -1  0  0  0 -1    0.0000000    0.0000000    0.5000000
-1  0  0  0  1  0  0  0  1    0.0000000    0.0000000    0.5000000
 0  0 -1  0 -1  0 -1  0  0    0.0000000    0.0000000    0.5000000
 0  0  1  0  1  0  1  0  0    0.0000000    0.0000000    0.5000000
-1  0  0  0 -1  0  0  0  1    0.0000000    0.0000000    0.5000000
 1  0  0  0  1  0  0  0 -1    0.0000000    0.0000000    0.5000000
 0  0  1  0 -1  0  1  0  0    0.0000000    0.0000000    0.5000000
 0  0 -1  0  1  0 -1  0  0    0.0000000    0.0000000    0.5000000
 0  1  0  0  0  1  1  0  0    0.0000000    0.0000000    0.5000000
 0 -1  0  0  0 -1 -1  0  0    0.0000000    0.0000000    0.5000000
 0  1  0  1  0  0  0  0 -1    0.0000000    0.0000000    0.5000000
 0 -1  0 -1  0  0  0  0  1    0.0000000    0.0000000    0.5000000
 0  1  0  0  0 -1 -1  0  0    0.0000000    0.0000000    0.5000000
 0 -1  0  0  0  1  1  0  0    0.0000000    0.0000000    0.5000000
 0  1  0 -1  0  0  0  0  1    0.0000000    0.0000000    0.5000000
 0 -1  0  1  0  0  0  0 -1    0.0000000    0.0000000    0.5000000
 0 -1  0  0  0 -1  1  0  0    0.0000000    0.0000000    0.5000000
 0  1  0  0  0  1 -1  0  0    0.0000000    0.0000000    0.5000000
 0 -1  0 -1  0  0  0  0 -1    0.0000000    0.0000000    0.5000000
 0  1  0  1  0  0  0  0  1    0.0000000    0.0000000    0.5000000
 0 -1  0  0  0  1 -1  0  0    0.0000000    0.0000000    0.5000000
 0  1  0  0  0 -1  1  0  0    0.0000000    0.0000000    0.5000000
 0 -1  0  1  0  0  0  0  1    0.0000000    0.0000000    0.5000000
 0  1  0 -1  0  0  0  0 -1    0.0000000    0.0000000    0.5000000
 0  0  1  1  0  0  0  1  0    0.0000000    0.0000000    0.5000000
 0  0 -1 -1  0  0  0 -1  0    0.0000000    0.0000000    0.5000000
 1  0  0  0  0 -1  0  1  0    0.0000000    0.0000000    0.5000000
-1  0  0  0  0  1  0 -1  0    0.0000000    0.0000000    0.5000000
 0  0 -1 -1  0  0  0  1  0    0.0000000    0.0000000    0.5000000
 0  0  1  1  0  0  0 -1  0    0.0000000    0.0000000    0.5000000
-1  0  0  0  0  1  0  1  0    0.0000000    0.0000000    0.5000000
 1  0  0  0  0 -1  0 -1  0    0.0000000    0.0000000    0.5000000
 0  0 -1  1  0  0  0 -1  0    0.0000000    0.0000000    0.5000000
 0  0  1 -1  0  0  0  1  0    0.0000000    0.0000000    0.5000000
-1  0  0  0  0 -1  0 -1  0    0.0000000    0.0000000    0.5000000
 1  0  0  0  0  1  0  1  0    0.0000000    0.0000000    0.5000000
 0  0  1 -1  0  0  0 -1  0    0.0000000    0.0000000    0.5000000
 0  0 -1  1  0  0  0  1  0    0.0000000    0.0000000    0.5000000
 1  0  0  0  0  1  0 -1  0    0.0000000    0.0000000    0.5000000
-1  0  0  0  0 -1  0  1  0    0.0000000    0.0000000    0.5000000
 1  0  0  0  1  0  0  0  1    0.7500000    0.7500000    0.5000000
-1  0  0  0 -1  0  0  0 -1    0.7500000    0.7500000    0.5000000
 0  0 -1  0  1  0  1  0  0    0.7500000    0.7500000    0.5000000
 0  0  1  0 -1  0 -1  0  0    0.7500000    0.7500000    0.5000000
-1  0  0  0  1  0  0  0 -1    0.7500000    0.7500000    0.5000000
 1  0  0  0 -1  0  0  0  1    0.7500000    0.7500000    0.5000000
 0  0  1  0  1  0 -1  0  0    0.7500000    0.7500000    0.5000000
 0  0 -1  0 -1  0  1  0  0    0.7500000    0.7500000    0.5000000
 1  0  0  0 -1  0  0  0 -1    0.7500000    0.7500000    0.5000000
-1  0  0  0  1  0  0  0  1    0.7500000    0.7500000    0.5000000
 0  0 -1  0 -1  0 -1  0  0    0.7500000    0.7500000    0.5000000
 0  0  1  0  1  0  1  0  0    0.7500000    0.7500000    0.5000000
-1  0  0  0 -1  0  0  0  1    0.7500000    0.7500000    0.5000000
 1  0  0  0  1  0  0  0 -1    0.7500000    0.7500000    0.5000000
 0  0  1  0 -1  0  1  0  0    0.7500000    0.7500000    0.5000000
 0  0 -1  0  1  0 -1  0  0    0.7500000    0.7500000    0.5000000
 0  1  0  0  0  1  1  0  0    0.7500000    0.7500000    0.5000000
 0 -1  0  0  0 -1 -1  0  0    0.7500000    0.7500000    0.5000000
 0  1  0  1  0  0  0  0 -1    0.7500000    0.7500000    0.5000000
 0 -1  0 -1  0  0  0  0  1    0.7500000    0.7500000    0.5000000
 0  1  0  0  0 -1 -1  0  0    0.7500000    0.7500000    0.5000000
 0 -1  0  0  0  1  1  0  0    0.7500000    0.7500000    0.5000000
 0  1  0 -1  0  0  0  0  1    0.7500000    0.7500000    0.5000000
 0 -1  0  1  0  0  0  0 -1    0.7500000    0.7500000    0.5000000
 0 -1  0  0  0 -1  1  0  0    0.7500000    0.7500000    0.5000000
 0  1  0  0  0  1 -1  0  0    0.7500000    0.7500000    0.5000000
 0 -1  0 -1  0  0  0  0 -1    0.7500000    0.7500000    0.5000000
 0  1  0  1  0  0  0  0  1    0.7500000    0.7500000    0.5000000
 0 -1  0  0  0  1 -1  0  0    0.7500000    0.7500000    0.5000000
 0  1  0  0  0 -1  1  0  0    0.7500000    0.7500000    0.5000000
 0 -1  0  1  0  0  0  0  1    0.7500000    0.7500000    0.5000000
 0  1  0 -1  0  0  0  0 -1    0.7500000    0.7500000    0.5000000
 0  0  1  1  0  0  0  1  0    0.7500000    0.7500000    0.5000000
 0  0 -1 -1  0  0  0 -1  0    0.7500000    0.7500000    0.5000000
 1  0  0  0  0 -1  0  1  0    0.7500000    0.7500000    0.5000000
-1  0  0  0  0  1  0 -1  0    0.7500000    0.7500000    0.5000000
 0  0 -1 -1  0  0  0  1  0    0.7500000    0.7500000    0.5000000
 0  0  1  1  0  0  0 -1  0    0.7500000    0.7500000    0.5000000
-1  0  0  0  0  1  0  1  0    0.7500000    0.7500000    0.5000000
 1  0  0  0  0 -1  0 -1  0    0.7500000    0.7500000    0.5000000
 0  0 -1  1  0  0  0 -1  0    0.7500000    0.7500000    0.5000000
 0  0  1 -1  0  0  0  1  0    0.7500000    0.7500000    0.5000000
-1  0  0  0  0 -1  0 -1  0    0.7500000    0.7500000    0.5000000
 1  0  0  0  0  1  0  1  0    0.7500000    0.7500000    0.5000000
 0  0  1 -1  0  0  0 -1  0    0.7500000    0.7500000    0.5000000
 0  0 -1  1  0  0  0  1  0    0.7500000    0.7500000    0.5000000
 1  0  0  0  0  1  0 -1  0    0.7500000    0.7500000    0.5000000
-1  0  0  0  0 -1  0  1  0    0.7500000    0.7500000    0.5000000
 1  0  0  0  1  0  0  0  1    0.5000000    0.5000000    0.5000000
-1  0  0  0 -1  0  0  0 -1    0.5000000    0.5000000    0.5000000
 0  0 -1  0  1  0  1  0  0    0.5000000    0.5000000    0.5000000
 0  0  1  0 -1  0 -1  0  0    0.5000000    0.5000000    0.5000000
-1  0  0  0  1  0  0  0 -1    0.5000000    0.5000000    0.5000000
 1  0  0  0 -1  0  0  0  1    0.5000000    0.5000000    0.5000000
 0  0  1  0  1  0 -1  0  0    0.5000000    0.5000000    0.5000000
 0  0 -1  0 -1  0  1  0  0    0.5000000    0.5000000    0.5000000
 1  0  0  0 -1  0  0  0 -1    0.5000000    0.5000000    0.5000000
-1  0  0  0  1  0  0  0  1    0.5000000    0.5000000    0.5000000
 0  0 -1  0 -1  0 -1  0  0    0.5000000    0.5000000    0.5000000
 0  0  1  0  1  0  1  0  0    0.5000000    0.5000000    0.5000000
-1  0  0  0 -1  0  0  0  1    0.5000000    0.5000000    0.5000000
 1  0  0  0  1  0  0  0 -1    0.5000000    0.5000000    0.5000000
 0  0  1  0 -1  0  1  0  0    0.5000000    0.5000000    0.5000000
 0  0 -1  0  1  0 -1  0  0    0.5000000    0.5000000    0.5000000
 0  1  0  0  0  1  1  0  0    0.5000000    0.5000000    0.5000000
 0 -1  0  0  0 -1 -1  0  0    0.5000000    0.5000000    0.5000000
 0  1  0  1  0  0  0  0 -1    0.5000000    0.5000000    0.5000000
 0 -1  0 -1  0  0  0  0  1    0.5000000    0.5000000    0.5000000
 0  1  0  0  0 -1 -1  0  0    0.5000000    0.5000000    0.5000000
 0 -1  0  0  0  1  1  0  0    0.5000000    0.5000000    0.5000000
 0  1  0 -1  0  0  0  0  1    0.5000000    0.5000000    0.5000000
 0 -1  0  1  0  0  0  0 -1    0.5000000    0.5000000    0.5000000
 0 -1  0  0  0 -1  1  0  0    0.5000000    0.5000000    0.5000000
 0  1  0  0  0  1 -1  0  0    0.5000000    0.5000000    0.5000000
 0 -1  0 -1  0  0  0  0 -1    0.5000000    0.5000000    0.5000000
 0  1  0  1  0  0  0  0  1    0.5000000    0.5000000    0.5000000
 0 -1  0  0  0  1 -1  0  0    0.5000000    0.5000000    0.5000000
 0  1  0  0  0 -1  1  0  0    0.5000000    0.5000000    0.5000000
 0 -1  0  1  0  0  0  0  1    0.5000000    0.5000000    0.5000000
 0  1  0 -1  0  0  0  0 -1    0.5000000    0.5000000    0.5000000
 0  0  1  1  0  0  0  1  0    0.5000000    0.5000000    0.5000000
 0  0 -1 -1  0  0  0 -1  0    0.5000000    0.5000000    0.5000000
 1  0  0  0  0 -1  0  1  0    0.5000000    0.5000000    0.5000000
-1  0  0  0  0  1  0 -1  0    0.5000000    0.5000000    0.5000000
 0  0 -1 -1  0  0  0  1  0    0.5000000    0.5000000    0.5000000
 0  0  1  1  0  0  0 -1  0    0.5000000    0.5000000    0.5000000
-1  0  0  0  0  1  0  1  0    0.5000000    0.5000000    0.5000000
 1  0  0  0  0 -1  0 -1  0    0.5000000    0.5000000    0.5000000
 0  0 -1  1  0  0  0 -1  0    0.5000000    0.5000000    0.5000000
 0  0  1 -1  0  0  0  1  0    0.5000000    0.5000000    0.5000000
-1  0  0  0  0 -1  0 -1  0    0.5000000    0.5000000    0.5000000
 1  0  0  0  0  1  0  1  0    0.5000000    0.5000000    0.5000000
 0  0  1 -1  0  0  0 -1  0    0.5000000    0.5000000    0.5000000
 0  0 -1  1  0  0  0  1  0    0.5000000    0.5000000    0.5000000
 1  0  0  0  0  1  0 -1  0    0.5000000    0.5000000    0.5000000
-1  0  0  0  0 -1  0  1  0    0.5000000    0.5000000    0.5000000
 1  0  0  0  1  0  0  0  1    0.5000000    0.2500000    0.2500000
-1  0  0  0 -1  0  0  0 -1    0.5000000    0.2500000    0.2500000
 0  0 -1  0  1  0  1  0  0    0.5000000    0.2500000    0.2500000
 0  0  1  0 -1  0 -1  0  0    0.5000000    0.2500000    0.2500000
-1  0  0  0  1  0  0  0 -1    0.5000000    0.2500000    0.2500000
 1  0  0  0 -1  0  0  0  1    0.5000000    0.2500000    0.2500000
 0  0  1  0  1  0 -1  0  0    0.5000000    0.2500000    0.2500000
 0  0 -1  0 -1  0  1  0  0    0.5000000    0.2500000    0.2500000
 1  0  0  0 -1  0  0  0 -1    0.5000000    0.2500000    0.2500000
-1  0  0  0  1  0  0  0  1    0.5000000    0.2500000    0.2500000
 0  0 -1  0 -1  0 -1  0  0    0.5000000    0.2500000    0.2500000
 0  0  1  0  1  0  1  0  0    0.5000000    0.2500000    0.2500000
-1  0  0  0 -1  0  0  0  1    0.5000000    0.2500000    0.2500000
 1  0  0  0  1  0  0  0 -1    0.5000000    0.2500000    0.2500000
 0  0  1  0 -1  0  1  0  0    0.5000000    0.2500000    0.2500000
 0  0 -1  0  1  0 -1  0  0    0.5000000    0.2500000    0.2500000
 0  1  0  0  0  1  1  0  0    0.5000000    0.2500000    0.2500000
 0 -1  0  0  0 -1 -1  0  0    0.5000000    0.2500000    0.2500000
 0  1  0  1  0  0  0  0 -1    0.5000000    0.2500000    0.2500000
 0 -1  0 -1  0  0  0  0  1    0.5000000    0.2500000    0.2500000
 0  1  0  0  0 -1 -1  0  0    0.5000000    0.2500000    0.2500000
 0 -1  0  0  0  1  1  0  0    0.5000000    0.2500000    0.2500000
 0  1  0 -1  0  0  0  0  1    0.5000000    0.2500000    0.2500000
 0 -1  0  1  0  0  0  0 -1    0.5000000    0.2500000    0.2500000
 0 -1  0  0  0 -1  1  0  0    0.5000000    0.2500000    0.2500000
 0  1  0  0  0  1 -1  0  0    0.5000000    0.2500000    0.2500000
 0 -1  0 -1  0  0  0  0 -1    0.5000000    0.2500000    0.2500000
 0  1  0  1  0  0  0  0  1    0.5000000    0.2500000    0.2500000
 0 -1  0  0  0  1 -1  0  0    0.5000000    0.2500000    0.2500000
 0  1  0  0  0 -1  1  0  0    0.5000000    0.2500000    0.2500000
 0 -1  0  1  0  0  0  0  1    0.5000000    0.2500000    0.2500000
 0  1  0 -1  0  0  0  0 -1    0.5000000    0.2500000    0.2500000
 0  0  1  1  0  0  0  1  0    0.5000000    0.2500000    0.2500000
 0  0 -1 -1  0  0  0 -1  0    0.5000000    0.2500000    0.2500000
 1  0  0  0  0 -1  0  1  0    0.5000000    0.2500000    0.2500000
-1  0  0  0  0  1  0 -1  0    0.5000000    0.2500000    0.2500000
 0  0 -1 -1  0  0  0  1  0    0.5000000    0.2500000    0.2500000
 0  0  1  1  0  0  0 -1  0    0.5000000    0.2500000    0.2500000
-1  0  0  0  0  1  0  1  0    0.5000000    0.2500000    0.2500000
 1  0  0  0  0 -1  0 -1  0    0.5000000    0.2500000    0.2500000
 0  0 -1  1  0  0  0 -1  0    0.5000000    0.2500000    0.2500000
 0  0  1 -1  0  0  0  1  0    0.5000000    0.2500000    0.2500000
-1  0  0  0  0 -1  0 -1  0    0.5000000    0.2500000    0.2500000
 1  0  0  0  0  1  0  1  0    0.5000000    0.2500000    0.2500000
 0  0  1 -1  0  0  0 -1  0    0.5000000    0.2500000    0.2500000
 0  0 -1  1  0  0  0  1  0    0.5000000    0.2500000    0.2500000
 1  0  0  0  0  1  0 -1  0    0.5000000    0.2500000    0.2500000
-1  0  0  0  0 -1  0  1  0    0.5000000    0.2500000    0.2500000
 1  0  0  0  1  0  0  0  1    0.2500000    0.0000000    0.2500000
-1  0  0  0 -1  0  0  0 -1    0.2500000    0.0000000    0.2500000
 0  0 -1  0  1  0  1  0  0    0.2500000    0.0000000    0.2500000
 0  0  1  0 -1  0 -1  0  0    0.2500000    0.0000000    0.2500000
-1  0  0  0  1  0  0  0 -1    0.2500000    0.0000000    0.2500000
 1  0  0  0 -1  0  0  0  1    0.2500000    0.0000000    0.2500000
 0  0  1  0  1  0 -1  0  0    0.2500000    0.0000000    0.2500000
 0  0 -1  0 -1  0  1  0  0    0.2500000    0.0000000    0.2500000
 1  0  0  0 -1  0  0  0 -1    0.2500000    0.0000000    0.2500000
-1  0  0  0  1  0  0  0  1    0.2500000    0.0000000    0.2500000
 0  0 -1  0 -1  0 -1  0  0    0.2500000    0.0000000    0.2500000
 0  0  1  0  1  0  1  0  0    0.2500000    0.0000000    0.2500000
-1  0  0  0 -1  0  0  0  1    0.2500000    0.0000000    0.2500000
 1  0  0  0  1  0  0  0 -1    0.2500000    0.0000000    0.2500000
 0  0  1  0 -1  0  1  0  0    0.2500000    0.0000000    0.2500000
 0  0 -1  0  1  0 -1  0  0    0.2500000    0.0000000    0.2500000
 0  1  0  0  0  1  1  0  0    0.2500000    0.0000000    0.2500000
 0 -1  0  0  0 -1 -1  0  0    0.2500000    0.0000000    0.2500000
 0  1  0  1  0  0  0  0 -1    0.2500000    0.0000000    0.2500000
 0 -1  0 -1  0  0  0  0  1    0.2500000    0.0000000    0.2500000
 0  1  0  0  0 -1 -1  0  0    0.2500000    0.0000000    0.2500000
 0 -1  0  0  0  1  1  0  0    0.2500000    0.0000000    0.2500000
 0  1  0 -1  0  0  0  0  1    0.2500000    0.0000000    0.2500000
 0 -1  0  1  0  0  0  0 -1    0.2500000    0.0000000    0.2500000
 0 -1  0  0  0 -1  1  0  0    0.2500000    0.0000000    0.2500000
 0  1  0  0  0  1 -1  0  0    0.2500000    0.0000000    0.2500000
 0 -1  0 -1  0  0  0  0 -1    0.2500000    0.0000000    0.2500000
 0  1  0  1  0  0  0  0  1    0.2500000    0.0000000    0.2500000
 0 -1  0  0  0  1 -1  0  0    0.2500000    0.0000000    0.2500000
 0  1  0  0  0 -1  1  0  0    0.2500000    0.0000000    0.2500000
 0 -1  0  1  0  0  0  0  1    0.2500000    0.0000000    0.2500000
 0  1  0 -1  0  0  0  0 -1    0.2500000    0.0000000    0.2500000
 0  0  1  1  0  0  0  1  0    0.2500000    0.0000000    0.2500000
 0  0 -1 -1  0  0  0 -1  0    0.2500000    0.0000000    0.2500000
 1  0  0  0  0 -1  0  1  0    0.2500000    0.0000000    0.2500000
-1  0  0  0  0  1  0 -1  0    0.2500000    0.0000000    0.2500000
 0  0 -1 -1  0  0  0  1  0    0.2500000    0.0000000    0.2500000
 0  0  1  1  0  0  0 -1  0    0.2500000    0.0000000    0.2500000
-1  0  0  0  0  1  0  1  0    0.2500000    0.0000000    0.2500000
 1  0  0  0  0 -1  0 -1  0    0.2500000    0.0000000    0.2500000
 0  0 -1  1  0  0  0 -1  0    0.2500000    0.0000000    0.2500000
 0  0  1 -1  0  0  0  1  0    0.2500000    0.0000000    0.2500000
-1  0  0  0  0 -1  0 -1  0    0.2500000    0.0000000    0.2500000
 1  0  0  0  0  1  0  1  0    0.2500000    0.0000000    0.2500000
 0  0  1 -1  0  0  0 -1  0    0.2500000    0.0000000    0.2500000
 0  0 -1  1  0  0  0  1  0    0.2500000    0.0000000    0.2500000
 1  0  0  0  0  1  0 -1  0    0.2500000    0.0000000    0.2500000
-1  0  0  0  0 -1  0  1  0    0.2500000    0.0000000    0.2500000
 1  0  0  0  1  0  0  0  1    0.0000000    0.7500000    0.2500000
-1  0  0  0 -1  0  0  0 -1    0.0000000    0.7500000    0.2500000
 0  0 -1  0  1  0  1  0  0    0.0000000    0.7500000    0.2500000
 0  0  1  0 -1  0 -1  0  0    0.0000000    0.7500000    0.2500000
-1  0  0  0  1  0  0  0 -1    0.0000000    0.7500000    0.2500000
 1  0  0  0 -1  0  0  0  1    0.0000000    0.7500000    0.2500000
 0  0  1  0  1  0 -1  0  0    0.0000000    0.7500000    0.2500000
 0  0 -1  0 -1  0  1  0  0    0.0000000    0.7500000    0.2500000
 1  0  0  0 -1  0  0  0 -1    0.0000000    0.7500000    0.2500000
-1  0  0  0  1  0  0  0  1    0.0000000    0.7500000    0.2500000
 0  0 -1  0 -1  0 -1  0  0    0.0000000    0.7500000    0.2500000
 0  0  1  0  1  0  1  0  0    0.0000000    0.7500000    0.2500000
-1  0  0  0 -1  0  0  0  1    0.0000000    0.7500000    0.2500000
 1  0  0  0  1  0  0  0 -1    0.0000000    0.7500000    0.2500000
 0  0  1  0 -1  0  1  0  0    0.0000000    0.7500000    0.2500000
 0  0 -1  0  1  0 -1  0  0    0.0000000    0.7500000    0.2500000
 0  1  0  0  0  1  1  0  0    0.0000000    0.7500000    0.2500000
 0 -1  0  0  0 -1 -1  0  0    0.0000000    0.7500000    0.2500000
 0  1  0  1  0  0  0  0 -1    0.0000000    0.7500000    0.2500000
 0 -1  0 -1  0  0  0  0  1    0.0000000    0.7500000    0.2500000
 0  1  0  0  0 -1 -1  0  0    0.0000000    0.7500000    0.2500000
 0 -1  0  0  0  1  1  0  0    0.0000000    0.7500000    0.2500000
 0  1  0 -1  0  0  0  0  1    0.0000000    0.7500000    0.2500000
 0 -1  0  1  0  0  0  0 -1    0.0000000    0.7500000    0.2500000
 0 -1  0  0  0 -1  1  0  0    0.0000000    0.7500000    0.2500000
 0  1  0  0  0  1 -1  0  0    0.0000000    0.7500000    0.2500000
 0 -1  0 -1  0  0  0  0 -1    0.0000000    0.7500000    0.2500000
 0  1  0  1  0  0  0  0  1    0.0000000    0.7500000    0.2500000
 0 -1  0  0  0  1 -1  0  0    0.0000000    0.7500000    0.2500000
 0  1  0  0  0 -1  1  0  0    0.0000000    0.7500000    0.2500000
 0 -1  0  1  0  0  0  0  1    0.0000000    0.7500000    0.2500000
 0  1  0 -1  0  0  0  0 -1    0.0000000    0.7500000    0.2500000
 0  0  1  1  0  0  0  1  0    0.0000000    0.7500000    0.2500000
 0  0 -1 -1  0  0  0 -1  0    0.0000000    0.7500000    0.2500000
 1  0  0  0  0 -1  0  1  0    0.0000000    0.7500000    0.2500000
-1  0  0  0  0  1  0 -1  0    0.0000000    0.7500000    0.2500000
 0  0 -1 -1  0  0  0  1  0    0.0000000    0.7500000    0.2500000
 0  0  1  1  0  0  0 -1  0    0.0000000    0.7500000    0.2500000
-1  0  0  0  0  1  0  1  0    0.0000000    0.7500000    0.2500000
 1  0  0  0  0 -1  0 -1  0    0.0000000    0.7500000    0.2500000
 0  0 -1  1  0  0  0 -1  0    0.0000000    0.7500000    0.2500000
 0  0  1 -1  0  0  0  1  0    0.0000000    0.7500000    0.2500000
-1  0  0  0  0 -1  0 -1  0    0.0000000    0.7500000    0.2500000
 1  0  0  0  0  1  0  1  0    0.0000000    0.7500000    0.2500000
 0  0  1 -1  0  0  0 -1  0    0.0000000    0.7500000    0.2500000
 0  0 -1  1  0  0  0  1  0    0.0000000    0.7500000    0.2500000
 1  0  0  0  0  1  0 -1  0    0.0000000    0.7500000    0.2500000
-1  0  0  0  0 -1  0  1  0    0.0000000    0.7500000    0.2500000
 1  0  0  0  1  0  0  0  1    0.7500000    0.5000000    0.2500000
-1  0  0  0 -1  0  0  0 -1    0.7500000    0.5000000    0.2500000
 0  0 -1  0  1  0  1  0  0    0.7500000    0.5000000    0.2500000
 0  0  1  0 -1  0 -1  0  0    0.7500000    0.5000000    0.2500000
-1  0  0  0  1  0  0  0 -1    0.7500000    0.5000000    0.2500000
 1  0  0  0 -1  0  0  0  1    0.7500000    0.5000000    0.2500000
 0  0  1  0  1  0 -1  0  0    0.7500000    0.5000000    0.2500000
 0  0 -1  0 -1  0  1  0  0    0.7500000    0.5000000    0.2500000
 1  0  0  0 -1  0  0  0 -1    0.7500000    0.5000000    0.2500000
-1  0  0  0  1  0  0  0  1    0.7500000    0.5000000    0.2500000
 0  0 -1  0 -1  0 -1  0  0    0.7500000    0.5000000    0.2500000
 0  0  1  0  1  0  1  0  0    0.7500000    0.5000000    0.2500000
-1  0  0  0 -1  0  0  0  1    0.7500000    0.5000000    0.2500000
 1  0  0  0  1  0  0  0 -1    0.7500000    0.5000000    0.2500000
 0  0  1  0 -1  0  1  0  0    0.7500000    0.5000000    0.2500000
 0  0 -1  0  1  0 -1  0  0    0.7500000    0.5000000    0.2500000
 0  1  0  0  0  1  1  0  0    0.7500000    0.5000000    0.2500000
 0 -1  0  0  0 -1 -1  0  0    0.7500000    0.5000000    0.2500000
 0  1  0  1  0  0  0  0 -1    0.7500000    0.5000000    0.2500000
 0 -1  0 -1  0  0  0  0  1    0.7500000    0.5000000    0.2500000
 0  1  0  0  0 -1 -1  0  0    0.7500000    0.5000000    0.2500000
 0 -1  0  0  0  1  1  0  0    0.7500000    0.5000000    0.2500000
 0  1  0 -1  0  0  0  0  1    0.7500000    0.5000000    0.2500000
 0 -1  0  1  0  0  0  0 -1    0.7500000    0.5000000    0.2500000
 0 -1  0  0  0 -1  1  0  0    0.7500000    0.5000000    0.2500000
 0  1  0  0  0  1 -1  0  0    0.7500000    0.5000000    0.2500000
 0 -1  0 -1  0  0  0  0 -1    0.7500000    0.5000000    0.2500000
 0  1  0  1  0  0  0  0  1    0.7500000    0.5000000    0.2500000
 0 -1  0  0  0  1 -1  0  0    0.7500000    0.5000000    0.2500000
 0  1  0  0  0 -1  1  0  0    0.7500000    0.5000000    0.2500000
 0 -1  0  1  0  0  0  0  1    0.7500000    0.5000000    0.2500000
 0  1  0 -1  0  0  0  0 -1    0.7500000    0.5000000    0.2500000
 0  0  1  1  0  0  0  1  0    0.7500000    0.5000000    0.2500000
 0  0 -1 -1  0  0  0 -1  0    0.7500000    0.5000000    0.2500000
 1  0  0  0  0 -1  0  1  0    0.7500000    0.5000000    0.2500000
-1  0  0  0  0  1  0 -1  0    0.7500000    0.5000000    0.2500000
 0  0 -1 -1  0  0  0  1  0    0.7500000    0.5000000    0.2500000
 0  0  1  1  0  0  0 -1  0    0.7500000    0.5000000    0.2500000
-1  0  0  0  0  1  0  1  0    0.7500000    0.5000000    0.2500000
 1  0  0  0  0 -1  0 -1  0    0.7500000    0.5000000    0.2500000
 0  0 -1  1  0  0  0 -1  0    0.7500000    0.5000000    0.2500000
 0  0  1 -1  0  0  0  1  0    0.7500000    0.5000000    0.2500000
-1  0  0  0  0 -1  0 -1  0    0.7500000    0.5000000    0.2500000
 1  0  0  0  0  1  0  1  0    0.7500000    0.5000000    0.2500000
 0  0  1 -1  0  0  0 -1  0    0.7500000    0.5000000    0.2500000
 0  0 -1  1  0  0  0  1  0    0.7500000    0.5000000    0.2500000
 1  0  0  0  0  1  0 -1  0    0.7500000    0.5000000    0.2500000
-1  0  0  0  0 -1  0  1  0    0.7500000    0.5000000    0.2500000"""


def test_pure_trans(get_crystal_data):
    """Test for new implementation of search_pure_translations in
    symmetry.c (ee97ad17) against a previous version. The order of
    symmetry operations found by this new implementation may be
    different from that obtained by the older version but the set must
    be the same in rotations and very close in translations.
    """
    Al222_file = Path(__file__).parent / "Al222.yaml"
    crystal_data: CrystalData = get_crystal_data(Al222_file)
    sym_ops = get_symmetry(crystal_data.cell)

    rot_ref = []
    trans_ref = []
    for i, line in enumerate(sym_ops_str.split("\n")):
        arr = line.split()
        rot_ref += [int(x) for x in arr[:9]]
        trans_ref += [float(x) for x in arr[9:]]
    rot_ref = np.reshape(rot_ref, (-1, 3, 3))
    trans_ref = np.reshape(trans_ref, (-1, 3))
    nums = []
    for i, (r, t) in enumerate(
        zip(sym_ops["rotations"], sym_ops["translations"]),
    ):
        for j, (rr, tr) in enumerate(zip(rot_ref, trans_ref)):
            if (r == rr).all() and (np.abs(t - tr) < 1e-5).all():
                nums.append(j)
                break

    np.testing.assert_array_equal(np.sort(nums), np.arange(len(rot_ref)))
