/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cli;

import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandLineOption {
    private final Set<String> options = new HashSet<String>();
    private Class<?> argumentType = Void.TYPE;
    private String description;
    private String subcommand;
    private String deprecationWarning;

    public CommandLineOption(Iterable<String> options) {
        for (String option : options) {
            this.options.add(option);
        }
    }

    public Set<String> getOptions() {
        return this.options;
    }

    public CommandLineOption hasArgument() {
        this.argumentType = String.class;
        return this;
    }

    public CommandLineOption hasArguments() {
        this.argumentType = List.class;
        return this;
    }

    public String getSubcommand() {
        return this.subcommand;
    }

    public CommandLineOption mapsToSubcommand(String command) {
        this.subcommand = command;
        return this;
    }

    public String getDescription() {
        if (this.deprecationWarning == null) {
            return this.description;
        }
        return this.description + " [deprecated - " + this.deprecationWarning + "].";
    }

    public CommandLineOption hasDescription(String description) {
        this.description = description;
        return this;
    }

    public boolean getAllowsArguments() {
        return this.argumentType != Void.TYPE;
    }

    public boolean getAllowsMultipleArguments() {
        return this.argumentType == List.class;
    }

    public CommandLineOption deprecated(String deprecationWarning) {
        this.deprecationWarning = deprecationWarning;
        return this;
    }

    public String getDeprecationWarning() {
        return this.deprecationWarning;
    }
}

