/*
  sqclient -- gets a page from squid cache or purge it
  Copyright (C) 2003  Pedro Zorzenon Neto <pzn@autsens.com>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef _SQCLIENT_H
#define _SQCLIENT_H

#define SQUIDCLIENT "/usr/bin/squidclient"
/* IMPORTANT: just use it from localhost, never change to other host */
#define SQUIDCLIENTARGS "-h localhost -p 3128"

/* returns 1 if successfully retrieved page
 * returns 0 if could not retrieve */
int sqclient_retrieve_if_in_cache (char * url, char * outfile);

void sqclient_purge_from_cache(char * url);

#endif /* _SQCLIENT_H */
