/* ====================================================================
 * Copyright (c) 2003-2007, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _TEXTMODEL_TEST_H
#define _TEXTMODEL_TEST_H

#include <cppunit/TestFixture.h>
#include <cppunit/extensions/HelperMacros.h>
class TextModel;

class TextModelTest : public CppUnit::TestFixture
{
  CPPUNIT_TEST_SUITE( TextModelTest );
  CPPUNIT_TEST( testSingleCharAdd );
  CPPUNIT_TEST( testEmptyDelLeft );
  CPPUNIT_TEST( testEmptyDelRight );
  CPPUNIT_TEST( testAddReturn );
  CPPUNIT_TEST( testAddMultiLineLE );
  CPPUNIT_TEST( testAddMultiLine );
  CPPUNIT_TEST( testCalcNearestCursorPos );
  CPPUNIT_TEST_SUITE_END(); 

public:
  void setUp();
  void tearDown();

  // Tests
  void testSingleCharAdd();
  void testEmptyDelLeft();
  void testEmptyDelRight();
  void testAddReturn();
  void testAddMultiLineLE();
  void testAddMultiLine();

  void testCalcNearestCursorPos();

private:
  TextModel* _text;
};

#endif // _TEXTMODEL_TEST_H
