
from ufl import *
from sfc import jit
from time import time

_t = None
def tic():
    global _t
    _t = time()

def toc():
    global _t
    t = time() - _t
    _t = None
    return t

def timeit(input):
    tic()
    jit(input)
    t = toc()
    return t

for take in range(3):
    print "="*80
    print "Take", take
    avg = 0.0
    n = 0
    for cell in (interval, triangle, tetrahedron):#, quadrilateral, hexahedron):
        for degree in range(1, 3):

            e = FiniteElement("CG", cell, degree)
            for input in (e, [e]):
                t = timeit(input)
                print "Time for %s: %.4f s" % (repr(input), t)
                avg += t
                n += 1

            input = FiniteElement("CG", cell, degree) + FiniteElement("CG", cell, degree+1)
            t = timeit(input)
            print "Time for %s: %.4f s" % (repr(input), t)
            avg += t
            n += 1

            input = TensorElement("CG", cell, degree) + VectorElement("CG", cell, degree+1) + FiniteElement("CG", cell, degree+2)
            t = timeit(input)
            print "Time for %s: %.4f s" % (repr(input), t)
            avg += t
            n += 1

    avg /= n
    print "Average for take", take, "is", avg

