C-----------------------------------------------------------------------
C
C                        SYRTHES version 3.4
C                        -------------------
C
C     This file is part of the SYRTHES Kernel, element of the
C     thermal code SYRTHES.
C
C     Copyright (C) 1988-2008 EDF S.A., France
C
C     contact: syrthes-support@edf.fr
C
C
C     The SYRTHES Kernel is free software; you can redistribute it
C     and/or modify it under the terms of the GNU General Public License
C     as published by the Free Software Foundation; either version 2 of
C     the License, or (at your option) any later version.
C
C     The SYRTHES Kernel is distributed in the hope that it will be
C     useful, but WITHOUT ANY WARRANTY; without even the implied warranty
C     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C     GNU General Public License for more details.
C
C
C     You should have received a copy of the GNU General Public License
C     along with the Code_Saturne Kernel; if not, write to the
C     Free Software Foundation, Inc.,
C     51 Franklin St, Fifth Floor,
C     Boston, MA  02110-1301  USA
C
C-----------------------------------------------------------------------
C                       *****************
                        SUBROUTINE CONT2D
C                       *****************
C    --------------- 
     *(XI,YI,FFORME)
C    --------------- 
C
C***********************************************************************
C* SYRTHES 3.4.3                                    COPYRIGHT EDF 2008 *
C***********************************************************************
C AUTEURS : C. PENIGUEL, I. RUPP                                       *
C***********************************************************************
C                                                                      *
C   FONCTION :                                                         *
C   --------   Calcul de facteur de forme                              *
C              Application a des segments cartesiens                   *
C-----------------------------------------------------------------------
C               (*)   (*)                 ARGUMENTS                    !
C   .________.______.____._____________________________________________.
C   !  NOM   ! TYPE !MODE!                  ROLE                       !
C   !________!______!____!_____________________________________________!
C   !   XI   !  TR  !  D ! Coordonnees X des 4 points des 2 segments   !
C   !   YI   !  TR  !  D ! Coordonnees Y des 4 points des 2 segments   !
C   ! FFORME !   R  !  R ! Facteur de forme resultat                   !
C   !________!______!____!_____________________________________________!
C   ! COMMONS                                                          !
C   !__________________________________________________________________!
C   !/XREFER/!      ! M  !                                             !
C   !__________________________________________________________________!
C   ! FONCTIONS IMPLICITES                                             !
C   !__________________________________________________________________!
C   !________!______!____!_____________________________________________!
C
C (*) TYPE : E (ENTIER), R (REEL), A (ALPHANUMERIQUE), T (TABLEAU)
C     ET TYPES COMPOSES
C (*) MODE : D (DONNEE NON MODIFIEE), R (RESULTAT), M (DONNEE MODIFIEE)
C            A (TABLEAU AUXILIAIRE)
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELE(S) : 
C                                   
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELANT(S) : 
C
C***********************************************************************
C
      IMPLICIT NONE
C
C**********************************************************************
C     DONNEES EN COMMON 
C**********************************************************************
C
#include "nlofes.h"
#include "optct.h" 
C
C**********************************************************************
C
C.. Variables externes
      DOUBLE PRECISION XI(4),YI(4),FFORME
C
C.. Variables locales
      DOUBLE PRECISION AD,BC,AC,BD
C
C**********************************************************************
C
C     1- Calcul du facteur de forme
C     =============================
      AD = SQRT((XI(4)-XI(1))*(XI(4)-XI(1))+(YI(4)-YI(1))*(YI(4)-YI(1)))
      BC = SQRT((XI(3)-XI(2))*(XI(3)-XI(2))+(YI(3)-YI(2))*(YI(3)-YI(2)))
      AC = SQRT((XI(3)-XI(1))*(XI(3)-XI(1))+(YI(3)-YI(1))*(YI(3)-YI(1)))
      BD = SQRT((XI(4)-XI(2))*(XI(4)-XI(2))+(YI(4)-YI(2))*(YI(4)-YI(2)))
C
      FFORME = 0.5D0*(AC+BD-AD-BC)
C
C     2- IMPRESSIONS DE CONTROLE
C     ==========================
c      IF (NBLBLR.GE.10) THEN
c        WRITE(NFECRA,2000) FFORME
c      ENDIF
C
C--------
C FORMATS
C--------
 2000 FORMAT('>>> CONT2D : Facteur de forme = ',E16.9)
C----
C FIN
C----
C
      END
