## TFSA-2022-024: Integer overflow in TFLite

### CVE Number
CVE-2022-23559

### Impact
An attacker can craft a TFLite model that would cause an integer overflow [in embedding lookup operations](https://github.com/tensorflow/tensorflow/blob/ca6f96b62ad84207fbec580404eaa7dd7403a550/tensorflow/lite/kernels/embedding_lookup_sparse.cc#L179-L189):

```cc
  int embedding_size = 1;
  int lookup_size = 1;
  for (int i = 0; i < lookup_rank - 1; i++, k++) {
    const int dim = dense_shape->data.i32[i];
    lookup_size *= dim;
    output_shape->data[k] = dim;
  }
  for (int i = 1; i < embedding_rank; i++, k++) {
    const int dim = SizeOfDimension(value, i);
    embedding_size *= dim;
    output_shape->data[k] = dim;
  }
```

Both `embedding_size` and `lookup_size` are products of values provided by the user. Hence, a malicious user could trigger overflows in the multiplication.

In certain scenarios, this can then result in heap OOB read/write.

### Patches
We have patched the issue in GitHub commits [f19be71717c497723ba0cea0379e84f061a75e01](https://github.com/tensorflow/tensorflow/commit/f19be71717c497723ba0cea0379e84f061a75e01), [1de49725a5fc4e48f1a3b902ec3599ee99283043](https://github.com/tensorflow/tensorflow/commit/1de49725a5fc4e48f1a3b902ec3599ee99283043) and [a4e401da71458d253b05e41f28637b65baf64be4](https://github.com/tensorflow/tensorflow/commit/a4e401da71458d253b05e41f28637b65baf64be4).

The fix will be included in TensorFlow 2.8.0. We will also cherrypick this commit on TensorFlow 2.7.1, TensorFlow 2.6.3, and TensorFlow 2.5.3, as these are also affected and still in supported range.

### For more information
Please consult [our security guide](https://github.com/tensorflow/tensorflow/blob/master/SECURITY.md) for more information regarding the security model and how to contact us with issues and questions.

### Attribution
This vulnerability has been reported by Wang Xuan of Qihoo 360 AIVul Team.
